/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityPylonLink
extends TileEntityChromaticBase
implements LocationCached {
    private static final MultiMap<UUID, PylonNode> links = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());
    private PylonNode connection;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PYLONLINK;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K && this.connection != null) {
            this.doFX(world, x, y, z);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getIconState(int side) {
        return side == 1 && this.connection != null ? 1 : 0;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.link();
    }

    private void link() {
        if (this.placerUUID == null) {
            return;
        }
        TileEntityCrystalPylon te = this.getPylon();
        if (te != null) {
            this.connection = new PylonNode(this, te);
            links.addValue((Object)this.placerUUID, (Object)this.connection);
            te.link(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doFX(World world, int x, int y, int z) {
        EntityBlurFX fx;
        float s;
        float g;
        double py;
        double pz;
        double px;
        double ang;
        double a;
        int c = this.connection.color.getColor();
        double t = (double)this.getTicksExisted() * 1.5;
        int n = 6;
        double da = 360.0 / (double)n;
        double r = 0.4375;
        for (a = 0.0; a < 360.0; a += da) {
            ang = Math.toRadians(a + t);
            px = (double)x + 0.5 + r * Math.cos(ang);
            pz = (double)z + 0.5 + r * Math.sin(ang);
            py = (double)y + 1.05;
            g = -((float)ReikaRandomHelper.getRandomBetween((double)0.0078125, (double)0.03125));
            s = (float)ReikaRandomHelper.getRandomBetween((double)0.375, (double)0.5);
            fx = new EntityBlurFX(world, px, py, pz).setColor(c).setGravity(g).setScale(s).setRapidExpand().setAlphaFading();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        t = (double)(-this.getTicksExisted()) * 3.5;
        n = 3;
        da = 360.0 / (double)n;
        r = 0.1875;
        for (a = 0.0; a < 360.0; a += da) {
            ang = Math.toRadians(a + t);
            px = (double)x + 0.5 + r * Math.cos(ang);
            pz = (double)z + 0.5 + r * Math.sin(ang);
            py = (double)y + 1.05;
            g = -((float)ReikaRandomHelper.getRandomBetween((double)0.0078125, (double)0.03125));
            s = (float)ReikaRandomHelper.getRandomBetween((double)0.375, (double)0.5);
            fx = new EntityBlurFX(world, px, py, pz).setColor(c).setGravity(g).setScale(s).setRapidExpand().setAlphaFading();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (int i = 1; i <= 4; ++i) {
            double px2 = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.03125);
            double pz2 = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.03125);
            double py2 = (double)(y + 1) + 4.5 + 4.5 * Math.sin((double)this.getTicksExisted() / 64.0 * (1.0 + (double)i / 8.0) + (double)(i * 5));
            EntityBlurFX fx2 = new EntityBlurFX(world, px2, py2, pz2).setColor(c).setScale(1.25f).setRapidExpand().setAlphaFading().setLife(12);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    public Collection<WorldLocation> getLinkedPylons() {
        if (this.placerUUID == null || this.connection == null) {
            return new ArrayList<WorldLocation>();
        }
        ArrayList<WorldLocation> li = new ArrayList<WorldLocation>();
        Collection c = links.get((Object)this.placerUUID);
        for (PylonNode pn : c) {
            if (pn.color != this.connection.color) continue;
            li.add(pn.pylon);
        }
        return li;
    }

    public TileEntityCrystalPylon getPylon() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int d = 9;
        for (int i = 1; i < d; ++i) {
            int dy = y + i;
            if (world.func_147439_a(x, dy, z).isAir((IBlockAccess)world, x, dy, z) || i == 1 && ChromaTiles.getTile((IBlockAccess)world, x, dy, z) == ChromaTiles.PYLONTURBO) continue;
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y + d, z);
        return tile instanceof TileEntityCrystalPylon ? (TileEntityCrystalPylon)tile : null;
    }

    public void breakBlock() {
        this.unlink();
    }

    private void unlink() {
        if (this.placerUUID == null || this.connection == null) {
            return;
        }
        WorldLocation loc = new WorldLocation((TileEntity)this);
        TileEntity te = this.connection.pylon.getTileEntity();
        if (te instanceof TileEntityCrystalPylon) {
            ((TileEntityCrystalPylon)te).link(null);
        }
        links.remove((Object)this.placerUUID, (Object)this.connection);
        this.connection = null;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("link")) {
            this.connection = PylonNode.readFromNBT("link", NBT);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.connection != null) {
            this.connection.writeToNBT("link", NBT);
        }
    }

    private static class PylonNode {
        private final WorldLocation tile;
        private final WorldLocation pylon;
        private final CrystalElement color;

        private PylonNode(TileEntityPylonLink te, TileEntityCrystalPylon p) {
            this(new WorldLocation((TileEntity)te), new WorldLocation((TileEntity)p), p.getColor());
        }

        private PylonNode(WorldLocation loc, WorldLocation py, CrystalElement e) {
            this.tile = loc;
            this.pylon = py;
            this.color = e;
        }

        private static PylonNode readFromNBT(String tag, NBTTagCompound NBT) {
            NBTTagCompound c = NBT.func_74775_l(tag);
            WorldLocation loc = WorldLocation.readFromNBT((String)"loc", (NBTTagCompound)c);
            WorldLocation py = WorldLocation.readFromNBT((String)"pylon", (NBTTagCompound)c);
            CrystalElement e = CrystalElement.elements[c.func_74762_e("color")];
            return new PylonNode(loc, py, e);
        }

        private void writeToNBT(String tag, NBTTagCompound NBT) {
            NBTTagCompound c = new NBTTagCompound();
            this.tile.writeToNBT("loc", c);
            this.pylon.writeToNBT("pylon", c);
            c.func_74768_a("color", this.color.ordinal());
            NBT.func_74782_a(tag, (NBTBase)c);
        }

        public int hashCode() {
            return this.tile.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof PylonNode) {
                PylonNode pn = (PylonNode)o;
                return pn.tile.equals((Object)this.tile) && pn.pylon.equals((Object)this.pylon) && pn.color == this.color;
            }
            return false;
        }
    }
}

