/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Base.TileEntity.CrystalTransmitterBase;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalFuse;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class TileEntityCrystalRepeater
extends CrystalTransmitterBase
implements CrystalRepeater,
CrystalFuse,
NBTTile,
SneakPop,
OwnedTile,
MultiBlockChromaTile {
    protected ForgeDirection facing = ForgeDirection.DOWN;
    protected boolean hasMultiblock;
    private int depth = -1;
    private boolean isTurbo = false;
    private boolean enhancedStructure = false;
    private CrystalElement surgeColor;
    private int surgeTicks = 0;
    protected int connectionRenderTick = 0;
    private HashSet<WorldLocation> connectableTiles;
    public static final int RANGE = 32;
    private boolean redstoneCache;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.REPEATER;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.connectionRenderTick > 0) {
            --this.connectionRenderTick;
            if (this.connectionRenderTick == 0) {
                this.connectableTiles = null;
            }
        }
        if (world.field_72995_K && this.canConduct() && this.isTurbocharged() && this.isEnhancedStructure()) {
            this.doEnhancedStructureParticles(world, x, y, z);
        }
        if (this.surgeTicks > 0) {
            --this.surgeTicks;
            if (this.surgeTicks == 0) {
                this.doSurge();
            }
            if (world.field_72995_K) {
                this.doSurgingParticles(world, x, y, z);
            }
        }
    }

    public void onBlockUpdate() {
        super.onBlockUpdate();
        this.redstoneCache = this.field_145850_b.func_72864_z(this.field_145851_c + this.facing.offsetX, this.field_145848_d + this.facing.offsetY, this.field_145849_e + this.facing.offsetZ);
    }

    @SideOnly(value=Side.CLIENT)
    private void doEnhancedStructureParticles(World world, int x, int y, int z) {
        double d = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        if (d < 1024.0 && (d < 256.0 || ReikaRandomHelper.doWithChance((double)(25600.0 / d)))) {
            int c = this.getActiveColor().getColor();
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125);
            ForgeDirection dir = this.facing.getOpposite();
            double vx = v * (double)dir.offsetX;
            double vy = v * (double)dir.offsetY;
            double vz = v * (double)dir.offsetZ;
            double dx = (double)x + rand.nextDouble();
            double dy = (double)y + rand.nextDouble();
            double dz = (double)z + rand.nextDouble();
            switch (dir) {
                case EAST: {
                    dx = x + 1;
                    break;
                }
                case WEST: {
                    dx = x;
                    break;
                }
                case NORTH: {
                    dz = z;
                    break;
                }
                case SOUTH: {
                    dz = z + 1;
                    break;
                }
                case UP: {
                    dy = y + 1;
                    break;
                }
                case DOWN: {
                    dy = y;
                    break;
                }
            }
            float s = 1.0f + rand.nextFloat();
            EntityBlurFX fx = new EntityBlurFX(world, dx, dy, dz, vx, vy, vz).setColor(c).setNoSlowdown().setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            EntityBlurFX fx2 = new EntityBlurFX(world, dx, dy, dz, vx, vy, vz).setColor(0xFFFFFF).setNoSlowdown().setScale(s / 2.5f).lockTo(fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.validateStructure();
    }

    @Override
    public int getSendRange() {
        return 32;
    }

    @Override
    public int getReceiveRange() {
        return 32;
    }

    @Override
    public boolean canConduct() {
        return this.hasMultiblock && !this.redstoneCache;
    }

    @Override
    public final void validateStructure() {
        this.hasMultiblock = this.checkForStructure();
        boolean bl = this.enhancedStructure = this.hasMultiblock && this.isTurbocharged() && this.checkEnhancedStructure();
        if (!this.hasMultiblock) {
            CrystalNetworker.instance.breakPaths(this);
        }
        this.syncAllData(false);
    }

    protected boolean checkForStructure() {
        ForgeDirection dir = this.facing;
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        if (world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != ChromaBlocks.RUNE.getBlockInstance()) {
            return false;
        }
        for (int i = 2; i < 4; ++i) {
            int m2;
            int dx = x + dir.offsetX * i;
            int dy = y + dir.offsetY * i;
            int dz = z + dir.offsetZ * i;
            Block id = world.func_147439_a(dx, dy, dz);
            int meta = world.func_72805_g(dx, dy, dz);
            int n = m2 = i == 3 && this.isTurbocharged() ? BlockPylonStructure.StoneTypes.RESORING.ordinal() : 0;
            if (id == ChromaBlocks.PYLONSTRUCT.getBlockInstance() && (meta == 0 || meta == m2)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkEnhancedStructure() {
        int dx = this.field_145851_c + this.facing.offsetX * 3;
        int dy = this.field_145848_d + this.facing.offsetY * 3;
        int dz = this.field_145849_e + this.facing.offsetZ * 3;
        return this.field_145850_b.func_72805_g(dx, dy, dz) == BlockPylonStructure.StoneTypes.RESORING.ordinal();
    }

    public void redirect(int side) {
        this.facing = this.dirs[side].getOpposite();
        this.validateStructure();
    }

    public boolean findFirstValidSide() {
        for (int i = 0; i < 6; ++i) {
            this.facing = this.dirs[i];
            this.validateStructure();
            if (!this.hasMultiblock) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.facing = this.dirs[NBT.func_74762_e("face")];
        this.hasMultiblock = NBT.func_74767_n("multi");
        this.depth = NBT.func_74762_e("depth");
        this.isTurbo = NBT.func_74767_n("turbo");
        this.enhancedStructure = NBT.func_74767_n("enhance");
        this.surgeTicks = NBT.func_74762_e("surge");
        this.surgeColor = CrystalElement.elements[NBT.func_74762_e("surge_c")];
        this.redstoneCache = NBT.func_74767_n("redstone");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.facing != null) {
            NBT.func_74768_a("face", this.facing.ordinal());
        }
        NBT.func_74757_a("multi", this.hasMultiblock);
        NBT.func_74768_a("depth", this.depth);
        NBT.func_74757_a("turbo", this.isTurbo);
        NBT.func_74757_a("enhance", this.enhancedStructure);
        NBT.func_74768_a("surge", this.surgeTicks);
        if (this.surgeColor != null) {
            NBT.func_74768_a("surge_c", this.surgeColor.ordinal());
        }
        NBT.func_74757_a("redstone", this.redstoneCache);
    }

    public final boolean isTurbocharged() {
        return this.isTurbo;
    }

    public final boolean isEnhancedStructure() {
        return this.enhancedStructure;
    }

    @Override
    public int maxThroughput() {
        return this.isTurbocharged() ? (this.isEnhancedStructure() ? 18000 : 9000) : 1000;
    }

    @Override
    public int getSignalDegradation() {
        return this.isTurbocharged() ? 0 : 10;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null && e == this.getActiveColor();
    }

    @Override
    public final int receiveElement(CrystalElement e, int amt) {
        return 1;
    }

    @Override
    public ImmutableTriple<Double, Double, Double> getTargetRenderOffset(CrystalElement e) {
        return null;
    }

    @Override
    public boolean checkConnectivity() {
        CrystalElement c = this.getActiveColor();
        return c != null && CrystalNetworker.instance.checkConnectivity(c, this);
    }

    public CrystalElement getActiveColor() {
        int dx = this.field_145851_c + this.facing.offsetX;
        int dy = this.field_145848_d + this.facing.offsetY;
        int dz = this.field_145849_e + this.facing.offsetZ;
        return this.canConduct() ? CrystalElement.elements[this.field_145850_b.func_72805_g(dx, dy, dz)] : null;
    }

    public CrystalSource getEnergySource() {
        CrystalElement e = this.getActiveColor();
        CrystalPath p = e != null ? CrystalNetworker.instance.getConnectivity(e, this) : null;
        return p != null ? p.transmitter : null;
    }

    @Override
    public boolean needsLineOfSightToReceiver(CrystalReceiver r) {
        return true;
    }

    @Override
    public int getSignalDepth(CrystalElement e) {
        return this.depth;
    }

    @Override
    public void setSignalDepth(CrystalElement e, int d) {
        if (e == this.getActiveColor()) {
            this.depth = d;
        }
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        NBT.func_74757_a("boosted", this.isTurbo);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.isTurbo = ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.getTile().getCraftedProduct()) && is.field_77990_d != null && is.field_77990_d.func_74767_n("boosted");
    }

    @Override
    public final void onPathCompleted(CrystalFlow p) {
    }

    @Override
    public final void onPathBroken(CrystalFlow p, CrystalNetworkLogger.FlowFail f) {
    }

    @Override
    public final void drop() {
        if (!this.shouldDrop()) {
            return;
        }
        ItemStack is = this.getTile().getCraftedProduct();
        is.field_77990_d = new NBTTagCompound();
        this.getTagsToWriteToStack(is.field_77990_d);
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        this.delete();
    }

    @Override
    public final boolean canDrop(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.placerUUID);
    }

    protected boolean shouldDrop() {
        return true;
    }

    @Override
    public boolean canTransmitTo(CrystalReceiver r) {
        return true;
    }

    @Override
    public boolean canReceiveFrom(CrystalTransmitter r) {
        return true;
    }

    public void triggerConnectionRender() {
        if (this.field_145850_b.field_72995_K) {
            this.connectionRenderTick = 100;
        } else {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.REPEATERCONN.ordinal(), (TileEntity)this, (int)128, (int[])new int[0]);
        }
    }

    public int getConnectionRenderAlpha() {
        return this.connectionRenderTick > 0 ? (this.connectionRenderTick > 10 ? 255 : 25 * this.connectionRenderTick) : 0;
    }

    public HashSet<WorldLocation> getRenderedConnectableTiles() {
        return this.connectableTiles;
    }

    @SideOnly(value=Side.CLIENT)
    private final HashSet<WorldLocation> getConnectableTilesForRender(float ptick) {
        HashSet<WorldLocation> c = new HashSet<WorldLocation>();
        int r = Math.max(this.getReceiveRange(), this.getSendRange());
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    boolean flag = false;
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e + k);
                    if (te instanceof CrystalReceiver && ((CrystalNetworkTile)te).canConduct() && this.canTransmitTo((CrystalReceiver)te)) {
                        flag = true;
                    }
                    if (te instanceof CrystalTransmitter && ((CrystalNetworkTile)te).canConduct() && ((CrystalTransmitter)te).canTransmitTo(this)) {
                        flag = true;
                    }
                    if (!flag || !(this.getDistanceSqTo(te.field_145851_c, te.field_145848_d, te.field_145849_e) <= (double)(r * r)) || (te instanceof CrystalReceiver ? this.needsLineOfSightToReceiver((CrystalReceiver)te) : ((CrystalTransmitter)te).needsLineOfSightToReceiver(this)) && !PylonFinder.lineOfSight(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, te.field_145851_c, te.field_145848_d, te.field_145849_e)) continue;
                    c.add(new WorldLocation(te));
                }
            }
        }
        return c;
    }

    @Override
    public final AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB def = super.getRenderBoundingBox();
        if (def == INFINITE_EXTENT_AABB) {
            return def;
        }
        if (this.connectionRenderTick > 0) {
            return INFINITE_EXTENT_AABB;
        }
        if (this.isTurbo) {
            return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(2.0, 2.0, 2.0);
        }
        return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(0.5, 0.5, 0.5);
    }

    @Override
    public float getFailureWeight(CrystalElement e) {
        return 1.5f;
    }

    @Override
    public final void overload(CrystalElement e) {
        this.startSurge(e);
    }

    private void startSurge(CrystalElement e) {
        ChromaSounds.REPEATERSURGE.playSoundAtBlockNoAttenuation((TileEntity)this, 1.0f, 1.0f, 1024);
        this.surgeTicks = 55;
        this.surgeColor = e;
        this.syncAllData(false);
    }

    private void doSurge() {
        if (!this.field_145850_b.field_72995_K) {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.REPEATERSURGE.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{this.surgeColor.ordinal()});
        }
        int y = this.field_145848_d - 1;
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        while (y > 0 && b == ChromaBlocks.PYLONSTRUCT.getBlockInstance() || b == ChromaBlocks.RUNE.getBlockInstance()) {
            ReikaWorldHelper.dropAndDestroyBlockAt((World)this.field_145850_b, (int)this.field_145851_c, (int)y, (int)this.field_145849_e, null, (boolean)true, (boolean)true);
            b = this.field_145850_b.func_147439_a(this.field_145851_c, --y, this.field_145849_e);
        }
        this.delete();
    }

    @SideOnly(value=Side.CLIENT)
    private void doSurgingParticles(World world, int x, int y, int z) {
        int n = 1 + rand.nextInt(2);
        if (rand.nextInt(10) == 0) {
            n = 24 + rand.nextInt(24);
        }
        double phi = rand.nextDouble() * 360.0;
        double theta = 2.0 + rand.nextDouble() * 86.0;
        double dx = (double)this.field_145851_c + 0.5;
        double dy = (double)this.field_145848_d + 0.5;
        double dz = (double)this.field_145849_e + 0.5;
        for (int i = 0; i < n; ++i) {
            double phi2 = ReikaRandomHelper.getRandomPlusMinus((double)phi, (double)2.0);
            double theta2 = ReikaRandomHelper.getRandomPlusMinus((double)theta, (double)2.0);
            double v = ReikaRandomHelper.getRandomBetween((double)0.25, (double)0.125);
            float s = 1.5f + rand.nextFloat() * 2.5f;
            double[] vxyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)theta2, (double)phi2);
            int l = 20 + rand.nextInt(80);
            EntityBlurFX fx = new EntityBlurFX(this.surgeColor, this.field_145850_b, dx, dy, dz, vxyz[0], vxyz[1], vxyz[2]).setLife(l).setScale(s).setRapidExpand().setNoSlowdown();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final void overloadClient(World world, int x, int y, int z, CrystalElement e) {
        for (int i = 0; i < 256; ++i) {
            double dx = (double)x + rand.nextDouble();
            double dy = (double)y + rand.nextDouble();
            double dz = (double)z + rand.nextDouble();
            double v = 0.25;
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            float s = 1.5f + rand.nextFloat() * 2.5f;
            float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            EntityBlurFX fx = new EntityBlurFX(e, world, dx, dy, dz, vx, vy, vz).setLife(200).setScale(s).setGravity(g).setRapidExpand().setNoSlowdown();
            switch (rand.nextInt(3)) {
                case 0: {
                    break;
                }
                case 1: {
                    fx.setIcon(ChromaIcons.FLARE);
                    break;
                }
                case 2: {
                    fx.setIcon(ChromaIcons.BIGFLARE);
                }
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        ChromaSounds.POWERDOWN.playSoundAtBlock(world, x, y, z);
        ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150359_w);
    }

    @Override
    public void onTransfer(CrystalSource src, CrystalReceiver r, CrystalElement e, int amt) {
    }

    @Override
    public int getPathPriority() {
        return 10;
    }

    @Override
    public boolean needsLineOfSightFromTransmitter(CrystalTransmitter r) {
        return true;
    }

    @Override
    public int getThoughputBonus() {
        return 0;
    }

    @Override
    public int getThoughputInsurance() {
        return 0;
    }
}

