/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.NotifiedNetworkTile;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalRepeater;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityCrystalBroadcaster
extends TileEntityCrystalRepeater
implements NotifiedNetworkTile,
MultiBlockChromaTile,
BreakAction {
    public static final int INTERFERENCE_RANGE = 384;
    public static final int MIN_RANGE = 512;
    public static final int BROADCAST_RANGE = 4096;
    private static final int AIR_SEARCH = 32;
    private static final int AIR_SEARCH_Y = 8;
    private WorldLocation interference;
    private boolean clearAir;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BROADCAST;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.validateStructure();
        this.checkInterfere();
        this.clearAir = this.testAirClear();
    }

    @Override
    public boolean needsLineOfSightToReceiver(CrystalReceiver r) {
        return !(r instanceof TileEntityCrystalBroadcaster);
    }

    @Override
    public boolean needsLineOfSightFromTransmitter(CrystalTransmitter r) {
        return !(r instanceof TileEntityCrystalBroadcaster);
    }

    @Override
    public int getSendRange() {
        return 4096;
    }

    @Override
    public int getReceiveRange() {
        return 4096;
    }

    @Override
    protected boolean checkForStructure() {
        return ChromaStructures.getBroadcastStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
    }

    @Override
    public boolean canConduct() {
        if (!super.canConduct()) {
            return false;
        }
        return this.interference == null && this.clearAir;
    }

    private boolean testAirClear() {
        int r = 32;
        int ry = 8;
        int c2 = 0;
        for (int i = -r; i <= r; ++i) {
            for (int j = -ry; j <= ry; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int dx = this.field_145851_c + i;
                    int dy = this.field_145848_d + j;
                    int dz = this.field_145849_e + k;
                    if (!this.field_145850_b.func_147439_a(dx, dy, dz).isAir((IBlockAccess)this.field_145850_b, dx, dy, dz)) continue;
                    ++c2;
                }
            }
        }
        int c1 = (r * 2 + 1) * (r * 2 + 1) * ry;
        return (double)((float)c1 / (float)c2) > 0.8;
    }

    private void checkInterfere() {
        TileEntityCrystalBroadcaster te = (TileEntityCrystalBroadcaster)CrystalNetworker.instance.getNearestTileOfType(this, this.getClass(), 384.0);
        if (te != null) {
            this.interference = new WorldLocation((TileEntity)te);
            te.interference = new WorldLocation((TileEntity)this);
        } else {
            this.interference = null;
        }
    }

    public static void updateAirCaches(World world, int x, int y, int z) {
        Collection<TileEntityCrystalBroadcaster> c = CrystalNetworker.instance.getNearTilesOfType(world, x, y, z, TileEntityCrystalBroadcaster.class, 32);
        for (TileEntityCrystalBroadcaster te : c) {
            if (Math.abs(te.field_145848_d - y) > 8 || Math.abs(te.field_145851_c - x) > 32 || Math.abs(te.field_145849_e - z) > 32) continue;
            te.clearAir = te.testAirClear();
        }
    }

    @Override
    public void redirect(int side) {
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null;
    }

    @Override
    public int maxThroughput() {
        return this.isTurbocharged() ? 250000 : 100000;
    }

    @Override
    public int getSignalDegradation() {
        int base;
        int n = base = this.isTurbocharged() ? 1500 : 3000;
        if (this.field_145850_b.func_72896_J()) {
            base *= 4;
        }
        return base;
    }

    @Override
    public void onPathConnected(CrystalPath p) {
    }

    @Override
    public boolean canTransmitTo(CrystalReceiver r) {
        if (r instanceof TileEntityCrystalBroadcaster) {
            return r.getDistanceSqTo(this.field_145851_c, this.field_145848_d, this.field_145849_e) >= 262144.0;
        }
        return true;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.interference = WorldLocation.readFromNBT((String)"interfere", (NBTTagCompound)NBT);
        this.clearAir = NBT.func_74767_n("air");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.interference != null) {
            this.interference.writeToNBT("interfere", NBT);
        }
        NBT.func_74757_a("air", this.clearAir);
    }

    @Override
    public void onTileNetworkTopologyChange(CrystalNetworkTile te, boolean remove) {
        if (te instanceof TileEntityCrystalBroadcaster) {
            this.checkInterfere();
        }
    }

    @Override
    public float getFailureWeight(CrystalElement e) {
        return 1.125f;
    }

    @Override
    public int getPathPriority() {
        return -50;
    }

    @Override
    public int getThoughputInsurance() {
        return this.isTurbocharged() ? 1000 : 500;
    }

    public void breakBlock() {
        TileEntity te;
        if (this.interference != null && (te = this.interference.getTileEntity()) instanceof TileEntityCrystalBroadcaster) {
            TileEntityCrystalBroadcaster tb = (TileEntityCrystalBroadcaster)te;
            if (tb.interference != null && tb.interference.equals(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                tb.interference = null;
            }
        }
    }
}

