/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Magic.Interfaces.ConnectivityAction;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalRepeater;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityCompoundRepeater
extends TileEntityCrystalRepeater
implements ConnectivityAction {
    private final EnumMap<CrystalElement, Integer> depth = new EnumMap(CrystalElement.class);
    private boolean connectedToPylon = false;

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (world.field_72995_K && this.canConduct()) {
            this.particles(world, x, y, z);
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    @SideOnly(value=Side.CLIENT)
    private void particles(World world, int x, int y, int z) {
        if (this.getColorCycleTick() % 32 == 5) {
            double px = (double)x + 0.5;
            double py = (double)y + 0.5;
            double pz = (double)z + 0.5;
            CrystalElement e = this.getParticleColor();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityRuneFX(world, px, py, pz, 0.0, 0.0, 0.0, e).setScale(5.0f).setFading());
        }
    }

    private CrystalElement getParticleColor() {
        return this.getRenderColorWithOffset(64);
    }

    public CrystalElement getRenderColorWithOffset(int i) {
        return CrystalElement.elements[(this.getColorCycleTick() + i) / 32 % 16];
    }

    public int getColorCycleTick() {
        return (int)(((double)this.field_145850_b.func_82737_E() + (double)this.field_145851_c / 8.0 % 16.0 + (double)this.field_145849_e / 8.0 % 16.0) % 512.0);
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null && this.canConduct();
    }

    @Override
    public int maxThroughput() {
        return this.isTurbocharged() ? (this.isEnhancedStructure() ? 20000 : 12000) : 1000;
    }

    @Override
    public int getSignalDegradation() {
        return this.isTurbocharged() ? (this.isEnhancedStructure() ? 10 : 20) : 100;
    }

    @Override
    protected boolean checkForStructure() {
        for (int i = 1; i <= 5; ++i) {
            int m2b;
            int dx = this.field_145851_c + this.facing.offsetX * i;
            int dy = this.field_145848_d + this.facing.offsetY * i;
            int dz = this.field_145849_e + this.facing.offsetZ * i;
            Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
            int meta = this.field_145850_b.func_72805_g(dx, dy, dz);
            int m2 = i == 3 ? 13 : (i == 1 || i == 5 ? 12 : this.getColumnBeam());
            int n = m2b = m2 == this.getColumnBeam() && this.isTurbocharged() ? BlockPylonStructure.StoneTypes.list[m2].getGlowingVariant().ordinal() : m2;
            if (b == ChromaBlocks.PYLONSTRUCT.getBlockInstance() && (meta == m2 || meta == m2b)) continue;
            return false;
        }
        return true;
    }

    private int getColumnBeam() {
        return this.facing.offsetY == 0 ? 1 : 2;
    }

    @Override
    protected boolean checkEnhancedStructure() {
        for (int i = 2; i <= 4; i += 2) {
            int dx = this.field_145851_c + this.facing.offsetX * i;
            int dy = this.field_145848_d + this.facing.offsetY * i;
            int dz = this.field_145849_e + this.facing.offsetZ * i;
            Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
            int meta = this.field_145850_b.func_72805_g(dx, dy, dz);
            if (b == ChromaBlocks.PYLONSTRUCT.getBlockInstance() && meta == BlockPylonStructure.StoneTypes.list[this.getColumnBeam()].getGlowingVariant().ordinal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.COMPOUND;
    }

    @Override
    public CrystalElement getActiveColor() {
        return CrystalElement.elements[(this.getRenderColorWithOffset(7).ordinal() + 2) % 16];
    }

    @Override
    public void setSignalDepth(CrystalElement e, int d) {
        this.depth.put(e, d);
    }

    @Override
    public int getSignalDepth(CrystalElement e) {
        Integer d = this.depth.get((Object)e);
        return d != null ? d : -1;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            String s = "depth_" + e.ordinal();
            if (!NBT.func_74764_b(s)) continue;
            this.depth.put(e, NBT.func_74762_e(s));
        }
        this.connectedToPylon = NBT.func_74767_n("pylon");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        for (CrystalElement e : this.depth.keySet()) {
            NBT.func_74768_a("depth_" + e.ordinal(), this.depth.get((Object)e).intValue());
        }
        NBT.func_74757_a("pylon", this.connectedToPylon);
    }

    @Override
    public float getFailureWeight(CrystalElement e) {
        return 1.25f;
    }

    @Override
    public int getPathPriority() {
        return -10;
    }

    @Override
    public void notifySendingTo(CrystalPath p, CrystalReceiver r) {
    }

    @Override
    public void notifyReceivingFrom(CrystalPath p, CrystalTransmitter t) {
        if (t instanceof TileEntityCrystalPylon) {
            p.addBaseAttenuation(1000);
            this.connectedToPylon = true;
        } else {
            this.connectedToPylon = false;
        }
    }

    public boolean connectedToPylon() {
        return this.connectedToPylon;
    }
}

