/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Decoration;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.BoundedValue;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.NBTCopyable;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityParticleSpawner
extends TileEntityChromaticBase
implements GuiController,
NBTCopyable {
    public ParticleDefinition particles = new ParticleDefinition();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PARTICLES;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K && !this.hasRedstoneSignal()) {
            this.spawnParticles(world, x, y, z);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.particles.location = new Coordinate((TileEntity)this);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        EntityFX fx = this.particles.getFX(this.getTicksExisted());
        if (fx != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.particles.writeToNBT(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.particles.readFromNBT(NBT);
    }

    public void writeCopyableData(NBTTagCompound NBT) {
        this.particles.writeToNBT(NBT);
    }

    public void readCopyableData(NBTTagCompound NBT) {
        this.particles.readFromNBT(NBT);
        this.particles.location = new Coordinate((TileEntity)this);
        this.syncAllData(true);
    }

    public static class VariableValue<N extends Number> {
        private BoundedValue<N> bounds;
        private BoundedValue<N> variation;

        private VariableValue(N min, N max) {
            this.bounds = new BoundedValue(min, max);
            this.variation = new BoundedValue((Number)0.0, (Number)this.getMaxVariance(), (Number)0);
        }

        private VariableValue(N min, N max, N init) {
            this.bounds = new BoundedValue(min, max, init);
            this.variation = new BoundedValue((Number)0.0, (Number)this.getMaxVariance(), (Number)0);
        }

        public VariableValue<N> setStep(N step) {
            this.bounds.setStep(step);
            this.variation.setStep(step);
            return this;
        }

        public double getValue() {
            return this.bounds.getValue();
        }

        public double getVariation() {
            return this.variation.getValue();
        }

        public boolean increase() {
            if (this.bounds.increase()) {
                this.onValueChange();
                return true;
            }
            return false;
        }

        public boolean decrease() {
            if (this.bounds.decrease()) {
                this.onValueChange();
                return true;
            }
            return false;
        }

        public boolean increaseVariation() {
            return this.variation.increase();
        }

        public boolean decreaseVariation() {
            return this.variation.decrease();
        }

        public void setValue(N value) {
            this.bounds.setValue(value);
            this.onValueChange();
        }

        private void onValueChange() {
            this.variation = new BoundedValue((Number)0.0, (Number)this.getMaxVariance(), (Number)this.variation.getValue()).setStep((Number)this.bounds.getStep());
        }

        private double getMaxVariance() {
            return Math.min(Math.abs(Math.abs(this.bounds.getMinValue()) - Math.abs(this.bounds.getValue())), Math.abs(Math.abs(this.bounds.getMaxValue()) - Math.abs(this.bounds.getValue())));
        }

        public void writeToNBT(String s, NBTTagCompound NBT) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound tag1 = new NBTTagCompound();
            NBTTagCompound tag2 = new NBTTagCompound();
            this.bounds.writeToNBT(tag1);
            this.variation.writeToNBT(tag2);
            tag.func_74782_a("bounds", (NBTBase)tag1);
            tag.func_74782_a("vary", (NBTBase)tag2);
            NBT.func_74782_a(s, (NBTBase)tag);
        }

        public void readFromNBT(String s, NBTTagCompound NBT) {
            NBTTagCompound tag = NBT.func_74775_l(s);
            NBTTagCompound tag1 = tag.func_74775_l("bounds");
            NBTTagCompound tag2 = tag.func_74775_l("vary");
            this.bounds = BoundedValue.readFromNBT((NBTTagCompound)tag1);
            this.variation = BoundedValue.readFromNBT((NBTTagCompound)tag2);
        }

        public String toString() {
            return this.bounds.toString() + " & " + this.variation.toString();
        }

        /* synthetic */ VariableValue(Number x0, Number x1, 1 x2) {
            this(x0, x1);
        }

        /* synthetic */ VariableValue(Number x0, Number x1, Number x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class ParticleDefinition {
        private Coordinate location = new Coordinate(0, 0, 0);
        public int particleColor = 0xFFFFFF;
        public VariableValue<Double> particlePositionX = new VariableValue<Double>((Number)-8.0, (Number)8.0, null).setStep(0.03125);
        public VariableValue<Double> particlePositionY = new VariableValue<Double>((Number)-8.0, (Number)8.0, null).setStep(0.03125);
        public VariableValue<Double> particlePositionZ = new VariableValue<Double>((Number)-8.0, (Number)8.0, null).setStep(0.03125);
        public VariableValue<Double> particleVelocityX = new VariableValue<Double>((Number)-2.0, (Number)2.0, null).setStep(0.03125);
        public VariableValue<Double> particleVelocityY = new VariableValue<Double>((Number)-2.0, (Number)2.0, null).setStep(0.03125);
        public VariableValue<Double> particleVelocityZ = new VariableValue<Double>((Number)-2.0, (Number)2.0, null).setStep(0.03125);
        public VariableValue<Float> particleSize = new VariableValue<Float>(Float.valueOf(0.125f), Float.valueOf(50.0f), Float.valueOf(1.0f), null).setStep(Float.valueOf(0.125f));
        public VariableValue<Float> particleGravity = new VariableValue<Float>((Number)Float.valueOf(-2.0f), (Number)Float.valueOf(2.0f), null).setStep(Float.valueOf(0.015625f));
        public VariableValue<Integer> particleLife = new VariableValue<Integer>(5, 1200, 20, null).setStep(1);
        public boolean particleCollision = false;
        public boolean rapidExpand = false;
        public boolean noSlowdown = false;
        public boolean alphaFade = false;
        public boolean cyclingColor = false;
        public ChromaIcons particleIcon = ChromaIcons.FADE;
        public BoundedValue<Integer> particleRate = new BoundedValue((Number)1, (Number)300, (Number)10).setStep((Number)1);

        private ParticleDefinition() {
        }

        @SideOnly(value=Side.CLIENT)
        public EntityFX getFX(int tick) {
            if (tick % (int)this.particleRate.getValue() == 0) {
                double px = (double)this.location.xCoord + 0.5 + ReikaRandomHelper.getRandomPlusMinus((double)this.particlePositionX.getValue(), (double)this.particlePositionX.getVariation());
                double py = (double)this.location.yCoord + 0.5 + ReikaRandomHelper.getRandomPlusMinus((double)this.particlePositionY.getValue(), (double)this.particlePositionY.getVariation());
                double pz = (double)this.location.zCoord + 0.5 + ReikaRandomHelper.getRandomPlusMinus((double)this.particlePositionZ.getValue(), (double)this.particlePositionZ.getVariation());
                double vx = ReikaRandomHelper.getRandomPlusMinus((double)this.particleVelocityX.getValue(), (double)this.particleVelocityX.getVariation());
                double vy = ReikaRandomHelper.getRandomPlusMinus((double)this.particleVelocityY.getValue(), (double)this.particleVelocityY.getVariation());
                double vz = ReikaRandomHelper.getRandomPlusMinus((double)this.particleVelocityZ.getValue(), (double)this.particleVelocityZ.getVariation());
                float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)this.particleGravity.getValue(), (double)this.particleGravity.getVariation());
                float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)this.particleSize.getValue(), (double)this.particleSize.getVariation());
                int l = ReikaRandomHelper.getRandomPlusMinus((int)((int)this.particleLife.getValue()), (int)((int)this.particleLife.getVariation()));
                EntityBlurFX fx = new EntityBlurFX((World)Minecraft.func_71410_x().field_71441_e, px, py, pz, vx, vy, vz).setGravity(g).setLife(l).setScale(s).setColor(this.particleColor);
                fx.setIcon(this.particleIcon);
                if (this.particleCollision) {
                    fx.setColliding();
                }
                if (this.particleIcon.isTransparent()) {
                    fx.setBasicBlend();
                }
                if (this.rapidExpand) {
                    fx.setRapidExpand();
                }
                if (this.noSlowdown) {
                    fx.setNoSlowdown();
                }
                if (this.alphaFade) {
                    fx.setAlphaFading();
                }
                if (this.cyclingColor) {
                    fx.setCyclingColor(1.0f);
                }
                return fx;
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void sendData() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            this.location.writeToNBT("loc", nbt);
            ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.PARTICLESPAWNER.ordinal(), (NBTTagCompound)nbt, (PacketTarget)PacketTarget.server);
        }

        public void writeToNBT(NBTTagCompound NBT) {
            NBT.func_74768_a("color", this.particleColor);
            NBT.func_74757_a("collide", this.particleCollision);
            NBT.func_74757_a("rapid", this.rapidExpand);
            NBT.func_74757_a("noslow", this.noSlowdown);
            NBT.func_74757_a("afade", this.alphaFade);
            NBT.func_74757_a("cycle", this.cyclingColor);
            NBT.func_74778_a("icon", this.particleIcon.name());
            NBTTagCompound tag = new NBTTagCompound();
            this.particleRate.writeToNBT(tag);
            NBT.func_74782_a("rate", (NBTBase)tag);
            this.particleLife.writeToNBT("life", NBT);
            this.particleSize.writeToNBT("size", NBT);
            this.particleGravity.writeToNBT("gravity", NBT);
            this.particlePositionX.writeToNBT("spawnX", NBT);
            this.particlePositionY.writeToNBT("spawnY", NBT);
            this.particlePositionZ.writeToNBT("spawnZ", NBT);
            this.particleVelocityX.writeToNBT("speedX", NBT);
            this.particleVelocityY.writeToNBT("speedY", NBT);
            this.particleVelocityZ.writeToNBT("speedZ", NBT);
            this.location.writeToNBT("loc", NBT);
        }

        public void readFromNBT(NBTTagCompound NBT) {
            this.particleColor = NBT.func_74762_e("color");
            this.particleCollision = NBT.func_74767_n("collide");
            this.rapidExpand = NBT.func_74767_n("rapid");
            this.noSlowdown = NBT.func_74767_n("noslow");
            this.alphaFade = NBT.func_74767_n("afade");
            this.cyclingColor = NBT.func_74767_n("cycle");
            try {
                this.particleIcon = ChromaIcons.valueOf(NBT.func_74779_i("icon"));
            }
            catch (IllegalArgumentException e) {
                ChromatiCraft.logger.logError((Object)("Tried to load invalid particle type '" + NBT.func_74779_i("icon") + "' from NBT."));
                e.printStackTrace();
            }
            NBTTagCompound tag = NBT.func_74775_l("rate");
            this.particleRate = BoundedValue.readFromNBT((NBTTagCompound)tag);
            this.particleLife.readFromNBT("life", NBT);
            this.particleSize.readFromNBT("size", NBT);
            this.particleGravity.readFromNBT("gravity", NBT);
            this.particlePositionX.readFromNBT("spawnX", NBT);
            this.particlePositionY.readFromNBT("spawnY", NBT);
            this.particlePositionZ.readFromNBT("spawnZ", NBT);
            this.particleVelocityX.readFromNBT("speedX", NBT);
            this.particleVelocityY.readFromNBT("speedY", NBT);
            this.particleVelocityZ.readFromNBT("speedZ", NBT);
            this.location = Coordinate.readFromNBT((String)"loc", (NBTTagCompound)NBT);
        }
    }
}

