/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Decoration;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.TemporaryCrystalReceiver;
import Reika.ChromatiCraft.Base.CrystalBlock;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.MIDIInterface;
import Reika.DragonAPI.Instantiable.MusicScore;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.TriggerableAction;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityCrystalMusic
extends TileEntityChromaticBase
implements GuiController,
TriggerableAction,
BreakAction {
    private static final int BROADCAST_RANGE = 96;
    private boolean isPlaying;
    private int playTick;
    private MusicScore track = new MusicScore(16);
    private CrystalReceiver receiver;
    private final CrystalPath[] networkConnections = new CrystalPath[16];
    private static final MusicScore demoTrack;
    private static final EnumMap<CrystalElement, Coordinate> colorPositions;

    public void addNote(int channel, ReikaMusicHelper.MusicKey key, int length, boolean rest) {
        this.addNote(this.getTime(channel), channel, key, length, rest);
    }

    public void addNote(int time, int channel, ReikaMusicHelper.MusicKey key, int length, boolean rest) {
        this.track.addNote(time, channel, key, rest ? -1 : 0, 100, length);
    }

    private int getTime(int channel) {
        int pos;
        Collection n = this.track.getNotes(channel, pos = this.track.getLatestPos(channel));
        return pos + (n != null && !n.isEmpty() ? ((MusicScore.Note)n.iterator().next()).length : 0);
    }

    public void clearChannel(int channel) {
        this.track.clearChannel(channel);
    }

    public void clearMusic() {
        this.track = new MusicScore(16);
        this.isPlaying = false;
        this.playTick = 0;
        for (int i = 0; i < this.networkConnections.length; ++i) {
            if (this.networkConnections[i] == null) continue;
            this.networkConnections[i].endBlink();
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.MUSIC;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && this.track != null && this.isPlaying) {
            this.play(world, x, y, z);
        }
    }

    protected void onPositiveRedstoneEdge() {
        this.triggerPlay();
    }

    public void triggerPlay() {
        if (this.isPlaying) {
            return;
        }
        this.calcPaths(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.playTick = 0;
        this.isPlaying = true;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.calcPaths(world, x, y, z);
        }
    }

    private void calcPaths(World world, int x, int y, int z) {
        block4: {
            if (world.field_72995_K) break block4;
            if (this.playRepeaters(world, x, y, z)) {
                this.receiver = this.createTemporaryReceiver();
                for (int i = 0; i < 16; ++i) {
                    this.networkConnections[i] = CrystalNetworker.instance.getConnectivity(CrystalElement.elements[i], this.receiver);
                }
            } else {
                this.receiver = null;
                for (int i = 0; i < 16; ++i) {
                    this.networkConnections[i] = null;
                }
            }
        }
    }

    private boolean playRepeaters(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        return b == Blocks.field_150371_ca || b == ChromaBlocks.PYLONSTRUCT.getBlockInstance();
    }

    private void play(World world, int x, int y, int z) {
        ArrayList li = this.track.getNotes(this.playTick);
        for (MusicScore.Note n : li) {
            if (n.voice != -1 && !this.playNote(world, x, y, z, n)) continue;
        }
        ++this.playTick;
        if (this.playTick > this.track.getLatestPos()) {
            this.isPlaying = false;
        }
    }

    private boolean playNote(World world, int x, int y, int z, MusicScore.Note n) {
        Set<CrystalElement> set = CrystalMusicManager.instance.getColorsWithKey(n.key);
        if (set.isEmpty()) {
            set = CrystalMusicManager.instance.getColorsWithKey(n.key.getOctave());
        }
        if (set.isEmpty()) {
            set = CrystalMusicManager.instance.getColorsWithKey(n.key.getInterval(-12));
        }
        if (set.isEmpty()) {
            set = CrystalMusicManager.instance.getColorsWithKey(n.key.getInterval(-24));
        }
        if (set.isEmpty()) {
            set = CrystalMusicManager.instance.getColorsWithKey(n.key.getInterval(-36));
        }
        boolean canPlay = false;
        if (!set.isEmpty()) {
            for (CrystalElement e : set) {
                canPlay |= this.playCrystal(world, x, y, z, e, n.length);
            }
            if (canPlay) {
                // empty if block
            }
        } else {
            canPlay = true;
            this.generateParticles(world, x, y + 2, z, CrystalElement.randomElement());
        }
        if (canPlay) {
            if (this.attentuate(world, x, y, z)) {
                ChromaSounds.DING.playSoundAtBlock((TileEntity)this, (float)n.volume / 100.0f, (float)CrystalMusicManager.instance.getPitchFactor(n.key));
            } else {
                ChromaSounds.DING.playSoundAtBlockNoAttenuation((TileEntity)this, (float)n.volume / 100.0f, (float)CrystalMusicManager.instance.getPitchFactor(n.key), 96);
            }
            return true;
        }
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CRYSTALMUSERROR.ordinal(), (TileEntity)this, (int)96, (int[])new int[0]);
        return false;
    }

    private boolean attentuate(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) != Blocks.field_150371_ca;
    }

    public boolean playCrystal(World world, int x, int y, int z, CrystalElement e, int length) {
        Coordinate c = colorPositions.get((Object)e).offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Block b = c.getBlock(world);
        if (b instanceof CrystalBlock && c.getBlockMetadata(world) == e.ordinal()) {
            this.generateParticles(world, c.xCoord, c.yCoord, c.zCoord, e);
            if (this.networkConnections[e.ordinal()] != null && this.networkConnections[e.ordinal()].stillValid()) {
                this.networkConnections[e.ordinal()].blink(MathHelper.func_76125_a((int)length, (int)1, (int)40), this.receiver);
            }
            return true;
        }
        return false;
    }

    public CrystalReceiver createTemporaryReceiver() {
        return new TemporaryCrystalReceiver(new WorldLocation((TileEntity)this), 0, 32, 0.35, ChromaResearchManager.ResearchLevel.BASICCRAFT);
    }

    private void generateParticles(World world, int x, int y, int z, CrystalElement e) {
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z, e);
        } else {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CRYSTALMUS.ordinal(), (TileEntity)this, (int)96, (int[])new int[]{x, y, z, e.ordinal()});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doErrorParticles(World world, int x, int y, int z) {
        int n = 12 + rand.nextInt(12);
        for (int i = 0; i < n; ++i) {
            double dx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double dy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double dz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            int l = 5 + rand.nextInt(15);
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.25, (double)0.125);
            int c = CrystalElement.randomElement().getColor();
            EntityBlurFX fx = new EntityBlurFX(world, (double)x + 0.5 + dx, (double)y + 0.5 + dy, (double)z + 0.5 + dz, -dx * v, -dy * v, -dz * v).setLife(l).setColor(c).setGravity(0.0f);
            fx.field_70145_X = false;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doParticles(World world, int x, int y, int z, CrystalElement e) {
        int n = 3 + rand.nextInt(6);
        for (int i = 0; i < n; ++i) {
            double px = (double)x + rand.nextDouble();
            double py = (double)y + rand.nextDouble();
            double pz = (double)z + rand.nextDouble();
            int l = 10 + rand.nextInt(40);
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.015125, (double)0.125));
            EntityBlurFX fx = new EntityFloatingSeedsFX(world, px, py, pz, 0.0, 90.0).setLife(l).setColor(e.getColor()).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (x != this.field_145851_c || y != this.field_145848_d || z != this.field_145849_e) {
            double dx = x - this.field_145851_c;
            double dy = y - this.field_145848_d;
            double dz = z - this.field_145849_e;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            for (double p = 0.0; p <= dd; p += 0.125) {
                double f = p / dd;
                float s = 1.0f + 1.5f * (float)Math.sin(f * Math.PI);
                int l = 10;
                double px = (double)this.field_145851_c + 0.5 + f * dx;
                double py = (double)this.field_145848_d + 0.5 + f * dy;
                double pz = (double)this.field_145849_e + 0.5 + f * dz;
                int clr = e.getColor();
                EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setLife(l).setNoSlowdown().setScale(s).setColor(clr);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void loadDemo() {
        if (demoTrack != null && demoTrack.getLatestPos() > 0) {
            this.setTrack(demoTrack.copy());
        }
        this.triggerPlay();
    }

    @SideOnly(value=Side.CLIENT)
    public void loadLocalMIDI(String file) {
        File f = new File(file);
        if (!f.exists() || f.isDirectory()) {
            ChromatiCraft.logger.logError((Object)"Could not load local MIDI: file is not a MIDI file!");
            return;
        }
        try {
            MusicScore mus = new MIDIInterface(f).fillToScore().scaleSpeed(11.0f);
            this.dispatchTrack(mus);
        }
        catch (Exception e) {
            ChromatiCraft.logger.logError((Object)e.toString());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void dispatchDemo() {
        this.dispatchTrack(demoTrack);
    }

    private void dispatchTrack(MusicScore mus) {
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MUSICCLEAR.ordinal(), (TileEntity)this, (int[])new int[0]);
        for (int i = 0; i < mus.countTracks(); ++i) {
            Map track = mus.getTrack(i);
            Iterator i$ = track.keySet().iterator();
            while (i$.hasNext()) {
                int time = (Integer)i$.next();
                Collection c = (Collection)track.get(time);
                for (MusicScore.Note n : c) {
                    if (n == null || n.key == null) continue;
                    ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.FIXEDMUSICNOTE.ordinal(), (TileEntity)this, (int[])new int[]{i, n.key.ordinal(), n.length, n.voice == -1 ? 1 : 0, time});
                }
            }
        }
    }

    public void setTrack(MusicScore music) {
        this.isPlaying = false;
        this.track = music;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        if (this.track != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.track.writeToNBT(tag);
            NBT.func_74782_a("track", (NBTBase)tag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        if (NBT.func_74764_b("track")) {
            NBTTagCompound tag = NBT.func_74775_l("track");
            this.track = MusicScore.readFromNBT((NBTTagCompound)tag);
        }
    }

    public boolean trigger() {
        if (this.track == null) {
            return false;
        }
        this.triggerPlay();
        return true;
    }

    public void breakBlock() {
        if (this.receiver != null) {
            CrystalNetworker.instance.breakPaths(this.receiver);
            CrystalNetworker.instance.removeTile(this.receiver);
        }
        for (int i = 0; i < this.networkConnections.length; ++i) {
            if (this.networkConnections[i] == null) continue;
            this.networkConnections[i].endBlink();
        }
    }

    static {
        MusicScore mus = null;
        try {
            mus = new MIDIInterface(ChromatiCraft.class, "Resources/music-demo.mid").fillToScore().scaleSpeed(11.0f);
            ChromatiCraft.logger.log((Object)("Loaded demo track " + mus));
        }
        catch (Exception e) {
            e.printStackTrace();
            ChromatiCraft.logger.logError((Object)"Could not load demo track!");
            mus = new MusicScore(16);
        }
        demoTrack = mus;
        colorPositions = new EnumMap(CrystalElement.class);
        colorPositions.put(CrystalElement.BLACK, new Coordinate(0, 0, -3));
        colorPositions.put(CrystalElement.RED, new Coordinate(1, 0, -3));
        colorPositions.put(CrystalElement.GREEN, new Coordinate(2, 0, -2));
        colorPositions.put(CrystalElement.BROWN, new Coordinate(3, 0, -1));
        colorPositions.put(CrystalElement.BLUE, new Coordinate(3, 0, 0));
        colorPositions.put(CrystalElement.PURPLE, new Coordinate(3, 0, 1));
        colorPositions.put(CrystalElement.CYAN, new Coordinate(2, 0, 2));
        colorPositions.put(CrystalElement.LIGHTGRAY, new Coordinate(1, 0, 3));
        colorPositions.put(CrystalElement.GRAY, new Coordinate(0, 0, 3));
        colorPositions.put(CrystalElement.PINK, new Coordinate(-1, 0, 3));
        colorPositions.put(CrystalElement.LIME, new Coordinate(-2, 0, 2));
        colorPositions.put(CrystalElement.YELLOW, new Coordinate(-3, 0, 1));
        colorPositions.put(CrystalElement.LIGHTBLUE, new Coordinate(-3, 0, 0));
        colorPositions.put(CrystalElement.MAGENTA, new Coordinate(-3, 0, -1));
        colorPositions.put(CrystalElement.ORANGE, new Coordinate(-2, 0, -2));
        colorPositions.put(CrystalElement.WHITE, new Coordinate(-1, 0, -3));
    }
}

