/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Auxiliary;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.ModRegistry.ModCropList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityFunctionRelay
extends TileEntityChromaticBase {
    private RelayFunctions function = RelayFunctions.HARVEST;
    private final StepTimer scanTimer = new StepTimer(50);
    private final ArrayList<Coordinate> activeCoords = new ArrayList();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FUNCTIONRELAY;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.scanTimer.update();
        if (this.scanTimer.checkCap()) {
            this.doScan(world, x, y, z);
        }
        if (world.field_72995_K) {
            // empty if block
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        int l = 3;
        double theta = 0.0;
        double phi = 0.0;
        double a = (double)this.getTicksExisted() * 0.73 % 360.0;
        double a2 = 0.135 * (double)this.getTicksExisted() % 360.0;
        for (double d = a; d < 360.0 + a; d += 15.0) {
            for (double d2 = -90.0 + a2; d2 <= 90.0 + a2; d2 += 15.0) {
                double r = 1.125 + 0.125 * Math.sin((double)this.getTicksExisted() / 8.0 + d / 9.41477796076938 + d2 / 12.556370614359173);
                double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)r, (double)(theta + d2), (double)(phi + d));
                double px = (double)x + 0.5 + xyz[0];
                double py = (double)y + 0.5 + xyz[1];
                double pz = (double)z + 0.5 + xyz[2];
                EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setLife(l).setAlphaFading();
                ColorBlendList cbl = new ColorBlendList((float)(l * 4), new int[]{0xFF00FF, 0xFFFF00, 0xFF00FF, 65535});
                fx.setColor(cbl.getColor((double)(this.getTicksExisted() + Math.abs((int)(d * d2 / 512.0)))));
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.doScan(world, x, y, z);
    }

    private void doScan(World world, int x, int y, int z) {
        this.activeCoords.clear();
        for (int i = -6; i <= 6; ++i) {
            for (int k = -6; k <= 6; ++k) {
                if (Math.abs(i) + Math.abs(k) > 9) continue;
                int dx = x + i;
                int dz = z + k;
                for (int j = -6; j <= 2; ++j) {
                    int meta;
                    int dy = y + j;
                    Block b = world.func_147439_a(dx, dy, dz);
                    if (b.isAir((IBlockAccess)world, dx, dy, dz) || !this.function.isCoordinateSignificant(world, dx, dy, dz, b, meta = world.func_72805_g(dx, dy, dz))) continue;
                    this.activeCoords.add(new Coordinate(dx, dy, dz));
                }
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public RelayFunctions getFunctionType() {
        return this.function;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("function", this.function.ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.function = RelayFunctions.list[NBT.func_74762_e("function")];
    }

    public Coordinate getRandomCoordinate() {
        return this.activeCoords.isEmpty() ? null : this.activeCoords.get(rand.nextInt(this.activeCoords.size()));
    }

    public static enum RelayFunctions {
        HARVEST;

        private static final RelayFunctions[] list;

        private boolean isCoordinateSignificant(World world, int x, int y, int z, Block b, int meta) {
            switch (this) {
                case HARVEST: {
                    return ReikaCropHelper.getCrop((Block)b) != null || ModCropList.getModCrop((Block)b, (int)meta) != null;
                }
            }
            return false;
        }

        static {
            list = RelayFunctions.values();
        }
    }
}

