/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.Interfaces.FocusAcceleratable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityFocusCrystal
extends TileEntityChromaticBase
implements NBTTile {
    private final HashSet<FocusConnection> connections = new HashSet();
    private CrystalTier tier = CrystalTier.FLAWED;

    public static float getSummedFocusFactor(TileEntity te) {
        return TileEntityFocusCrystal.getSummedFocusFactor(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static float getSummedFocusFactor(World world, int x, int y, int z) {
        float sum = 1.0f;
        for (int i = 0; i < FocusLocation.list.length; ++i) {
            TileEntityFocusCrystal te;
            Coordinate c = FocusLocation.list[i].relativeLocation.offset(x, y, z);
            if (ChromaTiles.getTile((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) != ChromaTiles.FOCUSCRYSTAL || !(te = (TileEntityFocusCrystal)c.getTileEntity(world)).canFunction()) continue;
            sum += te.getTier().efficiencyFactor;
        }
        return sum;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FOCUSCRYSTAL;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.scanConnections(world, x, y, z);
    }

    private void scanConnections(World world, int x, int y, int z) {
        this.connections.clear();
        for (int i = 0; i < FocusLocation.list.length; ++i) {
            FocusLocation loc = FocusLocation.list[i];
            Coordinate c = loc.relativeLocation.negate().offset(x, y, z);
            TileEntity te = c.getTileEntity(world);
            if (!(te instanceof FocusAcceleratable)) continue;
            this.connections.add(new FocusConnection(loc, te));
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.getTier() == CrystalTier.EXQUISITE && world.field_72995_K) {
            this.doParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (rand.nextInt(2 + Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            double hr = 0.825;
            double vr = 0.375;
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)(hr / 2.0));
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)(hr / 2.0));
            double py = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.375), (double)(vr / 2.0));
            int l = 6 + rand.nextInt(6);
            int c = this.getTier().getRenderColor(this.getTicksExisted());
            EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setIcon(ChromaIcons.FLARE).setLife(l).setColor(c);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean canFunction() {
        return true;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public CrystalTier getTier() {
        return this.tier;
    }

    public Collection<FocusConnection> getConnections() {
        return Collections.unmodifiableCollection(this.connections);
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        NBT.func_74768_a("tier", this.tier.ordinal());
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.tier = is != null && is.field_77990_d != null ? CrystalTier.tierList[is.field_77990_d.func_74762_e("tier")] : CrystalTier.FLAWED;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("tier", this.getTier().ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.tier = CrystalTier.tierList[NBT.func_74762_e("tier")];
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(4.0, 2.0, 4.0);
    }

    public static class FocusConnection {
        public final FocusLocation location;
        public final Coordinate target;
        public final Class tileClass;

        private FocusConnection(FocusLocation loc, TileEntity te) {
            this.location = loc;
            this.target = new Coordinate(te);
            this.tileClass = te.getClass();
        }
    }

    public static enum FocusLocation {
        N1(-1, 1, -3),
        N2(1, 1, -3),
        E1(3, 1, -1),
        E2(3, 1, 1),
        S1(1, 1, 3),
        S2(-1, 1, 3),
        W1(-3, 1, 1),
        W2(-3, 1, -1);

        public final Coordinate relativeLocation;
        public static final FocusLocation[] list;

        private FocusLocation(int x, int y, int z) {
            this.relativeLocation = new Coordinate(x, y, z);
        }

        static {
            list = FocusLocation.values();
        }
    }

    public static enum CrystalTier {
        FLAWED(0.0625f),
        DEFAULT(0.125f),
        REFINED(0.375f),
        EXQUISITE(0.875f);

        public final float efficiencyFactor;
        public static final CrystalTier[] tierList;

        private CrystalTier(float f) {
            this.efficiencyFactor = f;
        }

        public String getTextureSuffix() {
            switch (this) {
                case FLAWED: {
                    return "_cracked";
                }
                case EXQUISITE: {
                    return "_sparkle";
                }
            }
            return "";
        }

        public boolean useOrganizedModel() {
            return this == REFINED || this == EXQUISITE;
        }

        public int getRenderColor(float tick) {
            switch (this) {
                case FLAWED: {
                    return 3203136;
                }
                case DEFAULT: 
                case REFINED: {
                    return 0xE06060;
                }
                case EXQUISITE: {
                    return 0x22AAFF;
                }
            }
            return 0xFFFFFF;
        }

        public ItemStack getCraftedItem() {
            ItemStack is = ChromaTiles.FOCUSCRYSTAL.getCraftedProduct();
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("tier", this.ordinal());
            return is;
        }

        public String getDisplayName() {
            return this == DEFAULT ? "" : ReikaStringParser.capFirstChar((String)this.name());
        }

        static {
            tierList = CrystalTier.values();
        }
    }
}

