/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedCrystalReceiver;
import Reika.ChromatiCraft.Items.ItemStorageCrystal;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityCrystalCharger
extends InventoriedCrystalReceiver
implements OneSlotMachine {
    private float angle;
    public static final int CAPACITY = 120000;
    private boolean[] toggle = ReikaArrayHelper.getTrueArray((int)16);

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
            this.checkAndRequest();
        }
        if (this.hasItem()) {
            for (CrystalElement e : this.energy.elementSet()) {
                if (!this.isToggled(e)) continue;
                int max = this.getMaxTransfer(e);
                int amt = this.getEnergy(e);
                ItemStorageCrystal cry = this.item();
                int put = Math.min(max, Math.min(amt, ItemStorageCrystal.getSpace(e, this.inv[0])));
                if (put <= 0) continue;
                ItemStorageCrystal.addEnergy(this.inv[0], e, put);
                this.drainEnergy(e, put);
                ProgressionManager.ProgressStage.CHARGECRYSTAL.stepPlayerTo(this.getPlacer());
            }
        }
    }

    public float getAngle() {
        return this.angle;
    }

    private ItemStorageCrystal item() {
        return (ItemStorageCrystal)this.inv[0].func_77973_b();
    }

    private int getMaxTransfer(CrystalElement e) {
        int max = 10 + (int)Math.sqrt(this.getEnergy(e));
        return this.hasSpeedUpgrade() ? 8 * max : max;
    }

    public boolean hasSpeedUpgrade() {
        return ReikaItemHelper.matchStacks((ItemStack)this.inv[1], (ItemStack)ChromaStacks.speedUpgrade);
    }

    private void checkAndRequest() {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            int capacity;
            int space;
            CrystalElement e = CrystalElement.elements[i];
            if (!this.isToggled(e) || (space = (capacity = this.getMaxStorage(e)) - this.getEnergy(e)) <= 0) continue;
            this.requestEnergy(e, space);
        }
    }

    @Override
    public int getReceiveRange() {
        return 20;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null;
    }

    @Override
    public int maxThroughput() {
        return 4000;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        switch (slot) {
            case 0: {
                return ChromaItems.STORAGE.matchWith(is);
            }
            case 1: {
                return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.speedUpgrade);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_102008_b(int slot, ItemStack is, int side) {
        if (slot != 0) return false;
        if (!ChromaItems.STORAGE.matchWith(is)) return false;
        this.item();
        if (!ItemStorageCrystal.isFull(is)) return false;
        return true;
    }

    public int func_70302_i_() {
        return 2;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.CHARGER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (world == null) {
            this.angle = 0.0f;
            return;
        }
        int energy = this.energy.getTotalEnergy();
        if (this.hasItem()) {
            this.item();
            ElementTagCompound tag = ItemStorageCrystal.getStoredTags(this.inv[0]);
            energy += tag.getTotalEnergy();
        }
        if (energy > 0) {
            this.angle = (float)((double)this.angle + ReikaMathLibrary.logbase((long)energy, (int)2));
            if (this.angle >= 180.0f) {
                this.angle -= 180.0f;
            }
        }
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 120000;
    }

    public boolean hasItem() {
        return this.inv[0] != null && ChromaItems.STORAGE.matchWith(this.inv[0]);
    }

    public boolean isToggled(CrystalElement e) {
        return this.toggle[e.ordinal()];
    }

    public void toggle(CrystalElement e) {
        this.toggle[e.ordinal()] = !this.toggle[e.ordinal()];
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("toggle")) {
            this.toggle = ReikaArrayHelper.booleanFromBitflags((int)NBT.func_74762_e("toggle"), (int)16);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("toggle", ReikaArrayHelper.booleanToBitflags((boolean[])this.toggle));
    }
}

