/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Acquisition;

import Reika.ChromatiCraft.API.Interfaces.MinerBlock;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.ChargedCrystalPowered;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityRangeBoost;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Block.SpecialOreBlock;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityMiner
extends ChargedCrystalPowered
implements OwnedTile,
ChunkLoadingTile {
    public static final int MAXRANGE = 128;
    private boolean digging = false;
    private boolean digReady = false;
    private boolean finishedDigging = false;
    private int range = 128;
    private int readX = 0;
    private int readY = 0;
    private int readZ = 0;
    private double particleX;
    private double particleY;
    private double particleVX;
    private double particleVY;
    public int progress;
    private boolean dropFlag = false;
    private long lastWarning;
    private boolean chunkloaded;
    private static final int TICKSTEP = 2048;
    private int index;
    private StepTimer miningTimer = new StepTimer(5);
    private static final ElementTagCompound required = new ElementTagCompound();
    private final ArrayList<Coordinate> coords = new ArrayList();
    private final ItemHashMap<Integer> found = new ItemHashMap();
    private boolean silkTouch;

    public static ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.MINER;
    }

    public int getReadX() {
        return this.readX;
    }

    public int getReadY() {
        return this.readY;
    }

    public int getReadZ() {
        return this.readZ;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.updateRange();
        this.calcSilkTouch();
        this.dropFlag = false;
        this.digReady = false;
        this.digging = false;
        this.readY = 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        block21: {
            block24: {
                block23: {
                    block22: {
                        if (world.field_72995_K) break block21;
                        if (!this.dropFlag) break block22;
                        if (this.getTicksExisted() % 20 == 0) {
                            this.doDropWarning(world, x, y, z);
                        }
                        break block21;
                    }
                    if (!this.digging || this.coords.isEmpty()) break block23;
                    this.calcSilkTouch();
                    this.miningTimer.update();
                    if (!this.miningTimer.checkCap() || !this.hasEnergy(required)) break block24;
                    Coordinate c = this.coords.get(this.index);
                    int dx = c.xCoord;
                    int dy = c.yCoord;
                    int dz = c.zCoord;
                    Block id = this.parseBlock(world.func_147439_a(dx, dy, dz));
                    int meta2 = world.func_72805_g(dx, dy, dz);
                    this.removeFound(world, dx, dy, dz, id, meta2);
                    if (id instanceof SpecialOreBlock) {
                        this.dropSpecialOreBlock(world, x, y, z, dx, dy, dz, (SpecialOreBlock)id, meta2);
                    } else if (ReikaBlockHelper.isOre((Block)id, (int)meta2)) {
                        this.dropBlock(world, x, y, z, dx, dy, dz, id, meta2);
                    } else if (this.shouldMine(id, meta2)) {
                        this.dropBlock(world, x, y, z, dx, dy, dz, id, meta2);
                    } else if (this.isTieredResource(world, dx, dy, dz, id, meta2)) {
                        this.dropTieredResource(world, x, y, z, dx, dy, dz, id, meta2);
                    } else if (id instanceof MinerBlock) {
                        this.dropMineableBlock(world, x, y, z, dx, dy, dz, id, meta2);
                    }
                    this.useEnergy(required.copy().scale(this.getEnergyCostScale()));
                    ++this.index;
                    if (this.index < this.coords.size()) break block24;
                    this.finishDigging();
                    break block24;
                }
                if (!this.digReady && !this.finishedDigging) {
                    this.prepareChunkloading();
                    for (int i = 0; i < 2048; ++i) {
                        int dx = x + this.readX;
                        int dy = this.readY;
                        int dz = z + this.readZ;
                        ReikaWorldHelper.forceGenAndPopulate((World)world, (int)dx, (int)dz);
                        Block id = this.parseBlock(world.func_147439_a(dx, dy, dz));
                        int meta2 = world.func_72805_g(dx, dy, dz);
                        boolean add = false;
                        if (ReikaBlockHelper.isOre((Block)id, (int)meta2)) {
                            add = this.coords.add(new Coordinate(dx, dy, dz));
                        } else if (this.isTieredResource(world, dx, dy, dz, id, meta2)) {
                            add = this.coords.add(new Coordinate(dx, dy, dz));
                        } else if (id instanceof MinerBlock && ((MinerBlock)id).isMineable(meta2)) {
                            add = this.coords.add(new Coordinate(dx, dy, dz));
                        } else if (this.shouldMine(id, meta2)) {
                            add = this.coords.add(new Coordinate(dx, dy, dz));
                        }
                        if (add) {
                            this.addFound(world, dx, dy, dz, id, meta2);
                        }
                        this.updateReadPosition();
                        if (this.readY < this.field_145850_b.func_72940_L()) continue;
                        this.prepareDigging();
                    }
                }
            }
            this.progress = this.readY;
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
    }

    private void prepareChunkloading() {
        if (!this.chunkloaded) {
            this.chunkloaded = true;
            ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
        }
    }

    private void prepareDigging() {
        this.digReady = true;
        this.readX = 0;
        this.readY = 0;
        this.readZ = 0;
        this.index = 0;
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    private void finishDigging() {
        this.digging = false;
        this.digReady = false;
        this.coords.clear();
        this.found.clear();
        this.finishedDigging = true;
        this.syncAllData(true);
        this.scheduleBlockUpdate(5);
    }

    private Block parseBlock(Block b) {
        if (b == Blocks.field_150439_ay) {
            return Blocks.field_150450_ax;
        }
        return b;
    }

    private boolean shouldMine(Block id, int meta2) {
        if (id == Blocks.field_150426_aN) {
            return true;
        }
        if (id == Blocks.field_150474_ac) {
            // empty if block
        }
        return false;
    }

    public float getDigCompletion() {
        return this.isReady() ? 1.0f : (float)this.progress / (float)this.field_145850_b.func_72940_L();
    }

    public boolean isReady() {
        return this.digReady;
    }

    private void removeFound(World world, int x, int y, int z, Block b, int meta) {
        if (Item.func_150898_a((Block)b) == null) {
            return;
        }
        ItemStack is = new ItemStack(b, 1, meta);
        if (b instanceof SpecialOreBlock) {
            is = ((SpecialOreBlock)b).getDisplayItem(world, x, y, z);
        } else if (ReikaBlockHelper.isOre((Block)b, (int)meta)) {
            ReikaOreHelper ore = ReikaOreHelper.getEntryByOreDict((ItemStack)is);
            ModOreList mod = ModOreList.getModOreFromOre((ItemStack)is);
            if (ore != null) {
                is = ore.getOreBlock();
            } else if (mod != null && mod != ModOreList.CERTUSQUARTZ) {
                is = mod.getFirstOreBlock();
            }
        }
        Integer i = (Integer)this.found.get(is);
        if (i == null) {
            i = 0;
        }
        if (i > 1) {
            this.found.put(is, (Object)(i - 1));
        } else {
            this.found.remove(is);
        }
    }

    private void addFound(World world, int x, int y, int z, Block b, int meta) {
        if (b != null && Item.func_150898_a((Block)b) == null) {
            ChromatiCraft.logger.logError((Object)("Block " + b + " has no item to drop when mined???"));
            return;
        }
        ItemStack is = new ItemStack(b, 1, meta);
        if (b instanceof SpecialOreBlock) {
            is = ((SpecialOreBlock)b).getDisplayItem(world, x, y, z);
        } else if (ReikaBlockHelper.isOre((Block)b, (int)meta)) {
            ReikaOreHelper ore = ReikaOreHelper.getEntryByOreDict((ItemStack)is);
            ModOreList mod = ModOreList.getModOreFromOre((ItemStack)is);
            if (ore != null) {
                is = ore.getOreBlock();
            } else if (mod != null && mod != ModOreList.CERTUSQUARTZ) {
                is = mod.getFirstOreBlock();
            }
        }
        Integer i = (Integer)this.found.get(is);
        if (i == null) {
            i = 0;
        }
        this.found.put(is, (Object)(i + 1));
    }

    public List<ItemStack> getFound() {
        return Collections.unmodifiableList(this.found.sortedKeyset());
    }

    public int getNumberFound(ItemStack is) {
        Integer i = (Integer)this.found.get(is);
        return i != null ? i : 0;
    }

    private boolean isTieredResource(World world, int x, int y, int z, Block id, int meta) {
        EntityPlayer ep = this.getPlacer();
        return ep != null && id instanceof BlockTieredResource && ((BlockTieredResource)id).isPlayerSufficientTier((IBlockAccess)world, x, y, z, ep);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        double px = (double)x + this.particleX;
        double py = (double)y + this.particleY;
        double pz = z;
        int color = CrystalElement.getBlendedColor(this.getTicksExisted(), 40);
        EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        px = (double)(x + 1) - this.particleX;
        py = (double)(y + 1) - this.particleY;
        fx = new EntityBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        pz = z + 1;
        px = (double)(x + 1) - this.particleX;
        py = (double)y + this.particleY;
        fx = new EntityBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        px = (double)x + this.particleX;
        py = (double)(y + 1) - this.particleY;
        fx = new EntityBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        px = x;
        pz = (double)z + this.particleX;
        py = (double)y + this.particleY;
        fx = new EntityBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        pz = (double)(z + 1) - this.particleX;
        py = (double)(y + 1) - this.particleY;
        fx = new EntityBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        px = x + 1;
        pz = (double)(z + 1) - this.particleX;
        py = (double)y + this.particleY;
        fx = new EntityBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        pz = (double)z + this.particleX;
        py = (double)(y + 1) - this.particleY;
        fx = new EntityBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        double d = 0.05;
        this.particleX += this.particleVX;
        this.particleY += this.particleVY;
        this.particleX = MathHelper.func_151237_a((double)this.particleX, (double)0.0, (double)1.0);
        this.particleY = MathHelper.func_151237_a((double)this.particleY, (double)0.0, (double)1.0);
        if (this.particleX == 1.0 && this.particleY == 0.0) {
            this.particleVX = 0.0;
            this.particleVY = d;
        }
        if (this.particleY == 1.0 && this.particleY == 1.0) {
            this.particleVX = -d;
            this.particleVY = 0.0;
        }
        if (this.particleX == 0.0 && this.particleY == 1.0) {
            this.particleVX = 0.0;
            this.particleVY = -d;
        }
        if (this.particleX == 0.0 && this.particleY == 0.0) {
            this.particleVX = d;
            this.particleVY = 0.0;
        }
    }

    private void dropSpecialOreBlock(World world, int x, int y, int z, int dx, int dy, int dz, SpecialOreBlock id, int meta2) {
        if (this.silkTouch) {
            this.dropItems(world, x, y, z, ReikaJavaLibrary.makeListFrom((Object)id.getSilkTouchVersion(world, dx, dy, dz)));
        } else {
            this.dropItems(world, x, y, z, id.getDrops(world, dx, dy, dz, 0));
        }
        ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)id.getReplacementBlock(world, dx, dy, dz));
    }

    private void dropBlock(World world, int x, int y, int z, int dx, int dy, int dz, Block id, int meta2) {
        if (this.silkTouch) {
            this.dropItems(world, x, y, z, ReikaJavaLibrary.makeListFrom((Object)new ItemStack(id, 1, meta2)));
        } else {
            this.dropItems(world, x, y, z, id.getDrops(world, dx, dy, dz, meta2, 0));
        }
        this.getFillerBlock(world, dx, dy, dz, id, meta2).place(world, dx, dy, dz);
        ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)id);
        ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)dx, (int)dy, (int)dz, (int)Block.func_149682_b((Block)id), (int)meta2);
    }

    private void dropTieredResource(World world, int x, int y, int z, int dx, int dy, int dz, Block id, int meta2) {
        Collection li = ((BlockTieredResource)id).getHarvestResources(world, dx, dy, dz, 10, this.getPlacer());
        this.dropItems(world, x, y, z, li);
        this.getFillerBlock(world, dx, dy, dz, id, meta2).place(world, dx, dy, dz);
        ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)id);
        ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)dx, (int)dy, (int)dz, (int)Block.func_149682_b((Block)id), (int)meta2);
    }

    private void dropMineableBlock(World world, int x, int y, int z, int dx, int dy, int dz, Block id, int meta2) {
        if (this.silkTouch) {
            this.dropItems(world, x, y, z, ReikaJavaLibrary.makeListFrom((Object)new ItemStack(id, 1, meta2)));
        } else {
            this.dropItems(world, x, y, z, ((MinerBlock)id).getHarvestItems(world, dx, dy, dz, meta2, 0));
        }
        this.getFillerBlock(world, dx, dy, dz, id, meta2).place(world, dx, dy, dz);
        ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)id);
        ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)dx, (int)dy, (int)dz, (int)Block.func_149682_b((Block)id), (int)meta2);
    }

    private BlockKey getFillerBlock(World world, int dx, int dy, int dz, Block id, int meta2) {
        if (!id.func_149688_o().func_76220_a()) {
            return new BlockKey(Blocks.field_150350_a);
        }
        if (id == Blocks.field_150426_aN) {
            return new BlockKey(Blocks.field_150350_a);
        }
        if (id == Blocks.field_150474_ac) {
            return new BlockKey(Blocks.field_150350_a);
        }
        if (world.field_73011_w.field_76574_g == -1) {
            return new BlockKey(Blocks.field_150424_aL);
        }
        if (world.field_73011_w.field_76574_g == 1) {
            return new BlockKey(Blocks.field_150377_bs);
        }
        return new BlockKey(Blocks.field_150348_b);
    }

    public boolean hasCrystal() {
        return ChromaItems.STORAGE.matchWith(this.inv[0]);
    }

    private void calcSilkTouch() {
        Integer get = TileEntityAdjacencyUpgrade.getAdjacentUpgrades(this).get((Object)CrystalElement.PURPLE);
        this.silkTouch = get != null && get > 2;
    }

    @Override
    public void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        this.calcSilkTouch();
        this.updateRange();
        super.onAdjacentUpdate(world, x, y, z, b);
    }

    private void dropItems(World world, int x, int y, int z, Collection<ItemStack> li) {
        for (ItemStack is : li) {
            boolean flag = true;
            for (int i = 0; i < 6 && flag; ++i) {
                TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
                if (!(te instanceof IInventory) || !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)((IInventory)te))) continue;
                flag = false;
            }
            if (!flag) continue;
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 1.5), (double)((double)z + 0.5), (ItemStack)is);
            this.dropFlag = true;
            this.doDropWarning(world, x, y, z);
        }
    }

    private void doDropWarning(World world, int x, int y, int z) {
        if (this.lastWarning != world.func_82737_E()) {
            ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.MINERJAM.ordinal(), (TileEntity)this, (int)32, (int[])new int[0]);
        }
        this.lastWarning = world.func_82737_E();
    }

    @SideOnly(value=Side.CLIENT)
    public void doWarningParticles(World world, int x, int y, int z) {
        int n = 2 + rand.nextInt(6);
        for (int i = 0; i < n; ++i) {
            double rx = (double)x + rand.nextDouble();
            double ry = (double)y + rand.nextDouble();
            double rz = (double)z + rand.nextDouble();
            int l = 10 + rand.nextInt(20);
            float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125));
            EntityCenterBlurFX fx = new EntityCenterBlurFX(world, rx, ry, rz).setGravity(g).setLife(l);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void updateReadPosition() {
        boolean flag1 = false;
        boolean flag2 = false;
        ++this.readX;
        if (this.readX > this.range) {
            this.readX = -this.range;
            flag1 = true;
        }
        if (flag1) {
            ++this.readZ;
            if (this.readZ > this.range) {
                this.readZ = -this.range;
                flag2 = true;
            }
            if (flag2) {
                ++this.readY;
            }
        }
    }

    public boolean triggerDigging() {
        if (this.isReady()) {
            this.digging = true;
            this.dropFlag = false;
            ChromaSounds.USE.playSoundAtBlock((TileEntity)this);
            return true;
        }
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
        return false;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.readX = NBT.func_74762_e("rx");
        this.readY = NBT.func_74762_e("ry");
        this.readZ = NBT.func_74762_e("rz");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("rx", this.readX);
        NBT.func_74768_a("ry", this.readY);
        NBT.func_74768_a("rz", this.readZ);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.digging = NBT.func_74767_n("dig");
        this.digReady = NBT.func_74767_n("dig2");
        this.finishedDigging = NBT.func_74767_n("finish");
        this.index = NBT.func_74762_e("index");
        this.dropFlag = NBT.func_74767_n("dropped");
        this.silkTouch = NBT.func_74767_n("silk");
        this.found.clear();
        NBTTagList li = NBT.func_150295_c("count", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            int id = tag.func_74762_e("id");
            int meta = tag.func_74762_e("meta");
            int count = tag.func_74762_e("count");
            ItemStack is = new ItemStack(Item.func_150899_d((int)id), 1, meta);
            this.found.put(is, (Object)count);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("dig", this.digging);
        NBT.func_74757_a("dig2", this.digReady);
        NBT.func_74768_a("index", this.index);
        NBT.func_74757_a("finish", this.finishedDigging);
        NBT.func_74757_a("silk", this.silkTouch);
        NBTTagList li = new NBTTagList();
        for (ItemStack is : this.found.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("id", Item.func_150891_b((Item)is.func_77973_b()));
            tag.func_74768_a("meta", is.func_77960_j());
            tag.func_74768_a("count", ((Integer)this.found.get(is)).intValue());
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("count", (NBTBase)li);
        NBT.func_74757_a("dropped", this.dropFlag);
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        switch (slot) {
            case 0: {
                return ChromaItems.STORAGE.matchWith(is);
            }
        }
        return false;
    }

    public void breakBlock() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)(this.range >> 4));
    }

    @Override
    public float getCostModifier() {
        float f = 1.0f;
        if (this.silkTouch) {
            f *= 8.0f;
        }
        return f;
    }

    @Override
    public boolean usesColor(CrystalElement e) {
        return required.contains(e);
    }

    private void updateRange() {
        int val;
        int oldrange = this.range;
        double r = 1.0;
        Integer get = TileEntityAdjacencyUpgrade.getAdjacentUpgrades(this).get((Object)CrystalElement.LIME);
        int n = val = get != null ? get : 0;
        if (val > 0) {
            r = TileEntityRangeBoost.getFactor(val - 1);
        }
        this.range = (int)(128.0 * r);
        if (this.range != oldrange && !this.digging) {
            this.readX = 0;
            this.readY = 0;
            this.readZ = 0;
            this.digReady = false;
            this.found.clear();
            this.coords.clear();
        }
    }

    public boolean hasSilkTouch() {
        return this.silkTouch;
    }

    static {
        required.addTag(CrystalElement.YELLOW, 50);
        required.addTag(CrystalElement.LIME, 30);
        required.addTag(CrystalElement.GRAY, 20);
        required.addTag(CrystalElement.BROWN, 40);
    }
}

