/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMultiBuilder
extends TileEntityChromaticBase
implements LocationCached {
    private static final Collection<WorldLocation> cache = new HashSet<WorldLocation>();
    private Collection<RenderBeam> renderBeams = new ArrayList<RenderBeam>();
    private BlockBox bounds;
    private ArrayRegion region = new ArrayRegion();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.MULTIBUILDER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        WorldLocation loc;
        if (this.bounds == null) {
            this.bounds = BlockBox.block((TileEntity)this).expand(ForgeDirection.UP, 8);
        }
        if (!cache.contains(loc = new WorldLocation((TileEntity)this))) {
            cache.add(loc);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void expand(ForgeDirection dir) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.bounds = this.bounds.expand(Math.abs(dir.offsetX), 0, Math.abs(dir.offsetZ));
        this.syncAllData(false);
    }

    public void contract(ForgeDirection dir) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.bounds = this.bounds.contract(Math.abs(dir.offsetX), 0, Math.abs(dir.offsetZ));
        this.syncAllData(false);
    }

    public void expandArea(ForgeDirection dir) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (dir.offsetX != 0) {
            this.region.radiusX++;
        }
        if (dir.offsetZ != 0) {
            this.region.radiusZ++;
        }
        this.syncAllData(false);
    }

    public void contractArea(ForgeDirection dir) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (dir.offsetX != 0 && this.region.radiusX > 0) {
            this.region.radiusX--;
        }
        if (dir.offsetZ != 0 && this.region.radiusZ > 0) {
            this.region.radiusZ--;
        }
        this.syncAllData(false);
    }

    public void cycleShape() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.region.shape = this.region.shape.next();
        this.syncAllData(false);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        NBTTagCompound tag;
        super.writeSyncTag(NBT);
        if (this.bounds != null) {
            tag = new NBTTagCompound();
            this.bounds.writeToNBT(tag);
            NBT.func_74782_a("bounds", (NBTBase)tag);
        }
        tag = new NBTTagCompound();
        this.region.writeToNBT(tag);
        NBT.func_74782_a("region", (NBTBase)tag);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.bounds = NBT.func_74764_b("bounds") ? BlockBox.readFromNBT((NBTTagCompound)NBT.func_74775_l("bounds")) : null;
        this.region.readFromNBT(NBT.func_74775_l("region"));
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove(loc);
    }

    private void checkAndBuild(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep, ItemStack is) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73011_w.field_76574_g == this.field_145850_b.field_73011_w.field_76574_g && this.bounds.isBlockInside(x, y, z)) {
            for (Point p : this.region.getRegions(this.field_145851_c, this.field_145849_e, this.bounds)) {
                int dz;
                int dy;
                int dx;
                if (p.x == 0 && p.y == 0 || !this.buildBlock((WorldServer)world, dx = x + (this.bounds.getSizeX() - 1) * p.x, dy = y, dz = z + (this.bounds.getSizeZ() - 1) * p.y, b, meta, (EntityPlayerMP)ep, is)) continue;
                break;
            }
        }
    }

    private void checkAndBreak(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73011_w.field_76574_g == this.field_145850_b.field_73011_w.field_76574_g && this.bounds.isBlockInside(x, y, z)) {
            for (Point p : this.region.getRegions(this.field_145851_c, this.field_145849_e, this.bounds)) {
                if (p.x == 0 && p.y == 0) continue;
                int dx = x + (this.bounds.getSizeX() - 1) * p.x;
                int dy = y;
                int dz = z + (this.bounds.getSizeZ() - 1) * p.y;
                this.mineBlock((WorldServer)world, dx, dy, dz, b, meta, (EntityPlayerMP)ep);
            }
        }
    }

    private boolean buildBlock(WorldServer world, int x, int y, int z, Block b, int meta, EntityPlayerMP ep, ItemStack is) {
        if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z) && ReikaPlayerAPI.playerCanBreakAt((WorldServer)world, (int)x, (int)y, (int)z, (EntityPlayerMP)ep)) {
            if (is != null && is.field_77994_a > 0) {
                world.func_147465_d(x, y, z, b, meta, 3);
                b.func_149689_a((World)world, x, y, z, (EntityLivingBase)ep, is);
                b.func_149714_e((World)world, x, y, z, meta);
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)b);
                ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)Block.func_149682_b((Block)b), (int)meta);
                if (!ep.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void mineBlock(WorldServer world, int x, int y, int z, Block b, int meta, EntityPlayerMP ep) {
        if (new BlockKey(b, meta).matchInWorld((World)world, x, y, z) && ReikaPlayerAPI.playerCanBreakAt((WorldServer)world, (int)x, (int)y, (int)z, (EntityPlayerMP)ep)) {
            if (ep.field_71075_bZ.field_75098_d) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)b);
                ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)Block.func_149682_b((Block)b), (int)meta);
            } else {
                ReikaWorldHelper.dropAndDestroyBlockAt((World)world, (int)x, (int)y, (int)z, (EntityPlayer)ep, (boolean)true, (boolean)true);
            }
        }
    }

    public BlockBox getBounds() {
        return this.bounds;
    }

    @SideOnly(value=Side.CLIENT)
    public Collection<Point> getRegionsForRender() {
        ArrayList<Point> li = new ArrayList<Point>();
        for (Point p : this.region.getRegions(this.field_145851_c, this.field_145849_e, this.bounds)) {
            li.add(p);
        }
        return li;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.bounds != null ? ReikaAABBHelper.scaleAABB((AxisAlignedBB)this.bounds.asAABB(), (double)(1 + this.region.radiusX), (double)1.0, (double)(1 + this.region.radiusZ)) : super.getRenderBoundingBox();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBeams(float ptick, HashMap<DecimalPosition, Integer> columns) {
        Iterator<RenderBeam> it = this.renderBeams.iterator();
        while (it.hasNext()) {
            RenderBeam b = it.next();
            if (!b.render(ptick)) continue;
            it.remove();
        }
        if (rand.nextInt(10) == 0) {
            ArrayList<DecimalPosition> li = new ArrayList<DecimalPosition>(columns.keySet());
            DecimalPosition pos1 = li.get(rand.nextInt(li.size()));
            DecimalPosition pos2 = li.get(rand.nextInt(li.size()));
            while (pos2.equals((Object)pos1)) {
                pos2 = li.get(rand.nextInt(li.size()));
            }
            this.renderBeams.add(new RenderBeam(pos1, pos2, columns.get(pos1), columns.get(pos2), rand));
        }
    }

    public static void placeBlock(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep, ItemStack is) {
        Iterator<WorldLocation> it = cache.iterator();
        while (it.hasNext()) {
            WorldLocation loc = it.next();
            TileEntity te = loc.getTileEntity();
            if (te instanceof TileEntityMultiBuilder) {
                ((TileEntityMultiBuilder)te).checkAndBuild(world, x, y, z, b, meta, ep, is);
                continue;
            }
            it.remove();
            ChromatiCraft.logger.logError((Object)("Incorrect tile (" + te + ") @ " + loc + " in Multi Builder cache!?"));
        }
    }

    public static void breakBlock(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep) {
        Iterator<WorldLocation> it = cache.iterator();
        while (it.hasNext()) {
            WorldLocation loc = it.next();
            TileEntity te = loc.getTileEntity();
            if (te instanceof TileEntityMultiBuilder) {
                if (x == te.field_145851_c && y == te.field_145848_d && z == te.field_145849_e) continue;
                ((TileEntityMultiBuilder)te).checkAndBreak(world, x, y, z, b, meta, ep);
                continue;
            }
            it.remove();
            ChromatiCraft.logger.logError((Object)("Incorrect tile (" + te + ") @ " + loc + " in Multi Builder cache!?"));
        }
    }

    public static void clearCache() {
        cache.clear();
    }

    private static class RenderBeam {
        private final DecimalPosition pos1;
        private final DecimalPosition pos2;
        private final int color1;
        private final int color2;
        private int age;
        private final int maxAge;

        private RenderBeam(DecimalPosition p1, DecimalPosition p2, int c1, int c2, Random rand) {
            this.pos1 = p1;
            this.pos2 = p2;
            this.color1 = c1;
            this.color2 = c2;
            this.maxAge = 10 + rand.nextInt(41);
        }

        @SideOnly(value=Side.CLIENT)
        private boolean render(float ptick) {
            ++this.age;
            float f = (float)Math.sin(Math.toRadians(180.0 * (double)this.age / (double)this.maxAge));
            int c1 = ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color1, (float)f);
            int c2 = ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color2, (float)f);
            ChromaFX.renderBeam(this.pos1.xCoord, this.pos1.yCoord, this.pos1.zCoord, this.pos2.xCoord, this.pos2.yCoord, this.pos2.zCoord, ptick, 255, 0.125, c1, c2);
            return this.age >= this.maxAge;
        }
    }

    private static enum RegionShape {
        RECTANGLE,
        DIAMOND,
        ELLIPSE,
        HEXAGON,
        OCTAGON;

        private static final RegionShape[] list;

        private boolean isPointInShape(int i, int k, int radiusX, int radiusZ) {
            switch (this) {
                case RECTANGLE: {
                    return true;
                }
                case ELLIPSE: {
                    return ReikaMathLibrary.isPointInsideEllipse((double)i, (double)0.0, (double)k, (double)radiusX, (double)0.0, (double)radiusZ);
                }
                case DIAMOND: {
                    return Math.abs(i) + Math.abs(k) < Math.max(radiusX, radiusZ);
                }
                case HEXAGON: {
                    return ReikaMathLibrary.isPointInsidePolygon((double)i, (double)k, (double)6.0, (double)radiusX, (double)radiusZ);
                }
                case OCTAGON: {
                    return ReikaMathLibrary.isPointInsidePolygon((double)i, (double)k, (double)8.0, (double)radiusX, (double)radiusZ);
                }
            }
            return false;
        }

        public RegionShape next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        static {
            list = RegionShape.values();
        }
    }

    private static class ArrayRegion {
        private RegionShape shape = RegionShape.RECTANGLE;
        private int radiusX = 2;
        private int radiusZ = 2;

        private ArrayRegion() {
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("shape", this.shape.ordinal());
            tag.func_74768_a("rx", this.radiusX);
            tag.func_74768_a("rz", this.radiusZ);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.shape = RegionShape.list[tag.func_74762_e("shape")];
            this.radiusX = tag.func_74762_e("rx");
            this.radiusZ = tag.func_74762_e("rz");
        }

        private Collection<Point> getRegions(int x, int z, BlockBox zone) {
            ArrayList<Point> li = new ArrayList<Point>();
            for (int i = -this.radiusX; i <= this.radiusX; ++i) {
                for (int k = -this.radiusZ; k <= this.radiusZ; ++k) {
                    if (!this.shape.isPointInShape(i, k, this.radiusX, this.radiusZ)) continue;
                    li.add(new Point(i, k));
                }
            }
            return li;
        }
    }
}

