/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityHoverPad
extends TileEntityChromaticBase {
    private HoverMode mode = HoverMode.HOVER;
    private double[] particleX;
    private double[] particleY;
    private double[] particleZ;
    private AxisAlignedBB hoverBox;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.hoverBox != null) {
            if (world.field_72995_K) {
                this.spawnParticles(world, x, y, z);
            }
            List li = world.func_72872_a(EntityPlayer.class, this.hoverBox);
            for (EntityPlayer ep : li) {
                if (ep.func_70093_af() || ep.field_70122_E || ep.field_71075_bZ.field_75100_b) continue;
                ep.field_70181_x = this.mode.fallVelocity;
                ep.field_70133_I = true;
                float v = 0.15f;
                float v2 = 0.0f;
                if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LEFT)) {
                    v2 = v / 2.0f;
                } else if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.RIGHT)) {
                    v2 = v / 2.0f;
                }
                ep.func_70060_a(v2, v, v);
            }
        }
    }

    private int getParticleRate() {
        int base = this.mode == HoverMode.HOVER ? 1 : 4;
        base = (int)((double)base * (4.0 * Math.sqrt(ReikaAABBHelper.getVolume((AxisAlignedBB)this.hoverBox) / 480.0)));
        return base;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.hoverBox = this.calculateBox(world, x, y, z);
        ReikaJavaLibrary.pConsole((Object)this.hoverBox);
        if (this.hoverBox != null) {
            this.initParticleVectors();
        }
    }

    private AxisAlignedBB calculateBox(World world, int x, int y, int z) {
        int dy = y - 1;
        while (world.func_147439_a(x, dy, z).isAir((IBlockAccess)world, x, dy, z)) {
            --dy;
        }
        Block bk = world.func_147439_a(x, dy, z);
        if (bk != ChromaBlocks.PAD.getBlockInstance()) {
            return null;
        }
        BlockArray b = new BlockArray();
        b.recursiveAddWithBounds(world, x, dy, z, ChromaBlocks.PAD.getBlockInstance(), x - 32, x + 32, dy, dy, z - 32, z + 32);
        HashSet set = new HashSet(b.keySet());
        for (int i = 1; i < 16; ++i) {
            for (Coordinate c : set) {
                bk = world.func_147439_a(c.xCoord, c.yCoord + i, c.zCoord);
                if (!bk.isAir((IBlockAccess)world, c.xCoord, c.yCoord + i, c.zCoord)) continue;
                b.addBlockCoordinate(c.xCoord, c.yCoord + i, c.zCoord);
            }
        }
        b.shaveToCube();
        return b.asAABB();
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        int t = this.mode == HoverMode.HOVER ? 2 : 8;
        int n = this.getParticleRate();
        for (int i = 0; i < n; ++i) {
            if ((this.getTicksExisted() + i * t / n) % t == 0) {
                this.particleX[i] = ReikaRandomHelper.getRandomBetween((double)this.hoverBox.field_72340_a, (double)this.hoverBox.field_72336_d);
                this.particleY[i] = ReikaRandomHelper.getRandomBetween((double)this.hoverBox.field_72338_b, (double)this.hoverBox.field_72337_e);
                this.particleZ[i] = ReikaRandomHelper.getRandomBetween((double)this.hoverBox.field_72339_c, (double)this.hoverBox.field_72334_f);
            }
            float s = 1.5f;
            int l = 25;
            float g = 0.0f;
            int c = this.mode.particleColor;
            double v = -this.mode.particleGravity * 2.0f;
            EntityBlurFX fx = new EntityBlurFX(world, this.particleX[i], this.particleY[i], this.particleZ[i], 0.0, v, 0.0).setGravity(g).setColor(c).setLife(l).setScale(s).setIcon(ChromaIcons.FADE_GENTLE);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.HOVERPAD;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void toggleMode() {
        this.mode = this.mode.next();
        this.initParticleVectors();
        ChromaSounds.USE.playSoundAtBlock((TileEntity)this, 0.75f, 1.0f);
    }

    private void initParticleVectors() {
        this.particleX = new double[this.getParticleRate()];
        this.particleY = new double[this.getParticleRate()];
        this.particleZ = new double[this.getParticleRate()];
        this.randomizeParticleLocations();
    }

    private void randomizeParticleLocations() {
        int n = this.getParticleRate();
        for (int i = 0; i < n; ++i) {
            this.particleX[i] = ReikaRandomHelper.getRandomBetween((double)this.hoverBox.field_72340_a, (double)this.hoverBox.field_72336_d);
            this.particleY[i] = ReikaRandomHelper.getRandomBetween((double)this.hoverBox.field_72338_b, (double)this.hoverBox.field_72337_e);
            this.particleZ[i] = ReikaRandomHelper.getRandomBetween((double)this.hoverBox.field_72339_c, (double)this.hoverBox.field_72334_f);
        }
    }

    public static enum HoverMode {
        RISE(65280, -0.0625f, 0.1875),
        HOVER(0xFFFF00, 0.0f, 0.0),
        FALL(0xFF0000, 0.0625f, -0.1875);

        public final int particleColor;
        public final float particleGravity;
        public final double fallVelocity;
        private static final HoverMode[] list;

        private HoverMode(int c, float g, double v) {
            this.particleColor = c;
            this.particleGravity = g;
            this.fallVelocity = v;
        }

        private HoverMode next() {
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }

        static {
            list = HoverMode.values();
        }
    }
}

