/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrystalLaser
extends InventoriedRelayPowered {
    private static final HashSet<CrystalElement> localEffects = new HashSet();
    private static final HashSet<CrystalElement> aabbEffects = new HashSet();
    private int range;
    private StepTimer rangeTimer = new StepTimer(20);
    public static final int MAX_RANGE = 128;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.LASER;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        ForgeDirection dir = this.getFacing();
        this.rangeTimer.update();
        if (this.rangeTimer.checkCap()) {
            this.range = this.updateRange(dir);
        }
        if (this.isActive()) {
            if (!world.field_72995_K) {
                this.applyEffects(world, x, y, z, dir);
            }
            if (world.field_72995_K) {
                this.spawnParticles(world, x, y, z, dir);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z, ForgeDirection dir) {
        int c = 4 + 4 * Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (rand.nextInt(c) == 0) {
            this.spawnParticle(world, x, y, z, dir);
        }
    }

    private int updateRange(ForgeDirection dir) {
        if (!this.isActive()) {
            return 0;
        }
        int energy = this.getEnergy(this.getColor());
        int max = (int)Math.min(Math.sqrt(energy / 4), 128.0);
        for (int i = 1; i <= max; ++i) {
            int dx = this.field_145851_c + dir.offsetX * i;
            int dy = this.field_145848_d + dir.offsetY * i;
            int dz = this.field_145849_e + dir.offsetZ * i;
            Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
            if (b == Blocks.field_150350_a || !b.func_149662_c()) continue;
            return i;
        }
        return max;
    }

    public boolean isActive() {
        return ChromaItems.LENS.matchWith(this.inv[0]) && this.getEnergy(this.getColor()) > 0;
    }

    private void applyEffects(World world, int x, int y, int z, ForgeDirection dir) {
        int r = this.getRange();
        CrystalElement color = this.getColor();
        if (aabbEffects.contains((Object)color)) {
            AxisAlignedBB box = this.getAABB(r);
            List li = world.func_72872_a(Entity.class, box);
            switch (color) {
                case LIME: {
                    double vmax = 1.0;
                    for (Entity e : li) {
                        if (Math.abs(e.field_70159_w) < vmax) {
                            e.field_70159_w += (double)this.getFacing().offsetX * 0.0625;
                        }
                        if (Math.abs(e.field_70181_x) < vmax) {
                            e.field_70181_x += (double)this.getFacing().offsetY * 0.0625;
                        }
                        if (!(Math.abs(e.field_70179_y) < vmax)) continue;
                        e.field_70179_y += (double)this.getFacing().offsetZ * 0.0625;
                    }
                    break;
                }
                case RED: {
                    for (Entity e : li) {
                        if (!(e instanceof EntityLivingBase)) continue;
                        ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 100, 1));
                    }
                    break;
                }
                case BLACK: {
                    for (Entity e : li) {
                        if (!(e instanceof EntityPlayer)) continue;
                        EntityPlayer ep = (EntityPlayer)e;
                    }
                    break;
                }
            }
        }
        if (localEffects.contains((Object)color)) {
            block13: for (int i = 1; i <= r; ++i) {
                int dx = x + dir.offsetX * i;
                int dy = y + dir.offsetY * i;
                int dz = z + dir.offsetZ * i;
                switch (color) {
                    case BLUE: {
                        if (!world.func_147439_a(dx, dy, dz).isAir((IBlockAccess)world, dx, dy, dz)) continue block13;
                        world.func_147465_d(dx, dy, dz, ChromaBlocks.LIGHT.getBlockInstance(), 0, 3);
                        continue block13;
                    }
                    case GREEN: {
                        Block b = world.func_147439_a(dx, dy, dz);
                        b.func_149674_a(world, dx, dy, dz, rand);
                        BlockTickEvent.fire((World)world, (int)dx, (int)dy, (int)dz, (Block)b, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
                        continue block13;
                    }
                    case ORANGE: {
                        ReikaWorldHelper.temperatureEnvironment((World)world, (int)dx, (int)dy, (int)dz, (int)400);
                        continue block13;
                    }
                }
            }
        }
        this.drainEnergy(color, this.getRange());
    }

    public AxisAlignedBB getAABB(int range) {
        int minx = 0;
        int miny = 0;
        int minz = 0;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        switch (this.getFacing()) {
            case WEST: {
                minx = this.field_145851_c - range - 1;
                maxx = this.field_145851_c;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minz = this.field_145849_e;
                maxz = this.field_145849_e + 1;
                break;
            }
            case EAST: {
                minx = this.field_145851_c + 1;
                maxx = this.field_145851_c + range + 1;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minz = this.field_145849_e;
                maxz = this.field_145849_e + 1;
                break;
            }
            case SOUTH: {
                maxz = this.field_145849_e + range + 1;
                minz = this.field_145849_e + 1;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case NORTH: {
                maxz = this.field_145849_e;
                minz = this.field_145849_e - range - 1;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case UP: {
                minz = this.field_145849_e;
                maxz = this.field_145849_e + 1;
                miny = this.field_145848_d + 1;
                maxy = this.field_145848_d + range + 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case DOWN: {
                minz = this.field_145849_e;
                maxz = this.field_145849_e + 1;
                maxy = this.field_145848_d;
                miny = this.field_145848_d - range;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
        }
        return AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz).func_72314_b(0.0, 0.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticle(World world, int x, int y, int z, ForgeDirection dir) {
        int num = 1 + this.getRange() / 32;
        for (int i = 0; i < num; ++i) {
            double r = rand.nextDouble() * (double)this.getRange();
            double rx = (double)x + 0.5 + r * (double)dir.offsetX;
            double ry = (double)y + 0.5 + r * (double)dir.offsetY;
            double rz = (double)z + 0.5 + r * (double)dir.offsetZ;
            double px = ReikaRandomHelper.getRandomPlusMinus((double)rx, (double)0.25);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)ry, (double)0.25);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)rz, (double)0.25);
            EntityLaserFX fx = new EntityLaserFX(this.getColor(), world, px, py, pz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public ForgeDirection getFacing() {
        switch (this.func_145832_p()) {
            case 0: {
                return ForgeDirection.WEST;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.UP;
            }
            case 5: {
                return ForgeDirection.DOWN;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public CrystalElement getColor() {
        return this.inv[0] != null && ChromaItems.LENS.matchWith(this.inv[0]) ? CrystalElement.elements[this.inv[0].func_77960_j()] : null;
    }

    public int getRange() {
        return this.range;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return side == 0;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack swapLens(ItemStack is) {
        ItemStack ret = this.inv[0] != null ? this.inv[0].func_77946_l() : null;
        this.inv[0] = is != null ? is.func_77946_l() : null;
        return ret;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return ChromaItems.LENS.matchWith(is);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int r = this.getRange();
        ForgeDirection f = this.getFacing();
        int fx = f.offsetX;
        int fy = f.offsetY;
        int fz = f.offsetZ;
        return r > 0 ? ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b((double)(fx * r), (double)(fy * r), (double)(fz * r)) : super.getRenderBoundingBox();
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.range = NBT.func_74762_e("range");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("range", this.range);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 65536;
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return e == this.getColor();
    }

    @Override
    protected ElementTagCompound getRequiredEnergy() {
        ElementTagCompound tag = new ElementTagCompound();
        if (this.getColor() != null) {
            tag.addValueToColor(this.getColor(), 1);
        }
        return tag;
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return dir == this.getFacing().getOpposite();
    }

    static {
        localEffects.add(CrystalElement.GREEN);
        localEffects.add(CrystalElement.ORANGE);
        aabbEffects.add(CrystalElement.RED);
        aabbEffects.add(CrystalElement.BLACK);
        aabbEffects.add(CrystalElement.MAGENTA);
        aabbEffects.add(CrystalElement.LIME);
    }
}

