/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityChromaLamp
extends TileEntityChromaticBase
implements LocationCached {
    private static final HashMap<WorldLocation, Integer> cache = new HashMap();
    public static final int FACTOR = 8;
    private final ElementTagCompound colors = new ElementTagCompound();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.LAMP;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.cacheTile();
    }

    public int getRange() {
        return 8 * this.colors.tagCount();
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.colors.readFromNBT("energy", NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.colors.writeToNBT("energy", NBT);
    }

    private void cacheTile() {
        cache.put(new WorldLocation((TileEntity)this), this.getRange());
    }

    public void breakBlock() {
        cache.remove(new WorldLocation((TileEntity)this));
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static boolean findLampFromXYZ(World world, double x, double z) {
        for (WorldLocation loc : cache.keySet()) {
            int max = cache.get(loc);
            double dx = Math.abs(x - (double)loc.xCoord);
            double dz = Math.abs(z - (double)loc.zCoord);
            if (!(dx <= (double)max) || !(dz <= (double)max)) continue;
            return true;
        }
        return false;
    }

    public ElementTagCompound getColors() {
        return this.colors.copy();
    }

    public boolean addColor(CrystalElement e) {
        if (this.colors.contains(e)) {
            return false;
        }
        this.colors.addValueToColor(e, 1);
        this.cacheTile();
        return true;
    }
}

