/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.API.Interfaces.RangeUpgradeable;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.Decoration.BlockEtherealLight;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockSpiral;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TileEntityCaveLighter
extends TileEntityChromaticBase
implements RangeUpgradeable {
    public static final int BASE_RANGE = Math.min(64, ChromaOptions.CAVELIGHTERRANGE.getValue());
    public static final int MAXY = 80;
    private static final int ZONE_SIZE = MathHelper.func_76125_a((int)4, (int)16, (int)ChromaOptions.CAVELIGHTERSIZE.getValue());
    private final BlockSpiral[] spiral = new BlockSpiral[80 / ZONE_SIZE];
    private int idleTicks;
    private int range;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.LIGHTER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
        } else {
            this.placeLights(world, x, y, z);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("idle", this.idleTicks);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.idleTicks = NBT.func_74762_e("idle");
    }

    private void placeLights(World world, int x, int y, int z) {
        boolean flag = false;
        block0: for (int m = 0; m < 1; ++m) {
            for (int i = 0; i < this.spiral.length; ++i) {
                int cz;
                int cy;
                if (this.spiral[i].getSize() <= 0) continue;
                Coordinate c = this.spiral[i].getNextAndMoveOn();
                int cx = c.xCoord + rand.nextInt(ZONE_SIZE);
                if (this.placeBlockAt(world, cx, cy = 4 + c.yCoord + rand.nextInt(ZONE_SIZE), cz = c.zCoord + rand.nextInt(ZONE_SIZE))) {
                    world.func_147465_d(cx, cy, cz, ChromaBlocks.LIGHT.getBlockInstance(), BlockEtherealLight.Flags.PARTICLES.getFlag(), 3);
                    world.func_147471_g(cx, cy, cz);
                    ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.LIGHTERACT.ordinal(), (TileEntity)this, (int)32, (int[])new int[]{cx, cy, cz});
                }
                flag = true;
                if (this.spiral[i].getSize() != 0) continue block0;
                ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.LIGHTERDELTAY.ordinal(), (TileEntity)this, (int)32, (int[])new int[]{(i + 1) * ZONE_SIZE});
                if (i != this.spiral.length - 1) continue block0;
                ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.LIGHTEREND.ordinal(), (TileEntity)this, (int)32, (int[])new int[0]);
                continue block0;
            }
        }
        if (!flag) {
            ++this.idleTicks;
            if (this.idleTicks > 100) {
                this.idleTicks = 0;
                this.initSpirals(world, x, y, z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (this.idleTicks > 0) {
            ReikaParticleHelper.spawnColoredParticlesWithOutset((World)world, (int)x, (int)y, (int)z, (double)5.0, (double)5.0, (double)5.0, (int)8, (double)0.0625);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doDeltaYParticles(int newY) {
        int n = 6 + rand.nextInt(18);
        int c = BlockEtherealLight.getParticleColor(this.field_145850_b, newY);
        for (int i = 0; i < n; ++i) {
            double rx = (double)this.field_145851_c + rand.nextDouble();
            double ry = (double)this.field_145848_d + rand.nextDouble();
            double rz = (double)this.field_145849_e + rand.nextDouble();
            EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, rx, ry, rz).setColor(c).setGravity(-0.03125f).setLife(30).setScale(1.25f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doCompletionParticles() {
        int n = 16 + rand.nextInt(24);
        for (int i = 0; i < n; ++i) {
            double dx = rand.nextDouble() - 0.5;
            double dy = rand.nextDouble() - 0.5;
            double dz = rand.nextDouble() - 0.5;
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.25, (double)0.125);
            double rx = (double)this.field_145851_c + 0.5 + dx;
            double ry = (double)this.field_145848_d + 0.5 + dy;
            double rz = (double)this.field_145849_e + 0.5 + dz;
            EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, rx, ry, rz, dx * v, dy * v, dz * v).setColor(0xFFFFFF).setGravity(0.0f).setLife(60).setScale(1.75f).setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.CAST, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void doLightedParticles(int x, int y, int z) {
        double dx = x - this.field_145851_c;
        double dz = z - this.field_145849_e;
        double ang = Math.toRadians(-90.0 - ReikaPhysicsHelper.cartesianToPolar((double)dx, (double)0.0, (double)dz)[2]);
        double mr = 3.0;
        for (double r = 0.0; r < mr; r += 0.0625) {
            double px = (double)this.field_145851_c + 0.5 + r * Math.cos(ang);
            double pz = (double)this.field_145849_e + 0.5 + r * Math.sin(ang);
            int c = BlockEtherealLight.getParticleColor(this.field_145850_b, y);
            float s = (float)(2.0 - r / mr * 2.0);
            EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, px, (double)this.field_145848_d + 0.5, pz).setColor(c).setGravity(0.0f).setLife(80).setScale(s).setRapidExpand().setIcon(ChromaIcons.CENTER);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.range = BASE_RANGE;
        this.initSpirals(world, x, y, z);
    }

    private void initSpirals(World world, int x, int y, int z) {
        for (int i = 0; i < this.spiral.length; ++i) {
            this.spiral[i] = new BlockSpiral(x, i * ZONE_SIZE, z, this.range / ZONE_SIZE).setRightHanded().setGridSize(ZONE_SIZE).calculate();
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private boolean placeBlockAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z) && y < this.getMaxY(world, x, z) && this.isDark(world, x, y, z);
    }

    private int getMaxY(World world, int x, int z) {
        BiomeGenBase b = world.func_72807_a(x, z);
        return BiomeGlowingCliffs.isGlowingCliffs(b) ? 60 : 80;
    }

    private boolean isDark(World world, int x, int y, int z) {
        return !world.func_72937_j(x, y + 1, z) && world.func_72957_l(x, y, z) <= 7 && world.func_72972_b(EnumSkyBlock.Sky, x, y, z) < 4;
    }

    @Override
    public void upgradeRange(double r) {
        int last = this.range;
        this.range = (int)((double)BASE_RANGE * r);
        if (this.range != last) {
            this.initSpirals(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public int getRange() {
        return this.range;
    }
}

