/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityLocusPoint;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.GlowKnot;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FastBlockCache;
import Reika.DragonAPI.Instantiable.Data.Collections.FastPlayerCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Registry.CropType;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.VoidMonster.Entity.EntityVoidMonster;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import vazkii.botania.api.boss.IBotaniaBoss;

public class TileEntityAuraPoint
extends TileEntityLocusPoint
implements OwnedTile {
    @SideOnly(value=Side.CLIENT)
    public GlowKnot knot;
    private static final String NBT_TAG = "aurapoint";
    private static final int NEW_CROPS_PER_TICK = 256;
    private static final int CROPS_PER_TICK = 16;
    private static final int CROP_UPDATES = 8;
    private static final int CROP_RANGE = 96;
    private static final CropType sugarcane = new SugarCaneCrop();
    private int hue;
    private float saturation;
    private int hueTarget;
    private float saturationTarget;
    private final FastBlockCache cache = new FastBlockCache();
    private final FastPlayerCache hostilePlayers = new FastPlayerCache();
    public boolean doPVP = true;

    public TileEntityAuraPoint() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.loadGlowKnot();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void loadGlowKnot() {
        this.knot = new GlowKnot(0.875);
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
        this.removePoint();
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K) {
            this.playSounds(world, x, y, z);
            this.doAmbientEffects(world, x, y, z);
        }
    }

    private void playSounds(World world, int x, int y, int z) {
        double[] arr = new double[]{0.5, 1.0, 2.0};
        for (int i = 0; i < arr.length; ++i) {
            double d = arr[i];
            int t = (int)(221.0 / d);
            if (this.getTicksExisted() % t == 0) {
                ChromaSounds.DRONE.playSoundAtBlock(world, x, y, z, 0.75f, (float)d);
            }
            float f = 0.85f;
            if (this.getTicksExisted() % (int)(72.0f / f) != 0) continue;
            ChromaSounds.POWER.playSoundAtBlock(world, x, y, z, 0.1f, f);
        }
    }

    private void doAmbientEffects(World world, int x, int y, int z) {
        if (rand.nextInt(20) == 0) {
            this.killEntities(world, x, y, z);
        }
        if (rand.nextInt(160) == 0) {
            this.healFriendly(world, x, y, z);
        }
        if (rand.nextInt(2) == 0) {
            this.growCrops(world, x, y, z);
        }
    }

    private void killEntities(World world, int x, int y, int z) {
        int r = this.getAttackRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - r), (double)0.0, (double)(z - r), (double)(x + 1 + r), (double)256.0, (double)(z + 1 + r));
        List li = world.func_72872_a(EntityLivingBase.class, box);
        boolean flag = false;
        int i = 0;
        for (EntityLivingBase e : li) {
            if (!this.shouldAttack(e)) continue;
            this.attack(world, x, y, z, e);
            flag = true;
            ++i;
        }
        if (flag) {
            ChromaSounds.DISCHARGE.playSoundAtBlock((TileEntity)this);
            EntityPlayer ep = this.getPlacer();
            if (ep != null && ep.func_70011_f((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 32.0) {
                ChromaSounds.DISCHARGE.playSound((Entity)ep, 0.125f, 0.75f);
            }
        }
    }

    private int getAttackRange() {
        return (int)Math.min(8L + this.getTileEntityAge() / 16L, 96L);
    }

    private int getHealRange() {
        return (int)Math.min(4L + this.getTileEntityAge() / 64L, 32L);
    }

    private int getCropRange() {
        return (int)Math.min(1L + this.getTileEntityAge() / 128L, 96L);
    }

    private void attack(World world, int x, int y, int z, EntityLivingBase e) {
        float dmg = this.getAttackDamage(e);
        ChromaAux.doPylonAttack(CrystalElement.WHITE, e, dmg, false);
        ChromaSounds.DISCHARGE.playSound((Entity)e, 0.5f, 1.0f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.AURATTACK.ordinal(), (TileEntity)this, (int)192, (int[])new int[]{e.func_145782_y()});
    }

    private float getAttackDamage(EntityLivingBase e) {
        if (ModList.BOTANIA.isLoaded() && e instanceof IBotaniaBoss) {
            return 100.0f;
        }
        if (e instanceof EntityPlayer) {
            return 10.0f;
        }
        return Math.max(4.0f, e.func_110143_aJ() / 2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void doAttackFX(Entity e) {
        if (e != null) {
            double x = (double)this.field_145851_c + 0.5;
            double y = (double)this.field_145848_d + 0.5;
            double z = (double)this.field_145849_e + 0.5;
            double dx = e.field_70165_t - x;
            double dy = e.field_70163_u + (double)(e.field_70131_O / 2.0f) - y;
            double dz = e.field_70161_v - z;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            for (double d = 0.0; d <= dd; d += 0.5) {
                double f = d / dd;
                double f2 = f < 0.5 ? 1.0 - f : f;
                double px = x + f * dx;
                double py = y + f * dy;
                double pz = z + f * dz;
                px = ReikaRandomHelper.getRandomPlusMinus((double)px, (double)0.25);
                py = ReikaRandomHelper.getRandomPlusMinus((double)py, (double)0.25);
                pz = ReikaRandomHelper.getRandomPlusMinus((double)pz, (double)0.25);
                float sc = 2.5f + (float)((1.0 - f2) * 20.0);
                sc = (float)ReikaRandomHelper.getRandomPlusMinus((double)sc, (double)0.25);
                EntityBlurFX fx = new EntityBlurFX(e.field_70170_p, px, py, pz).setScale(sc).setRapidExpand().setLife(10).setIcon(ChromaIcons.FLARE);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    private boolean shouldAttack(EntityLivingBase e) {
        if (e.func_110143_aJ() <= 0.0f || e.field_70128_L) {
            return false;
        }
        if (e instanceof EntityPlayer) {
            if (!this.doPVP) {
                return false;
            }
            EntityPlayer ep = (EntityPlayer)e;
            if (this.isPlacer(ep)) {
                return false;
            }
            return this.hostilePlayers.containsPlayer(ep);
        }
        if (ModList.VOIDMONSTER.isLoaded() && e instanceof EntityVoidMonster) {
            return e.field_70163_u > 4.0;
        }
        return ReikaEntityHelper.isHostile((EntityLivingBase)e) || e instanceof EntityEnderman || e instanceof EntityPigZombie;
    }

    private void growCrops(World world, int x, int y, int z) {
        ArrayList bks = new ArrayList(this.cache.getBlocks());
        ArrayList<Coordinate> remove = new ArrayList<Coordinate>();
        int n = Math.min(16, bks.size() / 2);
        for (int i = 0; i < n; ++i) {
            int index = rand.nextInt(bks.size());
            Coordinate c = (Coordinate)bks.get(index);
            CropType type = this.getCropAt(world, c);
            if (type == null) {
                remove.add(c);
                continue;
            }
            if (type.isRipe(world, c.xCoord, c.yCoord, c.zCoord)) continue;
            int state = type.getGrowthState(world, c.xCoord, c.yCoord, c.zCoord);
            for (int k = 0; k < 8; ++k) {
                c.updateTick(world, rand);
            }
            if (state == type.getGrowthState(world, c.xCoord, c.yCoord, c.zCoord)) continue;
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.AURAGROW.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{c.xCoord, c.yCoord, c.zCoord});
        }
        for (Coordinate c : remove) {
            this.cache.removeBlock(c);
        }
        for (int k = 0; k < 256; ++k) {
            int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)this.getCropRange());
            int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)this.getCropRange());
            int dy = rand.nextInt(1 + ReikaWorldHelper.getTopNonAirBlock((World)world, (int)x, (int)z));
            Coordinate c = new Coordinate(dx, dy, dz);
            if (this.cache.containsBlock(c)) {
                --k;
                continue;
            }
            CropType type = this.getCropAt(world, c);
            if (type == null) continue;
            this.cache.addBlock(c);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doGrowFX(int x, int y, int z) {
        ReikaParticleHelper.BONEMEAL.spawnAroundBlock(this.field_145850_b, x, y, z, 4);
    }

    private CropType getCropAt(World world, Coordinate c) {
        Block b = c.getBlock(world);
        if (b == Blocks.field_150436_aH) {
            return sugarcane;
        }
        int meta = c.getBlockMetadata(world);
        ReikaCropHelper type = ReikaCropHelper.getCrop((Block)b);
        if (type == null) {
            type = ModCropList.getModCrop((Block)b, (int)meta);
        }
        return type;
    }

    private void healFriendly(World world, int x, int y, int z) {
        int r = this.getHealRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - r), (double)0.0, (double)(z - r), (double)(x + 1 + r), (double)256.0, (double)(z + 1 + r));
        List li = world.func_72872_a(EntityLivingBase.class, box);
        boolean flag = false;
        for (EntityLivingBase e : li) {
            if (!this.shouldHeal(e)) continue;
            this.heal(e);
            flag = true;
        }
    }

    private void heal(EntityLivingBase e) {
        e.func_70691_i(e.func_110138_aP());
        ChromaSounds.CAST.playSound((Entity)e, 0.5f, 1.0f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.AURAHEAL.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{e.func_145782_y()});
    }

    @SideOnly(value=Side.CLIENT)
    public void doHealFX(Entity e) {
        for (int i = 0; i < 32; ++i) {
            double x = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70165_t, (double)1.5);
            double z = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70161_v, (double)1.5);
            double y = e.field_70163_u - 1.0 + (double)(rand.nextFloat() * (e.field_70131_O + 2.0f));
            ReikaParticleHelper.MOBSPELL.spawnAt(e.field_70170_p, x, y, z);
        }
    }

    private boolean shouldHeal(EntityLivingBase e) {
        if (e.func_110143_aJ() >= e.func_110138_aP()) {
            return false;
        }
        if (e instanceof EntityPlayer) {
            EntityPlayer ep = (EntityPlayer)e;
            return this.isPlacer(ep) || !this.hostilePlayers.containsPlayer(ep);
        }
        return e instanceof EntityAnimal;
    }

    public void markHostile(EntityPlayer ep) {
        this.hostilePlayers.addPlayer(ep);
    }

    private void updateColors() {
        float ds = this.saturationTarget - this.saturation;
        int dh = this.hueTarget - this.hue;
        if (dh == 0 && (double)Math.abs(ds) < 0.03125) {
            this.hueTarget = rand.nextInt(360);
            this.saturationTarget = rand.nextFloat() * rand.nextFloat();
        }
        this.saturation = (float)((double)this.saturation + 0.00390625 * (double)Math.signum(ds));
        int hd = (int)Math.signum(dh);
        this.hue = Math.abs(dh) >= 180 ? (this.hue -= hd) : (this.hue += hd);
        if (this.hue < 0 || this.hue >= 360) {
            this.hue = (this.hue % 360 + 360) % 360;
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.AURAPOINT;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            if (world != null) {
                for (int i = 0; i < 5; ++i) {
                    this.knot.update();
                }
            }
            this.knot.update();
        }
        this.updateColors();
    }

    @Override
    public int getRenderColor() {
        return Color.HSBtoRGB((float)this.hue / 360.0f, this.saturation, 1.0f);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagCompound tag = new NBTTagCompound();
        this.cache.writeToNBT(tag);
        NBT.func_74782_a("crops", (NBTBase)tag);
        tag = new NBTTagCompound();
        this.hostilePlayers.writeToNBT(tag);
        NBT.func_74782_a("hostile", (NBTBase)tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.cache.readFromNBT(NBT.func_74775_l("crops"));
        this.hostilePlayers.readFromNBT(NBT.func_74775_l("hostile"));
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("pvp", this.doPVP);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.doPVP = NBT.func_74767_n("pvp");
    }

    public void savePoint() {
        EntityPlayer ep = this.getPlacer();
        NBTTagCompound tag = new NBTTagCompound();
        new WorldLocation((TileEntity)this).writeToNBT(tag);
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        nbt.func_74782_a(NBT_TAG, (NBTBase)tag);
    }

    public static TileEntityAuraPoint getPoint(EntityPlayer ep) {
        TileEntity te;
        NBTTagCompound tag;
        WorldLocation loc;
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        if (nbt.func_74764_b(NBT_TAG) && (loc = WorldLocation.readFromNBT((NBTTagCompound)(tag = nbt.func_74775_l(NBT_TAG)))) != null && (te = loc.getTileEntity()) instanceof TileEntityAuraPoint) {
            return (TileEntityAuraPoint)te;
        }
        return null;
    }

    public void removePoint() {
        EntityPlayer ep = this.getPlacer();
        NBTTagCompound tag = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        tag.func_82580_o(NBT_TAG);
    }

    private static class SugarCaneCrop
    implements CropType {
        private SugarCaneCrop() {
        }

        public boolean existsInGame() {
            return true;
        }

        public boolean isRipe(World world, int x, int y, int z) {
            return false;
        }

        public void setHarvested(World world, int x, int y, int z) {
            ++y;
            while (world.func_147439_a(x, y, z) == Blocks.field_150436_aH) {
                world.func_147468_f(x, y, z);
                ++y;
            }
            world.func_72921_c(x, y, z, 0, 3);
        }

        public void makeRipe(World world, int x, int y, int z) {
            world.func_72921_c(x, y, z, 15, 3);
        }

        public int getGrowthState(World world, int x, int y, int z) {
            return world.func_72805_g(x, y, z);
        }

        public boolean isSeedItem(ItemStack is) {
            return false;
        }

        public boolean destroyOnHarvest() {
            return true;
        }

        public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int fortune) {
            return ReikaJavaLibrary.makeListFrom((Object)new ItemStack(Items.field_151120_aE));
        }

        public boolean isCrop(Block id, int meta) {
            return id == Blocks.field_150436_aH;
        }

        public boolean neverDropsSecondSeed() {
            return false;
        }
    }
}

