/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.API.AcceleratorBlacklist;
import Reika.ChromatiCraft.API.Interfaces.Accelerator;
import Reika.ChromatiCraft.API.Interfaces.CustomAcceleration;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAccelerator
extends TileEntityChromaticBase
implements NBTTile,
SneakPop,
Accelerator {
    public static final long MAX_LAG = TileEntityAccelerator.calculateLagLimit();
    public static final int MAX_TIER = 7;
    private int tier;
    private boolean particles = true;
    private int soundtick = 0;
    private static HashMap<Class<? extends TileEntity>, Acceleration> actions = new HashMap();
    private static final Acceleration blacklistKey = new Acceleration(){

        @Override
        public void tick(TileEntity te, int factor) {
        }
    };

    public static void blacklistTile(Class<? extends TileEntity> cl) {
        actions.put(cl, blacklistKey);
    }

    public static void customizeTile(Class c, Acceleration a) {
        actions.put(c, a);
    }

    private static void blacklistTile(String name, ModList mod, AcceleratorBlacklist.BlacklistReason r) {
        if (mod != null && !mod.isLoaded()) {
            return;
        }
        try {
            Class<?> cl = Class.forName(name);
            ChromatiCraft.logger.log((Object)("TileEntity \"" + name + "\" has been blacklisted from the TileEntity Accelerator, because " + r.message));
            actions.put(cl, blacklistKey);
        }
        catch (ClassNotFoundException e) {
            ChromatiCraft.logger.logError((Object)("Could not add " + name + " to the Accelerator blacklist: Class not found!"));
        }
    }

    private static long calculateLagLimit() {
        return Math.max((long)ChromaOptions.TILELAG.getValue(), 100000L);
    }

    public static int getAccelFromTier(int tier) {
        return ReikaMathLibrary.intpow2((int)2, (int)(tier + 1)) - 1;
    }

    public int getAccel() {
        return TileEntityAccelerator.getAccelFromTier(this.getTier());
    }

    public int getTier() {
        return this.tier;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.func_94577_B(x, y, z) == 15) {
            this.soundtick = 0;
            return;
        }
        if (this.particles && world.field_72995_K) {
            this.spawnParticles(world, x, y, z, meta);
        }
        ++this.soundtick;
        float f = 1.0f + (float)this.getTier() / 7.0f;
        int l = (int)(221.0f / f);
        if (this.soundtick % l == 0) {
            ChromaSounds.DRONE.playSoundAtBlock(world, x, y, z, 0.25f, f);
        }
        long time = System.nanoTime();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            Acceleration a = this.getAccelerate(te);
            if (a == blacklistKey) continue;
            int max = this.getAccel();
            if (a != null) {
                a.tick(te, max);
                continue;
            }
            for (int k = 0; k < max; ++k) {
                te.func_145845_h();
                if (System.nanoTime() - time < MAX_LAG) continue;
                return;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z, int meta) {
        int p2 = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (rand.nextInt(1 + p2) == 0) {
            int p = this.getTier() > 0 ? (this.getTier() + 1) / 2 : (rand.nextBoolean() ? 1 : 0);
            for (int i = 0; i < p; ++i) {
                double dx = rand.nextDouble();
                double dy = rand.nextDouble();
                double dz = rand.nextDouble();
                double v = 0.125;
                double vx = v * (dx - 0.5);
                double vy = v * (dy - 0.5);
                double vz = v * (dz - 0.5);
                dx = (double)(x - 2) + dx * 4.0;
                dy = (double)(y - 2) + dy * 4.0;
                dz = (double)(z - 2) + dz * 4.0;
                vx = -(dx - (double)x) / 8.0;
                vy = -(dy - (double)y) / 8.0;
                vz = -(dz - (double)z) / 8.0;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntitySparkleFX(world, dx + 0.5, dy + 0.5, dz + 0.5, vx, vy, vz));
            }
        }
    }

    private Acceleration getAccelerate(TileEntity te) {
        if (te == null) {
            return blacklistKey;
        }
        if (te instanceof TileEntityAccelerator) {
            return blacklistKey;
        }
        if (!te.canUpdate() || te.func_145837_r()) {
            return blacklistKey;
        }
        Class<?> c = te.getClass();
        Acceleration a = actions.get(c);
        if (a != null) {
            return a;
        }
        String s = c.getSimpleName().toLowerCase(Locale.ENGLISH);
        if (s.contains("conduit") || s.contains("wire") || s.contains("cable")) {
            actions.put(c, blacklistKey);
            return blacklistKey;
        }
        if (s.contains("solar") || s.contains("windmill") || s.contains("watermill")) {
            actions.put(c, blacklistKey);
            return blacklistKey;
        }
        if (s.contains("windturbine") || s.contains("wind turbine") || s.contains("windmill") || s.contains("wind mill")) {
            actions.put(c, blacklistKey);
            return blacklistKey;
        }
        if (s.contains("watermill") || s.contains("water mill")) {
            actions.put(c, blacklistKey);
            return blacklistKey;
        }
        if (te.getClass().getCanonicalName().contains("appeng")) {
            actions.put(c, blacklistKey);
            return blacklistKey;
        }
        return null;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ACCELERATOR;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tier = NBT.func_74762_e("tier");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("tier", this.tier);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74757_a("particle", this.particles);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.particles = NBT.func_74767_n("particle");
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        if (ChromaItems.PLACER.matchWith(is) && is.field_77990_d != null) {
            this.tier = is.field_77990_d.func_74762_e("tier");
        }
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        NBT.func_74768_a("tier", this.getTier());
    }

    @Override
    public void drop() {
        ItemStack is = this.getTile().getCraftedProduct();
        is.field_77990_d = new NBTTagCompound();
        this.getTagsToWriteToStack(is.field_77990_d);
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        this.delete();
    }

    @Override
    public boolean canDrop(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.placerUUID);
    }

    @Override
    public int getAccelerationFactor() {
        return this.getAccel();
    }

    static {
        TileEntityAccelerator.blacklistTile("icbm.sentry.turret.Blocks.TileTurret", ModList.ICBM, AcceleratorBlacklist.BlacklistReason.BUGS);
        TileEntityAccelerator.blacklistTile("bluedart.tile.decor.TileForceTorch", ModList.DARTCRAFT, AcceleratorBlacklist.BlacklistReason.CRASH);
        TileEntityAccelerator.blacklistTile("com.sci.torcherino.tile.TileTorcherino", null, AcceleratorBlacklist.BlacklistReason.CRASH);
        TileEntityAccelerator.blacklistTile("mrtjp.projectred.integration.Timer", ModList.PROJRED, AcceleratorBlacklist.BlacklistReason.BUGS);
        TileEntityAccelerator.blacklistTile("mrtjp.projectred.integration.Sequencer", ModList.PROJRED, AcceleratorBlacklist.BlacklistReason.BUGS);
        TileEntityAccelerator.blacklistTile("mrtjp.projectred.integration.Repeater", ModList.PROJRED, AcceleratorBlacklist.BlacklistReason.BUGS);
        TileEntityAccelerator.blacklistTile("mrtjp.projectred.integration.StateCell", ModList.PROJRED, AcceleratorBlacklist.BlacklistReason.BUGS);
        for (int i = 0; i < ChromaTiles.TEList.length; ++i) {
            ChromaTiles c = ChromaTiles.TEList[i];
            if (c.allowsAcceleration()) continue;
            TileEntityAccelerator.blacklistTile(c.getTEClass());
        }
    }

    private static final class APIAcceleration
    extends Acceleration {
        private final CustomAcceleration accel;

        private APIAcceleration(CustomAcceleration acc) {
            this.accel = acc;
        }

        @Override
        protected void tick(TileEntity te, int factor) {
            this.accel.tick(factor);
        }
    }

    public static abstract class Acceleration {
        protected abstract void tick(TileEntity var1, int var2);
    }
}

