/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;

public class TileEntityPlayerDelegate
extends TileEntityAdjacencyUpgrade {
    private static final HashMap<Class, DelegateInterface> interactions = new HashMap();

    @Override
    protected boolean tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        DelegateInterface s;
        TileEntity te = this.getAdjacentTileEntity(dir);
        if (te != null && (s = this.getInterface(te)) != NoInterface.instance) {
            try {
                s.tick(te, this.getTier(), this.getPlacer());
            }
            catch (Exception ex) {
                ChromatiCraft.logger.logError((Object)("Could not tick Delegate interface " + s + " for " + te + " @ " + this));
                this.writeError(ex);
            }
        }
        return true;
    }

    private DelegateInterface getInterface(TileEntity te) {
        Class<?> c;
        Class<?> c2;
        DelegateInterface e = interactions.get(c2);
        for (c2 = c = te.getClass(); e == null && c2 != TileEntity.class; c2 = c2.getSuperclass()) {
            e = interactions.get(c2);
        }
        if (e == null) {
            e = NoInterface.instance;
        }
        interactions.put(c, e);
        return e;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.LIGHTGRAY;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    static {
        new DeconstructionTableDelegateInterface();
    }

    private static class DeconstructionTableDelegateInterface
    extends DelegateInterface {
        private Field aspectOutput;

        private DeconstructionTableDelegateInterface() {
        }

        @Override
        protected void tick(TileEntity te, int tier, EntityPlayer ep) throws Exception {
            Aspect a = (Aspect)this.aspectOutput.get(te);
            if (a != null) {
                ReikaThaumHelper.giveResearchPoint((Aspect)a, (int)1, (EntityPlayer)ep);
                this.aspectOutput.set(te, null);
            }
        }

        @Override
        protected void init() throws Exception {
            this.aspectOutput = Class.forName("thaumcraft.common.tiles.TileDeconstructionTable").getDeclaredField("aspect");
            this.aspectOutput.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.THAUMCRAFT;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"thaumcraft.common.tiles.TileDeconstructionTable"};
        }
    }

    private static abstract class FieldSetDelegateInterface
    extends DelegateInterface {
        private FieldSetDelegateInterface() {
        }

        @Override
        protected final void tick(TileEntity te, int tier, EntityPlayer ep) throws Exception {
            te = this.getActingTileEntity(te);
            Field f = this.getSetField(te);
            Number get = (Number)f.get(te);
            double val = this.getReplacedValue(te, tier, get);
            Number set = null;
            if (get instanceof Integer || get.getClass() == Integer.TYPE) {
                set = (int)val;
            } else if (get instanceof Double || get.getClass() == Double.TYPE) {
                set = val;
            } else if (get instanceof Float || get.getClass() == Float.TYPE) {
                set = Float.valueOf((float)val);
            } else if (get instanceof Short || get.getClass() == Short.TYPE) {
                set = (short)val;
            } else if (get instanceof Byte || get.getClass() == Byte.TYPE) {
                set = (byte)val;
            }
            f.set(te, set);
        }

        protected abstract double getReplacedValue(TileEntity var1, int var2, Number var3) throws Exception;

        protected abstract Field getSetField(TileEntity var1) throws Exception;
    }

    private static class NoInterface
    extends DelegateInterface {
        private static final NoInterface instance = new NoInterface();

        private NoInterface() {
        }

        @Override
        protected void tick(TileEntity te, int tier, EntityPlayer ep) throws Exception {
        }

        @Override
        protected void init() throws Exception {
        }

        @Override
        protected ModList getMod() {
            return null;
        }

        @Override
        protected String[] getClasses() {
            return new String[0];
        }
    }

    private static abstract class DelegateInterface {
        protected DelegateInterface() {
            if (this.getMod() == null || this.getMod().isLoaded()) {
                try {
                    String[] cs = this.getClasses();
                    for (int i = 0; i < cs.length; ++i) {
                        Class<?> c = Class.forName(cs[i]);
                        interactions.put(c, this);
                    }
                    this.init();
                    ChromatiCraft.logger.log((Object)("Loaded " + this + " for " + this.getMod()));
                }
                catch (Exception e) {
                    ChromatiCraft.logger.logError((Object)("Could not load " + this + " for " + this.getMod() + ":"));
                    e.printStackTrace();
                    ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)this.getMod(), e);
                }
            } else {
                ChromatiCraft.logger.log((Object)("Not loading " + this + " for " + this.getMod() + "; Mod not present."));
            }
        }

        protected abstract void tick(TileEntity var1, int var2, EntityPlayer var3) throws Exception;

        protected abstract void init() throws Exception;

        protected abstract ModList getMod();

        protected abstract String[] getClasses();

        protected TileEntity getActingTileEntity(TileEntity te) throws Exception {
            return te;
        }
    }
}

