/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.TileEntity.ThermalTile;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Processing.TileEntityElectrolyzer;
import Reika.ReactorCraft.TileEntities.Processing.TileEntitySynthesizer;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityComposter;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCompactor;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCrystallizer;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBlastFurnace;
import Reika.RotaryCraft.TileEntities.Production.TileEntityFermenter;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeatRelay
extends TileEntityAdjacencyUpgrade {
    private static final BlockMap<Integer> blockTemps = new BlockMap();
    private static final HashMap<String, Integer> tileList = new HashMap();
    private static final int machineHeat = 0;
    private static final int tieredMachineHeat = 1;
    private static final int reactorHeat = 10;
    private static final double[] factors = new double[]{0.03125, 0.0625, 0.125, 0.25, 0.375, 0.5, 0.75, 1.0};

    @DependentMethodStripper.ModDependent(value=ModList.ROTARYCRAFT)
    private static void addRC() {
        tileList.put(TileEntityBlastFurnace.class.getName(), 1);
        tileList.put(TileEntityCompactor.class.getName(), 0);
        tileList.put(TileEntityComposter.class.getName(), 0);
        tileList.put(TileEntityCrystallizer.class.getName(), 0);
        tileList.put(TileEntityFermenter.class.getName(), 0);
    }

    @DependentMethodStripper.ModDependent(value=ModList.REACTORCRAFT)
    private static void addReC() {
        for (int i = 0; i < ReactorTiles.TEList.length; ++i) {
            ReactorTiles r = ReactorTiles.TEList[i];
            if (!r.isReactorCore()) continue;
            tileList.put(r.getTEClass().getName(), 10);
        }
        tileList.put(TileEntitySynthesizer.class.getName(), 0);
        tileList.put(TileEntityElectrolyzer.class.getName(), 0);
    }

    @Override
    protected boolean ticksIndividually() {
        return false;
    }

    @Override
    protected void doCollectiveTick(World world, int x, int y, int z) {
        int Tavg = 0;
        int n = 0;
        HashMap<ThermalTile, Integer> set = new HashMap<ThermalTile, Integer>();
        int tierThisCycle = Integer.MAX_VALUE;
        double f = this.getEqualizationFactor();
        for (int i = 0; i < 6; ++i) {
            BlockKey bk = BlockKey.getAt((IBlockAccess)world, (int)(x + this.dirs[i].offsetX), (int)(y + this.dirs[i].offsetY), (int)(z + this.dirs[i].offsetZ));
            TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
            if (te instanceof ThermalTile && tileList.containsKey(te.getClass().getName())) {
                ++n;
                int tier = tileList.get(te.getClass().getName());
                set.put((ThermalTile)te, tier);
                tierThisCycle = Math.min(tierThisCycle, tier);
                Tavg += ((ThermalTile)te).getTemperature();
                continue;
            }
            if (blockTemps.get(bk) == null) continue;
            ++n;
            Tavg += ((Integer)blockTemps.get(bk)).intValue();
        }
        if (n <= 1) {
            return;
        }
        Tavg /= n;
        for (ThermalTile te : set.keySet()) {
            int hr = (Integer)set.get(te);
            if (hr > tierThisCycle) continue;
            int t1 = te.getTemperature();
            int t2 = (int)(this.getEqualizationFactor() * (double)Tavg + (1.0 - this.getEqualizationFactor()) * (double)t1);
            te.setTemperature(t2);
        }
    }

    private double getEqualizationFactor() {
        return factors[this.getTier()];
    }

    @Override
    protected boolean tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        return false;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.ORANGE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static double getFactor(int tier) {
        return factors[tier];
    }

    static {
        blockTemps.put(Blocks.field_150432_aD, (Object)0);
        blockTemps.put(Blocks.field_150355_j, (Object)15);
        blockTemps.put((Block)Blocks.field_150480_ab, (Object)90);
        if (ModList.ROTARYCRAFT.isLoaded()) {
            TileEntityHeatRelay.addRC();
            if (ModList.REACTORCRAFT.isLoaded()) {
                TileEntityHeatRelay.addReC();
            }
        }
    }
}

