/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.ModList;
import buildcraft.core.lib.engines.TileEngineBase;
import cofh.api.energy.EnergyStorage;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyIncrease
extends TileEntityAdjacencyUpgrade {
    private static final HashMap<Class, EnergyInterface> interactions = new HashMap();
    private static double[] factors = new double[]{0.125, 0.25, 0.5, 1.0, 3.0, 7.0, 15.0, 31.0};
    protected double cachedValue = Double.NaN;

    @Override
    protected boolean tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        EnergyInterface e;
        TileEntity te = this.getAdjacentTileEntity(dir);
        if (te != null && (e = this.getInterface(te)) != NoInterface.instance) {
            double boost = this.getBoostFactor();
            double f = e.getMultiplier();
            if (f != 1.0) {
                boost = Math.pow(1.0 + boost, f) - 1.0;
            }
            try {
                e.tick(this, te, boost);
            }
            catch (Exception ex) {
                ChromatiCraft.logger.logError((Object)("Could not tick energy interface " + e + " for " + te + " @ " + this));
                this.writeError(ex);
            }
        }
        return true;
    }

    public double getBoostFactor() {
        return factors[this.getTier()];
    }

    private EnergyInterface getInterface(TileEntity te) {
        Class<?> c;
        Class<?> c2;
        EnergyInterface e = interactions.get(c2);
        for (c2 = c = te.getClass(); e == null && c2 != TileEntity.class; c2 = c2.getSuperclass()) {
            e = interactions.get(c2);
        }
        if (e == null) {
            e = NoInterface.instance;
        }
        interactions.put(c, e);
        return e;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.YELLOW;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static double getFactor(int tier) {
        return factors[tier];
    }

    static {
        new TEDynamoInterface();
        new RailCraftTurbineInterface();
        new RailCraftEngineInterface();
        new BCEngineInterface();
        new ForestryEngineInterface();
        new IC2GeneratorInterface();
        new IC2ReactorInterface();
    }

    private static class ExUGeneratorInterface
    extends EnergyInjectionInterface {
        private Method genLevel;
        private Field storage;
        private static final ExUGeneratorInterface instance = new ExUGeneratorInterface();

        private ExUGeneratorInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("com.rwtema.extrautils.tileentity.generators.TileEntityGenerator");
            this.genLevel = c.getDeclaredMethod("genLevel", new Class[0]);
            this.genLevel.setAccessible(true);
            this.storage = c.getDeclaredField("storage");
            this.storage.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.EXTRAUTILS;
        }

        @Override
        protected int getBaseGeneration(TileEntity te) throws Exception {
            return ((Double)this.genLevel.invoke((Object)te, new Object[0])).intValue();
        }

        @Override
        protected void inject(TileEntity te, double gen) throws Exception {
            EnergyStorage es = (EnergyStorage)this.storage.get(te);
            es.modifyEnergyStored((int)gen);
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"com.rwtema.extrautils.tileentity.generators.TileEntityGenerator"};
        }
    }

    private static class RailCraftTurbineInterface
    extends EnergyInjectionInterface {
        private Field output;
        private Field energy;
        private Method getMasterBlock;
        private static final RailCraftTurbineInterface instance = new RailCraftTurbineInterface();

        private RailCraftTurbineInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("mods.railcraft.common.blocks.machine.alpha.TileSteamTurbine");
            this.output = c.getDeclaredField("output");
            this.output.setAccessible(true);
            this.energy = c.getDeclaredField("energy");
            this.energy.setAccessible(true);
            Class<?> c2 = Class.forName("mods.railcraft.common.blocks.machine.TileMultiBlock");
            this.getMasterBlock = c2.getDeclaredMethod("getMasterBlock", new Class[0]);
            this.getMasterBlock.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.RAILCRAFT;
        }

        @Override
        protected int getBaseGeneration(TileEntity te) throws Exception {
            return (int)this.output.getFloat(te);
        }

        @Override
        protected void inject(TileEntity te, double gen) throws Exception {
            this.energy.setDouble(te, this.energy.getDouble(te) + (double)((int)gen));
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"mods.railcraft.common.blocks.machine.alpha.TileSteamTurbine"};
        }

        @Override
        protected TileEntity getActingTileEntity(TileEntity te) throws Exception {
            return (TileEntity)this.getMasterBlock.invoke((Object)te, new Object[0]);
        }
    }

    private static class RailCraftEngineInterface
    extends EnergyInjectionInterface {
        private Method getMaxOutputRF;
        private Method maxEnergy;
        private Field energy;
        private static final RailCraftEngineInterface instance = new RailCraftEngineInterface();

        private RailCraftEngineInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("mods.railcraft.common.blocks.machine.beta.TileEngineSteam");
            this.getMaxOutputRF = c.getDeclaredMethod("getMaxOutputRF", new Class[0]);
            this.getMaxOutputRF.setAccessible(true);
            Class<?> c2 = Class.forName("mods.railcraft.common.blocks.machine.beta.TileEngine");
            this.energy = c2.getDeclaredField("energy");
            this.energy.setAccessible(true);
            this.maxEnergy = c2.getDeclaredMethod("maxEnergy", new Class[0]);
            this.maxEnergy.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.RAILCRAFT;
        }

        @Override
        protected int getBaseGeneration(TileEntity te) throws Exception {
            return (Integer)this.getMaxOutputRF.invoke((Object)te, new Object[0]);
        }

        @Override
        protected void inject(TileEntity te, double gen) throws Exception {
            this.energy.setInt(te, Math.min(this.energy.getInt(te) + (int)gen, (Integer)this.maxEnergy.invoke((Object)te, new Object[0])));
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"mods.railcraft.common.blocks.machine.beta.TileEngineSteam"};
        }
    }

    private static class ForestryEngineInterface
    extends EnergyInjectionInterface {
        private Field currentOutput;
        private Field energyManager;
        private Field energyStorage;
        private static final ForestryEngineInterface instance = new ForestryEngineInterface();

        private ForestryEngineInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("forestry.core.tiles.TileEngine");
            this.currentOutput = c.getDeclaredField("currentOutput");
            this.currentOutput.setAccessible(true);
            this.energyManager = c.getDeclaredField("energyManager");
            this.energyManager.setAccessible(true);
            Class<?> c2 = Class.forName("forestry.energy.EnergyManager");
            this.energyStorage = c2.getDeclaredField("energyStorage");
            this.energyStorage.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.FORESTRY;
        }

        @Override
        protected int getBaseGeneration(TileEntity te) throws Exception {
            return this.currentOutput.getInt(te);
        }

        @Override
        protected void inject(TileEntity te, double gen) throws Exception {
            EnergyStorage es = (EnergyStorage)this.energyStorage.get(this.energyManager.get(te));
            es.modifyEnergyStored((int)gen);
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"forestry.core.tiles.TileEngine"};
        }
    }

    private static class BCEngineInterface
    extends EnergyInjectionInterface {
        private static final BCEngineInterface instance = new BCEngineInterface();

        private BCEngineInterface() {
        }

        @Override
        @DependentMethodStripper.ModDependent(value=ModList.BCENERGY)
        protected int getBaseGeneration(TileEntity te) throws Exception {
            return ((TileEngineBase)te).currentOutput;
        }

        @Override
        @DependentMethodStripper.ModDependent(value=ModList.BCENERGY)
        protected void inject(TileEntity te, double gen) throws Exception {
            ((TileEngineBase)te).energy += (int)gen;
        }

        @Override
        protected void init() throws Exception {
        }

        @Override
        protected ModList getMod() {
            return ModList.BCENERGY;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"buildcraft.core.lib.engines.TileEngineBase"};
        }
    }

    private static class TEDynamoInterface
    extends EnergyInjectionInterface {
        private static final TEDynamoInterface instance = new TEDynamoInterface();
        private Field energyStorage;
        private Field config;
        private Field maxPower;
        private Field isActive;

        private TEDynamoInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("cofh.thermalexpansion.block.dynamo.TileDynamoBase");
            this.energyStorage = c.getDeclaredField("energyStorage");
            this.energyStorage.setAccessible(true);
            this.config = c.getDeclaredField("config");
            this.config.setAccessible(true);
            Class<?> c2 = Class.forName("cofh.thermalexpansion.block.TileTEBase$EnergyConfig");
            this.maxPower = c2.getDeclaredField("maxPower");
            this.maxPower.setAccessible(true);
            Class<?> c3 = Class.forName("cofh.thermalexpansion.block.TileRSControl");
            this.isActive = c3.getDeclaredField("isActive");
            this.isActive.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.THERMALEXPANSION;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"cofh.thermalexpansion.block.dynamo.TileDynamoBase"};
        }

        @Override
        protected void inject(TileEntity te, double gen) throws Exception {
            EnergyStorage es = (EnergyStorage)this.energyStorage.get(te);
            es.modifyEnergyStored((int)gen);
        }

        @Override
        protected int getBaseGeneration(TileEntity te) throws Exception {
            return this.isActive.getBoolean(te) ? this.maxPower.getInt(this.config.get(te)) : 0;
        }
    }

    private static class IC2ReactorInterface
    extends EnergyInterface {
        private static final IC2ReactorInterface instance = new IC2ReactorInterface();
        private Field updateTicker;

        private IC2ReactorInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric");
            this.updateTicker = c.getDeclaredField("updateTicker");
            this.updateTicker.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.IC2;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric", "ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric"};
        }

        @Override
        @DependentMethodStripper.ModDependent(value=ModList.IC2)
        protected TileEntity getActingTileEntity(TileEntity te) throws Exception {
            if (te instanceof IReactorChamber) {
                return (TileEntity)((IReactorChamber)te).getReactor();
            }
            return te;
        }

        @Override
        @DependentMethodStripper.ModDependent(value=ModList.IC2)
        protected void tick(TileEntityEnergyIncrease booster, TileEntity te, double boost) throws Exception {
            te = this.getActingTileEntity(te);
            IReactor ir = (IReactor)te;
            if (this.updateTicker.getInt(te) % 20 == 1) {
                float defaultval = ir.getReactorEnergyOutput();
                ir.addOutput((float)(boost * (double)defaultval));
            }
        }

        @Override
        public double getMultiplier() {
            return 0.75;
        }
    }

    private static class IC2GeneratorInterface
    extends EnergyInjectionInterface {
        private static final IC2GeneratorInterface instance = new IC2GeneratorInterface();
        private Field storage;
        private Field production;
        private Field maxStorage;

        private IC2GeneratorInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("ic2.core.block.generator.tileentity.TileEntityBaseGenerator");
            this.storage = c.getDeclaredField("storage");
            this.storage.setAccessible(true);
            this.production = c.getDeclaredField("production");
            this.production.setAccessible(true);
            this.maxStorage = c.getDeclaredField("maxStorage");
            this.maxStorage.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.IC2;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"ic2.core.block.generator.tileentity.TileEntityBaseGenerator"};
        }

        @Override
        protected void inject(TileEntity te, double gen) throws Exception {
            this.storage.set(te, Math.min(this.storage.getDouble(te) + gen, (double)this.maxStorage.getShort(te)));
        }

        @Override
        protected int getBaseGeneration(TileEntity te) throws Exception {
            return this.production.getInt(te);
        }
    }

    private static class NoInterface
    extends EnergyInterface {
        private static final NoInterface instance = new NoInterface();

        private NoInterface() {
        }

        @Override
        protected void tick(TileEntityEnergyIncrease booster, TileEntity te, double boost) throws Exception {
        }

        @Override
        protected void init() throws Exception {
        }

        @Override
        protected ModList getMod() {
            return null;
        }

        @Override
        protected String[] getClasses() {
            return new String[0];
        }
    }

    private static abstract class EnergyDumpInterface
    extends BasicEnergyInterface {
        private EnergyDumpInterface() {
        }

        @Override
        protected final void tick(TileEntityEnergyIncrease booster, TileEntity te, double boost) throws Exception {
            double gen = (double)this.getBaseGeneration(te) * boost;
            ForgeDirection dir = this.getFacing(te);
            TileEntity rec = te.field_145850_b.func_147438_o(te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ);
            if (rec != null) {
                this.dumpEnergy(rec, gen);
            }
        }

        protected abstract ForgeDirection getFacing(TileEntity var1) throws Exception;

        protected abstract void dumpEnergy(TileEntity var1, double var2) throws Exception;
    }

    private static abstract class EnergyFieldSetInterface
    extends EnergyInterface {
        private EnergyFieldSetInterface() {
        }

        @Override
        protected final void tick(TileEntityEnergyIncrease booster, TileEntity te, double boost) throws Exception {
            te = this.getActingTileEntity(te);
            Field f = this.getOutputField(te);
            Number get = (Number)f.get(te);
            double val = (1.0 + boost) * get.doubleValue();
            Number set = null;
            if (get instanceof Integer || get.getClass() == Integer.TYPE) {
                set = (int)val;
            } else if (get instanceof Double || get.getClass() == Double.TYPE) {
                set = val;
            } else if (get instanceof Float || get.getClass() == Float.TYPE) {
                set = Float.valueOf((float)val);
            } else if (get instanceof Short || get.getClass() == Short.TYPE) {
                set = (short)val;
            } else if (get instanceof Byte || get.getClass() == Byte.TYPE) {
                set = (byte)val;
            }
            f.set(te, set);
        }

        protected abstract Field getOutputField(TileEntity var1);
    }

    private static abstract class EnergyInjectionInterface
    extends BasicEnergyInterface {
        private EnergyInjectionInterface() {
        }

        @Override
        protected final void tick(TileEntityEnergyIncrease booster, TileEntity te, double boost) throws Exception {
            double gen = (double)this.getBaseGeneration(te) * boost;
            this.inject(te, gen);
        }

        protected abstract void inject(TileEntity var1, double var2) throws Exception;
    }

    private static abstract class BasicEnergyInterface
    extends EnergyInterface {
        private BasicEnergyInterface() {
        }

        protected abstract int getBaseGeneration(TileEntity var1) throws Exception;
    }

    private static abstract class EnergyInterface {
        protected EnergyInterface() {
            if (this.getMod() == null || this.getMod().isLoaded()) {
                try {
                    String[] cs = this.getClasses();
                    for (int i = 0; i < cs.length; ++i) {
                        Class<?> c = Class.forName(cs[i]);
                        interactions.put(c, this);
                    }
                    this.init();
                    ChromatiCraft.logger.log((Object)("Loaded " + this + " for " + this.getMod()));
                }
                catch (Exception e) {
                    ChromatiCraft.logger.logError((Object)("Could not load " + this + " for " + this.getMod() + ":"));
                    e.printStackTrace();
                    ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)this.getMod(), e);
                }
            } else {
                ChromatiCraft.logger.log((Object)("Not loading " + this + " for " + this.getMod() + "; Mod not present."));
            }
        }

        protected abstract void tick(TileEntityEnergyIncrease var1, TileEntity var2, double var3) throws Exception;

        protected abstract void init() throws Exception;

        protected abstract ModList getMod();

        protected abstract String[] getClasses();

        protected TileEntity getActingTileEntity(TileEntity te) throws Exception {
            return te;
        }

        public double getMultiplier() {
            return 1.0;
        }
    }
}

