/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBlockShuffler
extends TileEntityAdjacencyUpgrade {
    private static final int[] timing = new int[]{600, 100, 40, 20, 8, 4, 2, 1};
    private int tick;

    @Override
    protected boolean ticksIndividually() {
        return false;
    }

    @Override
    protected void doCollectiveTick(World world, int x, int y, int z) {
        ++this.tick;
        if (this.tick > timing[this.getTier()] && !world.field_72995_K) {
            this.doShuffle(world, x, y, z);
            this.tick = 0;
        }
    }

    private void doShuffle(World world, int x, int y, int z) {
        HashMap<Coordinate, BlockKey> blocks = new HashMap<Coordinate, BlockKey>();
        ArrayList<Coordinate> li = new ArrayList<Coordinate>();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            Coordinate c = new Coordinate(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            BlockKey bk = c.getBlockKey(world);
            if (!this.canMove(world, c.xCoord, c.yCoord, c.zCoord, bk.blockID, bk.metadata)) continue;
            blocks.put(c, bk);
            li.add(c);
        }
        if (li.size() > 1) {
            ArrayList keys = new ArrayList(blocks.keySet());
            Collections.shuffle(keys);
            Collections.shuffle(li);
            while (!li.isEmpty() && !keys.isEmpty()) {
                Coordinate from = (Coordinate)keys.remove(0);
                BlockKey bk = (BlockKey)blocks.get(from);
                Coordinate dest = (Coordinate)li.remove(0);
                dest.setBlock(world, bk.blockID, bk.metadata);
                ReikaSoundHelper.playBreakSound((World)world, (int)dest.xCoord, (int)dest.yCoord, (int)dest.zCoord, (Block)bk.blockID);
                ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (TileEntity)this, (int)16, (int[])new int[]{bk.getBlockID(), bk.metadata});
            }
        }
    }

    private boolean canMove(World world, int x, int y, int z, Block b, int meta) {
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (b.hasTileEntity(meta)) {
            return false;
        }
        return !ReikaBlockHelper.isUnbreakable((World)world, (int)x, (int)y, (int)z, (Block)b, (int)meta, (EntityPlayer)this.getPlacer());
    }

    @Override
    protected boolean tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        return false;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.GRAY;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static double getOperationsPerSecond(int tier) {
        return 20.0 / (double)timing[tier];
    }
}

