/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Entity.EntityMeteorShot;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityMeteorTower
extends CrystalReceiverBase
implements NBTTile,
MultiBlockChromaTile {
    private static final ElementTagCompound[] required = new ElementTagCompound[3];
    public static final MeteorShot[] attacks = new MeteorShot[3];
    public static final int[] COLORS = new int[]{7731490, 16633358, 15349024};
    public static final int MINRANGE = 12;
    private static final Comparator<EntityLiving> mobPriority = new MobPriorityComparator();
    private int tier;
    private boolean hasStructure = false;
    private int fireTick;
    private StepTimer scanTimer = new StepTimer(5);

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.hasStructure) {
            boolean flag = false;
            if (this.energy.containsAtLeast(required[this.tier])) {
                this.scanTimer.update();
                if ((this.scanTimer.checkCap() || this.fireTick > 0) && this.searchAndFire(world, x, y, z)) {
                    ++this.fireTick;
                    flag = true;
                }
            }
            if (!flag) {
                this.fireTick = Math.max(this.fireTick - 2, 0);
            }
            if (world.field_72995_K) {
                if (this.fireTick > 0) {
                    this.doChargingFX(world, x, y, z);
                }
                this.doIdleParticles(world, x, y, z);
            }
        }
        if (!world.field_72995_K && this.hasStructure && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
            this.checkAndRequest();
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        this.validateStructure();
    }

    @SideOnly(value=Side.CLIENT)
    private void doIdleParticles(World world, int x, int y, int z) {
        double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)2.5);
        double py = ReikaRandomHelper.getRandomBetween((int)(y - 11), (int)(y + 2));
        double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)2.5);
        float s = (float)ReikaRandomHelper.getRandomBetween((double)2.0, (double)3.0);
        float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.25);
        EntityBlurFX fx1 = new EntityBlurFX(world, px, py, pz).setColor(COLORS[this.tier]).setScale(s).setLife(40).setGravity(g).setColliding();
        EntityBlurFX fx2 = new EntityBlurFX(world, px, py, pz).setColor(0xFFFFFF).setScale(s * 0.5f).setLife(40).setGravity(g).setColliding().lockTo(fx1).setIcon(ChromaIcons.FADE_RAY);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
    }

    @SideOnly(value=Side.CLIENT)
    private void doChargingFX(World world, int x, int y, int z) {
        double f = (double)this.fireTick / (double)TileEntityMeteorTower.attacks[this.tier].chargeTime;
        double posY = (double)y - 6.5 + 0.5 + 4.0 * Math.sin(0.03125 * (double)this.getTicksExisted() / (1.0 + 1.0 / (double)TileEntityMeteorTower.attacks[this.tier].chargeTime - 0.5625 * Math.pow(f, 1.5)));
        int n = (int)Math.min(16.0, 1.0 + 16.0 * f * 2.0);
        for (int i = 0; i < n; ++i) {
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)1.0);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)posY, (double)0.75);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)1.0);
            float s = 2.5f + 4.0f * (float)f;
            EntityBlurFX fx1 = new EntityBlurFX(world, px, py, pz).setColor(COLORS[this.tier]).setScale(s).setLife(8).setRapidExpand();
            EntityBlurFX fx2 = new EntityBlurFX(world, px, py, pz).setColor(0xFFFFFF).setScale(s * 0.67f).setLife(8).setRapidExpand().lockTo(fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doFireFX(World world, int x, int y, int z) {
        int i;
        int n = 24 + rand.nextInt(48);
        for (i = 0; i < n; ++i) {
            double px = (double)x + rand.nextDouble();
            double py = (double)(y + 2) + rand.nextDouble();
            double pz = (double)z + rand.nextDouble();
            float s = 2.5f;
            double a1 = rand.nextDouble() * 360.0;
            double a2 = rand.nextDouble() * 360.0;
            EntityFloatingSeedsFX fx = (EntityFloatingSeedsFX)new EntityFloatingSeedsFX(world, px, py, pz, a1, a2).setColor(COLORS[this.tier]).setScale(s).setLife(40).setRapidExpand().setIcon(ChromaIcons.NODE2);
            fx.particleVelocity *= 4.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < 96; ++i) {
            double posY = ReikaRandomHelper.getRandomPlusMinus((double)((double)y - 6.5 + 0.5), (double)4.0);
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)1.5);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)posY, (double)0.75);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)1.5);
            float s = 7.5f;
            EntityBlurFX fx1 = new EntityBlurFX(world, px, py, pz).setColor(COLORS[this.tier]).setScale(s).setLife(12).setRapidExpand();
            EntityBlurFX fx2 = new EntityBlurFX(world, px, py, pz).setColor(0xFFFFFF).setScale(s * 0.67f).setLife(12).setRapidExpand().lockTo(fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    private boolean searchAndFire(World world, int x, int y, int z) {
        double r = TileEntityMeteorTower.attacks[this.tier].range;
        List li = world.func_72872_a(EntityLiving.class, ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(r, 200.0, r));
        if (!li.isEmpty()) {
            Collections.sort(li, mobPriority);
            for (EntityLiving e : li) {
                if (!this.canAttack(e)) continue;
                this.queueAttack(e);
                return true;
            }
        }
        return false;
    }

    private void queueAttack(EntityLiving e) {
        float f = (float)this.fireTick / (float)TileEntityMeteorTower.attacks[this.tier].chargeTime;
        ChromaSounds.KILLAURA_CHARGE.playSoundAtBlock((TileEntity)this, 0.25f + f, 0.5f + 0.5f * f);
        if (this.fireTick >= TileEntityMeteorTower.attacks[this.tier].chargeTime) {
            this.doAttack(e);
        }
    }

    private void doAttack(EntityLiving e) {
        ChromaSounds.KILLAURA.playSoundAtBlock((TileEntity)this, 2.0f, 0.96875f);
        this.fireTick = 0;
        if (this.field_145850_b.field_72995_K) {
            this.doFireFX(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (!this.field_145850_b.field_72995_K) {
            EntityMeteorShot m = new EntityMeteorShot(this, (Entity)e);
            this.field_145850_b.func_72838_d((Entity)m);
        }
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(6.0, 6.0, 6.0);
        List li = this.field_145850_b.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase in : li) {
            ReikaEntityHelper.knockbackEntityFromPos((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (Entity)in, (double)2.0);
        }
        this.drainEnergy(required[this.tier]);
    }

    private boolean canAttack(EntityLiving e) {
        if (e.field_70128_L || e.func_110143_aJ() <= 0.0f || e instanceof EntityFlying || !e.field_70122_E) {
            return false;
        }
        if (!ReikaEntityHelper.isHostile((EntityLivingBase)e)) {
            return false;
        }
        if (e instanceof EntitySlime && !(e instanceof EntityMagmaCube) && ((EntitySlime)e).func_70809_q() <= 1) {
            return false;
        }
        if (!ReikaEntityHelper.isNearSkylight((Entity)e)) {
            return false;
        }
        double d = e.func_70011_f((double)this.field_145851_c + 0.5, e.field_70163_u, (double)this.field_145849_e + 0.5);
        return d >= 12.0 && d <= TileEntityMeteorTower.attacks[this.tier].range;
    }

    private void checkAndRequest() {
        for (CrystalElement e : required[this.tier].elementSet()) {
            int capacity = this.getMaxStorage(e);
            int space = capacity - this.getEnergy(e);
            if (space <= 0) continue;
            this.requestEnergy(e, space);
        }
    }

    @Override
    public void validateStructure() {
        boolean bl = this.hasStructure = !this.field_145850_b.field_72995_K && ChromaStructures.getMeteorTowerStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tier).matchInWorld();
        if (!this.hasStructure) {
            this.fireTick = 0;
        }
        this.syncAllData(false);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.hasStructure() ? ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(6.0, 4.0, 6.0) : super.getRenderBoundingBox();
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
        this.tier = NBT.func_74762_e("tier");
        this.fireTick = NBT.func_74762_e("fire");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBT.func_74768_a("fire", this.fireTick);
        NBT.func_74768_a("tier", this.tier);
    }

    public void upgrade() {
        ++this.tier;
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return required[this.tier].contains(e);
    }

    @Override
    public int maxThroughput() {
        return 100 + 200 * this.tier;
    }

    @Override
    public boolean canConduct() {
        return this.hasStructure;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 20000 * (this.tier + 1);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.METEOR;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        super.getTagsToWriteToStack(NBT);
        NBT.func_74768_a("tier", this.tier);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        if (is.field_77990_d == null) {
            return;
        }
        super.setDataFromItemStackTag(is);
        this.tier = is.field_77990_d.func_74762_e("tier");
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEntityMeteorTower.required[i] = new ElementTagCompound();
            required[i].addValueToColor(CrystalElement.PINK, 1000 * ReikaMathLibrary.intpow2((int)(i + 1), (int)2));
            required[i].addValueToColor(CrystalElement.ORANGE, 200 + 100 * i * i);
            if (i <= 0) continue;
            required[i].addValueToColor(CrystalElement.LIME, 50 * (i + 1));
            if (i <= 1) continue;
            required[i].addValueToColor(CrystalElement.PURPLE, 50 * (i * i + 1));
        }
        TileEntityMeteorTower.attacks[0] = new MeteorShot(48, 2, 8, 1, 100);
        TileEntityMeteorTower.attacks[1] = new MeteorShot(48, 4, 16, 4, 80);
        TileEntityMeteorTower.attacks[2] = new MeteorShot(64, 8, 24, 10, 80);
    }

    public static class MeteorShot {
        public final double range;
        public final double splashRange;
        public final int baseDamage;
        public final int fireDuration;
        public final int chargeTime;

        private MeteorShot(int r, int s, int d, int f, int c) {
            this.range = r;
            this.splashRange = s;
            this.baseDamage = d;
            this.fireDuration = f;
            this.chargeTime = c;
        }
    }

    private static class MobPriorityComparator
    implements Comparator<EntityLiving> {
        private MobPriorityComparator() {
        }

        @Override
        public int compare(EntityLiving o1, EntityLiving o2) {
            return -Integer.compare(this.getWeight(o1), this.getWeight(o2));
        }

        private int getWeight(EntityLiving e) {
            if (e instanceof EntityCreeper) {
                return 30;
            }
            if (e instanceof EntityEnderman) {
                return 20;
            }
            if (e instanceof EntitySkeleton || e instanceof EntityBlaze) {
                return 10;
            }
            if (e instanceof EntityWither) {
                return 100;
            }
            return 0;
        }
    }
}

