/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.Auxiliary.LumenTurretDamage;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFlareFX;
import Reika.DragonAPI.Instantiable.RayTracer;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Entity.TameHostile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntityLumenTurret
extends TileEntityChromaticBase {
    private final HashMap<UUID, Integer> attackCooldown = new HashMap();
    private final StepTimer attackTimer = new StepTimer(5);
    private static final RayTracer tracer = new RayTracer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final int MAX_UPGRADES = 4;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.TURRET;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            this.attackTimer.update();
            if (this.attackTimer.checkCap() && (world.func_72937_j(x, y + 1, z) || TurretUpgrades.SKY.check(this))) {
                this.attackEntities(world, x, y, z);
            }
            this.decrementTicks();
        } else {
            this.doParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        TurretUpgrades u = TurretUpgrades.list[rand.nextInt(TurretUpgrades.list.length)];
        if (u.check(this)) {
            float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125));
            float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)1.25, (double)0.25);
            int l = 10 + rand.nextInt(30);
            EntityBlurFX fx = new EntityBlurFX(world, (double)x + 0.5, (double)y + 0.625, (double)z + 0.5).setColor(u.color.getColor()).setGravity(g).setLife(l).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void decrementTicks() {
        if (!this.attackCooldown.isEmpty()) {
            HashSet<UUID> rem = new HashSet<UUID>();
            for (UUID id : this.attackCooldown.keySet()) {
                int time = this.attackCooldown.get(id);
                if (time > 1) {
                    this.attackCooldown.put(id, time - 1);
                    continue;
                }
                rem.add(id);
            }
            for (UUID id : rem) {
                this.attackCooldown.remove(id);
            }
        }
    }

    private void attackEntities(World world, int x, int y, int z) {
        List li = world.func_72872_a(EntityLivingBase.class, this.getBox(world, x, y, z));
        for (EntityLivingBase e : li) {
            if (!this.shouldAttack(e)) continue;
            this.tryAttackEntity(world, x, y, z, e);
        }
    }

    private boolean shouldAttack(EntityLivingBase e) {
        if (e instanceof TameHostile || e instanceof EntityTameable && ((EntityTameable)e).func_70909_n()) {
            return false;
        }
        if (ReikaEntityHelper.isHostile((EntityLivingBase)e)) {
            return true;
        }
        if (e instanceof EntityPlayer) {
            return !this.isOwnedByPlayer((EntityPlayer)e) && this.isHostile((EntityPlayer)e) && TurretUpgrades.PLAYERS.check(this);
        }
        return TurretUpgrades.PASSIVE.check(this);
    }

    private boolean isHostile(EntityPlayer e) {
        return false;
    }

    private void tryAttackEntity(World world, int x, int y, int z, EntityLivingBase e) {
        if (!this.attackCooldown.containsKey(e.func_110124_au()) && this.canSeeEntity(world, x, y, z, (Entity)e)) {
            this.doAttackEntity(world, x, y, z, e);
        }
    }

    private boolean canSeeEntity(World world, int x, int y, int z, Entity e) {
        int n = 2;
        for (int i = 0; i <= n; ++i) {
            tracer.setOrigins((double)x + 0.5, (double)y + 0.5625, (double)z + 0.5, e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O * (float)i / (float)n), e.field_70161_v);
            if (!tracer.isClearLineOfSight(world)) continue;
            return true;
        }
        return false;
    }

    private void doAttackEntity(World world, int x, int y, int z, EntityLivingBase e) {
        this.attackCooldown.put(e.func_110124_au(), this.getAttackCooldown(e));
        e.func_70097_a((DamageSource)new LumenTurretDamage(this, TurretUpgrades.NONPLAYER.check(this)), this.getAttackDamage(e));
        e.field_70172_ad = 0;
        if (TurretUpgrades.FIRE.check(this)) {
            e.func_70015_d(2);
        }
        ChromaSounds.DISCHARGE.playSoundAtBlock((TileEntity)this, 0.25f, 1.5f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.TURRETATTACK.ordinal(), (TileEntity)this, (int)32, (int[])new int[]{e.func_145782_y()});
    }

    @SideOnly(value=Side.CLIENT)
    public void doAttackParticles(int entityID) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
        double px = (double)this.field_145851_c + 0.5;
        double py = (double)this.field_145848_d + 0.5625;
        double pz = (double)this.field_145849_e + 0.5;
        double dx = e.field_70165_t - px;
        double dy = e.field_70163_u + (double)(e.field_70131_O / 2.0f) - py;
        double dz = e.field_70161_v - pz;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double v = 0.75;
        double vx = v * dx / dd;
        double vy = v * dy / dd;
        double vz = v * dz / dd;
        int n = 2 + rand.nextInt(4);
        double dv = 0.03125;
        int l = 2 + (int)dd;
        for (int i = 0; i < n; ++i) {
            double dvx = ReikaRandomHelper.getRandomPlusMinus((double)vx, (double)dv);
            double dvy = ReikaRandomHelper.getRandomPlusMinus((double)vy, (double)dv);
            double dvz = ReikaRandomHelper.getRandomPlusMinus((double)vz, (double)dv);
            EntityFlareFX fx = new EntityFlareFX(CrystalElement.PINK, this.field_145850_b, px, py, pz, dvx, dvy, dvz).setNoGravity().setLife(l).setScale(2.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private float getAttackDamage(EntityLivingBase e) {
        return TurretUpgrades.DAMAGE.check(this) ? 7.0f : 4.0f;
    }

    private int getAttackCooldown(EntityLivingBase e) {
        if (TurretUpgrades.FIRERATE.check(this)) {
            return e instanceof EntityEnderman || e instanceof EntityCreeper ? 2 : 5;
        }
        return e instanceof EntityEnderman || e instanceof EntityCreeper ? 5 : 10;
    }

    private AxisAlignedBB getBox(World world, int x, int y, int z) {
        boolean flag = TurretUpgrades.RANGE.check(this);
        int r = flag ? 10 : 6;
        int r2 = flag ? 4 : 2;
        return ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b((double)r, (double)r2, (double)r);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static enum TurretUpgrades {
        PASSIVE(CrystalElement.GREEN),
        PLAYERS(CrystalElement.PURPLE),
        RANGE(CrystalElement.LIME),
        DAMAGE(CrystalElement.PINK),
        FIRERATE(CrystalElement.LIGHTBLUE),
        SKY(CrystalElement.BLUE),
        FIRE(CrystalElement.ORANGE),
        NONPLAYER(CrystalElement.LIGHTGRAY);

        public final CrystalElement color;
        private static final TurretUpgrades[] list;

        private TurretUpgrades(CrystalElement e) {
            this.color = e;
        }

        public boolean check(TileEntityLumenTurret te) {
            int y = te.field_145848_d - 1;
            Block b = te.field_145850_b.func_147439_a(te.field_145851_c, y, te.field_145849_e);
            if (b == ChromaBlocks.PYLONSTRUCT.getBlockInstance() && te.field_145850_b.func_72805_g(te.field_145851_c, y, te.field_145849_e) == BlockPylonStructure.StoneTypes.MULTICHROMIC.ordinal()) {
                return true;
            }
            while (y > 0 && y >= te.field_145848_d - 4 && b == ChromaBlocks.RUNE.getBlockInstance()) {
                if (te.field_145850_b.func_72805_g(te.field_145851_c, y, te.field_145849_e) == this.color.ordinal()) {
                    return true;
                }
                --y;
            }
            return false;
        }

        static {
            list = TurretUpgrades.values();
        }
    }
}

