/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.API.Interfaces.RangeUpgradeable;
import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.PylonDamage;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntityCrystalBeacon
extends CrystalReceiverBase
implements LocationCached,
RangeUpgradeable,
MultiBlockChromaTile {
    private static final Collection<WorldLocation> cache = new ArrayList<WorldLocation>();
    public static final int RATIO = 100;
    public static final int POWER = 2;
    public static final int MAXRANGE = 64;
    private boolean hasStructure;
    private int range;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BEACON;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
        if (!world.field_72995_K && this.hasStructure && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
            this.checkAndRequest();
        }
        this.range = 64;
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        this.validateStructure();
        WorldLocation loc = new WorldLocation((TileEntity)this);
        if (!cache.contains(loc)) {
            cache.add(loc);
        }
    }

    @Override
    public void validateStructure() {
        this.hasStructure = ChromaStructures.getProtectionBeaconStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
        this.syncAllData(false);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.hasStructure() ? ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(6.0, 4.0, 6.0) : super.getRenderBoundingBox();
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
    }

    private void checkAndRequest() {
        CrystalElement e = CrystalElement.RED;
        int capacity = this.getMaxStorage(e);
        int space = capacity - this.getEnergy(e);
        if (space > 0) {
            this.requestEnergy(e, space);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        double angle = (double)System.currentTimeMillis() / 15.0 % 360.0;
        double d = 0.05;
        double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)d);
        double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)d);
        double py = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 1.5 + 0.5 * (1.0 + Math.sin(Math.toRadians(angle)))), (double)d);
        CrystalElement c = CrystalElement.randomElement();
        EntityBlurFX fx = new EntityBlurFX(c, world, px, py, pz, 0.0, 0.0, 0.0).setScale(2.0f).setLife(10).setIcon(ChromaIcons.CENTER);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        if (this.energy.contains(CrystalElement.RED) && this.hasStructure) {
            double a = rand.nextDouble() * 360.0;
            double v = rand.nextBoolean() ? 0.03125 : -0.03125;
            double r = 0.25;
            px = (double)x + 0.5 + r * Math.cos(Math.toRadians(a));
            pz = (double)z + 0.5 + r * Math.sin(Math.toRadians(a));
            py = (double)y + ReikaRandomHelper.getRandomBetween((double)0.25, (double)1.5);
            float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            fx = new EntityBlurFX(c, world, px, py, pz, 0.0, v, 0.0).setScale(1.0f).setLife(30).setIcon(ChromaIcons.FADE_GENTLE).setColor(CrystalElement.RED.getColor()).setRapidExpand().setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            int[][] dir = new int[][]{{-2, -2}, {-2, 2}, {2, 2}, {2, -2}};
            for (int t = 0; t < 80; t += 30) {
                int i = this.getTicksExisted() % 4;
                int dx = dir[i][0];
                int dz = dir[i][1];
                boolean dy = true;
                d = 1.0 - (double)((this.getTicksExisted() + t + i * 20) % 80) / 80.0;
                px = (double)x + 0.5 + (double)dx * d;
                pz = (double)z + 0.5 + (double)dz * d;
                py = (double)y + 0.5 + (double)dy * d;
                double vx = 0.0;
                double vy = 0.0;
                double vz = 0.0;
                fx = new EntityBlurFX(c, world, px, py, pz, vx, vy, vz).setScale(1.5f).setLife(10).setIcon(ChromaIcons.NODE2).setColor(CrystalElement.RED.getColor());
                EntityBlurFX fx2 = new EntityBlurFX(c, world, px, py, pz, vx, vy, vz).setScale(0.75f).setLife(10).setIcon(ChromaIcons.NODE2).setColor(0xFFFFFF);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static boolean isPlayerInvincible(EntityPlayer ep, float dmg) {
        for (WorldLocation loc : cache) {
            TileEntityCrystalBeacon te = (TileEntityCrystalBeacon)loc.getTileEntity();
            if (!(Math.abs(ep.field_70163_u - (double)loc.yCoord) <= (double)(te.range / 2)) || !(loc.getDistanceTo((Entity)ep) <= (double)te.range) || !te.isPlacer(ep) || !te.prevent(dmg)) continue;
            return true;
        }
        return false;
    }

    private boolean prevent(float dmg) {
        int amt;
        if (this.hasStructure() && this.energy.containsAtLeast(CrystalElement.RED, amt = (int)(100.0 * Math.pow(dmg, 2.0)))) {
            this.drainEnergy(CrystalElement.RED, amt);
            return true;
        }
        return false;
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e == CrystalElement.RED;
    }

    @Override
    public int maxThroughput() {
        return 500;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 250000;
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove(loc);
    }

    public static boolean isDamageBlockable(DamageSource src) {
        return !(src instanceof PylonDamage);
    }

    @Override
    public void upgradeRange(double r) {
        this.range = (int)(64.0 * r);
    }

    @Override
    public int getRange() {
        return this.range;
    }

    public static void clearCache() {
        cache.clear();
    }
}

