/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityCloakingTower
extends TileEntityChromaticBase
implements LocationCached,
MultiBlockChromaTile {
    private static final Collection<WorldLocation> cache = new HashSet<WorldLocation>();
    public static final int MAXRANGE = 128;
    private boolean active;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.CLOAKING;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        if (!cache.contains(loc)) {
            cache.add(loc);
        }
        this.validateStructure();
    }

    @Override
    public void validateStructure() {
        this.active = ChromaStructures.getCloakingTower(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove(loc);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.active) {
            if (world.field_72995_K) {
                this.createParticles(world, x, y, z);
            } else {
                EntityPlayer ep = this.getPlacer();
                if (ep.field_70121_D.func_72326_a(this.getCloseEffectBox(world, x, y, z))) {
                    this.rechargeTools(ep);
                }
            }
        }
    }

    private void rechargeTools(EntityPlayer ep) {
        int slot = rand.nextBoolean() ? rand.nextInt(9) : rand.nextInt(ep.field_71071_by.func_70302_i_());
        ItemStack is = ep.field_71071_by.func_70301_a(slot);
        if (is != null && this.canCharge(is)) {
            this.charge(is);
        }
    }

    private boolean canCharge(ItemStack is) {
        if (InterfaceCache.RFENERGYITEM.instanceOf((Object)is.func_77973_b()) || InterfaceCache.IELECTRICITEM.instanceOf((Object)is.func_77973_b()) || InterfaceCache.MUSEELECTRICITEM.instanceOf((Object)is.func_77973_b())) {
            return !(is.func_77973_b() instanceof ItemBlock);
        }
        return false;
    }

    private boolean charge(ItemStack is) {
        MuseElectricItem ms;
        int amt;
        if (InterfaceCache.RFENERGYITEM.instanceOf((Object)is.func_77973_b())) {
            IEnergyContainerItem ie = (IEnergyContainerItem)is.func_77973_b();
            int amt2 = Math.min(Math.max(1, ie.getMaxEnergyStored(is) / 100), ie.getMaxEnergyStored(is) - ie.getEnergyStored(is));
            if (amt2 > 0) {
                int add = ie.receiveEnergy(is, amt2, false);
                return add > 0;
            }
            return false;
        }
        if (InterfaceCache.MUSEELECTRICITEM.instanceOf((Object)is.func_77973_b()) && (amt = Math.min(Math.max(1, (ms = (MuseElectricItem)is.func_77973_b()).getMaxCharge(is) / 100), ms.getMaxCharge(is) - (int)ms.getCurrentEnergy(is))) > 0) {
            int add = ms.receiveEnergy(is, amt, false);
            return add > 0;
        }
        return false;
    }

    private AxisAlignedBB getCloseEffectBox(World world, int x, int y, int z) {
        return ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(2.0, 5.0, 2.0);
    }

    @SideOnly(value=Side.CLIENT)
    private void createParticles(World world, int x, int y, int z) {
        EntityCenterBlurFX fx;
        int n = 3 - Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        for (int i = 0; i < n; ++i) {
            double a = rand.nextDouble() * 360.0;
            double dy = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)2.5);
            double h = dy - (double)this.field_145848_d;
            double r = ReikaRandomHelper.getRandomPlusMinus((double)(this.getWidth(h) + 0.5), (double)0.125);
            double dx = (double)x + 0.5 + r * Math.sin(Math.toRadians(a));
            double dz = (double)z + 0.5 + r * Math.cos(Math.toRadians(a));
            int l = 30 + rand.nextInt(30);
            float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125);
            if (rand.nextBoolean()) {
                g = -g;
            }
            fx = new EntityCenterBlurFX(world, dx, dy, dz).setGravity(g).setLife(l);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        int nd = 8;
        int di = Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2 ? 3 : 2;
        for (int i = 0; i < nd; i += di) {
            int t = (this.getTicksExisted() + i * 360 / nd) * 8;
            double a = t % 360;
            double dy = (double)y + 0.5 + (double)t % (360.0 * (double)nd) / 360.0 - 4.0;
            double r = 0.5;
            double dx = (double)x + 0.5 + r * Math.sin(Math.toRadians(a));
            double dz = (double)z + 0.5 + r * Math.cos(Math.toRadians(a));
            int l = 60;
            fx = new EntityCenterBlurFX(world, dx, dy, dz).setGravity(0.0f).setLife(l);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public double getWidth(double i) {
        double t = (double)System.currentTimeMillis() / 50.0 + (double)this.hashCode();
        if (!this.isActive()) {
            return 0.75 + 0.03125 * Math.sin(-t / 8.0 + i) + 0.03125 * Math.sin(t / 16.0 + i);
        }
        return 0.75 + 0.125 * Math.sin(i - t / 16.0) + 0.0625 * Math.cos(t / 8.0) + 0.375 * Math.sin(t / 64.0);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(3.0, 3.5, 3.0);
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.active = NBT.func_74767_n("active");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("active", this.active);
    }

    public static boolean isPlayerCloaked(EntityPlayer ep) {
        for (WorldLocation loc : cache) {
            TileEntityCloakingTower te;
            if (!(loc.getDistanceTo((Entity)ep) <= 128.0) || (te = (TileEntityCloakingTower)loc.getTileEntity()) == null || !te.isOwnedByPlayer(ep) || !te.isActive()) continue;
            return true;
        }
        return false;
    }

    public static void clearCache() {
        cache.clear();
    }
}

