/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Interfaces.TileEntity.SidePlacedTile;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAvoLaser
extends TileEntityRelayPowered
implements SidePlacedTile {
    public static final int MAXDIST = 8;
    private static final ElementTagCompound required = new ElementTagCompound();
    private int startDist = 0;
    private int endDist = 0;
    private ForgeDirection facing;
    private final TimerMap<UUID> attackCooldowns = new TimerMap();

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.UP;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.stepDistances(world, x, y, z);
        AxisAlignedBB box = this.getScanBox(world, x, y, z);
        if (box != null) {
            if (world.field_72995_K) {
                this.spawnParticles(world, x, y, z, box);
            } else {
                this.drainEnergy(required);
                List li = world.func_72872_a(EntityLivingBase.class, box);
                for (EntityLivingBase e : li) {
                    this.attack(e);
                }
            }
        }
        if (!world.field_72995_K) {
            this.attackCooldowns.tick();
        }
    }

    private void attack(EntityLivingBase e) {
        if (!this.attackCooldowns.containsKey((Object)e.func_110124_au())) {
            this.attackCooldowns.put((Object)e.func_110124_au(), 40);
            e.func_70097_a(DamageSource.field_76376_m, 8.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z, AxisAlignedBB box) {
        ForgeDirection dir = this.getFacing();
        box = box.func_72314_b(0.125, 0.125, 0.125).func_72317_d((double)dir.offsetX * 0.5, (double)dir.offsetY * 0.5, (double)dir.offsetZ * 0.5);
        for (int i = 0; i < 2; ++i) {
            double px = ReikaRandomHelper.getRandomBetween((double)box.field_72340_a, (double)box.field_72336_d);
            double py = ReikaRandomHelper.getRandomBetween((double)box.field_72338_b, (double)box.field_72337_e);
            double pz = ReikaRandomHelper.getRandomBetween((double)box.field_72339_c, (double)box.field_72334_f);
            EntityLaserFX fx = new EntityLaserFX(CrystalElement.RED, world, px, py, pz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean isActive() {
        return this.endDist > 0;
    }

    private void stepDistances(World world, int x, int y, int z) {
        boolean active;
        ForgeDirection dir = this.getFacing();
        if (this.endDist > 0) {
            this.endDist = Math.min(this.endDist + 1, this.getRange(world, x, y, z, dir));
        }
        boolean bl = active = this.hasRedstoneSignal() || world.func_72864_z(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (active &= this.energy.containsAtLeast(required)) {
            if (this.endDist == 0) {
                ++this.endDist;
            }
            this.startDist = Math.max(this.startDist - 1, 0);
            if (this.getTicksExisted() % 3 == 0) {
                ChromaSounds.AVOLASER.playSoundAtBlock((TileEntity)this, 0.5f, 1.0f);
            }
        } else if (this.endDist > 0) {
            this.startDist = Math.min(this.startDist + 1, this.getRange(world, x, y, z, dir));
        }
        if (this.startDist >= this.endDist) {
            this.startDist = 0;
            this.endDist = 0;
        }
    }

    private int getRange(World world, int x, int y, int z, ForgeDirection dir) {
        for (int i = 1; i <= 8; ++i) {
            int dx = x + dir.offsetX * i;
            int dy = y + dir.offsetY * i;
            int dz = z + dir.offsetZ * i;
            if (world.func_147439_a(dx, dy, dz).isAir((IBlockAccess)world, dx, dy, dz)) continue;
            return i - 1;
        }
        return 8;
    }

    public AxisAlignedBB getScanBox(World world, int x, int y, int z) {
        ForgeDirection dir = this.getFacing();
        if (this.endDist > 0) {
            AxisAlignedBB box = ReikaAABBHelper.getBeamBox((int)x, (int)y, (int)z, (ForgeDirection)dir, (int)this.startDist, (int)this.endDist);
            return box;
        }
        return null;
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return this.isAcceptingColor(e) && dir != this.getFacing();
    }

    @Override
    protected ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 6000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.AVOLASER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void placeOnSide(int s) {
        this.facing = this.dirs[s];
    }

    public boolean checkLocationValidity() {
        ForgeDirection dir = this.getFacing().getOpposite();
        int dx = this.field_145851_c + dir.offsetX;
        int dy = this.field_145848_d + dir.offsetY;
        int dz = this.field_145849_e + dir.offsetZ;
        return this.field_145850_b.func_147439_a(dx, dy, dz).isSideSolid((IBlockAccess)this.field_145850_b, dx, dy, dz, dir.getOpposite());
    }

    public void drop() {
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.getTile().getCraftedProduct());
        this.delete();
    }

    public int getBeamStart() {
        return this.startDist;
    }

    public int getBeamEnd() {
        return this.endDist;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.facing = this.dirs[NBT.func_74762_e("dir")];
        this.startDist = NBT.func_74762_e("start");
        this.endDist = NBT.func_74762_e("end");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("dir", this.getFacing().ordinal());
        NBT.func_74768_a("start", this.startDist);
        NBT.func_74768_a("end", this.endDist);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        ForgeDirection dir = this.getFacing();
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72321_a((double)(8 * dir.offsetX), (double)(8 * dir.offsetY), (double)(8 * dir.offsetZ));
    }

    static {
        required.addValueToColor(CrystalElement.PINK, 25);
        required.addValueToColor(CrystalElement.BLUE, 5);
        required.addValueToColor(CrystalElement.YELLOW, 10);
    }
}

