/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.TESR;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Base.ChromaRenderBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityCrystalTank;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class TankRender
extends ChromaRenderBase {
    public String getImageFileName(RenderFetcher te) {
        return null;
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (Keyboard.isKeyDown((int)76)) {
            return;
        }
        TileEntityCrystalTank te = (TileEntityCrystalTank)tile;
        Fluid f = te.getFluid();
        if (te.func_145830_o() && f != null && te.getLevel() > 0) {
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            if (!Keyboard.isKeyDown((int)80)) {
                this.renderLiquid(te, par2, par4, par6, par8, f);
            }
            GL11.glAlphaFunc((int)516, (float)0.1f);
            if (!Keyboard.isKeyDown((int)81)) {
                this.renderRunes(te, par2, par4, par6, par8);
            }
        }
    }

    private void renderRunes(TileEntityCrystalTank te, double par2, double par4, double par6, float par8) {
        Coordinate dat;
        WorldLocation loc = new WorldLocation((TileEntity)te);
        te.ptick = te.getTicksExisted();
        BlockArray blocks = te.getBlocks();
        int d = Math.max(5, 100 - blocks.getSize() / 2);
        int tick = te.getTicksExisted() / d;
        CrystalElement et = ChromaAux.getRune(te.getFluid());
        int last = te.lastptick;
        if ((et != null && te.getTicksExisted() != last && te.getTicksExisted() % d == 0 || et != null && Keyboard.isKeyDown((int)77)) && (dat = blocks.getRandomBlock()) != null) {
            te.runes.addRune(dat.xCoord, dat.yCoord, dat.zCoord, et);
            te.lastptick = te.getTicksExisted();
        }
        if (!Keyboard.isKeyDown((int)73)) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)par2, (double)par4, (double)par6);
            te.runes.updateAndRender(Tessellator.field_78398_a, te, par8);
            GL11.glPopMatrix();
        }
    }

    private void renderGlint(TileEntityCrystalTank te, double par2, double par4, double par6, float par8) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78380_c(240);
        float hue = (290.0f + 20.0f * (float)Math.sin(Math.toRadians((float)te.getTicksExisted() + par8))) / 360.0f;
        int color = new Color(Color.HSBtoRGB(hue, 1.0f, 0.5f)).getRGB();
        v5.func_78378_d(color);
        BlockArray blocks = te.getBlocks();
        blocks.remove(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/clouds/cloud2.png");
        GL11.glDisable((int)2896);
        double o = 0.001;
        double u = (double)(System.currentTimeMillis() % 5000L) / 200.0 + Math.sin((double)System.currentTimeMillis() / 500.0);
        double v = u * 1.0 + 0.5 * Math.sin(u);
        double d = 1.0;
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])ForgeDirection.VALID_DIRECTIONS);
            for (int k = 0; k < 6; ++k) {
                int dx = x + this.dirs[k].offsetX;
                int dy = y + this.dirs[k].offsetY;
                int dz = z + this.dirs[k].offsetZ;
                Block b = te.field_145850_b.func_147439_a(dx, dy, dz);
                if (b != ChromaBlocks.TANK.getBlockInstance()) continue;
                li.remove(this.dirs[k]);
            }
            int dx = x - te.field_145851_c;
            int dy = y - te.field_145848_d;
            int dz = z - te.field_145849_e;
            if (li.contains(ForgeDirection.SOUTH)) {
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy - 0) - o, (double)(dz + 1) + o, u, v);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy - 0) - o, (double)(dz + 1) + o, u + d, v);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy + 1) + o, (double)(dz + 1) + o, u + d, v + d);
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy + 1) + o, (double)(dz + 1) + o, u, v + d);
            }
            if (li.contains(ForgeDirection.NORTH)) {
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy + 1) + o, (double)(dz - 0) - o, u, v + d);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy + 1) + o, (double)(dz - 0) - o, u + d, v + d);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy - 0) - o, (double)(dz - 0) - o, u + d, v);
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy - 0) - o, (double)(dz - 0) - o, u, v);
            }
            if (li.contains(ForgeDirection.WEST)) {
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy - 0) - o, (double)(dz - 0) - o, u, v);
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy - 0) - o, (double)(dz + 1) + o, u + d, v);
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy + 1) + o, (double)(dz + 1) + o, u + d, v + d);
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy + 1) + o, (double)(dz - 0) - o, u, v + d);
            }
            if (li.contains(ForgeDirection.EAST)) {
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy + 1) + o, (double)(dz - 0) - o, u, v + d);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy + 1) + o, (double)(dz + 1) + o, u + d, v + d);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy - 0) - o, (double)(dz + 1) + o, u + d, v);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy - 0) - o, (double)(dz - 0) - o, u, v);
            }
            if (li.contains(ForgeDirection.UP)) {
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy + 1) + o, (double)(dz + 1) + o, u, v + d);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy + 1) + o, (double)(dz + 1) + o, u + d, v + d);
                v5.func_78374_a((double)(dx + 1) + o, (double)(dy + 1) + o, (double)(dz - 0) - o, u + d, v);
                v5.func_78374_a((double)(dx - 0) - o, (double)(dy + 1) + o, (double)(dz - 0) - o, u, v);
            }
            if (!li.contains(ForgeDirection.DOWN)) continue;
            v5.func_78374_a((double)(dx - 0) - o, (double)(dy - 0) - o, (double)(dz - 0) - o, u, v);
            v5.func_78374_a((double)(dx + 1) + o, (double)(dy - 0) - o, (double)(dz - 0) - o, u + d, v);
            v5.func_78374_a((double)(dx + 1) + o, (double)(dy - 0) - o, (double)(dz + 1) + o, u + d, v + d);
            v5.func_78374_a((double)(dx - 0) - o, (double)(dy - 0) - o, (double)(dz + 1) + o, u, v + d);
        }
        v5.func_78381_a();
        GL11.glDisable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderLiquid(TileEntityCrystalTank te, double par2, double par4, double par6, float par8, Fluid f) {
        boolean flip;
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        ReikaTextureHelper.bindTerrainTexture();
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDisable((int)2896);
        IIcon ico = f.getStillIcon();
        if (ico == null) {
            ChromatiCraft.logger.logError((Object)("Fluid " + f.getID() + " (" + f.getLocalizedName() + ") exists (block ID " + f.getBlock() + ") but has no icon! Registering bedrock texture as a placeholder!"));
            f.setIcons(Blocks.field_150357_h.func_149691_a(0, 0));
            ico = Blocks.field_150357_h.func_149691_a(0, 0);
        }
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        Block b = ChromaBlocks.TANK.getBlockInstance();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        v5.func_78382_b();
        BlockArray blocks = te.getBlocks();
        if (!blocks.hasBlock(te.field_145851_c, te.field_145848_d + 1, te.field_145849_e)) {
            blocks.remove(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
        if (flip = te.isInvertedFilled()) {
            GL11.glFrontFace((int)2304);
        }
        for (int i = 0; i < blocks.getSize(); ++i) {
            double en;
            double es;
            double ed;
            double eu;
            double en2;
            double es2;
            double ew;
            double ee;
            int br;
            boolean disp;
            Coordinate c = blocks.getNthBlock(i);
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            double h = te.getFillLevelForY(y);
            boolean bl = flip ? h < 1.0 || te.getFillLevelForY(y + 1) == 1.0 : (disp = h > 0.0 || te.getFillLevelForY(y - 1) == 1.0);
            if (!disp) continue;
            v5.func_78372_c((float)(x - te.field_145851_c), (float)(y - te.field_145848_d), (float)(z - te.field_145849_e));
            double o = 0.0025;
            h = Math.max(o, h);
            double min = flip ? 1.0 - o : 0.0 + o;
            double max = flip ? h + o : h - o;
            int bc = Keyboard.isKeyDown((int)71) ? 240 : te.func_145838_q().func_149677_c((IBlockAccess)te.field_145850_b, x, y, z);
            int[] brs = new int[6];
            for (int k = 0; k < 6; ++k) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[k];
                brs[k] = b.func_149677_c((IBlockAccess)te.field_145850_b, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            }
            int n = br = f.getLuminosity() > 10 ? 240 : bc;
            if (x == te.field_145851_c && y == te.field_145848_d && z == te.field_145849_e) {
                br = te.field_145850_b.func_147439_a(x, y + 1, z).func_149677_c((IBlockAccess)te.field_145850_b, x, y + 1, z);
            }
            v5.func_78380_c(br);
            RenderBlocks rb = RenderBlocks.getInstance();
            if (h < 1.0 || b.func_149646_a((IBlockAccess)te.field_145850_b, x, y, z, ForgeDirection.UP.ordinal())) {
                this.setFaceBrightness(v5, ForgeDirection.UP, f.getLuminosity());
                ee = blocks.hasBlock(x + 1, y, z) ? 1.0 : 1.0 - o;
                ew = blocks.hasBlock(x - 1, y, z) ? 0.0 : 0.0 + o;
                es2 = blocks.hasBlock(x, y, z + 1) ? 1.0 : 1.0 - o;
                en2 = blocks.hasBlock(x, y, z - 1) ? 0.0 : 0.0 + o;
                v5.func_78374_a(ew, max + te.getHeightOffsetAtCorner(x, y, z, -1, 1, h, par8), es2, (double)u, (double)dv);
                v5.func_78374_a(ee, max + te.getHeightOffsetAtCorner(x, y, z, 1, 1, h, par8), es2, (double)du, (double)dv);
                v5.func_78374_a(ee, max + te.getHeightOffsetAtCorner(x, y, z, 1, -1, h, par8), en2, (double)du, (double)v);
                v5.func_78374_a(ew, max + te.getHeightOffsetAtCorner(x, y, z, -1, -1, h, par8), en2, (double)u, (double)v);
            }
            if (b.func_149646_a((IBlockAccess)te.field_145850_b, x, y, z, ForgeDirection.DOWN.ordinal())) {
                this.setFaceBrightness(v5, ForgeDirection.DOWN, f.getLuminosity());
                ee = blocks.hasBlock(x + 1, y, z) ? 1.0 : 1.0 - o;
                ew = blocks.hasBlock(x - 1, y, z) ? 0.0 : 0.0 + o;
                es2 = blocks.hasBlock(x, y, z + 1) ? 1.0 : 1.0 - o;
                en2 = blocks.hasBlock(x, y, z - 1) ? 0.0 : 0.0 + o;
                v5.func_78374_a(ew, min, en2, (double)u, (double)v);
                v5.func_78374_a(ee, min, en2, (double)du, (double)v);
                v5.func_78374_a(ee, min, es2, (double)du, (double)dv);
                v5.func_78374_a(ew, min, es2, (double)u, (double)dv);
            }
            if (b.func_149646_a((IBlockAccess)te.field_145850_b, x, y, z, ForgeDirection.NORTH.ordinal())) {
                this.setFaceBrightness(v5, ForgeDirection.NORTH, f.getLuminosity());
                ee = blocks.hasBlock(x + 1, y, z) ? 1.0 : 1.0 - o;
                ew = blocks.hasBlock(x - 1, y, z) ? 0.0 : 0.0 + o;
                eu = blocks.hasBlock(x, y + 1, z) ? h : max;
                ed = blocks.hasBlock(x, y - 1, z) ? 0.0 : min;
                v5.func_78374_a(ew, eu + te.getHeightOffsetAtCorner(x, y, z, -1, -1, h, par8), 0.0 + o, (double)u, (double)dv);
                v5.func_78374_a(ee, eu + te.getHeightOffsetAtCorner(x, y, z, 1, -1, h, par8), 0.0 + o, (double)du, (double)dv);
                v5.func_78374_a(ee, ed, 0.0 + o, (double)du, (double)v);
                v5.func_78374_a(ew, ed, 0.0 + o, (double)u, (double)v);
            }
            if (b.func_149646_a((IBlockAccess)te.field_145850_b, x, y, z, ForgeDirection.SOUTH.ordinal())) {
                this.setFaceBrightness(v5, ForgeDirection.SOUTH, f.getLuminosity());
                ee = blocks.hasBlock(x + 1, y, z) ? 1.0 : 1.0 - o;
                ew = blocks.hasBlock(x - 1, y, z) ? 0.0 : 0.0 + o;
                eu = blocks.hasBlock(x, y + 1, z) ? h : max;
                ed = blocks.hasBlock(x, y - 1, z) ? 0.0 : min;
                v5.func_78374_a(ew, ed, 1.0 - o, (double)u, (double)v);
                v5.func_78374_a(ee, ed, 1.0 - o, (double)du, (double)v);
                v5.func_78374_a(ee, eu + te.getHeightOffsetAtCorner(x, y, z, 1, 1, h, par8), 1.0 - o, (double)du, (double)dv);
                v5.func_78374_a(ew, eu + te.getHeightOffsetAtCorner(x, y, z, -1, 1, h, par8), 1.0 - o, (double)u, (double)dv);
            }
            if (b.func_149646_a((IBlockAccess)te.field_145850_b, x, y, z, ForgeDirection.WEST.ordinal())) {
                this.setFaceBrightness(v5, ForgeDirection.WEST, f.getLuminosity());
                es = blocks.hasBlock(x, y, z + 1) ? 1.0 : 1.0 - o;
                en = blocks.hasBlock(x, y, z - 1) ? 0.0 : 0.0 + o;
                eu = blocks.hasBlock(x, y + 1, z) ? h : max;
                ed = blocks.hasBlock(x, y - 1, z) ? 0.0 : min;
                v5.func_78374_a(0.0 + o, ed, es, (double)u, (double)v);
                v5.func_78374_a(0.0 + o, eu + te.getHeightOffsetAtCorner(x, y, z, -1, 1, h, par8), es, (double)u, (double)dv);
                v5.func_78374_a(0.0 + o, eu + te.getHeightOffsetAtCorner(x, y, z, -1, -1, h, par8), en, (double)du, (double)dv);
                v5.func_78374_a(0.0 + o, ed, en, (double)du, (double)v);
            }
            if (b.func_149646_a((IBlockAccess)te.field_145850_b, x, y, z, ForgeDirection.EAST.ordinal())) {
                this.setFaceBrightness(v5, ForgeDirection.EAST, f.getLuminosity());
                es = blocks.hasBlock(x, y, z + 1) ? 1.0 : 1.0 - o;
                en = blocks.hasBlock(x, y, z - 1) ? 0.0 : 0.0 + o;
                eu = blocks.hasBlock(x, y + 1, z) ? h : max;
                ed = blocks.hasBlock(x, y - 1, z) ? 0.0 : min;
                v5.func_78374_a(1.0 - o, ed, en, (double)u, (double)dv);
                v5.func_78374_a(1.0 - o, eu + te.getHeightOffsetAtCorner(x, y, z, 1, -1, h, par8), en, (double)u, (double)v);
                v5.func_78374_a(1.0 - o, eu + te.getHeightOffsetAtCorner(x, y, z, 1, 1, h, par8), es, (double)du, (double)v);
                v5.func_78374_a(1.0 - o, ed, es, (double)du, (double)dv);
            }
            v5.func_78372_c((float)(-x + te.field_145851_c), (float)(-y + te.field_145848_d), (float)(-z + te.field_145849_e));
        }
        v5.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void setFaceBrightness(Tessellator v5, ForgeDirection dir, int brightness) {
        if (Keyboard.isKeyDown((int)72)) {
            return;
        }
        float f = 1.0f;
        float sub = 0.0f;
        switch (dir) {
            case DOWN: {
                sub = 0.4f;
                break;
            }
            case EAST: {
                sub = 0.5f;
                break;
            }
            case NORTH: {
                sub = 0.65f;
                break;
            }
            case SOUTH: {
                sub = 0.65f;
                break;
            }
            case UP: {
                sub = 0.0f;
                break;
            }
            case WEST: {
                sub = 0.5f;
                break;
            }
        }
        float osub = sub;
        sub *= (float)(16 - brightness) / 4.0f;
        sub = Math.min(sub, osub);
        v5.func_78386_a(f -= sub * 0.75f, f, f);
    }
}

