/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.TESR;

import Reika.ChromatiCraft.Base.ChromaModelBase;
import Reika.ChromatiCraft.Base.ChromaRenderBase;
import Reika.ChromatiCraft.Block.Decoration.BlockColoredAltar;
import Reika.ChromatiCraft.Models.ModelColoredAltar;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.CubeRotation;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.TruncatedCube;
import Reika.DragonAPI.Instantiable.Orbit;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Instantiable.Rendering.ColorVariance;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderColoredAltar
extends ChromaRenderBase {
    private static final Random rand = new Random();
    private static final EnumMap<CrystalElement, ColorBlendList[]> colors = new EnumMap(CrystalElement.class);
    private static final EnumMap<CrystalElement, ArrayList<Orbit>> orbits = new EnumMap(CrystalElement.class);
    private static final TruncatedCube cube = new TruncatedCube(0.03125, 0.05859375);
    private final ModelColoredAltar model = new ModelColoredAltar();

    public static int getBlendedCrystalColor(CrystalElement e, int pos, double tick) {
        return colors.get((Object)e)[pos].getColor(tick);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        BlockColoredAltar.TileEntityColoredAltar te = (BlockColoredAltar.TileEntityColoredAltar)tile;
        CrystalElement e = te.getColor();
        this.bindTextureByName("Textures/TileEntity/altartex.png");
        this.renderModel(tile, (ChromaModelBase)this.model, new Object[]{e, (double)((float)te.getRenderTick() + par8)});
        if (MinecraftForgeClient.getRenderPass() == 1) {
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            this.renderFloatingCubes(te, e, par2, par4, par6, par8);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderFloatingCubes(BlockColoredAltar.TileEntityColoredAltar te, CrystalElement e, double par2, double par4, double par6, float ptick) {
        ArrayList<Orbit> li = orbits.get((Object)e);
        double dtheta = te.getRenderTick() * 4;
        float pdist = (float)Minecraft.func_71410_x().field_71439_g.func_70011_f((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5);
        int n = li.size() / (1 + Minecraft.func_71410_x().field_71474_y.field_74362_aa);
        for (int i = 0; i < Math.min(n, li.size()); ++i) {
            Orbit o = li.get(i);
            CubeRotation cb = te.cubeRotations[i];
            double dn = 4.0 * (1.0 + (double)Minecraft.func_71410_x().field_71474_y.field_74362_aa / 2.0);
            if (pdist > 8.0f) {
                dn = Math.min(12.0, dn * 2.0);
            }
            if (pdist > 16.0f) {
                dn = Math.min(16.0, dn * 2.0);
            }
            for (double d = -24.0; d <= 0.0; d += dn) {
                DecimalPosition pos = o.getPosition(0.5, 1.25, 0.5, dtheta + d);
                this.renderCubeAtPos(te, e, pos.xCoord, pos.yCoord, pos.zCoord, cb.angX, cb.angY, cb.angZ, ptick, d, pdist);
            }
            double v = 0.375;
            double t = (float)te.getTicksExisted() + ptick;
            cb.rvX = v * (1.0 + 0.5 * Math.sin(Math.toRadians(t))) * (1.0 + 0.5 * Math.cos(Math.toRadians(90.0 + t)));
            cb.rvY = v * (1.0 + 0.25 * Math.sin(Math.toRadians(2.0 * t))) * (1.0 + 0.75 * Math.cos(Math.toRadians(t)));
            cb.rvZ = v * (1.0 + 0.75 * Math.sin(Math.toRadians(90.0 + t))) * (1.0 + 0.25 * Math.cos(Math.toRadians(2.0 * t)));
            cb.angX += cb.rvX;
            cb.angY += cb.rvY;
            cb.angZ += cb.rvZ;
        }
    }

    private void renderCubeAtPos(BlockColoredAltar.TileEntityColoredAltar te, CrystalElement e, double x, double y, double z, double r1, double r2, double r3, float ptick, double f, float pdist) {
        GL11.glPushMatrix();
        Tessellator v5 = Tessellator.field_78398_a;
        double s = 0.0625;
        double s2 = s * 1.875;
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotated((double)r1, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)r2, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)r3, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
        int c = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)e.getColor(), (float)0.125f);
        int c2 = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)e.getColor(), (float)0.375f);
        int a = (int)(190.0 * (1.0 + f / 24.0));
        int a2 = 150;
        cube.render(x, y, z, c | a << 24, c2 | a2 << 24, f == 0.0, pdist);
        GL11.glPopMatrix();
    }

    public String getImageFileName(RenderFetcher te) {
        return null;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            ColorBlendList[] arr = new ColorBlendList[24];
            for (int k = 0; k < arr.length; ++k) {
                ColorVariance cv = new ColorVariance(e.getColor(), 10.0f, 0.0f, 48.0f);
                cv.whiteVariation = 0.25f;
                cv.alphaRoot = 171;
                cv.alphaVariation = 21;
                arr[k] = cv.getBlends(8, (float)ReikaRandomHelper.getRandomPlusMinus((int)40, (int)30));
            }
            colors.put(e, arr);
            ArrayList<Orbit> li = new ArrayList<Orbit>();
            for (int k = 0; k < 12; ++k) {
                double a = ReikaRandomHelper.getRandomPlusMinus((double)0.5, (double)0.25);
                double ec = rand.nextDouble() * 0.4;
                li.add(new Orbit(a, ec, (double)rand.nextInt(90), (double)rand.nextInt(360), (double)rand.nextInt(360), (double)rand.nextInt(360)));
            }
            orbits.put(e, li);
        }
    }
}

