/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.TESR;

import Reika.ChromatiCraft.Base.ChromaRenderBase;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.TileEntity.AOE.Defence.TileEntityGuardianStone;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Orbit;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GuardianStoneRenderer
extends ChromaRenderBase {
    private static final ArrayList<ParticleOrbit> orbits = new ArrayList();
    private static final Random rand = new Random();

    private static void addParticle(double r, double e, double theta, double i, double raan, double arg) {
        orbits.add(new ParticleOrbit(new Orbit(r, e, theta, i, raan, arg), ReikaColorAPI.RGBtoHex((int)rand.nextInt(255), (int)120, (int)255)));
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        TileEntityGuardianStone te = (TileEntityGuardianStone)tile;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 1.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glDepthMask((boolean)false);
        if (tile.func_145830_o()) {
            this.drawMiddle(te);
        }
        this.drawInner(te);
        if (!tile.func_145830_o()) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
            this.drawOuter(te);
        }
        if (te.func_145830_o()) {
            GL11.glEnable((int)2896);
        } else {
            RenderHelper.func_74520_c();
        }
        GL11.glPopAttrib();
        if (te.func_145830_o()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawInner(TileEntityGuardianStone te) {
        ReikaTextureHelper.bindTerrainTexture();
        IIcon ico = ChromaIcons.GUARDIANINNER.getIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        float uu = du - u;
        float vv = dv - v;
        float r = 16.0f;
        u += uu / r;
        du -= uu / r;
        v += vv / r;
        dv -= vv / r;
        Tessellator v5 = Tessellator.field_78398_a;
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        double s = 0.33;
        if (te.func_145830_o()) {
            GL11.glScaled((double)s, (double)s, (double)s);
            RenderManager rm = RenderManager.field_78727_a;
            GL11.glRotatef((float)rm.field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            s = 0.5;
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glRotated((double)-45.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)-30.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)s);
        }
        v5.func_78382_b();
        v5.func_78374_a(-1.0, -1.0, 0.0, (double)u, (double)v);
        v5.func_78374_a(1.0, -1.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(1.0, 1.0, 0.0, (double)du, (double)dv);
        v5.func_78374_a(-1.0, 1.0, 0.0, (double)u, (double)dv);
        v5.func_78381_a();
        GL11.glEnable((int)2884);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPopMatrix();
    }

    private void drawMiddle(TileEntityGuardianStone te) {
        GL11.glDisable((int)3553);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        double theta = (double)System.currentTimeMillis() / 20.0 % 360.0;
        for (ParticleOrbit p : orbits) {
            this.renderOrbitingParticle(p, theta);
        }
        GL11.glEnable((int)3553);
    }

    private void renderOrbitingParticle(ParticleOrbit p, double dtheta) {
        Tessellator v5 = Tessellator.field_78398_a;
        DecimalPosition pos = p.orbit.getPosition(0.0, 0.0, 0.0, dtheta);
        RenderManager rm = RenderManager.field_78727_a;
        GL11.glRotatef((float)rm.field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        double d = 0.008;
        v5.func_78382_b();
        v5.func_78384_a(p.color, 255);
        v5.func_78377_a(pos.xCoord - d, pos.yCoord - d, pos.zCoord);
        v5.func_78377_a(pos.xCoord + d, pos.yCoord - d, pos.zCoord);
        v5.func_78377_a(pos.xCoord + d, pos.yCoord + d, pos.zCoord);
        v5.func_78377_a(pos.xCoord - d, pos.yCoord + d, pos.zCoord);
        d = 0.005;
        v5.func_78384_a(ReikaColorAPI.mixColors((int)0xFFFFFF, (int)p.color, (float)0.25f), 255);
        v5.func_78377_a(pos.xCoord - d, pos.yCoord - d, pos.zCoord);
        v5.func_78377_a(pos.xCoord + d, pos.yCoord - d, pos.zCoord);
        v5.func_78377_a(pos.xCoord + d, pos.yCoord + d, pos.zCoord);
        v5.func_78377_a(pos.xCoord - d, pos.yCoord + d, pos.zCoord);
        v5.func_78381_a();
        GL11.glRotatef((float)(-rm.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-rm.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void drawOuter(TileEntityGuardianStone te) {
        ReikaTextureHelper.bindTerrainTexture();
        IIcon ico = ChromaIcons.GUARDIANOUTER.getIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        this.drawBox(1.0f, 0.0, u, v, du, dv);
    }

    private void drawCore() {
        ReikaTextureHelper.bindTerrainTexture();
        Block b = ChromaBlocks.CRYSTAL.getBlockInstance();
        IIcon ico = b.func_149691_a(0, 0);
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        this.drawBox(0.5f, 0.25, u, v, du, dv);
        this.drawBox(0.25f, 0.125, u, v, du, dv);
        this.drawBox(0.125f, 0.0, u, v, du, dv);
    }

    private void drawBox(float a, double s, float u, float v, float du, float dv) {
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        v5.func_78382_b();
        v5.func_78374_a(s, s, s, (double)u, (double)v);
        v5.func_78374_a(1.0 - s, s, s, (double)du, (double)v);
        v5.func_78374_a(1.0 - s, s, 1.0 - s, (double)du, (double)dv);
        v5.func_78374_a(s, s, 1.0 - s, (double)u, (double)dv);
        v5.func_78374_a(s, 1.0 - s, 1.0 - s, (double)u, (double)dv);
        v5.func_78374_a(1.0 - s, 1.0 - s, 1.0 - s, (double)du, (double)dv);
        v5.func_78374_a(1.0 - s, 1.0 - s, s, (double)du, (double)v);
        v5.func_78374_a(s, 1.0 - s, s, (double)u, (double)v);
        v5.func_78374_a(s, s, s, (double)u, (double)v);
        v5.func_78374_a(s, 1.0 - s, s, (double)u, (double)dv);
        v5.func_78374_a(1.0 - s, 1.0 - s, s, (double)du, (double)dv);
        v5.func_78374_a(1.0 - s, s, s, (double)du, (double)v);
        v5.func_78374_a(1.0 - s, s, 1.0 - s, (double)du, (double)v);
        v5.func_78374_a(1.0 - s, 1.0 - s, 1.0 - s, (double)du, (double)dv);
        v5.func_78374_a(s, 1.0 - s, 1.0 - s, (double)u, (double)dv);
        v5.func_78374_a(s, s, 1.0 - s, (double)u, (double)v);
        v5.func_78374_a(s, s, 1.0 - s, (double)du, (double)v);
        v5.func_78374_a(s, 1.0 - s, 1.0 - s, (double)du, (double)dv);
        v5.func_78374_a(s, 1.0 - s, s, (double)u, (double)dv);
        v5.func_78374_a(s, s, s, (double)u, (double)v);
        v5.func_78374_a(1.0 - s, s, s, (double)u, (double)v);
        v5.func_78374_a(1.0 - s, 1.0 - s, s, (double)u, (double)dv);
        v5.func_78374_a(1.0 - s, 1.0 - s, 1.0 - s, (double)du, (double)dv);
        v5.func_78374_a(1.0 - s, s, 1.0 - s, (double)du, (double)v);
        v5.func_78381_a();
    }

    private void drawLines() {
        int a = 190;
        double ang = (double)System.currentTimeMillis() / 40.0 % 360.0;
        double r = 0.25 * (1.0 + Math.sin(Math.toRadians(ang + 0.0)));
        this.drawLineRing(r, 0.2, 0.125, 1.0f, 255, a, 255);
        r = 0.25 * (1.0 + Math.sin(Math.toRadians(ang + 60.0)));
        this.drawLineRing(r, 0.2, 0.25, -0.75f, a, a, 255);
        r = 0.25 * (1.0 + Math.sin(Math.toRadians(ang + 120.0)));
        this.drawLineRing(r, 0.2, 0.5, 1.5f, 255, 255, 255);
        r = 0.25 * (1.0 + Math.sin(Math.toRadians(ang + 180.0)));
        this.drawLineRing(r, 0.2, 0.675, -1.0f, a, 255, a);
        r = 0.25 * (1.0 + Math.sin(Math.toRadians(ang + 240.0)));
        this.drawLineRing(r, 0.2, 0.75, 0.75f, 255, a, a);
        r = 0.25 * (1.0 + Math.sin(Math.toRadians(ang + 300.0)));
        this.drawLineRing(r, 0.2, 0.875, -1.5f, 255, 255, a);
    }

    private void drawLineRing(double r, double h, double y, float speed, int red, int green, int blue) {
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        double ang = (double)System.currentTimeMillis() / 20.0 * (double)speed % 360.0;
        v5.func_78371_b(1);
        v5.func_78376_a(red, green, blue);
        float da = r > 0.4 ? 12.0f : (r > 0.3 ? 16.0f : (r > 0.25 ? 20.0f : (r > 0.125 ? 30.0f : 40.0f)));
        int i = 0;
        while (i < 360) {
            double ang2 = ang + (double)i;
            double x = 0.5 + r * Math.cos(Math.toRadians(ang2));
            double z = 0.5 + r * Math.sin(Math.toRadians(ang2));
            v5.func_78377_a(x, y - h / 2.0, z);
            v5.func_78377_a(x, y + h / 2.0, z);
            i = (int)((float)i + da);
        }
        v5.func_78381_a();
        GL11.glEnable((int)3553);
    }

    private void drawLine(double r, double h, double y, float speed, int red, int green, int blue) {
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        double ang = (double)System.currentTimeMillis() / 20.0 * (double)speed % 360.0;
        double ang2 = (double)System.currentTimeMillis() / 800.0 / (double)speed % 360.0;
        double x = 0.5 + (r *= Math.max(Math.abs(Math.sin(ang2)), 0.5)) * Math.cos(Math.toRadians(ang));
        double z = 0.5 + r * Math.sin(Math.toRadians(ang));
        v5.func_78371_b(1);
        v5.func_78376_a(red, green, blue);
        v5.func_78377_a(x, y - h / 2.0, z);
        v5.func_78377_a(x, y + h / 2.0, z);
        v5.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public String getImageFileName(RenderFetcher te) {
        return "";
    }

    static {
        boolean a = false;
        int b = 120;
        double r = 0.4;
        GuardianStoneRenderer.addParticle(r, 0.5, 0.0, 0.0, 0.0, 0.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 45.0, 60.0, 180.0, 90.0);
        GuardianStoneRenderer.addParticle(r, 0.4, 90.0, 40.0, 20.0, 270.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 135.0, 120.0, 220.0, 30.0);
        GuardianStoneRenderer.addParticle(r, 0.7, 180.0, 330.0, 60.0, 120.0);
        GuardianStoneRenderer.addParticle(r, 0.4, 225.0, 90.0, 60.0, 240.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 270.0, 260.0, 0.0, 0.0);
        GuardianStoneRenderer.addParticle(r, 0.5, 315.0, 100.0, 120.0, 100.0);
        GuardianStoneRenderer.addParticle(r, 0.5, 0.0, 40.0, 30.0, 20.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 45.0, 120.0, 160.0, 40.0);
        GuardianStoneRenderer.addParticle(r, 0.4, 90.0, 90.0, 20.0, 120.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 135.0, 320.0, 120.0, 30.0);
        GuardianStoneRenderer.addParticle(r, 0.7, 180.0, 170.0, 60.0, 240.0);
        GuardianStoneRenderer.addParticle(r, 0.4, 225.0, 40.0, 90.0, 60.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 270.0, 110.0, 0.0, 90.0);
        GuardianStoneRenderer.addParticle(r, 0.5, 315.0, 60.0, 0.0, 30.0);
        GuardianStoneRenderer.addParticle(r, 0.5, 0.0, 80.0, 90.0, 340.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 45.0, 240.0, 220.0, 320.0);
        GuardianStoneRenderer.addParticle(r, 0.4, 90.0, 180.0, 80.0, 240.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 135.0, 80.0, 180.0, 330.0);
        GuardianStoneRenderer.addParticle(r, 0.7, 180.0, 20.0, 120.0, 120.0);
        GuardianStoneRenderer.addParticle(r, 0.4, 225.0, 80.0, 150.0, 300.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 270.0, 220.0, 60.0, 270.0);
        GuardianStoneRenderer.addParticle(r, 0.5, 315.0, 120.0, 60.0, 330.0);
        GuardianStoneRenderer.addParticle(r, 0.5, 0.0, 80.0, 180.0, 320.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 45.0, 240.0, 80.0, 280.0);
        GuardianStoneRenderer.addParticle(r, 0.4, 90.0, 180.0, 160.0, 120.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 135.0, 80.0, 0.0, 300.0);
        GuardianStoneRenderer.addParticle(r, 0.7, 180.0, 20.0, 240.0, 240.0);
        GuardianStoneRenderer.addParticle(r, 0.4, 225.0, 80.0, 300.0, 240.0);
        GuardianStoneRenderer.addParticle(r, 0.6, 270.0, 220.0, 120.0, 90.0);
        GuardianStoneRenderer.addParticle(r, 0.5, 315.0, 120.0, 120.0, 300.0);
    }

    private static class ParticleOrbit {
        private final Orbit orbit;
        private final int color;

        private ParticleOrbit(Orbit o, int c) {
            this.orbit = o;
            this.color = c;
        }
    }
}

