/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.ChromatiCraft.Auxiliary.Interfaces.CustomRenderFX;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFireFX;
import Reika.ChromatiCraft.Render.Particle.EntityFireSmokeFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.ChromatiCraft.Render.Particle.EntityGlobeFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.DragonAPI.IO.ThrottleableEffectRenderer;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ParticleEngine
extends EffectRenderer {
    public static final ParticleEngine instance = new ParticleEngine();
    private final MultiMap<RenderKey, EntityFX> particles = new MultiMap((MultiMap.CollectionFactory)new MultiMap.ListFactory()).setNullEmpty();
    private final PluralMap<RenderKey> keyMap = new PluralMap(2);
    private Random rand = new Random();
    public static final int MAX_PARTICLES = ThrottleableEffectRenderer.getRegisteredInstance().limit;
    public final TextureMode blockTex = new VanillaTextureMode(TextureMap.field_110575_b);
    public final TextureMode itemTex = new VanillaTextureMode(TextureMap.field_110576_c);
    public final TextureMode particleTex = new VanillaTextureMode(new ResourceLocation("textures/particle/particles.png"));
    private final RenderKey DEFAULT_RENDER = new RenderKey(this.particleTex, new RenderMode());
    private boolean isRendering;
    private boolean isTicking;

    private ParticleEngine() {
        super(null, null);
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityBlurFX.class, (EffectRenderer)this);
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityFloatingSeedsFX.class, (EffectRenderer)this);
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityFireFX.class, (EffectRenderer)this);
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityFireSmokeFX.class, (EffectRenderer)this);
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityRuneFX.class, (EffectRenderer)this);
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityLaserFX.class, (EffectRenderer)this);
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityCenterBlurFX.class, (EffectRenderer)this);
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityGlobeFX.class, (EffectRenderer)this);
    }

    public String func_78869_b() {
        return this.particles.totalSize() + " Particles, " + this.keyMap.size() + " keys";
    }

    public void func_78874_a(Entity entity, float frame) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        this.isRendering = true;
        for (RenderKey rm : this.particles.keySet()) {
            Collection parts = this.particles.get((Object)rm);
            if (parts.isEmpty()) continue;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            rm.apply();
            float yaw = ActiveRenderInfo.field_74588_d;
            float pitch = ActiveRenderInfo.field_74586_f;
            float f3 = ActiveRenderInfo.field_74587_g;
            float f4 = ActiveRenderInfo.field_74596_h;
            float f5 = ActiveRenderInfo.field_74589_e;
            EntityFX.field_70556_an = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
            EntityFX.field_70554_ao = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
            EntityFX.field_70555_ap = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            for (EntityFX fx : parts) {
                if (rm.mode.flags[RenderModeFlags.LIGHT.ordinal()]) {
                    v5.func_78380_c(fx.func_70070_b(frame));
                } else {
                    v5.func_78380_c(240);
                }
                fx.func_70539_a(v5, frame, yaw, f5, pitch, f3, f4);
            }
            v5.func_78381_a();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        this.isRendering = false;
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void func_78873_a(EntityFX fx) {
        if (this.isRendering) {
            ChromatiCraft.logger.logError((Object)"Tried adding a particle mid-render!");
            Thread.dumpStack();
            return;
        }
        if (this.isTicking) {
            ChromatiCraft.logger.logError((Object)"Tried adding a particle mid-update!");
            Thread.dumpStack();
            return;
        }
        RenderKey rm = this.DEFAULT_RENDER;
        if (fx instanceof CustomRenderFX) {
            rm = this.getOrCreateKey(((CustomRenderFX)fx).getTexture(), ((CustomRenderFX)fx).getRenderMode());
        }
        this.particles.addValue((Object)rm, (Object)fx, true);
        Collection parts = this.particles.get((Object)rm);
        if (parts.size() >= MAX_PARTICLES) {
            ((List)parts).remove(0);
        }
    }

    private RenderKey getOrCreateKey(TextureMode tex, RenderMode rm) {
        RenderKey rk = (RenderKey)this.keyMap.get(new Object[]{tex, rm});
        if (rk == null) {
            rk = new RenderKey(tex, rm);
            this.keyMap.put((Object)rk, new Object[]{tex, rm});
        }
        return rk;
    }

    public void func_78868_a() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71441_e == null) {
            return;
        }
        this.isTicking = true;
        int dim = mc.field_71441_e.field_73011_w.field_76574_g;
        for (RenderKey rm : this.particles.keySet()) {
            Collection parts = this.particles.get((Object)rm);
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                try {
                    EntityFX fx = (EntityFX)it.next();
                    if (fx != null) {
                        fx.func_70071_h_();
                    }
                    if (fx != null && !fx.field_70128_L) continue;
                    it.remove();
                }
                catch (ConcurrentModificationException e) {}
            }
        }
        this.isTicking = false;
    }

    public void func_78870_a(World world) {
        this.particles.clear();
    }

    public static enum RenderModeFlags {
        ALPHA(true),
        LIGHT(true),
        ADDITIVE(false),
        DEPTH(true),
        ALPHACLIP(true);

        private final boolean defaultValue;
        private static final RenderModeFlags[] list;

        private RenderModeFlags(boolean f) {
            this.defaultValue = f;
        }

        private int getFlag() {
            return 1 << this.ordinal();
        }

        private void apply(boolean set) {
            switch (this) {
                case LIGHT: {
                    if (set) {
                        GL11.glEnable((int)2896);
                        ReikaRenderHelper.enableEntityLighting();
                        break;
                    }
                    GL11.glDisable((int)2896);
                    ReikaRenderHelper.disableEntityLighting();
                    break;
                }
                case ALPHA: {
                    if (set) {
                        GL11.glEnable((int)3042);
                        break;
                    }
                    GL11.glDisable((int)3042);
                    break;
                }
                case ADDITIVE: {
                    if (set) {
                        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
                        break;
                    }
                    ReikaGLHelper.BlendMode.DEFAULT.apply();
                    break;
                }
                case DEPTH: {
                    if (set && !ThrottleableEffectRenderer.renderThroughWalls()) {
                        GL11.glEnable((int)2929);
                        break;
                    }
                    GL11.glDisable((int)2929);
                    break;
                }
                case ALPHACLIP: {
                    if (set) {
                        GL11.glEnable((int)3008);
                        break;
                    }
                    GL11.glDisable((int)3008);
                }
            }
        }

        static {
            list = RenderModeFlags.values();
        }
    }

    public static class RenderMode {
        private final boolean[] flags = new boolean[RenderModeFlags.access$600().length];

        public RenderMode() {
            for (int i = 0; i < this.flags.length; ++i) {
                this.flags[i] = RenderModeFlags.list[i].defaultValue;
            }
        }

        public RenderMode setFlag(RenderModeFlags f, boolean flag) {
            this.flags[f.ordinal()] = flag;
            return this;
        }

        public int hashCode() {
            return ReikaArrayHelper.booleanToBitflags((boolean[])this.flags);
        }

        public boolean equals(Object o) {
            if (o instanceof RenderMode) {
                RenderMode r = (RenderMode)o;
                return Arrays.equals(this.flags, r.flags);
            }
            return false;
        }

        private void apply() {
            for (int i = 0; i < this.flags.length; ++i) {
                RenderModeFlags.list[i].apply(this.flags[i]);
            }
        }
    }

    private static final class VanillaTextureMode
    extends TextureMode {
        private final ResourceLocation resource;

        private VanillaTextureMode(ResourceLocation loc) {
            this.resource = loc;
        }

        @Override
        protected void bind() {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resource);
        }

        @Override
        protected boolean isTextureSame(TextureMode o) {
            return ((VanillaTextureMode)o).resource.equals((Object)this.resource);
        }

        @Override
        public int hashCode() {
            return this.resource.hashCode();
        }
    }

    public static final class CustomTextureMode
    extends TextureMode {
        private final Class reference;
        private final String texture;

        public CustomTextureMode(Class c, String t) {
            this.reference = c;
            this.texture = t;
        }

        @Override
        protected void bind() {
            ReikaTextureHelper.bindFinalTexture((Class)this.reference, (String)this.texture);
        }

        @Override
        protected boolean isTextureSame(TextureMode o) {
            CustomTextureMode cm = (CustomTextureMode)o;
            return cm.reference == this.reference && this.texture.equals(cm.texture);
        }

        @Override
        public int hashCode() {
            return this.reference.hashCode() ^ this.texture.hashCode();
        }
    }

    public static abstract class TextureMode {
        protected abstract void bind();

        public final boolean equals(Object o) {
            return o.getClass() == this.getClass() && this.isTextureSame((TextureMode)o);
        }

        protected abstract boolean isTextureSame(TextureMode var1);

        public abstract int hashCode();
    }

    private static class RenderKey {
        private final RenderMode mode;
        private final TextureMode texture;

        private RenderKey(TextureMode s, RenderMode rm) {
            this.texture = s;
            this.mode = rm;
        }

        private void apply() {
            this.mode.apply();
            this.texture.bind();
        }

        public int hashCode() {
            return this.texture.hashCode() ^ this.mode.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RenderKey) {
                RenderKey r = (RenderKey)o;
                return this.texture.equals(r.texture) && this.mode.equals(r.mode);
            }
            return false;
        }
    }
}

