/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.Particle;

import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class EntityFloatingSeedsFX
extends EntityBlurFX {
    private double angXZ;
    private double angY;
    private double angXZ_vel;
    private double angY_vel;
    private double angXZ_target;
    private double angY_target;
    private final double windAngle;
    private final double climbAngle;
    public double tolerance = 1.5;
    public double freedom = 20.0;
    public double angleVelocity = 0.75;
    public double particleVelocity = 0.0625;

    public EntityFloatingSeedsFX(World world, double x, double y, double z, double windAng, double climbAng) {
        this(world, x, y, z, windAng, climbAng, null);
    }

    public EntityFloatingSeedsFX(World world, double x, double y, double z, double windAng, double climbAng, IIcon icon) {
        super(world, x, y, z);
        this.windAngle = windAng;
        this.climbAngle = climbAng;
        this.angXZ = this.windAngle;
        this.angY = this.climbAngle;
        this.randomizeXZ();
        this.randomizeY();
        this.updateVelocities();
        if (icon == null) {
            IIcon ico = this.field_70550_a;
            switch (this.field_70146_Z.nextInt(4)) {
                case 1: {
                    ico = ChromaIcons.BIGFLARE.getIcon();
                    break;
                }
                case 2: {
                    ico = ChromaIcons.SPARKLEPARTICLE.getIcon();
                    this.setBasicBlend();
                    this.enableAlphaTest();
                    break;
                }
                case 3: {
                    ico = ChromaIcons.CENTER.getIcon();
                }
            }
            this.func_110125_a(ico);
        } else {
            this.func_110125_a(icon);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateAnglesAndSpeeds();
    }

    private void updateAnglesAndSpeeds() {
        this.updateAngles();
        this.angXZ += this.angXZ_vel;
        this.angY += this.angY_vel;
        this.updateVelocities();
    }

    private void updateAngles() {
        if (Math.abs(this.angXZ_target - this.angXZ) <= this.tolerance) {
            this.randomizeXZ();
        }
        if (Math.abs(this.angY_target - this.angY) <= this.tolerance) {
            this.randomizeY();
        }
    }

    private void randomizeXZ() {
        this.angXZ_target = ReikaRandomHelper.getRandomPlusMinus((double)this.windAngle, (double)this.freedom);
        if (this.angXZ_target > this.angXZ) {
            this.angXZ_vel = this.angleVelocity;
        } else if (this.angXZ_target < this.angXZ) {
            this.angXZ_vel = -this.angleVelocity;
        }
    }

    private void randomizeY() {
        this.angY_target = ReikaRandomHelper.getRandomPlusMinus((double)this.climbAngle, (double)this.freedom);
        if (this.angY_target > this.angY) {
            this.angY_vel = this.angleVelocity;
        } else if (this.angY_target < this.angY) {
            this.angY_vel = -this.angleVelocity;
        }
    }

    private void updateVelocities() {
        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)this.particleVelocity, (double)this.angY, (double)this.angXZ);
        this.field_70159_w = xyz[0];
        this.field_70181_x = xyz[1];
        this.field_70179_y = xyz[2];
    }
}

