/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.Particle;

import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class EntityFireFX
extends EntityBlurFX {
    private int color1;
    private int color2;
    private float particleStretch = (float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.0625);
    private float tailOff = (float)ReikaRandomHelper.getRandomPlusMinus((double)5.0, (double)2.5);
    private boolean exploding = false;
    private boolean hasImpacted;

    public EntityFireFX(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setColliding();
        this.color1 = 0xFF0000 | this.field_70146_Z.nextInt(127) << 8;
        this.color2 = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)0xFFFF00, (float)this.field_70146_Z.nextFloat());
    }

    public EntityFireFX setStretch(float s) {
        this.particleStretch = s;
        return this;
    }

    public EntityFireFX setTailoff(float t) {
        this.tailOff = t;
        return this;
    }

    public EntityFireFX setExploding() {
        this.exploding = true;
        return this;
    }

    @Override
    protected void onCollision() {
        this.hasImpacted = true;
        this.particleStretch *= 0.25f;
        if (this.exploding) {
            this.explode();
        } else {
            float frac = (float)this.field_70546_d / (float)this.field_70547_e;
            this.field_70547_e = 20;
            this.field_70546_d = (int)(frac * (float)this.field_70547_e);
        }
    }

    private void explode() {
        ReikaParticleHelper.EXPLODE.spawnAt((Entity)this);
        this.func_70106_y();
    }

    public void func_70539_a(Tessellator v5, float par2, float par3, float par4, float par5, float par6, float par7) {
        float s = this.field_70544_f;
        double y = this.field_70163_u;
        int n = this.hasImpacted ? 1 + (this.field_70146_Z.nextInt(2) == 0 ? 1 : 0) : 5;
        for (int i = 0; i < n; ++i) {
            float ds = 1.0f - (float)i / this.tailOff;
            this.field_70163_u = y + (double)((float)i * s * this.particleStretch);
            this.field_70544_f = s * ds;
            this.setColor(this.color1);
            super.func_70539_a(v5, par2, par3, par4, par5, par6, par7);
            this.setColor(this.color2);
            this.field_70544_f = s * ds * 0.6f;
            super.func_70539_a(v5, par2, par3, par4, par5, par6, par7);
        }
        this.field_70544_f = s;
        this.field_70163_u = y;
    }
}

