/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.Particle;

import Reika.ChromatiCraft.Auxiliary.Interfaces.CustomRenderFX;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.ParticleEngine;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityCenterBlurFX
extends EntityFX
implements CustomRenderFX {
    private static final ParticleEngine.TextureMode texture = new ParticleEngine.CustomTextureMode(ChromatiCraft.class, "Textures/Particle/64x.png");
    private static final ParticleEngine.RenderMode render = new ParticleEngine.RenderMode().setFlag(ParticleEngine.RenderModeFlags.ADDITIVE, true).setFlag(ParticleEngine.RenderModeFlags.ALPHACLIP, false).setFlag(ParticleEngine.RenderModeFlags.LIGHT, false);
    private float scale;
    private float cyclescale;
    private boolean noSlow;

    public EntityCenterBlurFX(World world, double x, double y, double z) {
        this(CrystalElement.WHITE, world, x, y, z, 0.0, 0.0, 0.0);
    }

    public EntityCenterBlurFX(World world, double x, double y, double z, double vx, double vy, double vz) {
        this(CrystalElement.WHITE, world, x, y, z, vx, vy, vz);
    }

    public EntityCenterBlurFX(CrystalElement e, World world, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.field_70545_g = 0.0f;
        this.field_70145_X = true;
        this.field_70547_e = 63;
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        this.field_70544_f = 1.0f;
        this.field_70552_h = (float)e.getRed() / 255.0f;
        this.field_70553_i = (float)e.getGreen() / 255.0f;
        this.field_70551_j = (float)e.getBlue() / 255.0f;
    }

    public EntityCenterBlurFX setScale(float f) {
        this.field_70544_f = f;
        return this;
    }

    public final EntityCenterBlurFX setLife(int time) {
        this.field_70547_e = time;
        return this;
    }

    public final EntityCenterBlurFX setNoSlowdown() {
        this.noSlow = true;
        return this;
    }

    public final EntityCenterBlurFX setGravity(float g) {
        this.field_70545_g = g;
        return this;
    }

    public final EntityCenterBlurFX setColor(int rgb) {
        this.field_70552_h = ReikaColorAPI.HextoColorMultiplier((int)rgb, (int)0);
        this.field_70553_i = ReikaColorAPI.HextoColorMultiplier((int)rgb, (int)1);
        this.field_70551_j = ReikaColorAPI.HextoColorMultiplier((int)rgb, (int)2);
        return this;
    }

    public void func_70071_h_() {
        if (this.noSlow) {
            double mx = this.field_70159_w;
            double my = this.field_70181_x;
            double mz = this.field_70179_y;
            super.func_70071_h_();
            this.field_70159_w = mx;
            this.field_70181_x = my;
            this.field_70179_y = mz;
        } else {
            super.func_70071_h_();
        }
        if (this.field_70546_d < 16) {
            this.field_94054_b = this.field_70546_d;
            this.field_94055_c = 4;
        } else if (this.field_70546_d < 32) {
            this.field_94054_b = this.field_70546_d - 16;
            this.field_94055_c = 5;
        } else if (this.field_70546_d < 48) {
            this.field_94054_b = 15 - this.field_70546_d % 16;
            this.field_94055_c = 5;
        } else {
            this.field_94054_b = 15 - this.field_70546_d % 16;
            this.field_94055_c = 4;
        }
        if (this.cyclescale > 0.0f) {
            CrystalElement e = CrystalElement.elements[(int)((float)this.field_70546_d * this.cyclescale % 16.0f)];
            this.field_70552_h = (float)e.getRed() / 255.0f;
            this.field_70553_i = (float)e.getGreen() / 255.0f;
            this.field_70551_j = (float)e.getBlue() / 255.0f;
        }
    }

    public int func_70070_b(float par1) {
        return 240;
    }

    public int func_70537_b() {
        return 2;
    }

    public EntityCenterBlurFX setCyclingColor(float scale) {
        this.cyclescale = scale;
        return this;
    }

    @Override
    public ParticleEngine.RenderMode getRenderMode() {
        return render;
    }

    @Override
    public ParticleEngine.TextureMode getTexture() {
        return texture;
    }
}

