/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.Particle;

import Reika.ChromatiCraft.Auxiliary.Interfaces.CustomRenderFX;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.ParticleEngine;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityBlurFX
extends EntityFX
implements CustomRenderFX {
    private float scale;
    private float cyclescale;
    private boolean noSlow = false;
    private boolean rapidExpand = false;
    private boolean alphaFade = false;
    private AxisAlignedBB bounds = null;
    private double collideAngle;
    private boolean colliding = false;
    private int lifeFreeze;
    private int preColor = -1;
    private int fadeColor = -1;
    private float defaultRed;
    private float defaultGreen;
    private float defaultBlue;
    private Coordinate destination;
    private EntityFX lock;
    private Collection<EntityFX> locks = new HashSet<EntityFX>();
    private boolean additiveBlend = true;
    private boolean depthTest = true;
    private boolean alphaTest = false;
    private MotionController motionController;
    private PositionController positionController;
    private ColorController colorController;

    public EntityBlurFX(World world, double x, double y, double z) {
        this(CrystalElement.WHITE, world, x, y, z, 0.0, 0.0, 0.0);
    }

    public EntityBlurFX(World world, double x, double y, double z, double vx, double vy, double vz) {
        this(CrystalElement.WHITE, world, x, y, z, vx, vy, vz);
    }

    public EntityBlurFX(CrystalElement e, World world, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.field_70545_g = 0.0f;
        this.field_70145_X = true;
        this.field_70547_e = 60;
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        this.scale = 1.0f;
        this.setColor(e.getColor());
        this.field_70550_a = ChromaIcons.FADE.getIcon();
    }

    public EntityBlurFX setIcon(ChromaIcons c) {
        this.field_70550_a = c.getIcon();
        if (!c.isTransparent()) {
            this.alphaTest = false;
            this.additiveBlend = true;
        }
        return this;
    }

    public EntityBlurFX setIcon(IIcon ii) {
        this.field_70550_a = ii;
        return this;
    }

    public EntityBlurFX setScale(float f) {
        this.scale = f;
        return this;
    }

    public final EntityBlurFX setLife(int time) {
        this.field_70547_e = time;
        return this;
    }

    public final EntityBlurFX setNoSlowdown() {
        this.noSlow = true;
        return this;
    }

    public EntityBlurFX setRapidExpand() {
        this.rapidExpand = true;
        return this;
    }

    public EntityBlurFX setAlphaFading() {
        this.alphaFade = true;
        return this;
    }

    public final EntityBlurFX setGravity(float g) {
        this.field_70545_g = g;
        return this;
    }

    public final EntityBlurFX setColor(int r, int g, int b) {
        this.field_70552_h = (float)r / 255.0f;
        this.field_70553_i = (float)g / 255.0f;
        this.field_70551_j = (float)b / 255.0f;
        this.defaultRed = this.field_70552_h;
        this.defaultGreen = this.field_70553_i;
        this.defaultBlue = this.field_70551_j;
        return this;
    }

    public final EntityBlurFX setColor(int rgb) {
        return this.setColor(ReikaColorAPI.getRed((int)rgb), ReikaColorAPI.getGreen((int)rgb), ReikaColorAPI.getBlue((int)rgb));
    }

    public final EntityBlurFX fadeColors(int c1, int c2) {
        this.preColor = c1;
        this.fadeColor = c2;
        return this.setColor(c1);
    }

    public final EntityBlurFX bound(AxisAlignedBB box) {
        this.bounds = box;
        return this;
    }

    public final EntityBlurFX setColliding() {
        return this.setColliding(this.field_70146_Z.nextDouble() * 360.0);
    }

    public final EntityBlurFX setColliding(double ang) {
        this.field_70145_X = false;
        this.colliding = true;
        this.collideAngle = ang;
        return this;
    }

    public EntityBlurFX setCyclingColor(float scale) {
        this.cyclescale = scale;
        return this;
    }

    public EntityBlurFX markDestination(int x, int y, int z) {
        this.destination = new Coordinate(x, y, z);
        return this;
    }

    public EntityBlurFX lockTo(EntityFX fx) {
        this.lock = fx;
        if (fx instanceof EntityBlurFX) {
            EntityBlurFX bfx = (EntityBlurFX)fx;
            if (!bfx.getRenderMode().equals(this.getRenderMode())) {
                ChromatiCraft.logger.logError((Object)("Cannot accurately lock two different particle render types: " + fx + " & " + this));
            }
            bfx.locks.add(this);
        }
        return this;
    }

    public EntityBlurFX setBasicBlend() {
        this.additiveBlend = false;
        return this;
    }

    public EntityBlurFX setNoDepthTest() {
        this.depthTest = false;
        return this;
    }

    public EntityBlurFX enableAlphaTest() {
        this.alphaTest = true;
        return this;
    }

    public EntityBlurFX setAge(int age) {
        this.field_70546_d = age;
        return this;
    }

    public EntityBlurFX freezeLife(int ticks) {
        this.lifeFreeze = ticks;
        return this;
    }

    public EntityBlurFX setMotionController(MotionController m) {
        this.motionController = m;
        return this;
    }

    public EntityBlurFX setPositionController(PositionController m) {
        this.positionController = m;
        return this;
    }

    public EntityBlurFX setColorController(ColorController m) {
        this.colorController = m;
        return this;
    }

    public void func_70071_h_() {
        Coordinate c;
        this.field_70173_aa = this.field_70546_d;
        if (this.field_70546_d < 0) {
            return;
        }
        if (this.colliding) {
            if (this.field_70124_G) {
                double v = this.field_70146_Z.nextDouble() * 0.0625;
                this.field_70159_w = v * Math.sin(Math.toRadians(this.collideAngle));
                this.field_70179_y = v * Math.cos(Math.toRadians(this.collideAngle));
                this.colliding = false;
                this.setNoSlowdown();
                this.lifeFreeze = 20;
                this.field_70545_g *= 4.0f;
                this.onCollision();
            }
            if (this.field_70123_F) {
                // empty if block
            }
        }
        if (this.destination != null && (c = new Coordinate((Entity)this)).equals((Object)this.destination)) {
            this.func_70106_y();
        }
        if (this.noSlow) {
            double mx = this.field_70159_w;
            double my = this.field_70181_x;
            double mz = this.field_70179_y;
            super.func_70071_h_();
            this.field_70159_w = mx;
            this.field_70181_x = my;
            this.field_70179_y = mz;
        } else {
            super.func_70071_h_();
        }
        if (this.lifeFreeze > 0) {
            --this.lifeFreeze;
            --this.field_70546_d;
        }
        int age = Math.max(this.field_70546_d, 1);
        if (this.fadeColor != -1) {
            int c2 = ReikaColorAPI.mixColors((int)this.fadeColor, (int)this.preColor, (float)((float)age / (float)this.field_70547_e));
            this.setColor(c2);
        }
        if (this.alphaFade) {
            this.field_70544_f = this.scale;
            float f = 1.0f;
            f = this.rapidExpand ? (this.field_70547_e / age >= 12 ? (float)age * 12.0f / (float)this.field_70547_e : 1.0f - (float)age / (float)this.field_70547_e) : (float)Math.sin(Math.toRadians(180.0 * (double)age / (double)this.field_70547_e));
            if (this.additiveBlend) {
                this.field_70552_h = this.defaultRed * f;
                this.field_70553_i = this.defaultGreen * f;
                this.field_70551_j = this.defaultBlue * f;
            } else {
                this.field_82339_as = f;
            }
        } else {
            this.field_70544_f = this.rapidExpand ? this.scale * (this.field_70547_e / age >= 12 ? (float)age * 12.0f / (float)this.field_70547_e : 1.0f - (float)age / (float)this.field_70547_e) : this.scale * (float)Math.sin(Math.toRadians(180.0 * (double)age / (double)this.field_70547_e));
        }
        if (this.cyclescale > 0.0f) {
            int c3 = CrystalElement.getBlendedColor((int)((float)age * this.cyclescale), 5);
            this.field_70552_h = (float)ReikaColorAPI.getRed((int)c3) / 255.0f;
            this.field_70553_i = (float)ReikaColorAPI.getGreen((int)c3) / 255.0f;
            this.field_70551_j = (float)ReikaColorAPI.getBlue((int)c3) / 255.0f;
        }
        if (this.bounds != null) {
            if (this.field_70165_t <= this.bounds.field_72340_a && this.field_70159_w < 0.0 || this.field_70165_t >= this.bounds.field_72336_d && this.field_70159_w > 0.0) {
                this.field_70159_w = -this.field_70159_w;
            }
            if (this.field_70163_u <= this.bounds.field_72338_b && this.field_70181_x < 0.0 || this.field_70163_u >= this.bounds.field_72337_e && this.field_70181_x > 0.0) {
                this.field_70181_x = -this.field_70181_x;
            }
            if (this.field_70161_v <= this.bounds.field_72339_c && this.field_70179_y < 0.0 || this.field_70161_v >= this.bounds.field_72334_f && this.field_70179_y > 0.0) {
                this.field_70179_y = -this.field_70179_y;
            }
        }
        if (this.lock != null) {
            this.field_70165_t = this.lock.field_70165_t;
            this.field_70163_u = this.lock.field_70163_u;
            this.field_70161_v = this.lock.field_70161_v;
            this.field_70159_w = this.lock.field_70159_w;
            this.field_70181_x = this.lock.field_70181_x;
            this.field_70179_y = this.lock.field_70179_y;
        }
        for (EntityFX fx : this.locks) {
            fx.field_70159_w = this.field_70159_w;
            fx.field_70181_x = this.field_70181_x;
            fx.field_70179_y = this.field_70179_y;
        }
        if (this.motionController != null) {
            this.field_70159_w = this.motionController.getMotionX((Entity)this);
            this.field_70181_x = this.motionController.getMotionY((Entity)this);
            this.field_70179_y = this.motionController.getMotionZ((Entity)this);
            this.motionController.update((Entity)this);
        }
        if (this.positionController != null) {
            this.field_70165_t = this.positionController.getPositionX((Entity)this);
            this.field_70163_u = this.positionController.getPositionY((Entity)this);
            this.field_70161_v = this.positionController.getPositionZ((Entity)this);
            if (this.positionController != this.motionController) {
                this.positionController.update((Entity)this);
            }
        }
        if (this.colorController != null) {
            this.setColor(this.colorController.getColor((Entity)this));
            this.colorController.update((Entity)this);
        }
    }

    protected void onCollision() {
    }

    public int func_70070_b(float par1) {
        return 240;
    }

    public int func_70537_b() {
        return 2;
    }

    @Override
    public ParticleEngine.RenderMode getRenderMode() {
        return new ParticleEngine.RenderMode().setFlag(ParticleEngine.RenderModeFlags.ADDITIVE, this.additiveBlend).setFlag(ParticleEngine.RenderModeFlags.DEPTH, this.depthTest).setFlag(ParticleEngine.RenderModeFlags.LIGHT, false).setFlag(ParticleEngine.RenderModeFlags.ALPHACLIP, this.alphaTest && this.additiveBlend);
    }

    @Override
    public ParticleEngine.TextureMode getTexture() {
        return ParticleEngine.instance.blockTex;
    }
}

