/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.ISBRH;

import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Interfaces.Block.ConnectedTextureGlass;
import Reika.DragonAPI.Interfaces.ISBRH;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SelectiveGlassRenderer
implements ISBRH {
    private static final Random rand = new Random();
    private static final ForgeDirection[] dirs = ForgeDirection.values();
    public static int renderPass = 0;
    private final WeightedRandom<CrystalElement> possibleRunes = new WeightedRandom();
    private long lastRerender = System.currentTimeMillis();

    public SelectiveGlassRenderer() {
        this.possibleRunes.addEntry((Object)CrystalElement.RED, 20.0);
        this.possibleRunes.addEntry((Object)CrystalElement.BLACK, 5.0);
        this.possibleRunes.addEntry((Object)CrystalElement.PINK, 10.0);
        this.possibleRunes.addEntry((Object)CrystalElement.WHITE, 5.0);
        this.possibleRunes.addEntry((Object)CrystalElement.LIME, 2.0);
        this.possibleRunes.addEntry((Object)CrystalElement.LIGHTGRAY, 2.0);
    }

    private IIcon getOverlayIcon(long t, ConnectedTextureGlass b, int meta, ForgeDirection dir, IBlockAccess world, int x, int y, int z, boolean checkTime) {
        if (checkTime && t - this.lastRerender < 4000L) {
            return this.getOverlayIcon(this.lastRerender, b, meta, dir, world, x, y, z, false);
        }
        this.lastRerender = t;
        long seed = t + (long)new Coordinate(x, y, z).hashCode() + (long)(dir.ordinal() << 6);
        rand.setSeed(seed);
        this.possibleRunes.setSeed(seed);
        int r = rand.nextInt(100);
        if (r < 80) {
            return null;
        }
        if (r < 95) {
            Tessellator.field_78398_a.func_78384_a(0xFFFFFF, 255);
            return b.getIconForEdge(world, x, y, z, 5);
        }
        Tessellator.field_78398_a.func_78384_a(0xFFFFFF, 96);
        return ((CrystalElement)((Object)this.possibleRunes.getRandomEntry())).getEngravingRune();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks rb) {
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glPushAttrib((int)1048575);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        v5.func_78382_b();
        v5.func_78378_d(0xFFFFFF);
        v5.func_78380_c(240);
        ConnectedTextureGlass b = (ConnectedTextureGlass)block;
        boolean render5 = b.renderCentralTextureForItem(metadata);
        IIcon ico = b.getIconForEdge(metadata, 0);
        IIcon ico2 = b.getIconForEdge(metadata, 5);
        float u = ico.func_94209_e();
        float du = ico.func_94212_f();
        float v = ico.func_94206_g();
        float dv = ico.func_94210_h();
        float u2 = ico2.func_94209_e();
        float du2 = ico2.func_94212_f();
        float v2 = ico2.func_94206_g();
        float dv2 = ico2.func_94210_h();
        float dx = -0.5f;
        float dy = -0.5f;
        float dz = -0.5f;
        v5.func_78372_c(dx, dy, dz);
        this.setFaceBrightness(v5, ForgeDirection.UP, 1.0f);
        v5.func_78374_a(1.0, 1.0, 0.0, (double)u, (double)v);
        v5.func_78374_a(0.0, 1.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(0.0, 1.0, 1.0, (double)du, (double)dv);
        v5.func_78374_a(1.0, 1.0, 1.0, (double)u, (double)dv);
        if (render5) {
            v5.func_78374_a(1.0, 1.0, 0.0, (double)u2, (double)v2);
            v5.func_78374_a(0.0, 1.0, 0.0, (double)du2, (double)v2);
            v5.func_78374_a(0.0, 1.0, 1.0, (double)du2, (double)dv2);
            v5.func_78374_a(1.0, 1.0, 1.0, (double)u2, (double)dv2);
        }
        this.setFaceBrightness(v5, ForgeDirection.DOWN, 1.0f);
        v5.func_78374_a(0.0, 0.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(1.0, 0.0, 0.0, (double)u, (double)v);
        v5.func_78374_a(1.0, 0.0, 1.0, (double)u, (double)dv);
        v5.func_78374_a(0.0, 0.0, 1.0, (double)du, (double)dv);
        if (render5) {
            v5.func_78374_a(0.0, 0.0, 0.0, (double)du2, (double)v2);
            v5.func_78374_a(1.0, 0.0, 0.0, (double)u2, (double)v2);
            v5.func_78374_a(1.0, 0.0, 1.0, (double)u2, (double)dv2);
            v5.func_78374_a(0.0, 0.0, 1.0, (double)du2, (double)dv2);
        }
        this.setFaceBrightness(v5, ForgeDirection.EAST, 1.0f);
        v5.func_78374_a(1.0, 0.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(1.0, 1.0, 0.0, (double)u, (double)v);
        v5.func_78374_a(1.0, 1.0, 1.0, (double)u, (double)dv);
        v5.func_78374_a(1.0, 0.0, 1.0, (double)du, (double)dv);
        if (render5) {
            v5.func_78374_a(1.0, 0.0, 0.0, (double)du2, (double)v2);
            v5.func_78374_a(1.0, 1.0, 0.0, (double)u2, (double)v2);
            v5.func_78374_a(1.0, 1.0, 1.0, (double)u2, (double)dv2);
            v5.func_78374_a(1.0, 0.0, 1.0, (double)du2, (double)dv2);
        }
        this.setFaceBrightness(v5, ForgeDirection.WEST, 1.0f);
        v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v);
        v5.func_78374_a(0.0, 0.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(0.0, 0.0, 1.0, (double)du, (double)dv);
        v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)dv);
        if (render5) {
            v5.func_78374_a(0.0, 1.0, 0.0, (double)u2, (double)v2);
            v5.func_78374_a(0.0, 0.0, 0.0, (double)du2, (double)v2);
            v5.func_78374_a(0.0, 0.0, 1.0, (double)du2, (double)dv2);
            v5.func_78374_a(0.0, 1.0, 1.0, (double)u2, (double)dv2);
        }
        this.setFaceBrightness(v5, ForgeDirection.SOUTH, 1.0f);
        v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)v);
        v5.func_78374_a(0.0, 0.0, 1.0, (double)du, (double)v);
        v5.func_78374_a(1.0, 0.0, 1.0, (double)du, (double)dv);
        v5.func_78374_a(1.0, 1.0, 1.0, (double)u, (double)dv);
        if (render5) {
            v5.func_78374_a(0.0, 1.0, 1.0, (double)u2, (double)v2);
            v5.func_78374_a(0.0, 0.0, 1.0, (double)du2, (double)v2);
            v5.func_78374_a(1.0, 0.0, 1.0, (double)du2, (double)dv2);
            v5.func_78374_a(1.0, 1.0, 1.0, (double)u2, (double)dv2);
        }
        this.setFaceBrightness(v5, ForgeDirection.NORTH, 1.0f);
        v5.func_78374_a(0.0, 0.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v);
        v5.func_78374_a(1.0, 1.0, 0.0, (double)u, (double)dv);
        v5.func_78374_a(1.0, 0.0, 0.0, (double)du, (double)dv);
        if (render5) {
            v5.func_78374_a(0.0, 0.0, 0.0, (double)du2, (double)v2);
            v5.func_78374_a(0.0, 1.0, 0.0, (double)u2, (double)v2);
            v5.func_78374_a(1.0, 1.0, 0.0, (double)u2, (double)dv2);
            v5.func_78374_a(1.0, 0.0, 0.0, (double)du2, (double)dv2);
        }
        v5.func_78372_c(-dx, -dy, -dz);
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks rb) {
        Tessellator v5 = Tessellator.field_78398_a;
        ConnectedTextureGlass b = (ConnectedTextureGlass)block;
        v5.func_78372_c((float)x, (float)y, (float)z);
        v5.func_78378_d(0xFFFFFF);
        int mix = block.func_149677_c(world, x, y, z);
        v5.func_78380_c(240);
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        float l = Math.max((float)w.func_72972_b(EnumSkyBlock.Block, x, y, z), (float)w.func_72972_b(EnumSkyBlock.Sky, x, y, z) * w.getSunBrightnessFactor(0.0f));
        float a = 1.0f - l / 32.0f;
        if (renderPass == 1) {
            float dv;
            float v;
            IIcon ico;
            float dz;
            float dx;
            float vv;
            float uu;
            float dv2;
            float v2;
            float du;
            float u;
            v5.func_78384_a(0xFF0000, 128);
            ArrayList li = b.getEdgesForFace(world, x, y, z, ForgeDirection.UP);
            this.setFaceBrightness(v5, ForgeDirection.UP, a);
            if (block.func_149646_a(world, x, y, z, ForgeDirection.UP.ordinal())) {
                for (int i = 0; i < li.size(); ++i) {
                    int edge = (Integer)li.get(i);
                    IIcon ico2 = b.getIconForEdge(world, x, y, z, edge);
                    u = ico2.func_94209_e();
                    du = ico2.func_94212_f();
                    v2 = ico2.func_94206_g();
                    dv2 = ico2.func_94210_h();
                    uu = du - u;
                    vv = dv2 - v2;
                    dx = uu / 16.0f;
                    dz = vv / 16.0f;
                    v5.func_78374_a(1.0, 1.0, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(0.0, 1.0, 0.0, (double)du, (double)v2);
                    v5.func_78374_a(0.0, 1.0, 1.0, (double)du, (double)dv2);
                    v5.func_78374_a(1.0, 1.0, 1.0, (double)u, (double)dv2);
                }
                ico = this.getOverlayIcon(System.currentTimeMillis(), b, 0, ForgeDirection.UP, world, x, y, z, true);
                if (ico != null) {
                    float u2 = ico.func_94209_e();
                    float du2 = ico.func_94212_f();
                    v = ico.func_94206_g();
                    dv = ico.func_94210_h();
                    v5.func_78380_c(mix);
                    v5.func_78374_a(1.0, 1.0, 0.0, (double)u2, (double)v);
                    v5.func_78374_a(0.0, 1.0, 0.0, (double)du2, (double)v);
                    v5.func_78374_a(0.0, 1.0, 1.0, (double)du2, (double)dv);
                    v5.func_78374_a(1.0, 1.0, 1.0, (double)u2, (double)dv);
                }
            }
            v5.func_78380_c(240);
            li = b.getEdgesForFace(world, x, y, z, ForgeDirection.DOWN);
            this.setFaceBrightness(v5, ForgeDirection.DOWN, a);
            if (block.func_149646_a(world, x, y, z, ForgeDirection.DOWN.ordinal())) {
                for (int i = 0; i < li.size(); ++i) {
                    int edge = (Integer)li.get(i);
                    IIcon ico3 = b.getIconForEdge(world, x, y, z, edge);
                    u = ico3.func_94209_e();
                    du = ico3.func_94212_f();
                    v2 = ico3.func_94206_g();
                    dv2 = ico3.func_94210_h();
                    uu = du - u;
                    vv = dv2 - v2;
                    dx = uu / 16.0f;
                    dz = vv / 16.0f;
                    v5.func_78374_a(0.0, 0.0, 0.0, (double)du, (double)v2);
                    v5.func_78374_a(1.0, 0.0, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(1.0, 0.0, 1.0, (double)u, (double)dv2);
                    v5.func_78374_a(0.0, 0.0, 1.0, (double)du, (double)dv2);
                }
                ico = this.getOverlayIcon(System.currentTimeMillis(), b, 0, ForgeDirection.DOWN, world, x, y, z, true);
                if (ico != null) {
                    float u3 = ico.func_94209_e();
                    float du3 = ico.func_94212_f();
                    v = ico.func_94206_g();
                    dv = ico.func_94210_h();
                    v5.func_78380_c(mix);
                    v5.func_78374_a(0.0, 0.0, 0.0, (double)du3, (double)v);
                    v5.func_78374_a(1.0, 0.0, 0.0, (double)u3, (double)v);
                    v5.func_78374_a(1.0, 0.0, 1.0, (double)u3, (double)dv);
                    v5.func_78374_a(0.0, 0.0, 1.0, (double)du3, (double)dv);
                }
            }
            v5.func_78380_c(240);
            li = b.getEdgesForFace(world, x, y, z, ForgeDirection.EAST);
            this.setFaceBrightness(v5, ForgeDirection.EAST, a);
            if (block.func_149646_a(world, x, y, z, ForgeDirection.EAST.ordinal())) {
                for (int i = 0; i < li.size(); ++i) {
                    int edge = (Integer)li.get(i);
                    IIcon ico4 = b.getIconForEdge(world, x, y, z, edge);
                    u = ico4.func_94209_e();
                    du = ico4.func_94212_f();
                    v2 = ico4.func_94206_g();
                    dv2 = ico4.func_94210_h();
                    uu = du - u;
                    vv = dv2 - v2;
                    dx = uu / 16.0f;
                    dz = vv / 16.0f;
                    v5.func_78374_a(1.0, 0.0, 0.0, (double)du, (double)v2);
                    v5.func_78374_a(1.0, 1.0, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(1.0, 1.0, 1.0, (double)u, (double)dv2);
                    v5.func_78374_a(1.0, 0.0, 1.0, (double)du, (double)dv2);
                }
                ico = this.getOverlayIcon(System.currentTimeMillis(), b, 0, ForgeDirection.EAST, world, x, y, z, true);
                if (ico != null) {
                    float u4 = ico.func_94209_e();
                    float du4 = ico.func_94212_f();
                    v = ico.func_94206_g();
                    dv = ico.func_94210_h();
                    v5.func_78380_c(mix);
                    v5.func_78374_a(1.0, 0.0, 0.0, (double)du4, (double)dv);
                    v5.func_78374_a(1.0, 1.0, 0.0, (double)du4, (double)v);
                    v5.func_78374_a(1.0, 1.0, 1.0, (double)u4, (double)v);
                    v5.func_78374_a(1.0, 0.0, 1.0, (double)u4, (double)dv);
                }
            }
            v5.func_78380_c(240);
            li = b.getEdgesForFace(world, x, y, z, ForgeDirection.WEST);
            this.setFaceBrightness(v5, ForgeDirection.WEST, a);
            if (block.func_149646_a(world, x, y, z, ForgeDirection.WEST.ordinal())) {
                for (int i = 0; i < li.size(); ++i) {
                    int edge = (Integer)li.get(i);
                    IIcon ico5 = b.getIconForEdge(world, x, y, z, edge);
                    u = ico5.func_94209_e();
                    du = ico5.func_94212_f();
                    v2 = ico5.func_94206_g();
                    dv2 = ico5.func_94210_h();
                    uu = du - u;
                    vv = dv2 - v2;
                    dx = uu / 16.0f;
                    dz = vv / 16.0f;
                    v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(0.0, 0.0, 0.0, (double)du, (double)v2);
                    v5.func_78374_a(0.0, 0.0, 1.0, (double)du, (double)dv2);
                    v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)dv2);
                }
                ico = this.getOverlayIcon(System.currentTimeMillis(), b, 0, ForgeDirection.WEST, world, x, y, z, true);
                if (ico != null) {
                    float u5 = ico.func_94209_e();
                    float du5 = ico.func_94212_f();
                    v = ico.func_94206_g();
                    dv = ico.func_94210_h();
                    v5.func_78380_c(mix);
                    v5.func_78374_a(0.0, 0.0, 1.0, (double)du5, (double)dv);
                    v5.func_78374_a(0.0, 1.0, 1.0, (double)du5, (double)v);
                    v5.func_78374_a(0.0, 1.0, 0.0, (double)u5, (double)v);
                    v5.func_78374_a(0.0, 0.0, 0.0, (double)u5, (double)dv);
                }
            }
            v5.func_78380_c(240);
            li = b.getEdgesForFace(world, x, y, z, ForgeDirection.SOUTH);
            this.setFaceBrightness(v5, ForgeDirection.SOUTH, a);
            if (block.func_149646_a(world, x, y, z, ForgeDirection.SOUTH.ordinal())) {
                for (int i = 0; i < li.size(); ++i) {
                    int edge = (Integer)li.get(i);
                    IIcon ico6 = b.getIconForEdge(world, x, y, z, edge);
                    u = ico6.func_94209_e();
                    du = ico6.func_94212_f();
                    v2 = ico6.func_94206_g();
                    dv2 = ico6.func_94210_h();
                    uu = du - u;
                    vv = dv2 - v2;
                    dx = uu / 16.0f;
                    dz = vv / 16.0f;
                    v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)v2);
                    v5.func_78374_a(0.0, 0.0, 1.0, (double)du, (double)v2);
                    v5.func_78374_a(1.0, 0.0, 1.0, (double)du, (double)dv2);
                    v5.func_78374_a(1.0, 1.0, 1.0, (double)u, (double)dv2);
                }
                ico = this.getOverlayIcon(System.currentTimeMillis(), b, 0, ForgeDirection.SOUTH, world, x, y, z, true);
                if (ico != null) {
                    float u6 = ico.func_94209_e();
                    float du6 = ico.func_94212_f();
                    v = ico.func_94206_g();
                    dv = ico.func_94210_h();
                    v5.func_78380_c(mix);
                    v5.func_78374_a(1.0, 0.0, 1.0, (double)du6, (double)dv);
                    v5.func_78374_a(1.0, 1.0, 1.0, (double)du6, (double)v);
                    v5.func_78374_a(0.0, 1.0, 1.0, (double)u6, (double)v);
                    v5.func_78374_a(0.0, 0.0, 1.0, (double)u6, (double)dv);
                }
            }
            v5.func_78380_c(240);
            li = b.getEdgesForFace(world, x, y, z, ForgeDirection.NORTH);
            this.setFaceBrightness(v5, ForgeDirection.NORTH, a);
            if (block.func_149646_a(world, x, y, z, ForgeDirection.NORTH.ordinal())) {
                for (int i = 0; i < li.size(); ++i) {
                    int edge = (Integer)li.get(i);
                    IIcon ico7 = b.getIconForEdge(world, x, y, z, edge);
                    u = ico7.func_94209_e();
                    du = ico7.func_94212_f();
                    v2 = ico7.func_94206_g();
                    dv2 = ico7.func_94210_h();
                    uu = du - u;
                    vv = dv2 - v2;
                    dx = uu / 16.0f;
                    dz = vv / 16.0f;
                    v5.func_78374_a(0.0, 0.0, 0.0, (double)du, (double)v2);
                    v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(1.0, 1.0, 0.0, (double)u, (double)dv2);
                    v5.func_78374_a(1.0, 0.0, 0.0, (double)du, (double)dv2);
                }
                IIcon ico8 = this.getOverlayIcon(System.currentTimeMillis(), b, 0, ForgeDirection.NORTH, world, x, y, z, true);
                if (ico8 != null) {
                    float u7 = ico8.func_94209_e();
                    float du7 = ico8.func_94212_f();
                    v = ico8.func_94206_g();
                    dv = ico8.func_94210_h();
                    v5.func_78380_c(mix);
                    v5.func_78374_a(1.0, 1.0, 0.0, (double)u7, (double)v);
                    v5.func_78374_a(1.0, 0.0, 0.0, (double)u7, (double)dv);
                    v5.func_78374_a(0.0, 0.0, 0.0, (double)du7, (double)dv);
                    v5.func_78374_a(0.0, 1.0, 0.0, (double)du7, (double)v);
                }
            }
        }
        v5.func_78377_a(0.0, 0.0, 0.0);
        v5.func_78377_a(0.0, 0.0, 0.0);
        v5.func_78377_a(0.0, 0.0, 0.0);
        v5.func_78377_a(0.0, 0.0, 0.0);
        v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    public boolean shouldRender3DInInventory(int model) {
        return true;
    }

    public int getRenderId() {
        return 0;
    }

    private void setFaceBrightness(Tessellator v5, ForgeDirection dir, float a) {
        float f = 1.0f;
        switch (dir) {
            case DOWN: {
                f = 0.4f;
                break;
            }
            case EAST: {
                f = 0.5f;
                break;
            }
            case NORTH: {
                f = 0.65f;
                break;
            }
            case SOUTH: {
                f = 0.65f;
                break;
            }
            case UP: {
                f = 1.0f;
                break;
            }
            case WEST: {
                f = 0.5f;
                break;
            }
        }
        v5.func_78369_a(f, f, f, a);
    }
}

