/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.ISBRH;

import Reika.ChromatiCraft.Auxiliary.Interfaces.CrystalRenderedBlock;
import Reika.ChromatiCraft.ChromaCommon;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Rendering.TessellatorVertexList;
import Reika.DragonAPI.Interfaces.ISBRH;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class CrystalRenderer
implements ISBRH {
    public static int renderPass;
    public static boolean renderAllArmsInInventory;
    public static int staticColor;

    public void renderInventoryBlock(Block b, int meta, int modelID, RenderBlocks rb) {
        Tessellator v5 = Tessellator.field_78398_a;
        int color = ReikaColorAPI.getColorWithBrightnessMultiplier((int)((CrystalRenderedBlock)b).getTintColor(meta), (float)0.8f);
        if (staticColor >= 0) {
            color = staticColor;
        }
        int alpha = 255;
        IIcon ico = b.func_149691_a(0, meta);
        double u = ico.func_94209_e();
        double v = ico.func_94206_g();
        double xu = ico.func_94212_f();
        double xv = ico.func_94210_h();
        int w = ico.func_94211_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 0.8f, 0.0f);
        v5.func_78384_a(color, alpha);
        this.renderSpike(v5, u, v, xu, xv, w);
        v5.func_78381_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 0.5f, 0.0f);
        v5.func_78384_a(color, alpha);
        this.renderXAngledSpike(u, v, xu, xv, 0.1875, w);
        if (renderAllArmsInInventory) {
            this.renderXAngledSpike(u, v, xu, xv, -0.1875, w);
        }
        v5.func_78381_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 0.5f, 0.0f);
        v5.func_78384_a(color, alpha);
        this.renderZAngledSpike(u, v, xu, xv, 0.1875, w);
        if (renderAllArmsInInventory) {
            this.renderZAngledSpike(u, v, xu, xv, -0.1875, w);
        }
        v5.func_78381_a();
        if (((CrystalRenderedBlock)b).renderBase()) {
            v5.func_78382_b();
            v5.func_78384_a(color, alpha);
            v5.func_78381_a();
            v5.func_78382_b();
            v5.func_78384_a(color, alpha);
            v5.func_78381_a();
            v5.func_78382_b();
            v5.func_78384_a(color, alpha);
            this.renderBase(v5, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, 0, 0, 0, (CrystalRenderedBlock)b);
            v5.func_78381_a();
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block b, int modelId, RenderBlocks rb) {
        int meta = world.func_72805_g(x, y, z);
        int color = ((CrystalRenderedBlock)b).getTintColor(meta);
        int alpha = 220;
        IIcon ico = b.func_149691_a(0, meta);
        double u = ico.func_94209_e();
        double v = ico.func_94206_g();
        double xu = ico.func_94212_f();
        double xv = ico.func_94210_h();
        Tessellator v5 = Tessellator.field_78398_a;
        double maxx = b.func_149753_y();
        double minx = b.func_149704_x();
        double miny = b.func_149665_z();
        double maxy = b.func_149669_A();
        double maxz = b.func_149693_C();
        double minz = b.func_149706_B();
        int l = b.func_149677_c(world, x, y, z);
        v5.func_78380_c(240);
        v5.func_78372_c((float)x, (float)y, (float)z);
        v5.func_78384_a(color, alpha);
        int w = ico.func_94211_a();
        if (renderPass == 1) {
            this.renderSpike(v5, u, v, xu, xv, w);
            int val = Math.abs(x) % 9 + Math.abs(z) % 9;
            if (val > 15 || ((CrystalRenderedBlock)b).renderAllArms()) {
                val = 15;
            }
            if ((val & 8) == 8) {
                this.renderXAngledSpike(u, v, xu, xv, 0.1875, w);
            }
            if ((val & 4) == 4) {
                this.renderXAngledSpike(u, v, xu, xv, -0.1875, w);
            }
            if ((val & 2) == 2) {
                this.renderZAngledSpike(u, v, xu, xv, 0.1875, w);
            }
            if ((val & 1) == 1) {
                this.renderZAngledSpike(u, v, xu, xv, -0.1875, w);
            }
            v5.func_78378_d(0xFFFFFF);
            this.renderWater(world, x, y, z, b, meta, v5);
        }
        if (renderPass == 0 && ((CrystalRenderedBlock)b).renderBase()) {
            this.renderBase(v5, world, x, y, z, (CrystalRenderedBlock)b);
        }
        v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    private void renderWater(IBlockAccess world, int x, int y, int z, Block block, int meta, Tessellator v5) {
        Block above = world.func_147439_a(x, y + 1, z);
        if (above != Blocks.field_150355_j && above != Blocks.field_150358_i && (above != block || world.func_72805_g(x, y + 1, z) != meta)) {
            boolean flag = ReikaWorldHelper.hasAdjacentWater((IBlockAccess)world, (int)x, (int)y, (int)z, (boolean)false, (boolean)true);
            if (!flag) {
                for (int i = 2; i < 6 && !flag; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                    int dx = x + dir.offsetX;
                    int dy = y + dir.offsetY;
                    int dz = z + dir.offsetZ;
                    flag = flag || ReikaWorldHelper.hasAdjacentWater((IBlockAccess)world, (int)dx, (int)dy, (int)dz, (boolean)false, (boolean)true);
                }
            }
            if (flag) {
                IIcon ico = FluidRegistry.WATER.getIcon();
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                double h = 0.888;
                v5.func_78374_a(0.0, h, 1.0, (double)u, (double)dv);
                v5.func_78374_a(1.0, h, 1.0, (double)du, (double)dv);
                v5.func_78374_a(1.0, h, 0.0, (double)du, (double)v);
                v5.func_78374_a(0.0, h, 0.0, (double)u, (double)v);
            }
        }
    }

    private void renderBase(Tessellator v5, IBlockAccess world, int x, int y, int z, CrystalRenderedBlock b) {
        BlockKey bk = b.getBaseBlock(world, x, y, z, ForgeDirection.UP);
        IIcon ico = bk.blockID.func_149691_a(0, bk.metadata);
        int w = ico.func_94211_a();
        v5.func_78376_a(255, 255, 255);
        double u = ico.func_94209_e();
        double v = ico.func_94206_g();
        double xu = ico.func_94212_f();
        double xv = ico.func_94210_h();
        double top = 0.125;
        v5.func_78374_a(0.0, top, 1.0, u, xv);
        v5.func_78374_a(1.0, top, 1.0, xu, xv);
        v5.func_78374_a(1.0, top, 0.0, xu, v);
        v5.func_78374_a(0.0, top, 0.0, u, v);
        v5.func_78376_a(110, 110, 110);
        v5.func_78374_a(0.0, 0.0, 0.0, u, v);
        v5.func_78374_a(1.0, 0.0, 0.0, xu, v);
        v5.func_78374_a(1.0, 0.0, 1.0, xu, xv);
        v5.func_78374_a(0.0, 0.0, 1.0, u, xv);
        bk = b.getBaseBlock(world, x, y, z, ForgeDirection.UP);
        ico = bk.blockID.func_149691_a(0, bk.metadata);
        u = ico.func_94209_e();
        v = ico.func_94206_g();
        xu = ico.func_94212_f();
        xv = ico.func_94210_h();
        double vv = v + (xv - v) / (double)w * 2.0;
        v5.func_78376_a(200, 200, 200);
        v5.func_78374_a(0.0, top, 0.0, u, vv);
        v5.func_78374_a(1.0, top, 0.0, xu, vv);
        v5.func_78374_a(1.0, 0.0, 0.0, xu, v);
        v5.func_78374_a(0.0, 0.0, 0.0, u, v);
        v5.func_78376_a(170, 170, 170);
        v5.func_78374_a(0.0, 0.0, 1.0, u, v);
        v5.func_78374_a(1.0, 0.0, 1.0, xu, v);
        v5.func_78374_a(1.0, top, 1.0, xu, vv);
        v5.func_78374_a(0.0, top, 1.0, u, vv);
        v5.func_78376_a(200, 200, 200);
        v5.func_78374_a(0.0, 0.0, 0.0, u, v);
        v5.func_78374_a(0.0, 0.0, 1.0, xu, v);
        v5.func_78374_a(0.0, top, 1.0, xu, vv);
        v5.func_78374_a(0.0, top, 0.0, u, vv);
        v5.func_78376_a(170, 170, 170);
        v5.func_78374_a(1.0, top, 0.0, u, vv);
        v5.func_78374_a(1.0, top, 1.0, xu, vv);
        v5.func_78374_a(1.0, 0.0, 1.0, xu, v);
        v5.func_78374_a(1.0, 0.0, 0.0, u, v);
    }

    private void renderOutline(Tessellator v5) {
        double core = 0.15;
        double vl = 0.8;
        double dd = 0.01;
        double tip = 1.0;
        double zf = 0.4;
        v5.func_78374_a(0.5 + core - dd, 0.0, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core + dd, 0.0, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core + dd, vl, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core - dd, vl, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core - dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core + dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core + dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core - dd, 0.0, 0.0);
        v5.func_78374_a(0.5 - core - dd, 0.0, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core + dd, 0.0, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core + dd, vl, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core - dd, vl, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, 0.0, 0.5 - core - dd, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, 0.0, 0.5 - core + dd, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, vl, 0.5 - core + dd, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, vl, 0.5 - core - dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core - dd, 0.0, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core + dd, 0.0, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core + dd, vl, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core - dd, vl, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core - dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core + dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core + dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core - dd, 0.0, 0.0);
        v5.func_78374_a(0.5 - core - dd, 0.0, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core + dd, 0.0, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core + dd, vl, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core - dd, vl, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core - dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core + dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core + dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core - dd, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, vl, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core, vl + dd, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5, tip + dd, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5, tip, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5 + core - dd * zf, vl, 0.5 + core + dd * zf, 0.0, 0.0);
        v5.func_78374_a(0.5 + core + dd * zf, vl, 0.5 + core - dd * zf, 0.0, 0.0);
        v5.func_78374_a(0.5 + dd * zf, tip, 0.5 - dd * zf, 0.0, 0.0);
        v5.func_78374_a(0.5 - dd * zf, tip, 0.5 + dd * zf, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, vl, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, vl + dd, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5, tip + dd, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5, tip, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5 - core - dd * zf, vl, 0.5 - core + dd * zf, 0.0, 0.0);
        v5.func_78374_a(0.5 - core + dd * zf, vl, 0.5 - core - dd * zf, 0.0, 0.0);
        v5.func_78374_a(0.5 + dd * zf, tip, 0.5 - dd * zf, 0.0, 0.0);
        v5.func_78374_a(0.5 - dd * zf, tip, 0.5 + dd * zf, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, vl, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, vl + dd, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5, tip + dd, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5, tip, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5 + core + dd, vl + dd, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 + core - dd, vl + dd, 0.5 - core, 0.0, 0.0);
        v5.func_78374_a(0.5 - dd, tip + dd, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5 + dd, tip + dd, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, vl, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core, vl + dd, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5, tip + dd, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5, tip, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5 - core + dd, vl + dd, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 - core - dd, vl + dd, 0.5 + core, 0.0, 0.0);
        v5.func_78374_a(0.5 - dd, tip + dd, 0.5, 0.0, 0.0);
        v5.func_78374_a(0.5 + dd, tip + dd, 0.5, 0.0, 0.0);
    }

    private void renderSpike(Tessellator v5, double u, double v, double xu, double xv, int w) {
        double core = 0.15;
        double vl = 0.8;
        v5.func_78374_a(0.5 - core, vl, 0.5 - core, u, v);
        v5.func_78374_a(0.5 - core, vl, 0.5 + core, xu, v);
        v5.func_78374_a(0.5, 1.0, 0.5, xu, xv);
        v5.func_78374_a(0.5, 1.0, 0.5, xu, xv);
        v5.func_78374_a(0.5 - core, vl, 0.5 + core, u, v);
        v5.func_78374_a(0.5 + core, vl, 0.5 + core, xu, v);
        v5.func_78374_a(0.5, 1.0, 0.5, xu, xv);
        v5.func_78374_a(0.5, 1.0, 0.5, xu, xv);
        v5.func_78374_a(0.5, 1.0, 0.5, u, xv);
        v5.func_78374_a(0.5, 1.0, 0.5, xu, xv);
        v5.func_78374_a(0.5 + core, vl, 0.5 + core, xu, v);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core, u, v);
        v5.func_78374_a(0.5, 1.0, 0.5, u, xv);
        v5.func_78374_a(0.5, 1.0, 0.5, xu, xv);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core, xu, v);
        v5.func_78374_a(0.5 - core, vl, 0.5 - core, u, v);
        xv -= (xv - v) / (double)w;
        v += (xv - v) / ((double)w * 1.2);
        u += (xu - u) / (double)(w * 2);
        xu -= (xu - u) / (double)(w * 2);
        v5.func_78374_a(0.5 - core, vl, 0.5 - core, u, xv);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core, xu, xv);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core, xu, v);
        v5.func_78374_a(0.5 - core, 0.0, 0.5 - core, u, v);
        v5.func_78374_a(0.5 - core, 0.0, 0.5 + core, u, v);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 + core, xu, v);
        v5.func_78374_a(0.5 + core, vl, 0.5 + core, xu, xv);
        v5.func_78374_a(0.5 - core, vl, 0.5 + core, u, xv);
        v5.func_78374_a(0.5 + core, vl, 0.5 - core, u, xv);
        v5.func_78374_a(0.5 + core, vl, 0.5 + core, xu, xv);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 + core, xu, v);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core, u, v);
        v5.func_78374_a(0.5 - core, 0.0, 0.5 - core, u, v);
        v5.func_78374_a(0.5 - core, 0.0, 0.5 + core, xu, v);
        v5.func_78374_a(0.5 - core, vl, 0.5 + core, xu, xv);
        v5.func_78374_a(0.5 - core, vl, 0.5 - core, u, xv);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 - core, u, xv);
        v5.func_78374_a(0.5 + core, 0.0, 0.5 + core, xu, xv);
        v5.func_78374_a(0.5 - core, 0.0, 0.5 + core, xu, v);
        v5.func_78374_a(0.5 - core, 0.0, 0.5 - core, u, v);
    }

    private void renderXAngledSpike(double u, double v, double xu, double xv, double out, int w) {
        double core = 0.12;
        double vl = 0.55;
        double dvl = vl / 6.0;
        double dy = -0.05;
        double tout = out;
        double htip = 0.1;
        int dir = out > 0.0 ? 1 : -1;
        TessellatorVertexList v5 = new TessellatorVertexList();
        v5.addVertexWithUV(0.5 + core * (double)dir + out, dy + vl + dvl, 0.5 + core, u, v);
        v5.addVertexWithUV(0.5 + core * (double)dir + out, dy + vl + dvl, 0.5 - core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir + out + tout, dy + vl + dvl + htip, 0.5, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir + out + tout, dy + vl + dvl + htip, 0.5, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir + out + tout, dy + vl + dvl + htip, 0.5, u, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir + out + tout, dy + vl + dvl + htip, 0.5, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0 + out, dy + vl, 0.5 - core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0 + out, dy + vl, 0.5 + core, u, v);
        v5.addVertexWithUV(0.5 + core * (double)dir + out + tout, dy + vl + dvl + htip, 0.5, u, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir + out + tout, dy + vl + dvl + htip, 0.5, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0 + out, dy + vl, 0.5 + core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir + out, dy + vl + dvl, 0.5 + core, u, v);
        v5.addVertexWithUV(0.5 + core * (double)dir + out, dy + vl + dvl, 0.5 - core, u, v);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0 + out, dy + vl, 0.5 - core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir + out + tout, dy + vl + dvl + htip, 0.5, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir + out + tout, dy + vl + dvl + htip, 0.5, xu, xv);
        xv -= (xv - v) / (double)w;
        v += (xv - v) / ((double)w * 1.2);
        u += (xu - u) / (double)(w * 2);
        xu -= (xu - u) / (double)(w * 2);
        v5.addVertexWithUV(0.5 + core * (double)dir, dy + dvl, 0.5 - core, u, v);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0, dy + 0.0, 0.5 - core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0 + out, dy + vl, 0.5 - core, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir + out, dy + vl + dvl, 0.5 - core, u, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir + out, dy + vl + dvl, 0.5 + core, u, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0 + out, dy + vl, 0.5 + core, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0, dy + 0.0, 0.5 + core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir, dy + dvl, 0.5 + core, u, v);
        v5.addVertexWithUV(0.5 + core * (double)dir + out, dy + vl + dvl, 0.5 - core, u, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir + out, dy + vl + dvl, 0.5 + core, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir, dy + dvl, 0.5 + core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir, dy + dvl, 0.5 - core, u, v);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0, dy, 0.5 - core, u, v);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0, dy, 0.5 + core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0 + out, dy + vl, 0.5 + core, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0 + out, dy + vl, 0.5 - core, u, xv);
        v5.addVertexWithUV(0.5 - core * (double)dir * 3.0 + out * 2.56, dy + dvl, 0.5 - core, u, xv);
        v5.addVertexWithUV(0.5 - core * (double)dir * 3.0 + out * 2.56, dy + dvl, 0.5 + core, xu, xv);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0, dy, 0.5 + core, xu, v);
        v5.addVertexWithUV(0.5 + core * (double)dir * 3.0, dy, 0.5 - core, u, v);
        if (out > 0.0) {
            v5.reverse();
        }
        v5.render();
    }

    private void renderZAngledSpike(double u, double v, double xu, double xv, double out, int w) {
        double core = 0.12;
        double vl = 0.55;
        double dvl = vl / 6.0;
        double dy = -0.1;
        double tout = out;
        double htip = 0.1;
        int dir = out > 0.0 ? 1 : -1;
        TessellatorVertexList v5 = new TessellatorVertexList();
        v5.addVertexWithUV(0.5 + core, dy + vl + dvl, 0.5 + core * (double)dir + out, u, v);
        v5.addVertexWithUV(0.5 - core, dy + vl + dvl, 0.5 + core * (double)dir + out, xu, v);
        v5.addVertexWithUV(0.5, dy + vl + dvl + htip, 0.5 + core * (double)dir + out + tout, xu, xv);
        v5.addVertexWithUV(0.5, dy + vl + dvl + htip, 0.5 + core * (double)dir + out + tout, u, xv);
        v5.addVertexWithUV(0.5, dy + vl + dvl + htip, 0.5 + core * (double)dir + out + tout, xu, xv);
        v5.addVertexWithUV(0.5, dy + vl + dvl + htip, 0.5 + core * (double)dir + out + tout, xu, xv);
        v5.addVertexWithUV(0.5 - core, dy + vl, 0.5 + core * (double)dir * 3.0 + out, xu, v);
        v5.addVertexWithUV(0.5 + core, dy + vl, 0.5 + core * (double)dir * 3.0 + out, u, v);
        v5.addVertexWithUV(0.5, dy + vl + dvl + htip, 0.5 + core * (double)dir + out + tout, xu, xv);
        v5.addVertexWithUV(0.5, dy + vl + dvl + htip, 0.5 + core * (double)dir + out + tout, xu, xv);
        v5.addVertexWithUV(0.5 + core, dy + vl, 0.5 + core * (double)dir * 3.0 + out, xu, v);
        v5.addVertexWithUV(0.5 + core, dy + vl + dvl, 0.5 + core * (double)dir + out, u, v);
        v5.addVertexWithUV(0.5 - core, dy + vl + dvl, 0.5 + core * (double)dir + out, u, v);
        v5.addVertexWithUV(0.5 - core, dy + vl, 0.5 + core * (double)dir * 3.0 + out, xu, v);
        v5.addVertexWithUV(0.5, dy + vl + dvl + htip, 0.5 + core * (double)dir + out + tout, xu, xv);
        v5.addVertexWithUV(0.5, dy + vl + dvl + htip, 0.5 + core * (double)dir + out + tout, u, xv);
        xv -= (xv - v) / (double)w;
        v += (xv - v) / ((double)w * 1.2);
        u += (xu - u) / (double)(w * 2);
        xu -= (xu - u) / (double)(w * 2);
        v5.addVertexWithUV(0.5 - core, dy + dvl, 0.5 + core * (double)dir, u, v);
        v5.addVertexWithUV(0.5 - core, dy + 0.0, 0.5 + core * (double)dir * 3.0, xu, v);
        v5.addVertexWithUV(0.5 - core, dy + vl, 0.5 + core * (double)dir * 3.0 + out, xu, xv);
        v5.addVertexWithUV(0.5 - core, dy + vl + dvl, 0.5 + core * (double)dir + out, u, xv);
        v5.addVertexWithUV(0.5 + core, dy + vl + dvl, 0.5 + core * (double)dir + out, u, xv);
        v5.addVertexWithUV(0.5 + core, dy + vl, 0.5 + core * (double)dir * 3.0 + out, xu, xv);
        v5.addVertexWithUV(0.5 + core, dy + 0.0, 0.5 + core * (double)dir * 3.0, xu, v);
        v5.addVertexWithUV(0.5 + core, dy + dvl, 0.5 + core * (double)dir, u, v);
        v5.addVertexWithUV(0.5 - core, dy + vl + dvl, 0.5 + core * (double)dir + out, u, xv);
        v5.addVertexWithUV(0.5 + core, dy + vl + dvl, 0.5 + core * (double)dir + out, xu, xv);
        v5.addVertexWithUV(0.5 + core, dy + dvl, 0.5 + core * (double)dir, xu, v);
        v5.addVertexWithUV(0.5 - core, dy + dvl, 0.5 + core * (double)dir, u, v);
        v5.addVertexWithUV(0.5 - core, dy, 0.5 + core * (double)dir * 3.0, u, v);
        v5.addVertexWithUV(0.5 + core, dy, 0.5 + core * (double)dir * 3.0, xu, v);
        v5.addVertexWithUV(0.5 + core, dy + vl, 0.5 + core * (double)dir * 3.0 + out, xu, xv);
        v5.addVertexWithUV(0.5 - core, dy + vl, 0.5 + core * (double)dir * 3.0 + out, u, xv);
        v5.addVertexWithUV(0.5 - core, dy + dvl + 0.0025, 0.5 - core * (double)dir * 3.0 + out * 2.56, u, xv);
        v5.addVertexWithUV(0.5 + core, dy + dvl + 0.0025, 0.5 - core * (double)dir * 3.0 + out * 2.56, xu, xv);
        v5.addVertexWithUV(0.5 + core, dy, 0.5 + core * (double)dir * 3.0, xu, v);
        v5.addVertexWithUV(0.5 - core, dy, 0.5 + core * (double)dir * 3.0, u, v);
        if (out < 0.0) {
            v5.reverse();
        }
        v5.render();
    }

    public boolean shouldRender3DInInventory(int model) {
        return true;
    }

    public int getRenderId() {
        return ChromaCommon.crystalRender;
    }

    static {
        renderAllArmsInInventory = false;
        staticColor = -1;
    }
}

