/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.ISBRH;

import Reika.ChromatiCraft.ChromaCommon;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Rendering.TessellatorVertexList;
import Reika.DragonAPI.Interfaces.ISBRH;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class ArtefactRenderer
implements ISBRH {
    private final Random rand = new Random();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks rb) {
        this.rand.setSeed(this.calcSeed(x, y, z));
        Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z));
        this.renderDirtChunks(world, x, y, z, rb);
        this.renderArtefactSimple(world, x, y, z, block);
        return true;
    }

    private void renderArtefactSimple(IBlockAccess world, int x, int y, int z, Block b) {
        Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
        double ang1 = 30.0 + this.rand.nextDouble() * 120.0;
        double ang2 = -45.0 + this.rand.nextDouble() * 90.0;
        double ang3 = this.rand.nextDouble() * 360.0;
        TessellatorVertexList tv5 = new TessellatorVertexList(0.0, 0.0, 0.0);
        ReikaRenderHelper.renderIconIn3D((TessellatorVertexList)tv5, (IIcon)b.func_149691_a(0, 0), (int)x, (int)y, (int)z);
        tv5.rotateNonOrthogonal(ang1, ang2, ang3);
        tv5.center();
        tv5.offset((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        tv5.render();
    }

    private void renderArtefact(IBlockAccess world, int x, int y, int z, Block b) {
        int i;
        double fv;
        double fu;
        double dz;
        double dx;
        Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
        double ang1 = this.rand.nextDouble() * 360.0;
        double ang2 = this.rand.nextDouble() * 360.0;
        double ang3 = this.rand.nextDouble() * 360.0;
        IIcon ico = b.func_149691_a(0, 0);
        double u = ico.func_94209_e();
        double v = ico.func_94206_g();
        double du = ico.func_94212_f();
        double dv = ico.func_94210_h();
        double uu = du - u;
        double vv = dv - v;
        ArrayList<TessellatorVertexList.TessellatorVertex> li = new ArrayList<TessellatorVertexList.TessellatorVertex>();
        for (int i2 = 0; i2 < 4; ++i2) {
            double x1 = 0.375;
            double x2 = 0.5625;
            double x3 = 0.5625;
            double x4 = 0.375;
            double y1 = 0.0;
            double y2 = 0.0625;
            double y3 = 0.3125;
            double y4 = 0.5;
            li.add(new TessellatorVertexList.TessellatorVertex(x4, 0.0, y4));
            li.add(new TessellatorVertexList.TessellatorVertex(x3, 0.0, y3));
            li.add(new TessellatorVertexList.TessellatorVertex(x2, 0.0, y2));
            li.add(new TessellatorVertexList.TessellatorVertex(x1, 0.0, y1));
            x1 = 0.75;
            x2 = 0.875;
            x3 = 0.6875;
            x4 = 0.4375;
            y1 = 0.0625;
            y2 = 0.25;
            y3 = 0.4375;
            y4 = 0.375;
            li.add(new TessellatorVertexList.TessellatorVertex(x4, 0.0, y4));
            li.add(new TessellatorVertexList.TessellatorVertex(x3, 0.0, y3));
            li.add(new TessellatorVertexList.TessellatorVertex(x2, 0.0, y2));
            li.add(new TessellatorVertexList.TessellatorVertex(x1, 0.0, y1));
            for (TessellatorVertexList.TessellatorVertex vtx : li) {
                vtx.rotate(0.0, 90.0, 0.0, 0.5, 0.5, 0.5);
            }
        }
        double t = 0.0625;
        TessellatorVertexList tv5 = new TessellatorVertexList((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        for (TessellatorVertexList.TessellatorVertex vtx : li) {
            dx = vtx.x();
            dz = vtx.z();
            fu = u + uu * dx;
            fv = v + vv * dz;
            tv5.addVertexWithUVColor((double)x + dx, (double)y + 0.5 + t, (double)z + dz, fu, fv, -1);
        }
        for (i = li.size() - 1; i >= 0; --i) {
            TessellatorVertexList.TessellatorVertex vtx;
            vtx = (TessellatorVertexList.TessellatorVertex)li.get(i);
            dx = vtx.x();
            dz = vtx.z();
            fu = u + uu * dx;
            fv = v + vv * dz;
            tv5.addVertexWithUVColor((double)x + dx, (double)y + 0.5 - t, (double)z + dz, fu, fv, -6250336);
        }
        for (i = 0; i < li.size(); ++i) {
            TessellatorVertexList.TessellatorVertex vtx1 = (TessellatorVertexList.TessellatorVertex)li.get(i);
            TessellatorVertexList.TessellatorVertex vtx2 = i % 4 != 3 ? (TessellatorVertexList.TessellatorVertex)li.get(i + 1) : (TessellatorVertexList.TessellatorVertex)li.get(i - i % 4);
            double dx1 = vtx1.x();
            double dz1 = vtx1.z();
            double fu1 = u + uu * dx1;
            double fv1 = v + vv * dz1;
            double dx2 = vtx2.x();
            double dz2 = vtx2.z();
            double fu2 = u + uu * dx2;
            double fv2 = v + vv * dz2;
            tv5.addVertexWithUVColor((double)x + dx2, (double)y + 0.5 - t, (double)z + dz2, fu2, fv2, -3487030);
            tv5.addVertexWithUVColor((double)x + dx2, (double)y + 0.5 + t, (double)z + dz2, fu2, fv2, -3487030);
            tv5.addVertexWithUVColor((double)x + dx1, (double)y + 0.5 + t, (double)z + dz1, fu1, fv1, -3487030);
            tv5.addVertexWithUVColor((double)x + dx1, (double)y + 0.5 - t, (double)z + dz1, fu1, fv1, -3487030);
        }
        tv5.rotateNonOrthogonal(ang1, ang2, ang3);
        tv5.render();
    }

    private long calcSeed(int x, int y, int z) {
        return Minecraft.func_71410_x().field_71441_e.func_72905_C() ^ (long)new Coordinate(x, y, z).hashCode();
    }

    private void renderDirtChunks(IBlockAccess world, int x, int y, int z, RenderBlocks rb) {
        int n = 6 + this.rand.nextInt(7);
        for (int i = 0; i < n; ++i) {
            int s = 4 + this.rand.nextInt(5);
            int dx = this.rand.nextInt(16 - s + 1);
            int dy = this.rand.nextInt(Math.max(8 - s, 0) + 1);
            int dz = this.rand.nextInt(16 - s + 1);
            ReikaRenderHelper.renderBlockSubCube((int)x, (int)y, (int)z, (double)dx, (double)dy, (double)dz, (double)s, (Tessellator)Tessellator.field_78398_a, (RenderBlocks)rb, (Block)Blocks.field_150346_d, (int)0);
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ChromaCommon.artefactRender;
    }
}

