/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GlowKnot {
    private static final Random rand = new Random();
    private final Spline spline;
    public final int density;
    public final double size;

    public GlowKnot(double size) {
        this.density = 48;
        this.size = size;
        this.spline = new Spline(Spline.SplineType.CENTRIPETAL);
        for (int i = 0; i < this.density; ++i) {
            double phi = rand.nextDouble() * 360.0;
            double theta = rand.nextDouble() * 360.0;
            this.spline.addPoint((Spline.SplineAnchor)new KnotPoint(size, phi, theta, size));
        }
    }

    public void render(double x, double y, double z, int color, boolean inworld) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        Tessellator v5 = Tessellator.field_78398_a;
        this.spline.render(v5, 0.5, 0.5, 0.5, color, inworld, true, 32, 1.0f, ReikaGLHelper.BlendMode.DEFAULT);
        IIcon ico = ChromaIcons.FADE.getIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        ReikaTextureHelper.bindTerrainTexture();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        if (inworld) {
            RenderManager rm = RenderManager.field_78727_a;
            double dx = x - RenderManager.field_78725_b;
            double dy = y - RenderManager.field_78726_c;
            double dz = z - RenderManager.field_78723_d;
            double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)dx, (double)dy, (double)dz);
            GL11.glRotated((double)angs[2], (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 - angs[1]), (double)1.0, (double)0.0, (double)0.0);
        }
        double d = 1.25;
        double pz = 0.05;
        v5.func_78382_b();
        int a = 160;
        v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)color, (float)((float)a / 255.0f)), a);
        v5.func_78374_a(-d, -d, pz, (double)u, (double)v);
        v5.func_78374_a(d, -d, pz, (double)du, (double)v);
        v5.func_78374_a(d, d, pz, (double)du, (double)dv);
        v5.func_78374_a(-d, d, pz, (double)u, (double)dv);
        v5.func_78381_a();
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    public void update() {
        this.spline.update();
    }

    private static class KnotPoint
    implements Spline.SplineAnchor {
        private double radius;
        private double theta;
        private double phi;
        public final double maxSize;
        private double targetRadius;
        private double targetTheta;
        private double targetPhi;

        private KnotPoint(double r, double t, double p, double size) {
            this.radius = r;
            this.theta = t;
            this.phi = p;
            this.maxSize = size;
            this.pickNewTarget();
        }

        public DecimalPosition asPosition() {
            double[] dat = ReikaPhysicsHelper.polarToCartesian((double)this.radius, (double)this.theta, (double)this.phi);
            return new DecimalPosition(dat[0], dat[1], dat[2]);
        }

        public void update() {
            double dr = this.targetRadius - this.radius;
            double dt = this.targetTheta - this.theta;
            double dp = this.targetPhi - this.phi;
            if (this.atTarget(dr, dt, dp)) {
                this.pickNewTarget();
            }
            this.move(dr, dt, dp);
        }

        private void move(double dr, double dt, double dp) {
            if (Math.abs(dr) >= 0.05) {
                this.radius += 0.025 * Math.signum(dr);
            }
            if (Math.abs(dt) >= 1.0) {
                this.theta += 0.25 * Math.signum(dt);
            }
            if (Math.abs(dp) >= 1.0) {
                this.phi += 0.25 * Math.signum(dp);
            }
        }

        private boolean atTarget(double dr, double dt, double dp) {
            return Math.abs(dr) < 0.05 && Math.abs(dt) < 1.0 && Math.abs(dp) < 1.0;
        }

        private void pickNewTarget() {
            this.targetRadius = ReikaRandomHelper.getRandomPlusMinus((double)this.maxSize, (double)(this.maxSize / 16.0));
            this.targetTheta = rand.nextDouble() * 360.0;
            this.targetPhi = rand.nextDouble() * 360.0;
        }
    }
}

