/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.Instantiable.Math.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class CliffFogRenderer_Noise {
    public static final CliffFogRenderer_Noise instance = new CliffFogRenderer_Noise();
    private static final int RESOLUTION = 8;
    private static final int HEIGHTVAR = 15;
    private static final int BLOCKSIZE = 8;
    private static final int MINHEIGHT = 4;
    private static final int MAXHEIGHT = 12;
    private final SimplexNoiseGenerator cloudNoiseA = new SimplexNoiseGenerator(System.currentTimeMillis()).addOctave(2.0, 0.5).addOctave(4.0, 0.125).addOctave(8.0, 0.125).setFrequency(0.3333333333333333);
    private final SimplexNoiseGenerator cloudNoiseB = new SimplexNoiseGenerator(System.currentTimeMillis() * 2L).addOctave(2.0, 0.5).addOctave(4.0, 0.125).addOctave(8.0, 0.125).setFrequency(0.3333333333333333);
    private final SimplexNoiseGenerator cloudHeight = new SimplexNoiseGenerator(-System.currentTimeMillis()).addOctave(2.0, 0.25).setFrequency(0.1);
    private final SimplexNoiseGenerator cloudThickness = new SimplexNoiseGenerator(System.currentTimeMillis() ^ 0xFFFFFFFFFFFFFFFFL).setFrequency(0.6666666666666666);
    private CloudVertex[][] clouds;
    private final ArrayList<Integer> layers = new ArrayList();

    private CliffFogRenderer_Noise() {
        this.layers.add(80);
        this.layers.add(102);
        this.layers.add(144);
        this.layers.add(192);
        this.layers.add(240);
        this.cloudNoiseA.clampEdge = true;
        this.cloudNoiseB.clampEdge = true;
    }

    public void initialize() {
        int i;
        int size = this.getArraySize();
        float[][] cloudData = new float[size][size];
        float[][] heightData = new float[size][size];
        float[][] thickData = new float[size][size];
        this.clouds = new CloudVertex[size][size];
        for (i = 0; i < size; ++i) {
            for (int k = 0; k < size; ++k) {
                float f = (float)(Math.max(0.0, this.cloudNoiseA.getValue((double)i, (double)k)) * Math.max(0.0, this.cloudNoiseB.getValue((double)i, (double)k)));
                cloudData[i][k] = f > 0.0f ? f : 0.0f;
                heightData[i][k] = (float)(this.cloudHeight.getValue((double)i, (double)k) * 15.0);
                thickData[i][k] = f > 0.0f ? (float)((double)f * ReikaMathLibrary.normalizeToBounds((double)this.cloudThickness.getValue((double)i, (double)k), (double)4.0, (double)12.0)) : 0.0f;
            }
        }
        for (i = 0; i < size; ++i) {
            float f1 = cloudData[0][i];
            float f2 = cloudData[size - 1][i];
            if (f1 > 0.0f || f2 > 0.0f) {
                cloudData[0][i] = f1 * 0.67f + f2 * 0.33f;
                cloudData[size - 1][i] = f2 * 0.67f + f1 * 0.33f;
                f1 = heightData[0][i];
                f2 = heightData[size - 1][i];
                heightData[0][i] = f1 * 0.5f + f2 * 0.5f;
                heightData[size - 1][i] = f2 * 0.5f + f1 * 0.5f;
                f1 = thickData[0][i];
                f2 = thickData[size - 1][i];
                thickData[0][i] = f1 * 0.5f + f2 * 0.5f;
                thickData[size - 1][i] = f2 * 0.5f + f1 * 0.5f;
            }
            f1 = cloudData[i][0];
            f2 = cloudData[i][size - 1];
            if (!(f1 > 0.0f) && !(f2 > 0.0f)) continue;
            cloudData[i][0] = f1 * 0.67f + f2 * 0.33f;
            cloudData[i][size - 1] = f2 * 0.67f + f1 * 0.33f;
            f1 = heightData[i][0];
            f2 = heightData[i][size - 1];
            heightData[i][0] = f1 * 0.5f + f2 * 0.5f;
            heightData[i][size - 1] = f2 * 0.5f + f1 * 0.5f;
            f1 = thickData[i][0];
            f2 = thickData[i][size - 1];
            thickData[i][0] = f1 * 0.5f + f2 * 0.5f;
            thickData[i][size - 1] = f2 * 0.5f + f1 * 0.5f;
        }
        for (i = 0; i < size; ++i) {
            for (int k = 0; k < size; ++k) {
                this.clouds[i][k] = new CloudVertex(i - size / 2, k - size / 2, heightData[i][k], cloudData[i][k], thickData[i][k]);
            }
        }
    }

    private int getArraySize() {
        return 32;
    }

    public void render() {
        if (MinecraftForgeClient.getRenderPass() != 1) {
            return;
        }
        float f = ReikaRenderHelper.getPartialTickTime();
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        double x = ep.field_70165_t + (ep.field_70165_t - ep.field_70142_S) * (double)f;
        double y = ep.field_70163_u + (ep.field_70163_u - ep.field_70137_T) * (double)f;
        double z = ep.field_70161_v + (ep.field_70161_v - ep.field_70136_U) * (double)f;
        int px = MathHelper.func_76128_c((double)x);
        int py = MathHelper.func_76128_c((double)y);
        int pz = MathHelper.func_76128_c((double)z);
        BiomeGenBase b = ep.field_70170_p.func_72807_a(px, pz);
        if (!BiomeGlowingCliffs.isGlowingCliffs(b)) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDisable((int)2896);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glDepthMask((boolean)false);
        GL11.glShadeModel((int)7425);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
        int ox = ReikaMathLibrary.roundDownToX((int)256, (int)px);
        int oz = ReikaMathLibrary.roundDownToX((int)256, (int)pz);
        int x2 = px - ox > 128 ? ox + 256 : ox - 256;
        int z2 = pz - oz > 128 ? oz + 256 : oz - 256;
        this.renderRegion(Tessellator.field_78398_a, ox, oz);
        this.renderRegion(Tessellator.field_78398_a, x2, oz);
        this.renderRegion(Tessellator.field_78398_a, ox, z2);
        this.renderRegion(Tessellator.field_78398_a, x2, z2);
        ReikaRenderHelper.enableEntityLighting();
        GL11.glShadeModel((int)7424);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderRegion(Tessellator v5, int x, int z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)0.0, (double)z);
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78380_c(240);
        for (int layer : this.layers) {
            this.renderLayer(layer, v5);
        }
        v5.func_78381_a();
        GL11.glPopMatrix();
    }

    private void renderLayer(int layer, Tessellator v5) {
        double a = (double)System.currentTimeMillis() * (1.0 + (double)layer / 192.0) / 90000.0 % (Math.PI * 2) + (double)layer / 80.0;
        double ax = (double)this.clouds.length * 0.5 * Math.cos(a);
        double az = (double)this.clouds.length * 0.5 * Math.sin(a);
        v5.func_78372_c((float)ax, 0.0f, (float)az);
        for (int i = 0; i < this.clouds.length; ++i) {
            for (int k = 0; k < this.clouds.length; ++k) {
                this.renderVertex(v5, 0.0, layer, 0.0, i, k);
            }
        }
        v5.func_78372_c(-((float)ax), 0.0f, -((float)az));
    }

    private void renderVertex(Tessellator v5, double x, double y, double z, int i, int k) {
        int pi = i == this.clouds.length - 1 ? 0 : i + 1;
        int pk = k == this.clouds.length - 1 ? 0 : k + 1;
        CloudVertex c7 = this.clouds[i][k];
        CloudVertex c9 = this.clouds[pi][k];
        CloudVertex c1 = this.clouds[i][pk];
        CloudVertex c3 = this.clouds[pi][pk];
        if (c7.value == 0.0f && c9.value == 0.0f && c1.value == 0.0f && c3.value == 0.0f) {
            return;
        }
        v5.func_78378_d(c7.value > 0.0f ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)c7.value) : 0);
        v5.func_78377_a(x + this.offset(i), y + (double)c7.heightOffset - (double)(c7.value * c7.thickness), z + this.offset(k));
        v5.func_78378_d(c9.value > 0.0f ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)c9.value) : 0);
        v5.func_78377_a(x + this.offset(pi == 0 ? this.clouds.length : pi), y + (double)c9.heightOffset - (double)(c9.value * c9.thickness), z + this.offset(k));
        v5.func_78378_d(c3.value > 0.0f ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)c3.value) : 0);
        v5.func_78377_a(x + this.offset(pi == 0 ? this.clouds.length : pi), y + (double)c3.heightOffset - (double)(c3.value * c3.thickness), z + this.offset(pk == 0 ? this.clouds.length : pk));
        v5.func_78378_d(c1.value > 0.0f ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)c1.value) : 0);
        v5.func_78377_a(x + this.offset(i), y + (double)c1.heightOffset - (double)(c1.value * c1.thickness), z + this.offset(pk == 0 ? this.clouds.length : pk));
        v5.func_78378_d(c1.value > 0.0f ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)c1.value) : 0);
        v5.func_78377_a(x + this.offset(i), y + (double)c1.heightOffset + (double)(c1.value * c1.thickness), z + this.offset(pk == 0 ? this.clouds.length : pk));
        v5.func_78378_d(c3.value > 0.0f ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)c3.value) : 0);
        v5.func_78377_a(x + this.offset(pi == 0 ? this.clouds.length : pi), y + (double)c3.heightOffset + (double)(c3.value * c3.thickness), z + this.offset(pk == 0 ? this.clouds.length : pk));
        v5.func_78378_d(c9.value > 0.0f ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)c9.value) : 0);
        v5.func_78377_a(x + this.offset(pi == 0 ? this.clouds.length : pi), y + (double)c9.heightOffset + (double)(c9.value * c9.thickness), z + this.offset(k));
        v5.func_78378_d(c7.value > 0.0f ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)c7.value) : 0);
        v5.func_78377_a(x + this.offset(i), y + (double)c7.heightOffset + (double)(c7.value * c7.thickness), z + this.offset(k));
    }

    private double offset(int a) {
        return a * 8;
    }

    private static class CloudVertex {
        private final int relPosX;
        private final int relPosZ;
        private final float value;
        private final float heightOffset;
        private final float thickness;

        private CloudVertex(int x, int z, float dy, float v, float t) {
            this.relPosX = x;
            this.relPosZ = z;
            this.value = v;
            this.heightOffset = dy;
            this.thickness = t;
        }
    }
}

