/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class CliffFogRenderer {
    public static final CliffFogRenderer instance = new CliffFogRenderer();
    private static final int CLOUD_COUNT = 48;
    private final ArrayList<Cloud> clouds = new ArrayList();
    private final Random rand = new Random();

    private CliffFogRenderer() {
    }

    public void render() {
        Cloud c;
        if (MinecraftForgeClient.getRenderPass() != 1) {
            return;
        }
        float f = ReikaRenderHelper.getPartialTickTime();
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        double x = ep.field_70165_t + (ep.field_70165_t - ep.field_70142_S) * (double)f;
        double y = ep.field_70163_u + (ep.field_70163_u - ep.field_70137_T) * (double)f;
        double z = ep.field_70161_v + (ep.field_70161_v - ep.field_70136_U) * (double)f;
        int px = MathHelper.func_76128_c((double)x);
        int py = MathHelper.func_76128_c((double)y);
        int pz = MathHelper.func_76128_c((double)z);
        BiomeGenBase b = ep.field_70170_p.func_72807_a(px, pz);
        if (BiomeGlowingCliffs.isGlowingCliffs(b) && this.clouds.size() < 48 && this.rand.nextInt(4) == 0 && (c = this.createCloud(ep.field_70170_p, x, y, z)) != null) {
            this.clouds.add(c);
        }
        if (this.clouds.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3008);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDepthMask((boolean)false);
        GL11.glShadeModel((int)7425);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindFinalTexture(ChromatiCraft.class, (String)"Textures/biomefog_alpha.png");
        GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
        double v = 0.125;
        double a = (double)(4L * ep.field_70170_p.func_82737_E() % 24000L) / 24000.0 * (Math.PI * 2);
        double vx = v * Math.cos(a);
        double vz = v * Math.sin(a);
        double vy = 1.0 + Math.sin(-a);
        Iterator<Cloud> it = this.clouds.iterator();
        while (it.hasNext()) {
            Cloud c2 = it.next();
            c2.render(Tessellator.field_78398_a, x, y, z);
            if (!c2.update(vx, 0.0, vz)) continue;
            it.remove();
        }
        GL11.glShadeModel((int)7424);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private Cloud createCloud(World world, double x, double y, double z) {
        double dx = ReikaRandomHelper.getRandomPlusMinus((double)x, (double)96.0);
        double dz = ReikaRandomHelper.getRandomPlusMinus((double)z, (double)96.0);
        if (!BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dz)))) {
            return null;
        }
        double dy = ReikaRandomHelper.getRandomBetween((double)60.0, (double)256.0);
        int l = 40 + this.rand.nextInt(200);
        double s = ReikaRandomHelper.getRandomBetween((double)24.0, (double)96.0);
        float sx = (float)ReikaRandomHelper.getRandomBetween((double)0.0625, (double)0.375);
        float sy = (float)ReikaRandomHelper.getRandomBetween((double)0.0625, (double)0.375);
        float tx = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)2.44140625E-4);
        float ty = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)2.44140625E-4);
        float fx = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)9.765625E-4);
        float fy = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)9.765625E-4);
        Cloud c = new Cloud(this.rand.nextFloat(), this.rand.nextFloat(), sx, sy, s, l, dx, dy, dz).setTextureSpeed(tx, ty).setSizeSpeed(fx, fy);
        c.scaleSpeed = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.001953125);
        return c;
    }

    private static class Cloud {
        private float textureX;
        private float textureY;
        private float sizeX;
        private float sizeY;
        private double scale;
        private float textureXSpeed = 0.0f;
        private float textureYSpeed = 0.0f;
        private float sizeXSpeed = 0.0f;
        private float sizeYSpeed = 0.0f;
        private double scaleSpeed = 0.0;
        private final int lifespan;
        private int age;
        private double posX;
        private double posY;
        private double posZ;

        private Cloud(float tx, float ty, float sx, float sy, double s, int l, double x, double y, double z) {
            this.textureX = tx;
            this.textureY = ty;
            this.sizeX = sx;
            this.sizeY = sy;
            this.scale = s;
            this.lifespan = l;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        private Cloud setTextureSpeed(float x, float y) {
            this.textureXSpeed = x;
            this.textureYSpeed = y;
            return this;
        }

        private Cloud setSizeSpeed(float x, float y) {
            this.sizeXSpeed = x;
            this.sizeYSpeed = y;
            return this;
        }

        private boolean update(double vx, double vy, double vz) {
            this.posX += vx;
            this.posY += vy;
            this.posZ += vz;
            this.textureX += this.textureXSpeed;
            this.textureY += this.textureYSpeed;
            this.sizeX += this.sizeXSpeed;
            this.sizeY += this.sizeYSpeed;
            this.scale += this.scaleSpeed;
            ++this.age;
            return this.age >= this.lifespan;
        }

        private float getAlpha() {
            return (float)Math.sin(Math.toRadians(180.0 * (double)this.age / (double)this.lifespan));
        }

        private void render(Tessellator v5, double x, double y, double z) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.posX, (double)this.posY, (double)this.posZ);
            RenderManager rm = RenderManager.field_78727_a;
            GL11.glRotatef((float)(-rm.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            v5.func_78382_b();
            float f = this.getAlpha();
            v5.func_78375_b(0.0f, 1.0f, 0.0f);
            v5.func_78380_c(240);
            v5.func_78384_a(0xFFFFFF, (int)(255.0f * f));
            double x1 = -this.scale * (double)this.sizeX;
            double x2 = this.scale * (double)this.sizeX;
            double y1 = -this.scale * (double)this.sizeY;
            double y2 = this.scale * (double)this.sizeY;
            double ds = 0.125;
            for (double d1 = 0.0; d1 < 1.0; d1 += ds) {
                for (double d2 = 0.0; d2 < 1.0; d2 += ds) {
                    double dx = x1 + (x2 - x1) * d1;
                    double dy = y1 + (y2 - y1) * d2;
                    double dx2 = dx + ds * (double)this.sizeX * this.scale * 2.0;
                    double dy2 = dy + ds * (double)this.sizeY * this.scale * 2.0;
                    double u1 = (double)this.textureX + d1 * (double)this.sizeX;
                    double u2 = u1 + ds * (double)this.sizeX;
                    double v1 = (double)this.textureY + d2 * (double)this.sizeY;
                    double v2 = v1 + ds * (double)this.sizeY;
                    double rx1 = 1.0 - Math.abs(d1 * 2.0 - 1.0);
                    double rz1 = 1.0 - Math.abs(d2 * 2.0 - 1.0);
                    double r1 = rx1 * rz1;
                    float f2 = (float)((double)f * r1);
                    v5.func_78384_a(0xFFFFFF, (int)(255.0f * f2));
                    v5.func_78374_a(dx, dy, 0.0, u1, v1);
                    rx1 = 1.0 - Math.abs((d1 + ds) * 2.0 - 1.0);
                    rz1 = 1.0 - Math.abs(d2 * 2.0 - 1.0);
                    r1 = rx1 * rz1;
                    f2 = (float)((double)f * r1);
                    v5.func_78384_a(0xFFFFFF, (int)(255.0f * f2));
                    v5.func_78374_a(dx2, dy, 0.0, u2, v1);
                    rx1 = 1.0 - Math.abs((d1 + ds) * 2.0 - 1.0);
                    rz1 = 1.0 - Math.abs((d2 + ds) * 2.0 - 1.0);
                    r1 = rx1 * rz1;
                    f2 = (float)((double)f * r1);
                    v5.func_78384_a(0xFFFFFF, (int)(255.0f * f2));
                    v5.func_78374_a(dx2, dy2, 0.0, u2, v2);
                    rx1 = 1.0 - Math.abs(d1 * 2.0 - 1.0);
                    rz1 = 1.0 - Math.abs((d2 + ds) * 2.0 - 1.0);
                    r1 = rx1 * rz1;
                    f2 = (float)((double)f * r1);
                    v5.func_78384_a(0xFFFFFF, (int)(255.0f * f2));
                    v5.func_78374_a(dx, dy2, 0.0, u1, v2);
                }
            }
            v5.func_78381_a();
            GL11.glPopMatrix();
        }
    }
}

