/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class BiomeFXRenderer {
    public static final BiomeFXRenderer instance = new BiomeFXRenderer();
    private static final int RAIN_RADIUS = 48;
    private static final int POINT_COUNT = 28;
    private static final HashMap<Integer, ColorReference> colorMapA = new HashMap();
    private static final HashMap<Integer, ColorReference> colorMapB = new HashMap();
    private int biomeRainColor = 0;
    private ArrayList<RainPoint> points = new ArrayList();

    private BiomeFXRenderer() {
    }

    public void render() {
        if (MinecraftForgeClient.getRenderPass() != 1) {
            return;
        }
        float f = ReikaRenderHelper.getPartialTickTime();
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        double x = ep.field_70165_t + (ep.field_70165_t - ep.field_70142_S) * (double)f;
        double y = ep.field_70163_u + (ep.field_70163_u - ep.field_70137_T) * (double)f;
        double z = ep.field_70161_v + (ep.field_70161_v - ep.field_70136_U) * (double)f;
        int px = MathHelper.func_76128_c((double)x);
        int py = MathHelper.func_76128_c((double)y);
        int pz = MathHelper.func_76128_c((double)z);
        int b = ep.field_70170_p.func_72807_a((int)px, (int)pz).field_76756_M;
        ColorReference c1 = colorMapA.get(b);
        if (c1 != null && ep.field_70170_p.func_72972_b(EnumSkyBlock.Sky, px, py, pz) > 5) {
            ColorReference c2 = colorMapB.get(b);
            long tick = ep.field_70170_p.func_82737_E();
            int c = 0xFF000000 | (c1 == c2 ? c1.getColor(tick) : ReikaColorAPI.mixColors((int)c1.getColor(tick), (int)c2.getColor(tick), (float)((float)(0.5 + 0.5 * Math.sin((double)System.currentTimeMillis() / 1500.0)))));
            this.biomeRainColor = ReikaColorAPI.mixColors((int)c, (int)this.biomeRainColor, (float)0.05f);
        } else {
            this.biomeRainColor = ReikaColorAPI.mixColors((int)0, (int)this.biomeRainColor, (float)0.025f);
        }
        if (this.biomeRainColor == 0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDisable((int)2896);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glDepthMask((boolean)false);
        GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/biomeFX2.png");
        Tessellator v5 = Tessellator.field_78398_a;
        Iterator<RainPoint> it = this.points.iterator();
        while (it.hasNext()) {
            RainPoint p = it.next();
            if (!p.tick((EntityPlayer)ep)) continue;
            it.remove();
        }
        while (this.points.size() < 28) {
            this.generateNewPoint((EntityPlayer)ep);
        }
        v5.func_78382_b();
        for (RainPoint p : this.points) {
            int c = this.biomeRainColor;
            float al = p.getAlpha();
            if (al < 1.0f) {
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)al);
            }
            v5.func_78378_d(c);
            double u = (double)(System.currentTimeMillis() / (long)((int)(50.0f * p.animationSpeed)) % 64L) / 64.0;
            double du = u + 0.015625;
            double rx = p.posX;
            double rz = p.posZ;
            int n = 6;
            double da = 360.0 / (double)n;
            double r = p.radius;
            double h = p.height;
            int ty = ep.field_70170_p.func_72825_h(px, pz);
            double my = Math.max((double)(ty - 8), ep.field_70163_u - 64.0);
            for (double ry = my = Math.max(my, (double)ep.field_70170_p.func_72874_g(MathHelper.func_76128_c((double)rx), MathHelper.func_76128_c((double)rz))); ry <= ep.field_70163_u + 64.0; ry += h * 2.0) {
                for (double a = 0.0; a <= 360.0; a += da) {
                    double ang1 = Math.toRadians(a);
                    double dx1 = rx + r * Math.cos(ang1);
                    double dz1 = rz + r * Math.sin(ang1);
                    double ang2 = Math.toRadians(a + da);
                    double dx2 = rx + r * Math.cos(ang2);
                    double dz2 = rz + r * Math.sin(ang2);
                    v5.func_78374_a(dx1, ry + h, dz1, u, 0.0);
                    v5.func_78374_a(dx2, ry + h, dz2, du, 0.0);
                    v5.func_78374_a(dx2, ry - h, dz2, du, 1.0);
                    v5.func_78374_a(dx1, ry - h, dz1, u, 1.0);
                }
            }
        }
        v5.func_78381_a();
        ReikaRenderHelper.enableEntityLighting();
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void generateNewPoint(EntityPlayer ep) {
        double dx = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70165_t, (double)48.0);
        double dz = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70161_v, (double)48.0);
        Random r = ep.field_70170_p.field_73012_v;
        RainPoint p = new RainPoint(dx, dz, 40 + r.nextInt(440), 0.0625 + 0.0625 * r.nextDouble(), ReikaRandomHelper.getRandomPlusMinus((int)9, (int)3), 0.5f + r.nextFloat() * 1.5f);
        this.points.add(p);
    }

    static {
        colorMapA.put(ExtraChromaIDs.RAINBOWFOREST.getValue(), new SolidColorReference(0x22AAFF));
        colorMapB.put(ExtraChromaIDs.RAINBOWFOREST.getValue(), new SolidColorReference(24831));
        colorMapA.put(ExtraChromaIDs.ENDERFOREST.getValue(), new SolidColorReference(10510591));
        colorMapB.put(ExtraChromaIDs.ENDERFOREST.getValue(), new SolidColorReference(0xFFAAFF));
        colorMapA.put(ExtraChromaIDs.LUMINOUSCLIFFS.getValue(), new ColorBlendReference(new ColorBlendList(5.0f, ChromaFX.getChromaColorTiles())));
        colorMapB.put(ExtraChromaIDs.LUMINOUSCLIFFS.getValue(), colorMapA.get(ExtraChromaIDs.LUMINOUSCLIFFS.getValue()));
    }

    private static class RainPoint {
        private static final int FADE_IN = 10;
        private static final int FADE_OUT = 20;
        private final int lifespan;
        private int age;
        private final float animationSpeed;
        private final double radius;
        private final double height;
        private final double posX;
        private final double posZ;

        private RainPoint(double x, double z, int l, double r, double h, float sp) {
            this.posX = x;
            this.posZ = z;
            this.lifespan = l;
            this.radius = r;
            this.height = h;
            this.animationSpeed = sp;
        }

        private boolean tick(EntityPlayer ep) {
            double dx = ep.field_70165_t - this.posX;
            double dz = ep.field_70161_v - this.posZ;
            double dd = dx * dx + dz * dz;
            this.age = dd >= 2304.0 ? (this.age += this.lifespan / 8) : ++this.age;
            return this.age >= this.lifespan;
        }

        private float getAlpha() {
            if (this.age < 10) {
                return (float)this.age / 10.0f;
            }
            if (this.age > this.lifespan - 20) {
                int rem = this.lifespan - this.age;
                return (float)rem / 20.0f;
            }
            return 1.0f;
        }
    }

    private static class SolidColorReference
    extends ColorReference {
        private final int color;

        private SolidColorReference(int c) {
            this.color = c;
        }

        @Override
        protected int getColor(long tick) {
            return this.color;
        }
    }

    private static class ColorBlendReference
    extends ColorReference {
        private final ColorBlendList list;

        private ColorBlendReference(ColorBlendList c) {
            this.list = c;
        }

        @Override
        protected int getColor(long tick) {
            return this.list.getColor((double)tick);
        }
    }

    private static abstract class ColorReference {
        private ColorReference() {
        }

        protected abstract int getColor(long var1);
    }
}

