/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.API.CrystalElementProxy;
import Reika.ChromatiCraft.Magic.ElementMixer;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public enum CrystalElement {
    BLACK("Kuro", 0x191919, EnumChatFormatting.BLACK),
    RED("Karmir", 0xFF0000, EnumChatFormatting.DARK_RED),
    GREEN("Kijani", 32526, EnumChatFormatting.DARK_GREEN),
    BROWN("Ruskea", 7488808, EnumChatFormatting.GOLD),
    BLUE("Nila", 9983, EnumChatFormatting.BLUE),
    PURPLE("Zambarau", 9175274, EnumChatFormatting.DARK_PURPLE),
    CYAN("Vadali", 40895, EnumChatFormatting.DARK_AQUA),
    LIGHTGRAY("Argia", 0x979797, EnumChatFormatting.GRAY),
    GRAY("Ykri", 0x404040, EnumChatFormatting.DARK_GRAY),
    PINK("Ruzova", 16759513, EnumChatFormatting.RED),
    LIME("Asveste", 65280, EnumChatFormatting.GREEN),
    YELLOW("Kitrino", 0xFFFF00, EnumChatFormatting.YELLOW),
    LIGHTBLUE("Galazio", 8377599, EnumChatFormatting.AQUA),
    MAGENTA("Kurauri", 16711900, EnumChatFormatting.LIGHT_PURPLE),
    ORANGE("Portokali", 16738816, EnumChatFormatting.GOLD),
    WHITE("Tahara", 0xFFFFFF, EnumChatFormatting.WHITE);

    private final ReikaDyeHelper color = ReikaDyeHelper.getColorFromDamage((int)this.ordinal());
    public final String displayName;
    private IIcon glowIcon;
    private IIcon animatedFace;
    private IIcon engraving;
    private IIcon outline;
    private IIcon overbright;
    private final int rgb;
    private final EnumChatFormatting chat;
    private final float[] hsb;
    private static final Random rand;
    public static final CrystalElement[] elements;
    private static final MultiMap<Integer, CrystalElement> levelMap;
    private static final HashMap<String, CrystalElement> nameMap;
    private static final HashMap<CrystalElement, Integer> colorMap;

    private CrystalElement(String n2, int rgb, EnumChatFormatting c) {
        this.displayName = n2;
        this.rgb = 0xFF000000 | rgb;
        this.chat = c;
        this.hsb = Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
    }

    public String getEnglishName() {
        return this.color.colorName;
    }

    public int getColor() {
        return this.rgb;
    }

    public int getHue() {
        return (int)(this.hsb[0] * 360.0f);
    }

    public int getSaturation() {
        return (int)(this.hsb[1] * 255.0f);
    }

    public int getValue() {
        return (int)(this.hsb[2] * 255.0f);
    }

    public int getRed() {
        return ReikaColorAPI.getRed((int)this.getColor());
    }

    public int getGreen() {
        return ReikaColorAPI.getGreen((int)this.getColor());
    }

    public int getBlue() {
        return ReikaColorAPI.getBlue((int)this.getColor());
    }

    public Color getJavaColor() {
        return new Color(this.rgb);
    }

    public int getLevel() {
        switch (this) {
            case BLACK: 
            case BLUE: 
            case BROWN: 
            case GREEN: 
            case RED: 
            case WHITE: 
            case YELLOW: {
                return 0;
            }
            case CYAN: 
            case LIGHTBLUE: 
            case GRAY: 
            case LIME: 
            case ORANGE: 
            case PURPLE: 
            case PINK: {
                return 1;
            }
            case LIGHTGRAY: 
            case MAGENTA: {
                return 2;
            }
        }
        return -1;
    }

    public CrystalElement mixWith(CrystalElement e) {
        return ElementMixer.instance.getMix(this, e);
    }

    public CrystalElement subtract(CrystalElement e) {
        return ElementMixer.instance.subtract(this, e);
    }

    public boolean isCompatible(CrystalElement e) {
        return ElementMixer.instance.isCompatible(this, e);
    }

    public boolean isPrimary() {
        return this.getLevel() == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void setIcons(IIconRegister ico) {
        this.glowIcon = ico.func_94245_a("chromaticraft:runes/glow/tile" + this.ordinal() + "_0");
        this.animatedFace = ico.func_94245_a("chromaticraft:runes/frontpng/tile" + this.ordinal() + "_0");
        this.engraving = ico.func_94245_a("chromaticraft:runes/engraved/tile" + this.ordinal() + "_0");
        this.outline = ico.func_94245_a("chromaticraft:runes/outline/tile" + this.ordinal() + "_0");
        this.overbright = ico.func_94245_a("chromaticraft:crystal/overbright/bloom_" + this.name().toLowerCase(Locale.ENGLISH));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getGlowRune() {
        return this.glowIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFaceRune() {
        return this.animatedFace;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBlockRune() {
        return ChromaBlocks.RUNE.getBlockInstance().func_149691_a(0, this.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getEngravingRune() {
        return this.engraving;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOutlineRune() {
        return this.outline;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverbrightIcon() {
        return this.overbright;
    }

    public static CrystalElement randomElement() {
        return elements[ReikaDyeHelper.getRandomColor().ordinal()];
    }

    public static CrystalElement randomElement(int level) {
        Collection li = levelMap.get((Object)level);
        return li != null ? (CrystalElement)((Object)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)li)) : null;
    }

    public static CrystalElement randomPrimaryElement() {
        return CrystalElement.randomElement(0);
    }

    public static int getBlendedColor(int tick, int mod) {
        CrystalElement e = elements[tick / mod % 16];
        CrystalElement e2 = elements[(tick / mod + 1) % 16];
        float mix = (float)(tick % mod) / (float)mod;
        return ReikaColorAPI.mixColors((int)e2.getColor(), (int)e.getColor(), (float)mix);
    }

    public String getChatColorString() {
        return this.chat.toString();
    }

    public CrystalElementProxy getAPIProxy() {
        return CrystalElementProxy.list[this.ordinal()];
    }

    public static CrystalElement getFromAPI(CrystalElementProxy e) {
        return elements[e.ordinal()];
    }

    public static CrystalElement getByName(String s) {
        return nameMap.get(s);
    }

    public static Map<CrystalElement, Integer> getColorMap() {
        return Collections.unmodifiableMap(colorMap);
    }

    static {
        rand = new Random();
        elements = CrystalElement.values();
        levelMap = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());
        nameMap = new HashMap();
        colorMap = new HashMap();
        for (int i = 0; i < elements.length; ++i) {
            CrystalElement e = elements[i];
            int lvl = e.getLevel();
            levelMap.addValue((Object)lvl, (Object)e);
            nameMap.put(e.displayName, e);
            colorMap.put(e, e.getColor());
        }
    }
}

