/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import java.net.URL;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum ChromaSounds implements SoundEnum
{
    RIFT("rift"),
    POWERDOWN("powerdown-2"),
    DISCHARGE("discharge"),
    CAST("cast3"),
    POWER("ambient"),
    CRAFTING("ambient1_short"),
    CRAFTING_BOOST("ambient1_short_boost"),
    CRAFTDONE("craftdone2"),
    UPGRADE("upgrade"),
    ABILITY("ability"),
    ERROR("error"),
    INFUSE("infuse"),
    INFUSION("infuse2"),
    USE("use2"),
    TRAP("slam2"),
    DING("ding2"),
    DING_HI("ding2_hi"),
    DING_LO("ding2_lo"),
    SHOCKWAVE("shockwave3"),
    BALLLIGHTNING("balllightning"),
    ITEMSTAND("stand"),
    GLOWCLOUD("powercrystal"),
    GUICLICK("gui2"),
    GUISEL("gui4"),
    DRONE("drone2"),
    PORTAL("portal2"),
    ORB("orb"),
    ORB_HI("orb_hi"),
    ORB_LO("orb_lo"),
    GOTODIM("todim"),
    OVERLOAD("discharge2"),
    PYLONFLASH("pylonboost"),
    PYLONTURBO("pylonturbo"),
    PYLONBOOSTRITUAL("pylonboost_ritual_short"),
    PYLONBOOSTSTART("pylonbooststart"),
    DASH("dash"),
    REPEATERSURGE("repeatersurge"),
    REPEATERSURGE_WEAK("repeatersurge_weak"),
    FIRE("fire"),
    LASER("laser"),
    MONUMENT("monument"),
    MONUMENTRAY("monumentray"),
    MONUMENTCOMPLETE("monumentcomplete"),
    BUFFERWARNING("buffer_warning"),
    BUFFERWARNING_LOW("buffer_warning2"),
    BUFFERWARNING_EMPTY("buffer_warning3"),
    KILLAURA("killaura"),
    KILLAURA_CHARGE("killaura_charge"),
    POWERCRAFT("powercraft"),
    METEOR("meteor"),
    IMPACT("impact"),
    NOCLIPON("rumble-in"),
    NOCLIPOFF("rumble-out"),
    NOCLIPRUN("rumble"),
    FLAREATTACK("flareattack"),
    BOUNCE("bounce"),
    SKYRIVER("lumenstream"),
    PING("ping"),
    GAINPROGRESS("progress2"),
    AVOLASER("avolaser2"),
    CLIFFSOUND("cliffambience"),
    CLIFFSOUND2("cliffambience2"),
    CLIFFSOUND3("cliffambience3"),
    INSCRIBE("inscribe"),
    LOREHEX("lore"),
    LORECOMPLETE("lorecomplete2"),
    LIGHTCAST("lightcast"),
    WATERLOCK("waterlock");

    public static final ChromaSounds[] soundList;
    public static final String PREFIX = "Reika/ChromatiCraft/";
    public static final String SOUND_FOLDER = "Sounds/";
    private static final String SOUND_PREFIX = "Reika.ChromatiCraft.Sounds.";
    private static final String SOUND_DIR = "Sounds/";
    private static final String SOUND_EXT = ".ogg";
    private final String path;
    private final String name;
    private boolean isVolumed = false;

    private ChromaSounds(String n2) {
        if (n2.startsWith("#")) {
            this.isVolumed = true;
            n2 = n2.substring(1);
        }
        this.name = n2;
        this.path = "Reika/ChromatiCraft/Sounds/" + this.name + SOUND_EXT;
    }

    public float getSoundVolume() {
        float vol = 1.0f;
        if (vol < 0.0f) {
            vol = 0.0f;
        }
        if (vol > 1.0f) {
            vol = 1.0f;
        }
        return vol;
    }

    public float getModulatedVolume() {
        if (!this.isVolumed) {
            return 1.0f;
        }
        return this.getSoundVolume();
    }

    public void playSound(Entity e) {
        this.playSound(e, 1.0f, 1.0f);
    }

    public void playSound(Entity e, float vol, float pitch) {
        this.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch);
    }

    public void playSound(World world, double x, double y, double z, float vol, float pitch) {
        if (world.field_72995_K) {
            return;
        }
        ReikaSoundHelper.playSound((SoundEnum)this, (String)"ChromaData", (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch);
    }

    public void playSound(World world, double x, double y, double z, float vol, float pitch, boolean attenuate) {
        if (world.field_72995_K) {
            return;
        }
        ReikaSoundHelper.playSound((SoundEnum)this, (String)"ChromaData", (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch, (boolean)attenuate);
    }

    public void playSoundAtBlock(World world, int x, int y, int z, float vol, float pitch) {
        this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vol, pitch);
    }

    public void playSoundAtBlock(World world, int x, int y, int z) {
        this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, 1.0f);
    }

    public void playSoundAtBlock(TileEntity te, float vol, float pitch) {
        this.playSoundAtBlock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, vol, pitch);
    }

    public void playSoundAtBlockNoAttenuation(TileEntity te, float vol, float pitch, int broadcast) {
        this.playSoundAtBlockNoAttenuation(te.field_145850_b, (double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5, vol, pitch, broadcast);
    }

    public void playSoundAtBlockNoAttenuation(World world, double x, double y, double z, float vol, float pitch, int broadcast) {
        if (world.field_72995_K) {
            return;
        }
        ReikaPacketHelper.sendSoundPacket((String)"ChromaData", (SoundEnum)this, (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch, (boolean)false, (int)broadcast);
    }

    public void playSoundAtBlock(TileEntity te) {
        this.playSoundAtBlock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public void playSoundAtBlock(WorldLocation loc) {
        this.playSoundAtBlock(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public String getName() {
        return this.name();
    }

    public String getPath() {
        return this.path;
    }

    public URL getURL() {
        return ChromatiCraft.class.getResource("Sounds/" + this.name + SOUND_EXT);
    }

    public static ChromaSounds getSoundByName(String name) {
        for (int i = 0; i < soundList.length; ++i) {
            if (!soundList[i].name().equals(name)) continue;
            return soundList[i];
        }
        ChromatiCraft.logger.logError((Object)("\"" + name + "\" does not correspond to a registered sound!"));
        return null;
    }

    public SoundCategory getCategory() {
        if (this == GLOWCLOUD || this == BALLLIGHTNING) {
            return SoundCategory.MOBS;
        }
        return SoundCategory.MASTER;
    }

    public boolean canOverlap() {
        return this == RIFT || this == CAST || this == USE || this == ERROR || this == INFUSE || this == DING || this == DRONE || this == ITEMSTAND || this == KILLAURA_CHARGE || this == DASH || this == ORB_LO;
    }

    public boolean attenuate() {
        return this != GOTODIM && this != PYLONTURBO && this != PYLONFLASH && this != PYLONBOOSTRITUAL && this != PYLONBOOSTSTART && this != REPEATERSURGE && this != MONUMENT && this != MONUMENTRAY && this != GAINPROGRESS;
    }

    public boolean hasWiderPitchRange() {
        return this == DING || this == ORB;
    }

    public ChromaSounds getUpshiftedPitch() {
        if (this == DING) {
            return DING_HI;
        }
        if (this == ORB) {
            return ORB_HI;
        }
        return this;
    }

    public ChromaSounds getDownshiftedPitch() {
        if (this == DING) {
            return DING_LO;
        }
        if (this == ORB) {
            return ORB_LO;
        }
        return this;
    }

    public boolean preload() {
        switch (this) {
            case MONUMENT: 
            case MONUMENTCOMPLETE: 
            case CRAFTING: 
            case CRAFTING_BOOST: 
            case POWERCRAFT: 
            case INFUSION: 
            case ABILITY: 
            case GOTODIM: 
            case PYLONBOOSTRITUAL: 
            case REPEATERSURGE: {
                return true;
            }
        }
        return false;
    }

    static {
        soundList = ChromaSounds.values();
    }
}

