/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Special.RepeaterTurboRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PoolRecipes;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Base.ItemCrystalBasic;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityBallLightning;
import Reika.ChromatiCraft.Items.ItemBlock.ItemBlockCrystal;
import Reika.ChromatiCraft.Items.ItemBlock.ItemBlockCrystalColors;
import Reika.ChromatiCraft.Items.ItemBlock.ItemBlockDyeTypes;
import Reika.ChromatiCraft.Items.ItemMagicBranch;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.Registry.AdjacencyUpgrades;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.DragonAPI.Auxiliary.Trackers.PackModificationTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Registry.Dependency;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeSpecies;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public enum ChromaResearch implements ChromaResearchManager.ProgressElement
{
    INTRO("Introduction", ""),
    START("Getting Started", new ItemStack(Blocks.field_150346_d), ChromaResearchManager.ResearchLevel.ENTRY, new ProgressionManager.ProgressStage[0]),
    LEXICON("The Lexicon", ChromaItems.HELP.getStackOf(), ChromaResearchManager.ResearchLevel.ENTRY, new ProgressionManager.ProgressStage[0]),
    ELEMENTS("Crystal Energy", ChromaItems.ELEMENTAL.getStackOf(CrystalElement.BLUE), ChromaResearchManager.ResearchLevel.BASICCRAFT, ProgressionManager.ProgressStage.ALLCOLORS),
    CRYSTALS("Crystals", ChromaBlocks.CRYSTAL.getStackOfMetadata(4), ChromaResearchManager.ResearchLevel.ENTRY, ProgressionManager.ProgressStage.CRYSTALS),
    PYLONS("Pylons", ChromaTiles.PYLON.getCraftedProduct(), ChromaResearchManager.ResearchLevel.ENTRY, ProgressionManager.ProgressStage.PYLON),
    STRUCTURES("Structures", ChromaBlocks.PYLONSTRUCT.getStackOf(), ChromaResearchManager.ResearchLevel.RAWEXPLORE, new ProgressionManager.ProgressStage[0]),
    TRANSMISSION("Signal Transmission", ChromaStacks.beaconDust, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    CRAFTING("Casting", ChromaTiles.TABLE.getCraftedProduct(), ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    ENCHANTS("Enchantments", ChromaTiles.ENCHANTER.getCraftedProduct(), ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    CRAFTING2("Casting II", ChromaTiles.TABLE.getCraftedProduct(), ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.RUNEUSE),
    BALLLIGHTNING("Ball Lightning", ChromaStacks.auraDust, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, ProgressionManager.ProgressStage.BALLLIGHTNING),
    APIRECIPES("Other Recipes", new ItemStack(Blocks.field_150346_d), ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    LEYLINES("Ley Lines", ChromaTiles.REPEATER.getCraftedProduct(), ChromaResearchManager.ResearchLevel.NETWORKING, ProgressionManager.ProgressStage.REPEATER),
    USINGRUNES("Crafting With Runes", ChromaBlocks.RUNE.getStackOfMetadata(1), ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.RUNEUSE),
    DIMENSION("Another World", ChromaBlocks.PORTAL.getStackOf(), ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressionManager.ProgressStage.DIMENSION)),
    DIMENSION2("A Volatile World", ChromaBlocks.GLOWSAPLING.getStackOf(), ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.DIMENSION),
    DIMENSION3("The Far Regions", ChromaBlocks.DIMGEN.getStackOfMetadata(BlockDimensionDeco.DimDecoTypes.FLOATSTONE.ordinal()), ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.DIMENSION, ProgressionManager.ProgressStage.STRUCTCOMPLETE),
    TURBO("Turbocharging", ChromaStacks.elementUnit, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressionManager.ProgressStage.TURBOCHARGE)),
    TURBOREPEATER("Repeater Turbocharging", ChromaStacks.turboRepeater, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.TURBOCHARGE),
    PACKCHANGES("Modpack Changes", new ItemStack(Blocks.field_150346_d), ChromaResearchManager.ResearchLevel.ENTRY, new ProgressionManager.ProgressStage[0]),
    NODENET("Networking Aura Nodes", new ItemStack(Blocks.field_150346_d), ChromaResearchManager.ResearchLevel.CTM, ProgressionManager.ProgressStage.CTM),
    SELFCHARGE("Energy Internalization", ChromaItems.TOOL.getStackOf(), ChromaResearchManager.ResearchLevel.CHARGESELF, ProgressionManager.ProgressStage.CHARGE),
    MYSTPAGE("World Authoring", new ItemStack((Item)Items.field_151148_bJ), ChromaResearchManager.ResearchLevel.RAWEXPLORE, new ProgressionManager.ProgressStage[0]),
    ENCHANTING("Crystal Enchanting", new ItemStack((Item)Items.field_151134_bR), ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.MULTIBLOCK),
    MACHINEDESC("Constructs", ""),
    REPEATER(ChromaTiles.REPEATER, ChromaResearchManager.ResearchLevel.NETWORKING, ProgressionManager.ProgressStage.BLOWREPEATER),
    GUARDIAN(ChromaTiles.GUARDIAN, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    REPROGRAMMER(ChromaTiles.REPROGRAMMER, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    ACCEL(ChromaTiles.ADJACENCY, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]),
    RIFT(ChromaTiles.RIFT, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    TANK(ChromaTiles.TANK, ChromaResearchManager.ResearchLevel.PYLONCRAFT, ProgressionManager.ProgressStage.OCEAN),
    COMPOUND(ChromaTiles.COMPOUND, ChromaResearchManager.ResearchLevel.NETWORKING, ProgressionManager.ProgressStage.REPEATER),
    CHARGER(ChromaTiles.CHARGER, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.STORAGE),
    LILY(ChromaTiles.HEATLILY, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    TICKER(ChromaTiles.TICKER, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    FENCE(ChromaTiles.FENCE, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    FURNACE(ChromaTiles.FURNACE, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    TELEPUMP(ChromaTiles.TELEPUMP, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    MINER(ChromaTiles.MINER, ChromaResearchManager.ResearchLevel.CTM, ProgressionManager.ProgressStage.CTM),
    ITEMSTAND(ChromaTiles.STAND, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    LASER(ChromaTiles.LASER, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    ITEMRIFT(ChromaTiles.ITEMRIFT, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    CRYSTAL(ChromaTiles.CRYSTAL, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]),
    INFUSER(ChromaTiles.INFUSER, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    FABRICATOR(ChromaTiles.FABRICATOR, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    ENCHANTER(ChromaTiles.ENCHANTER, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    CHROMAFLOWER(ChromaTiles.CHROMAFLOWER, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    COLLECTOR(ChromaTiles.COLLECTOR, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    BREWER(ChromaTiles.BREWER, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    RITUALTABLE(ChromaTiles.RITUAL, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    CASTTABLE(ChromaTiles.TABLE, ChromaResearchManager.ResearchLevel.ENTRY, new ProgressionManager.ProgressStage[0]),
    BEACON(ChromaTiles.BEACON, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]),
    ITEMCOLLECTOR(ChromaTiles.ITEMCOLLECTOR, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    AISHUTDOWN(ChromaTiles.AISHUTDOWN, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    ASPECT(ChromaTiles.ASPECT, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    LAMP(ChromaTiles.LAMP, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    POWERTREE(ChromaTiles.POWERTREE, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.POWERCRYSTAL),
    LAMPCONTROL(ChromaTiles.LAMPCONTROL, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    BIOMEPAINT(ChromaTiles.BIOMEPAINTER, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.RAINBOWFOREST),
    ASPECTJAR(ChromaTiles.ASPECTJAR, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    FARMER(ChromaTiles.FARMER, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    AUTO(ChromaTiles.AUTOMATOR, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]),
    MEDISTRIB(ChromaTiles.MEDISTRIBUTOR, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    WINDOW(ChromaTiles.WINDOW, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    RFDISTRIB(ChromaTiles.RFDISTRIBUTOR, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    PERSONAL(ChromaTiles.PERSONAL, ChromaResearchManager.ResearchLevel.CHARGESELF, ProgressionManager.ProgressStage.CHARGE),
    MUSIC(ChromaTiles.MUSIC, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    PYLONTURBO(ChromaTiles.PYLONTURBO, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.DIMENSION),
    TURRET(ChromaTiles.TURRET, ChromaResearchManager.ResearchLevel.BASICCRAFT, ProgressionManager.ProgressStage.KILLMOB),
    BROADCAST(ChromaTiles.BROADCAST, ChromaResearchManager.ResearchLevel.NETWORKING, ProgressionManager.ProgressStage.REPEATER),
    CLOAKING(ChromaTiles.CLOAKING, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.KILLMOB),
    CAVELIGHTER(ChromaTiles.LIGHTER, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.BEDROCK),
    GLOWFIRE(ChromaTiles.GLOWFIRE, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, ProgressionManager.ProgressStage.SHARDCHARGE),
    ESSENTIA(ChromaTiles.ESSENTIARELAY, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    INSERTER(ChromaTiles.INSERTER, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    LOTUS(ChromaTiles.REVERTER, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    COBBLEGEN(ChromaTiles.COBBLEGEN, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    PLANTACCEL(ChromaTiles.PLANTACCEL, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    CROPSPEED(ChromaTiles.CROPSPEED, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    WEAKREPEATER(ChromaTiles.WEAKREPEATER, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, ProgressionManager.ProgressStage.PYLON, ProgressionManager.ProgressStage.MAKECHROMA),
    ENCHANTDECOMP(ChromaTiles.ENCHANTDECOMP, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.MAKECHROMA),
    LUMENWIRE(ChromaTiles.LUMENWIRE, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    PARTICLES(ChromaTiles.PARTICLES, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    METEOR(ChromaTiles.METEOR, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    FLUIDDISTRIB(ChromaTiles.FLUIDDISTRIBUTOR, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    VILLAGEREPAIR(ChromaTiles.VILLAGEREPAIR, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.VILLAGECASTING),
    AREABREAKER(ChromaTiles.AREABREAKER, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    WIRELESS(ChromaTiles.WIRELESS, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.USEENERGY),
    GATE(ChromaTiles.TELEPORT, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.END),
    FLUIDRELAY(ChromaTiles.FLUIDRELAY, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    BOOKDECOMP(ChromaTiles.BOOKDECOMP, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    PLANTHARVEST(ChromaTiles.HARVESTPLANT, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    AVOLASER(ChromaTiles.AVOLASER, ChromaResearchManager.ResearchLevel.ENDGAME, BlockTieredOre.TieredOres.AVOLITE.level),
    ALVEARY(ChromaTiles.ALVEARY, ChromaResearchManager.ResearchLevel.PYLONCRAFT, ProgressionManager.ProgressStage.HIVE),
    ROUTER(ChromaTiles.ROUTERHUB, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    FOCUSCRYSTALS(ChromaTiles.FOCUSCRYSTAL, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, ProgressionManager.ProgressStage.FOCUSCRYSTAL),
    FLUXMAKER(ChromaTiles.FLUXMAKER, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    FUNCRELAY(ChromaTiles.FUNCTIONRELAY, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    CHROMACRAFTER(ChromaTiles.CHROMACRAFTER, ChromaResearchManager.ResearchLevel.PYLONCRAFT, ProgressionManager.ProgressStage.ALLOY),
    MULTIBUILDER(ChromaTiles.MULTIBUILDER, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    BLOCKS("Other Blocks", ""),
    RUNES(ChromaBlocks.RUNE, CrystalElement.LIGHTBLUE.ordinal(), ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    CHROMA(ChromaBlocks.CHROMA, ChromaResearchManager.ResearchLevel.RAWEXPLORE, new ProgressionManager.ProgressStage[0]),
    HEATLAMP(ChromaBlocks.HEATLAMP, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.NETHER),
    TNT(ChromaBlocks.TNT, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    TANKAUX(ChromaBlocks.TANK, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    FENCEAUX(ChromaBlocks.FENCE, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    LUMENLEAVES(ChromaBlocks.POWERTREE, CrystalElement.LIME.ordinal(), ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.POWERCRYSTAL),
    DYELEAVES(ChromaBlocks.DYELEAF, CrystalElement.BROWN.ordinal(), ChromaResearchManager.ResearchLevel.ENTRY, ProgressionManager.ProgressStage.DYETREE),
    RAINBOWLEAVES(ChromaBlocks.RAINBOWLEAF, 3, ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.RAINBOWLEAF),
    LAMPAUX(ChromaBlocks.LAMPBLOCK, CrystalElement.WHITE.ordinal(), ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    CRYSTALLAMP(ChromaBlocks.LAMP, CrystalElement.YELLOW.ordinal(), ChromaResearchManager.ResearchLevel.RAWEXPLORE, new ProgressionManager.ProgressStage[0]),
    SUPERLAMP(ChromaBlocks.SUPER, CrystalElement.MAGENTA.ordinal(), ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    PATH(ChromaBlocks.PATH, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    GLOW(ChromaBlocks.GLOW, CrystalElement.RED.ordinal(), ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    RELAY(ChromaBlocks.RELAY, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    PORTAL(ChromaBlocks.PORTAL, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressionManager.ProgressStage.DIMENSION)),
    COLORALTAR(ChromaBlocks.COLORALTAR, CrystalElement.WHITE.ordinal(), ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    DOOR(ChromaBlocks.DOOR, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    GLASS(ChromaBlocks.GLASS, CrystalElement.BLUE.ordinal(), ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    MUSICTRIGGER(ChromaBlocks.MUSICTRIGGER, ChromaResearchManager.ResearchLevel.BASICCRAFT, ProgressionManager.ProgressStage.ANYSTRUCT),
    SELECTIVEGLASS(ChromaBlocks.SELECTIVEGLASS, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    AVOLAMP(ChromaBlocks.AVOLAMP, ChromaResearchManager.ResearchLevel.ENDGAME, BlockTieredOre.TieredOres.AVOLITE.level),
    REPEATERLAMP(ChromaBlocks.REPEATERLAMP, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    REDSTONEPOD(ChromaBlocks.REDSTONEPOD, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    TOOLDESC("Tools", ""),
    WAND(ChromaItems.TOOL, ChromaResearchManager.ResearchLevel.ENTRY, new ProgressionManager.ProgressStage[0]),
    FINDER(ChromaItems.FINDER, ChromaResearchManager.ResearchLevel.BASICCRAFT, ProgressionManager.ProgressStage.PYLON),
    EXCAVATOR(ChromaItems.EXCAVATOR, ChromaResearchManager.ResearchLevel.CHARGESELF, new ProgressionManager.ProgressStage[0]),
    TRANSITION(ChromaItems.TRANSITION, ChromaResearchManager.ResearchLevel.CHARGESELF, new ProgressionManager.ProgressStage[0]),
    INVLINK(ChromaItems.LINK, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    PENDANT(ChromaItems.PENDANT, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    LENS(ChromaItems.LENS, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    STORAGE(ChromaItems.STORAGE, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    LINKTOOL(ChromaItems.LINKTOOL, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    WARP(ChromaItems.WARP, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    TELEPORT(ChromaItems.TELEPORT, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    DUPLICATOR(ChromaItems.DUPLICATOR, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    BUILDER(ChromaItems.BUILDER, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    CAPTURE(ChromaItems.CAPTURE, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.KILLMOB),
    VOIDCELL(ChromaItems.VOIDCELL, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]),
    AURAPOUCH(ChromaItems.AURAPOUCH, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    MULTITOOL(ChromaItems.MULTITOOL, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    OREPICK(ChromaItems.OREPICK, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    ORESILK(ChromaItems.ORESILK, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    GROWTH(ChromaItems.GROWTH, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    ENDERCRYS(ChromaItems.ENDERCRYSTAL, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.END),
    BULKMOVER(ChromaItems.BULKMOVER, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    CHAINGUN(ChromaItems.CHAINGUN, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    HOVER(ChromaItems.HOVERWAND, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    SPLASH(ChromaItems.SPLASHGUN, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    VACUUMGUN(ChromaItems.VACUUMGUN, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.DIMENSION),
    DOORKEY(ChromaItems.KEY, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    OWNERKEY(ChromaItems.SHARE, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    CRYSTALCELL(ChromaItems.CRYSTALCELL, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.CHARGE),
    PURIFY(ChromaItems.PURIFY, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.RAINBOWLEAF, ProgressionManager.ProgressStage.ALLOY),
    EFFICIENCY(ChromaItems.EFFICIENCY, ChromaResearchManager.ResearchLevel.CTM, new ProgressionManager.ProgressStage[0]),
    KILLAURA(ChromaItems.KILLAURAGUN, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]),
    FLOATBOOTS(ChromaItems.FLOATBOOTS, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.DIMENSION),
    TELECAPSULE(ChromaItems.WARPCAPSULE, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    BEEFRAME(ChromaItems.BEEFRAME, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.HIVE),
    STRUCTFIND(ChromaItems.STRUCTUREFINDER, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.RUNEUSE, ProgressionManager.ProgressStage.ANYSTRUCT),
    MOBSONAR(ChromaItems.MOBSONAR, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.KILLMOB, ProgressionManager.ProgressStage.CHARGE),
    CAVEEXIT(ChromaItems.CAVEPATHER, ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    SPLINEATTACK(ChromaItems.SPLINEATTACK, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.KILLMOB),
    RESOURCEDESC("Resources", ""),
    BERRIES("Berries", ChromaItems.BERRY.getStackOf(CrystalElement.ORANGE), ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.DYETREE),
    SHARDS("Shards", ChromaStacks.redShard, ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.CRYSTALS),
    DUSTS("Plant Dusts", ChromaStacks.auraDust, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    GROUPS("Groups", ChromaStacks.crystalCore, ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    CORES("Cores", ChromaStacks.energyCore, ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    HICORES("Energized Cores", ChromaStacks.energyCoreHigh, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    IRID("Iridescent Crystal", ChromaStacks.iridCrystal, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.ALLOY),
    ORES("Buried Secrets", ChromaStacks.bindingCrystal, ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.CRYSTALS),
    CRYSTALSTONE("Crystal Stone", ChromaBlocks.PYLONSTRUCT.getBlockInstance(), ChromaResearchManager.ResearchLevel.BASICCRAFT, new ProgressionManager.ProgressStage[0]),
    SEED("Crystal Seeds", ChromaItems.SEED.getStackOf(CrystalElement.MAGENTA), ChromaResearchManager.ResearchLevel.RUNECRAFT, new ProgressionManager.ProgressStage[0]),
    FRAGMENT("Fragments", ChromaItems.FRAGMENT, ChromaResearchManager.ResearchLevel.ENTRY, new ProgressionManager.ProgressStage[0]),
    AUGMENT("Upgrades", ChromaStacks.speedUpgrade, ChromaResearchManager.ResearchLevel.PYLONCRAFT, ProgressionManager.ProgressStage.STORAGE),
    ALLOYS("Alloying", ChromaStacks.chromaIngot, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.instance.getPrereqsArray(ProgressionManager.ProgressStage.ALLOY)),
    INSCRIPTION("Inscription", ChromaItems.DATACRYSTAL.getStackOf(), ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.TOWER),
    BEES("Crystal Bees", new ItemStack(Blocks.field_150346_d), ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.HIVE),
    TINKERTOOLS("Mix-And-Magic Tools", new ItemStack(Blocks.field_150346_d), ChromaResearchManager.ResearchLevel.MULTICRAFT, new ProgressionManager.ProgressStage[0]),
    BRANCHES("Magic Branches", ItemMagicBranch.BranchTypes.CRYSTAL.getStack(), ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, new ProgressionManager.ProgressStage[0]),
    FERTILITYSEED("Fertility Seeds", ChromaItems.FERTILITYSEED.getStackOf(), ChromaResearchManager.ResearchLevel.RAWEXPLORE, new ProgressionManager.ProgressStage[0]),
    ARTEFACT("Mysterious Artifacts", ChromaItems.ARTEFACT.getStackOf(), ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.ARTEFACT),
    ABILITYDESC("Abilities", ""),
    REACH(Chromabilities.REACH),
    MAGNET(Chromabilities.MAGNET),
    SONIC(Chromabilities.SONIC),
    SHIFT(Chromabilities.SHIFT),
    HEAL(Chromabilities.HEAL),
    SHIELD(Chromabilities.SHIELD),
    FIREBALL(Chromabilities.FIREBALL),
    COMMUNICATE(Chromabilities.COMMUNICATE),
    HEALTH(Chromabilities.HEALTH),
    PYLONPROTECT(Chromabilities.PYLON, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE),
    LIGHTNING(Chromabilities.LIGHTNING),
    LIFEPOINT(Chromabilities.LIFEPOINT),
    DEATHPROOF(Chromabilities.DEATHPROOF),
    SHOCKWAVE(Chromabilities.SHOCKWAVE),
    WARPLOC(Chromabilities.TELEPORT, ChromaResearchManager.ResearchLevel.ENDGAME),
    LEECH(Chromabilities.LEECH),
    FLOAT(Chromabilities.FLOAT),
    SPAWNERSEE(Chromabilities.SPAWNERSEE, ChromaResearchManager.ResearchLevel.ENDGAME),
    BREADCRUMB(Chromabilities.BREADCRUMB),
    RANGEBOOST(Chromabilities.RANGEDBOOST),
    DIMPING(Chromabilities.DIMPING, ChromaResearchManager.ResearchLevel.ENDGAME),
    DASH(Chromabilities.DASH),
    LASERBILITY(Chromabilities.LASER, ChromaResearchManager.ResearchLevel.ENDGAME),
    FIRERAIN(Chromabilities.FIRERAIN, ChromaResearchManager.ResearchLevel.CTM),
    KEEPINV(Chromabilities.KEEPINV, ChromaResearchManager.ResearchLevel.ENDGAME),
    ORECLIP(Chromabilities.ORECLIP, ChromaResearchManager.ResearchLevel.CTM),
    DOUBLECRAFT(Chromabilities.DOUBLECRAFT, ChromaResearchManager.ResearchLevel.CTM),
    GROWAURA(Chromabilities.GROWAURA, ChromaResearchManager.ResearchLevel.ENDGAME),
    RECHARGE(Chromabilities.RECHARGE, ChromaResearchManager.ResearchLevel.ENDGAME),
    MEINV(Chromabilities.MEINV, ChromaResearchManager.ResearchLevel.ENDGAME),
    MOBSEEK(Chromabilities.MOBSEEK, ChromaResearchManager.ResearchLevel.ENDGAME),
    BEEALYZE(Chromabilities.BEEALYZE),
    NUKER(Chromabilities.NUKER, ChromaResearchManager.ResearchLevel.ENDGAME),
    LIGHTCAST(Chromabilities.LIGHTCAST),
    STRUCTUREDESC("Structures", ""),
    PYLON(ChromaStructures.Structures.PYLON, 5, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, ProgressionManager.ProgressStage.PYLON),
    CASTING1(ChromaStructures.Structures.CASTING1, 0, ChromaResearchManager.ResearchLevel.BASICCRAFT, ProgressionManager.ProgressStage.CRYSTALS),
    CASTING2(ChromaStructures.Structures.CASTING2, 1, ChromaResearchManager.ResearchLevel.RUNECRAFT, ProgressionManager.ProgressStage.RUNEUSE),
    CASTING3(ChromaStructures.Structures.CASTING3, 2, ChromaResearchManager.ResearchLevel.NETWORKING, ProgressionManager.ProgressStage.MULTIBLOCK, ProgressionManager.ProgressStage.BLOWREPEATER),
    RITUAL(ChromaStructures.Structures.RITUAL, 7, ChromaResearchManager.ResearchLevel.CHARGESELF, ProgressionManager.ProgressStage.CHARGE),
    INFUSION(ChromaStructures.Structures.INFUSION, 12, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.CHROMA),
    TREE(ChromaStructures.Structures.TREE, 14, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.POWERCRYSTAL),
    REPEATERSTRUCT(ChromaStructures.Structures.REPEATER, 0, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, ProgressionManager.ProgressStage.RUNEUSE),
    COMPOUNDSTRUCT(ChromaStructures.Structures.COMPOUND, 13, ChromaResearchManager.ResearchLevel.NETWORKING, ProgressionManager.ProgressStage.REPEATER),
    CAVERN(ChromaStructures.Structures.CAVERN, 0, ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.CAVERN),
    BURROW(ChromaStructures.Structures.BURROW, 0, ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.BURROW),
    OCEAN(ChromaStructures.Structures.OCEAN, 0, ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.OCEAN),
    DESERT(ChromaStructures.Structures.DESERT, 0, ChromaResearchManager.ResearchLevel.RAWEXPLORE, ProgressionManager.ProgressStage.DESERTSTRUCT),
    PORTALSTRUCT(ChromaStructures.Structures.PORTAL, 0, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressionManager.ProgressStage.DIMENSION)),
    MINIPYLON(ChromaStructures.Structures.PERSONAL, 9, ChromaResearchManager.ResearchLevel.CHARGESELF, ProgressionManager.ProgressStage.CHARGE),
    BROADCASTER(ChromaStructures.Structures.BROADCAST, 15, ChromaResearchManager.ResearchLevel.NETWORKING, ProgressionManager.ProgressStage.MULTIBLOCK),
    CLOAKTOWER(ChromaStructures.Structures.CLOAKTOWER, 3, ChromaResearchManager.ResearchLevel.MULTICRAFT, ProgressionManager.ProgressStage.KILLMOB),
    BOOSTTREE(ChromaStructures.Structures.TREE_BOOSTED, 14, ChromaResearchManager.ResearchLevel.CTM, ProgressionManager.ProgressStage.TURBOCHARGE),
    BEACONSTRUCT(ChromaStructures.Structures.PROTECT, 6, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]),
    MINIREPEATER(ChromaStructures.Structures.WEAKREPEATER, Blocks.field_150364_r, 0, ChromaResearchManager.ResearchLevel.ENERGYEXPLORE, ProgressionManager.ProgressStage.PYLON),
    METEOR1(ChromaStructures.Structures.METEOR1, 12, ChromaResearchManager.ResearchLevel.PYLONCRAFT, new ProgressionManager.ProgressStage[0]),
    METEOR2(ChromaStructures.Structures.METEOR2, 12, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]),
    METEOR3(ChromaStructures.Structures.METEOR3, 12, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.DIMENSION),
    RITUAL2(ChromaStructures.Structures.RITUAL2, 7, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.DIMENSION),
    GATESTRUCT(ChromaStructures.Structures.TELEGATE, 2, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.END),
    RELAYSTRUCT(ChromaStructures.Structures.RELAY, 9, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.POWERCRYSTAL),
    PYLONBROADCAST(ChromaStructures.Structures.PYLONBROADCAST, 5, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.ProgressStage.DIMENSION),
    PYLONTURBORING(ChromaStructures.Structures.PYLONTURBO, 5, ChromaResearchManager.ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressionManager.ProgressStage.TURBOCHARGE)),
    WIRELESSPED(ChromaStructures.Structures.WIRELESSPEDESTAL, 13, ChromaResearchManager.ResearchLevel.ENDGAME, new ProgressionManager.ProgressStage[0]);

    private final ItemStack iconItem;
    private final String pageTitle;
    private boolean isParent = false;
    private ChromaTiles machine;
    private ChromaBlocks block;
    private ChromaItems item;
    private final ProgressionManager.ProgressStage[] progress;
    public final ChromaResearchManager.ResearchLevel level;
    private Chromabilities ability;
    private ChromaStructures.Structures struct;
    private int sectionIndex = 0;
    public static final ChromaResearch[] researchList;
    static final MultiMap<ChromaResearchManager.ResearchLevel, ChromaResearch> levelMap;
    private static final ItemHashMap<ChromaResearch> itemMap;
    private static final HashMap<AbilityAPI.Ability, ChromaResearch> abilityMap;
    private static final List<ChromaResearch> parents;
    private static final List<ChromaResearch> nonParents;
    private static final List<ChromaResearch> obtainable;
    private static final HashMap<String, ChromaResearch> byName;
    private static final IdentityHashMap<Object, ChromaResearch> duplicateChecker;

    private ChromaResearch() {
        this("");
    }

    private ChromaResearch(ChromaTiles r, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this(r.getName(), r.getCraftedProduct(), rl, p);
        this.machine = r;
    }

    private ChromaResearch(ChromaBlocks r, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this(r.getBasicName(), r.getStackOf(), rl, p);
        this.block = r;
    }

    private ChromaResearch(ChromaBlocks r, int meta, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this(r.getBasicName(), r.getStackOfMetadata(meta), rl, p);
        this.block = r;
    }

    private ChromaResearch(ChromaItems i, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this(i.getBasicName(), i.getStackOf(), rl, p);
        this.item = i;
    }

    private ChromaResearch(String name, String s) {
        this(name);
        this.isParent = true;
    }

    private ChromaResearch(String name) {
        this(name, (ItemStack)null, null, new ProgressionManager.ProgressStage[0]);
    }

    private ChromaResearch(String name, ChromaItems i, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this(name, i.getStackOf(), rl, p);
    }

    private ChromaResearch(String name, ChromaTiles r, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this(name, r.getCraftedProduct(), rl, p);
    }

    private ChromaResearch(String name, Item icon, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this(name, new ItemStack(icon), rl, p);
    }

    private ChromaResearch(String name, Block icon, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this(name, new ItemStack(icon), rl, p);
    }

    private ChromaResearch(String name, ItemStack icon, ChromaResearchManager.ResearchLevel rl, ProgressionManager.ProgressStage ... p) {
        this.iconItem = icon != null ? icon.func_77946_l() : null;
        this.pageTitle = name;
        this.progress = p;
        this.level = rl;
    }

    private ChromaResearch(Chromabilities c) {
        this(c, ChromaResearchManager.ResearchLevel.PYLONCRAFT);
    }

    private ChromaResearch(Chromabilities c, ChromaResearchManager.ResearchLevel rl) {
        this.iconItem = ChromaTiles.RITUAL.getCraftedProduct();
        this.pageTitle = c.getDisplayName();
        Collection<ProgressionManager.ProgressStage> p = AbilityHelper.instance.getProgressFor(c);
        if (rl == ChromaResearchManager.ResearchLevel.PYLONCRAFT) {
            for (ProgressionManager.ProgressStage ps : p) {
                if (!ps.isGatedAfter(ProgressionManager.ProgressStage.DIMENSION)) continue;
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Ability fragment " + c + " gated behind " + ps + " but is only level " + rl + "!");
            }
        }
        this.progress = p.toArray(new ProgressionManager.ProgressStage[p.size()]);
        this.level = rl;
        this.ability = c;
    }

    private ChromaResearch(ChromaStructures.Structures s, int meta, ChromaResearchManager.ResearchLevel r, ProgressionManager.ProgressStage ... p) {
        this(s, ChromaBlocks.PYLONSTRUCT.getBlockInstance(), meta, r, p);
    }

    private ChromaResearch(ChromaStructures.Structures s, Block b, int meta, ChromaResearchManager.ResearchLevel r, ProgressionManager.ProgressStage ... p) {
        this.iconItem = new ItemStack(b, 1, meta);
        this.pageTitle = s.getDisplayName();
        this.progress = p;
        this.level = r;
        this.struct = s;
    }

    public int sectionIndex() {
        return this.sectionIndex;
    }

    public boolean isAlwaysPresent() {
        return this == START || this == LEXICON;
    }

    public boolean playerCanSee(EntityPlayer ep) {
        if (this.isDummiedOut()) {
            return DragonAPICore.isReikasComputer();
        }
        if (this.progress != null) {
            for (int i = 0; i < this.progress.length; ++i) {
                ProgressionManager.ProgressStage p = this.progress[i];
                if (p.isPlayerAtStage(ep)) continue;
                return false;
            }
        }
        return ChromaResearchManager.instance.playerHasFragment(ep, this);
    }

    public boolean playerCanRead(EntityPlayer ep) {
        return this.playerCanSee(ep) || ChromaResearchManager.instance.canPlayerStepTo(ep, this);
    }

    public boolean playerHasProgress(EntityPlayer ep) {
        if (this.progress != null) {
            for (int i = 0; i < this.progress.length; ++i) {
                ProgressionManager.ProgressStage p = this.progress[i];
                if (p.isPlayerAtStage(ep)) continue;
                return false;
            }
        }
        return true;
    }

    public ProgressionManager.ProgressStage[] getRequiredProgress() {
        return Arrays.copyOf(this.progress, this.progress.length);
    }

    public boolean isMachine() {
        return this.machine != null;
    }

    public Chromabilities getAbility() {
        return this.ability;
    }

    public ChromaStructures.Structures getStructure() {
        return this.struct;
    }

    public ChromaTiles getMachine() {
        return this.machine;
    }

    public ChromaBlocks getBlock() {
        return this.block;
    }

    public ChromaItems getItem() {
        return this.item;
    }

    @SideOnly(value=Side.CLIENT)
    private ItemStack getTabIcon() {
        if (this == BEES) {
            return CrystalBees.getCrystalBee().getBeeItem((World)Minecraft.func_71410_x().field_71441_e, EnumBeeType.QUEEN);
        }
        if (this == TINKERTOOLS) {
            int mat = ExtraChromaIDs.CHROMAMATID.getValue();
            return TinkerToolHandler.Tools.HAMMER.getToolOfMaterials(mat, mat, mat, mat);
        }
        if (this == ENDERCRYS) {
            return this.item.getStackOfMetadata(1);
        }
        if (this == ACCEL) {
            return ChromaItems.ADJACENCY.getStackOfMetadata(CrystalElement.LIGHTBLUE.ordinal());
        }
        return this.iconItem;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderIcon(RenderItem ri, FontRenderer fr, int x, int y) {
        this.drawTabIcon(ri, x, y);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawTabIcon(RenderItem ri, int x, int y) {
        if (this == START) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ReikaGuiAPI.instance.func_94065_a(x, y + 1, ChromaIcons.QUESTION.getIcon(), 16, 14);
            GL11.glPopAttrib();
            return;
        }
        if (this == BALLLIGHTNING) {
            EntityBallLightning eb = new EntityBallLightning((World)Minecraft.func_71410_x().field_71441_e);
            eb.field_70128_L = true;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            double d = 8.0;
            GL11.glTranslated((double)((double)x + d), (double)((double)y + d), (double)0.0);
            double s = 18.0;
            GL11.glScaled((double)(-s), (double)s, (double)1.0);
            ReikaEntityHelper.getEntityRenderer(EntityBallLightning.class).func_76986_a((Entity)eb, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
            return;
        }
        if (this == PACKCHANGES) {
            ReikaTextureHelper.bindTerrainTexture();
            ReikaGuiAPI.instance.func_94065_a(x, y + 1, ChromaIcons.QUESTION.getIcon(), 16, 14);
            return;
        }
        if (this == NODENET) {
            ItemStack is = ThaumItemHelper.BlockEntry.NODE.getItem();
            GL11.glPushMatrix();
            double s = 2.0;
            GL11.glTranslated((double)(x - 8), (double)(y - 6), (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)1.0);
            ReikaGuiAPI.instance.drawItemStack(ri, is, 0, 0);
            GL11.glPopMatrix();
            return;
        }
        if (this == TURBO) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            GL11.glRotated((double)0.0, (double)0.0, (double)0.0, (double)1.0);
            int ds = 4;
            ReikaGuiAPI.instance.func_94065_a(x - ds, y - ds, ChromaIcons.TURBO.getIcon(), 16 + ds * 2, 16 + ds * 2);
            ds = -1;
            float f = 0.5f;
            GL11.glColor4f((float)f, (float)f, (float)f, (float)f);
            ReikaGuiAPI.instance.func_94065_a(x - ds, y - ds, ChromaIcons.RADIATE.getIcon(), 16 + ds * 2, 16 + ds * 2);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            return;
        }
        if (this == APIRECIPES) {
            ArrayList<ItemStack> ico = new ArrayList<ItemStack>();
            for (CastingRecipe cr : RecipesCastingTable.instance.getAllAPIRecipes()) {
                if (ReikaItemHelper.collectionContainsItemStack(ico, (ItemStack)cr.getOutput())) continue;
                ico.add(cr.getOutput());
            }
            for (CastingRecipe cr : RecipesCastingTable.instance.getAllModdedItemRecipes()) {
                if (ReikaItemHelper.collectionContainsItemStack(ico, (ItemStack)cr.getOutput())) continue;
                ico.add(cr.getOutput());
            }
            if (!ico.isEmpty()) {
                int idx = (int)(System.currentTimeMillis() / 400L % (long)ico.size());
                ReikaGuiAPI.instance.drawItemStack(ri, ReikaItemHelper.getSizedItemStack((ItemStack)((ItemStack)ico.get(idx)), (int)1), x, y);
            } else {
                ReikaGuiAPI.instance.func_94065_a(x, y, ChromaIcons.NOENTER.getIcon(), 16, 16);
            }
            return;
        }
        float zp = ri.field_77023_b;
        if (this.isUnloadable()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            ReikaGuiAPI.instance.func_94065_a(x, y, ChromaIcons.NOENTER.getIcon(), 16, 16);
            GL11.glPopAttrib();
            ri.field_77023_b = 0.0f;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-50.0);
        ItemStack ico = this.getTabIcon().func_77946_l();
        if (ico.field_77990_d == null) {
            ico.field_77990_d = new NBTTagCompound();
        }
        ico.field_77990_d.func_74757_a("tooltip", true);
        ReikaGuiAPI.instance.drawItemStack(ri, ico, x, y);
        ri.field_77023_b = zp;
        if (this == DIMENSION3) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glTranslated((double)0.0, (double)0.0, (double)-240.0);
            int s = 32;
            int ds = (s - 16) / 2;
            ReikaGuiAPI.instance.func_94065_a(x - ds, y - ds, ChromaIcons.PURPLESPIN.getIcon(), s, s);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public boolean isUnloadable() {
        return !ChromatiCraft.instance.isDimensionLoadable() && (this == DIMENSION || this == DIMENSION2 || this == PORTAL || this == PORTALSTRUCT);
    }

    public String getData() {
        if (this == PACKCHANGES) {
            return "These are changes made to the way the mod works by the creator of the pack. None of these are normal behavior of the mod, and any negative effects of these changes should be discussed with the pack creator, not the mod developer.";
        }
        return ChromaDescriptions.getData(this);
    }

    public String getNotes(int subpage) {
        if (this == PACKCHANGES) {
            return ((PackModificationTracker.PackModification)PackModificationTracker.instance.getModifications((DragonAPIMod)ChromatiCraft.instance).get(subpage - 1)).toString();
        }
        if (this == ACCEL) {
            return ChromaDescriptions.getNotes(this, subpage - 1);
        }
        return ChromaDescriptions.getNotes(this, 0);
    }

    public boolean sameTextAllSubpages() {
        return false;
    }

    public boolean isGating() {
        if (this.isDummiedOut()) {
            return false;
        }
        if (this.isMachine() && this.getMachine().isIncomplete()) {
            return false;
        }
        if (this == DEATHPROOF) {
            return false;
        }
        if (this == BEES) {
            return false;
        }
        if (this == BEEFRAME) {
            return false;
        }
        if (this == TINKERTOOLS) {
            return false;
        }
        if (this == BALLLIGHTNING) {
            return false;
        }
        if (this.requiresProgress(ProgressionManager.ProgressStage.TOWER) || this.requiresProgress(ProgressionManager.ProgressStage.ARTEFACT)) {
            return false;
        }
        return this.struct == null || !this.struct.isNatural();
    }

    public boolean isAbility() {
        if (this.isParent) {
            return false;
        }
        return this.getParent() == ABILITYDESC;
    }

    public boolean isCrafting() {
        if (this.isParent) {
            return false;
        }
        if (this == APIRECIPES) {
            return true;
        }
        if (this == TURBOREPEATER) {
            return true;
        }
        if (this.isMachine() || this.isTool()) {
            return true;
        }
        if (this == GROUPS) {
            return true;
        }
        if (this == CORES) {
            return true;
        }
        if (this == HICORES) {
            return true;
        }
        if (this == ALLOYS) {
            return true;
        }
        if (this == IRID) {
            return true;
        }
        if (this == TINKERTOOLS) {
            return true;
        }
        if (this == SEED) {
            return true;
        }
        if (this == AUGMENT) {
            return true;
        }
        if (this == RELAY) {
            return true;
        }
        if (this == RUNES) {
            return true;
        }
        if (this == TANKAUX) {
            return true;
        }
        if (this == FENCEAUX) {
            return true;
        }
        if (this == TNT) {
            return true;
        }
        if (this == LAMPAUX) {
            return true;
        }
        if (this == CRYSTALLAMP || this == SUPERLAMP) {
            return true;
        }
        if (this == CRYSTALSTONE) {
            return true;
        }
        if (this == PATH) {
            return true;
        }
        if (this == GLOW) {
            return true;
        }
        if (this == PORTAL) {
            return true;
        }
        if (this == HEATLAMP) {
            return true;
        }
        if (this == COLORALTAR) {
            return true;
        }
        if (this == DOOR) {
            return true;
        }
        if (this == GLASS) {
            return true;
        }
        if (this == MUSICTRIGGER) {
            return true;
        }
        if (this == SELECTIVEGLASS) {
            return true;
        }
        if (this == AVOLAMP) {
            return true;
        }
        return this == REPEATERLAMP;
    }

    public boolean isTool() {
        return this.getParent() == TOOLDESC;
    }

    public boolean requiresProgress(ProgressionManager.ProgressStage p) {
        for (int i = 0; i < this.progress.length; ++i) {
            if (this.progress[i] != p) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getItemStacks() {
        if (this == ACCEL) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 16; ++i) {
                if (!AdjacencyUpgrades.upgrades[i].isImplemented()) continue;
                for (int k = 0; k < 8; ++k) {
                    ItemStack is = ChromaItems.ADJACENCY.getStackOfMetadata(i);
                    is.field_77990_d = new NBTTagCompound();
                    is.field_77990_d.func_74768_a("tier", k);
                    li.add(is);
                }
            }
            return li;
        }
        if (this == ROUTER) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(this.machine.getCraftedProduct());
            li.add(ChromaBlocks.ROUTERNODE.getStackOfMetadata(0));
            li.add(ChromaBlocks.ROUTERNODE.getStackOfMetadata(1));
            return li;
        }
        if (this == FOCUSCRYSTALS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < TileEntityFocusCrystal.CrystalTier.tierList.length; ++i) {
                li.add(TileEntityFocusCrystal.CrystalTier.tierList[i].getCraftedItem());
            }
            return li;
        }
        if (this.isMachine()) {
            return ReikaJavaLibrary.makeListFrom((Object)this.machine.getCraftedProduct());
        }
        if (this == TURBOREPEATER) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.turboRepeater);
            li.add(ChromaStacks.turboMultiRepeater);
            li.add(ChromaStacks.turboBroadcastRepeater);
            return li;
        }
        if (this == STORAGE) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaItems.STORAGE.getNumberMetadatas(); ++i) {
                li.add(ChromaItems.STORAGE.getStackOfMetadata(i));
            }
            return li;
        }
        if (this == GLOW) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 48; ++i) {
                li.add(ChromaBlocks.GLOW.getStackOfMetadata(i));
            }
            return li;
        }
        if (this == RELAY) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaTiles.RELAYSOURCE.getCraftedProduct());
            li.add(ChromaBlocks.RELAYFILTER.getStackOf());
            for (int i = 0; i < 16; ++i) {
                li.add(ChromaBlocks.RELAY.getStackOfMetadata(i));
            }
            li.add(ChromaBlocks.RELAY.getStackOfMetadata(16));
            li.add(ChromaBlocks.FLOATINGRELAY.getStackOf());
            return li;
        }
        if (this == PENDANT) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 16; ++i) {
                li.add(ChromaItems.PENDANT.getStackOfMetadata(i));
                li.add(ChromaItems.PENDANT3.getStackOfMetadata(i));
            }
            return li;
        }
        if (this == ENDERCRYS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaItems.ENDERCRYSTAL.getStackOfMetadata(0));
            li.add(ChromaItems.ENDERCRYSTAL.getStackOfMetadata(1));
            return li;
        }
        if (this == AUGMENT) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.speedUpgrade);
            li.add(ChromaStacks.efficiencyUpgrade);
            li.add(ChromaStacks.silkUpgrade);
            return li;
        }
        if (this.item != null) {
            if (this.item.getItemInstance() instanceof ItemCrystalBasic) {
                ArrayList<ItemStack> li = new ArrayList<ItemStack>();
                for (int i = 0; i < 16; ++i) {
                    li.add(this.item.getStackOfMetadata(i));
                }
                return li;
            }
            return ReikaJavaLibrary.makeListFrom((Object)this.item.getStackOf());
        }
        if (this.iconItem != null && this.iconItem.func_77973_b() instanceof ItemCrystalBasic) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 16; ++i) {
                li.add(new ItemStack(this.iconItem.func_77973_b(), 1, i));
            }
            return li;
        }
        if (this == GROUPS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 13; ++i) {
                li.add(ChromaItems.CLUSTER.getStackOfMetadata(i));
            }
            return li;
        }
        if (this == ALLOYS) {
            return new ArrayList<ItemStack>(PoolRecipes.instance.getAllOutputItems());
        }
        if (this == ORES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.chromaDust);
            for (int i = 0; i < 16; ++i) {
                li.add(ChromaItems.ELEMENTAL.getStackOfMetadata(i));
            }
            li.add(ChromaStacks.focusDust);
            li.add(ChromaStacks.bindingCrystal);
            li.add(ChromaStacks.enderDust);
            li.add(ChromaStacks.waterDust);
            li.add(ChromaStacks.firaxite);
            li.add(ChromaStacks.spaceDust);
            li.add(ChromaStacks.resocrystal);
            li.add(ChromaStacks.lumaDust);
            li.add(ChromaStacks.echoCrystal);
            li.add(ChromaStacks.fireEssence);
            li.add(ChromaStacks.thermiticCrystal);
            li.add(ChromaStacks.lumenGem);
            li.add(ChromaStacks.avolite);
            li.add(ChromaStacks.echoCrystal);
            return li;
        }
        if (this == DUSTS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.auraDust);
            li.add(ChromaStacks.purityDust);
            li.add(ChromaStacks.elementDust);
            li.add(ChromaStacks.beaconDust);
            li.add(ChromaStacks.resonanceDust);
            li.add(ChromaStacks.teleDust);
            li.add(ChromaStacks.icyDust);
            li.add(ChromaStacks.etherBerries);
            li.add(ChromaStacks.energyPowder);
            li.add(ChromaStacks.livingEssence);
            li.add(ChromaStacks.voidDust);
            return li;
        }
        if (this == IRID) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.rawCrystal);
            li.add(ChromaStacks.iridCrystal);
            li.add(ChromaStacks.iridChunk);
            return li;
        }
        if (this == CORES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.crystalFocus);
            li.add(ChromaStacks.energyCore);
            li.add(ChromaStacks.transformCore);
            li.add(ChromaStacks.voidCore);
            li.add(ChromaStacks.elementUnit);
            li.add(ChromaStacks.crystalLens);
            return li;
        }
        if (this == HICORES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.energyCoreHigh);
            li.add(ChromaStacks.transformCoreHigh);
            li.add(ChromaStacks.voidCoreHigh);
            li.add(ChromaStacks.glowChunk);
            li.add(ChromaStacks.lumenCore);
            return li;
        }
        if (this == PATH) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaBlocks.PATH.getNumberMetadatas(); ++i) {
                li.add(new ItemStack(ChromaBlocks.PATH.getBlockInstance(), 1, i));
            }
            return li;
        }
        if (this == REPEATERLAMP) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaBlocks.REPEATERLAMP.getNumberMetadatas(); ++i) {
                li.add(new ItemStack(ChromaBlocks.REPEATERLAMP.getBlockInstance(), 1, i));
            }
            return li;
        }
        if (this == CRYSTALSTONE) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaBlocks.PYLONSTRUCT.getNumberMetadatas(); ++i) {
                li.add(new ItemStack(ChromaBlocks.PYLONSTRUCT.getBlockInstance(), 1, i));
            }
            return li;
        }
        if (this == BEES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            World world = ReikaWorldHelper.getBasicReferenceWorld();
            Collection<BeeSpecies> c = CrystalBees.getBasicBees();
            for (BeeSpecies b : c) {
                li.add(b.getBeeItem(world, EnumBeeType.DRONE));
                li.add(b.getBeeItem(world, EnumBeeType.PRINCESS));
                li.add(b.getBeeItem(world, EnumBeeType.QUEEN));
            }
            for (int i = 0; i < 16; ++i) {
                CrystalElement e = CrystalElement.elements[i];
                li.add(CrystalBees.getElementalBee(e).getBeeItem(world, EnumBeeType.DRONE));
                li.add(CrystalBees.getElementalBee(e).getBeeItem(world, EnumBeeType.PRINCESS));
                li.add(CrystalBees.getElementalBee(e).getBeeItem(world, EnumBeeType.QUEEN));
            }
            c = CrystalBees.getAdvancedBees();
            for (BeeSpecies b : c) {
                li.add(b.getBeeItem(world, EnumBeeType.DRONE));
                li.add(b.getBeeItem(world, EnumBeeType.PRINCESS));
                li.add(b.getBeeItem(world, EnumBeeType.QUEEN));
            }
            return li;
        }
        if (this == TINKERTOOLS) {
            int i;
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (i = 0; i < TinkerToolHandler.ToolParts.partList.length; ++i) {
                li.add(TinkerToolHandler.ToolParts.partList[i].getItem(ExtraChromaIDs.CHROMAMATID.getValue()));
            }
            for (i = 0; i < TinkerToolHandler.WeaponParts.partList.length; ++i) {
                li.add(TinkerToolHandler.ToolParts.partList[i].getItem(ExtraChromaIDs.CHROMAMATID.getValue()));
            }
            return li;
        }
        if (this.block != null) {
            Item item = Item.func_150898_a((Block)this.block.getBlockInstance());
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            if (item instanceof ItemBlockDyeTypes || item instanceof ItemBlockCrystalColors || item instanceof ItemBlockCrystal) {
                for (int i = 0; i < 16; ++i) {
                    li.add(this.block.getStackOfMetadata(i));
                }
            } else {
                li.add(this.block.getStackOf());
            }
            return li;
        }
        if (this == FENCEAUX || this == TNT || this == TANKAUX) {
            return ReikaJavaLibrary.makeListFrom((Object)this.iconItem);
        }
        if (this == APIRECIPES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (CastingRecipe c : RecipesCastingTable.instance.getAllAPIRecipes()) {
                li.add(c.getOutput());
            }
            for (CastingRecipe c : RecipesCastingTable.instance.getAllModdedItemRecipes()) {
                li.add(c.getOutput());
            }
            return li;
        }
        return null;
    }

    public int getRecipeCount() {
        return this.getCraftingRecipes().size();
    }

    public int getVanillaRecipeCount() {
        return this.getVanillaRecipes().size();
    }

    public boolean isCraftable() {
        if (this == ALLOYS) {
            return true;
        }
        if (!this.isConfigDisabled() && this.isCrafting()) {
            return this.isVanillaRecipe() ? this.getVanillaRecipeCount() > 0 : this.getRecipeCount() > 0;
        }
        return false;
    }

    public boolean isVanillaRecipe() {
        switch (this) {
            case CASTTABLE: 
            case WAND: {
                return true;
            }
        }
        return false;
    }

    public boolean crafts(ItemStack is) {
        if (!this.isCrafting()) {
            return false;
        }
        if (this == ALLOYS) {
            return ReikaItemHelper.listContainsItemStack(this.getItemStacks(), (ItemStack)is, (boolean)false);
        }
        if (this.isVanillaRecipe()) {
            for (IRecipe ir : this.getVanillaRecipes()) {
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ir.func_77571_b())) continue;
                return true;
            }
        } else {
            for (CastingRecipe c : this.getCraftingRecipes()) {
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)c.getOutput())) continue;
                return true;
            }
        }
        return false;
    }

    public ChromaGuis getCraftingType() {
        if (this == ALLOYS) {
            return ChromaGuis.ALLOYING;
        }
        return this.isVanillaRecipe() ? ChromaGuis.CRAFTING : ChromaGuis.RECIPE;
    }

    public ArrayList<CastingRecipe> getCraftingRecipes() {
        if (this == APIRECIPES) {
            HashSet<CastingRecipe> li = new HashSet<CastingRecipe>();
            li.addAll(RecipesCastingTable.instance.getAllAPIRecipes());
            li.addAll(RecipesCastingTable.instance.getAllModdedItemRecipes());
            return new ArrayList<CastingRecipe>(li);
        }
        if (this == TURBOREPEATER) {
            ArrayList<CastingRecipe> li = new ArrayList<CastingRecipe>();
            for (CastingRecipe cr : RecipesCastingTable.instance.getAllRecipes()) {
                if (!(cr instanceof RepeaterTurboRecipe)) continue;
                li.add(cr);
            }
            return li;
        }
        if (!this.isCrafting()) {
            return new ArrayList<CastingRecipe>();
        }
        ArrayList<ItemStack> li = this.getItemStacks();
        if (li == null || li.isEmpty()) {
            return new ArrayList<CastingRecipe>();
        }
        ArrayList<CastingRecipe> rec = new ArrayList<CastingRecipe>();
        for (ItemStack is : li) {
            ArrayList<CastingRecipe> cr = RecipesCastingTable.instance.getAllRecipesMaking(is);
            for (CastingRecipe c : cr) {
                if (!c.isIndexed()) continue;
                rec.add(c);
            }
        }
        return rec;
    }

    public int getRecipeIndex(ItemStack is) {
        if (this == ALLOYS) {
            return new ArrayList<PoolRecipes.PoolRecipe>(PoolRecipes.instance.getAllPoolRecipes()).indexOf(PoolRecipes.instance.getPoolRecipeByOutput(is));
        }
        if (this == METEOR && is.field_77990_d != null) {
            return is.field_77990_d.func_74762_e("tier");
        }
        ArrayList<CastingRecipe> li = this.getCraftingRecipes();
        for (int i = 0; i < li.size(); ++i) {
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)li.get(i).getOutput())) continue;
            return i;
        }
        return 0;
    }

    public CastingRecipe.RecipeType getRecipeLevel(int recipe) {
        ArrayList<CastingRecipe> li = this.getCraftingRecipes();
        if (li.isEmpty()) {
            return null;
        }
        return li.get((int)recipe).type;
    }

    public ArrayList<IRecipe> getVanillaRecipes() {
        if (!this.isCrafting()) {
            return new ArrayList<IRecipe>();
        }
        ArrayList<ItemStack> li = this.getItemStacks();
        if (li == null || li.isEmpty()) {
            return new ArrayList<IRecipe>();
        }
        ArrayList<IRecipe> rec = new ArrayList<IRecipe>();
        for (ItemStack is : li) {
            rec.addAll(ReikaRecipeHelper.getAllRecipesByOutput((List)CraftingManager.func_77594_a().func_77592_b(), (ItemStack)is));
        }
        return rec;
    }

    @Override
    public String getTitle() {
        if (this == ACCEL) {
            return "Adjacency Cores";
        }
        return this.pageTitle;
    }

    public ChromaResearch getParent() {
        ChromaResearch parent = null;
        for (int i = 0; i < researchList.length; ++i) {
            if (!ChromaResearch.researchList[i].isParent || this.ordinal() < researchList[i].ordinal()) continue;
            parent = researchList[i];
        }
        return parent;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public boolean isConfigDisabled() {
        if (this.machine != null) {
            return this.machine.isConfigDisabled();
        }
        if (this.item != null) {
            return this.item.isConfigDisabled();
        }
        return false;
    }

    public boolean isDummiedOut() {
        if (this.machine != null) {
            return this.machine.isDummiedOut();
        }
        if (this.item != null) {
            return this.item.isDummiedOut();
        }
        if (this.ability != null) {
            return this.ability.isDummiedOut();
        }
        if (this == APIRECIPES && DragonAPICore.hasGameLoaded()) {
            return RecipesCastingTable.instance.getAllAPIRecipes().isEmpty() && RecipesCastingTable.instance.getAllModdedItemRecipes().isEmpty();
        }
        if (this == PACKCHANGES && !PackModificationTracker.instance.modificationsExist((DragonAPIMod)ChromatiCraft.instance)) {
            return true;
        }
        if (this == AUGMENT) {
            return false;
        }
        Dependency dep = this.getDependency();
        if (dep != null && !dep.isLoaded()) {
            return true;
        }
        for (int i = 0; i < this.progress.length; ++i) {
            if (this.progress[i].active) continue;
            return true;
        }
        return false;
    }

    public Dependency getDependency() {
        switch (this) {
            case BEES: {
                return ModList.FORESTRY;
            }
            case TINKERTOOLS: {
                return ModList.TINKERER;
            }
            case RFDISTRIB: {
                return PowerTypes.RF;
            }
            case BALLLIGHTNING: {
                return ChromaOptions.BALLLIGHTNING;
            }
            case NODENET: {
                return ModList.THAUMCRAFT;
            }
            case MYSTPAGE: {
                return ModList.MYSTCRAFT;
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getShortDesc() {
        return "Something new to investigate";
    }

    @Override
    public String getFormatting() {
        return EnumChatFormatting.ITALIC.toString();
    }

    private Object getIDObject() {
        if (this.machine != null) {
            return this.machine;
        }
        if (this.block != null) {
            return this.block;
        }
        if (this.item != null) {
            return this.item;
        }
        if (this.ability != null) {
            return this.ability;
        }
        if (this.struct != null) {
            return this.struct;
        }
        return this.ordinal();
    }

    public static void loadPostCache() {
        for (int i = 0; i < researchList.length; ++i) {
            ChromaResearch r = researchList[i];
            if (r.isDummiedOut()) continue;
            try {
                ArrayList<ItemStack> c = r.getItemStacks();
                if (c != null) {
                    for (ItemStack is : c) {
                        if (is == null || is.func_77973_b() == null) continue;
                        itemMap.put(is, (Object)r);
                    }
                }
                ArrayList<CastingRecipe> crc = r.getCraftingRecipes();
                for (CastingRecipe cr : crc) {
                    cr.setFragment(r);
                }
                if (r.ability == null) continue;
                abilityMap.put(r.ability, r);
                continue;
            }
            catch (Exception e) {
                Dependency dep = r.getDependency();
                if (dep != null && !(dep instanceof ConfigList)) {
                    e.printStackTrace();
                    throw new InstallationException((DragonAPIMod)ChromatiCraft.instance, "Another mod/API, '" + dep.getDisplayName() + "' is an incompatible version. Update both mods if possible, or if updating " + dep.getDisplayName() + " caused this, revert to the previous version.");
                }
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not initialize Info Fragment '" + r + "'!", e);
            }
        }
    }

    public static ArrayList<ChromaResearch> getInfoTabs() {
        return ChromaResearch.getAllUnder(INTRO);
    }

    public static ArrayList<ChromaResearch> getMachineTabs() {
        return ChromaResearch.getAllUnder(MACHINEDESC);
    }

    public static ArrayList<ChromaResearch> getBlockTabs() {
        return ChromaResearch.getAllUnder(BLOCKS);
    }

    public static ArrayList<ChromaResearch> getAbilityTabs() {
        return ChromaResearch.getAllUnder(ABILITYDESC);
    }

    public static ArrayList<ChromaResearch> getToolTabs() {
        return ChromaResearch.getAllUnder(TOOLDESC);
    }

    public static ArrayList<ChromaResearch> getResourceTabs() {
        return ChromaResearch.getAllUnder(RESOURCEDESC);
    }

    public static ArrayList<ChromaResearch> getStructureTabs() {
        return ChromaResearch.getAllUnder(STRUCTUREDESC);
    }

    private static ArrayList<ChromaResearch> getAllUnder(ChromaResearch parent) {
        ChromaResearch r;
        ArrayList<ChromaResearch> li = new ArrayList<ChromaResearch>();
        for (int i = parent.ordinal() + 1; i < researchList.length && (r = researchList[i]).getParent() == parent; ++i) {
            li.add(r);
        }
        return li;
    }

    public static ChromaResearch getPageFor(ItemStack is) {
        return (ChromaResearch)itemMap.get(is);
    }

    public static ChromaResearch getPageFor(Chromabilities a) {
        return abilityMap.get(a);
    }

    public static List<ChromaResearch> getAllParents() {
        return Collections.unmodifiableList(parents);
    }

    public static List<ChromaResearch> getAllNonParents() {
        return Collections.unmodifiableList(nonParents);
    }

    public static List<ChromaResearch> getAllObtainableFragments() {
        return Collections.unmodifiableList(obtainable);
    }

    public static ChromaResearch getByName(String s) {
        return byName.get(s);
    }

    @Override
    public boolean giveToPlayer(EntityPlayer ep, boolean notify) {
        return ChromaResearchManager.instance.givePlayerFragment(ep, this, notify);
    }

    public boolean playerCanSeeRecipe(ItemStack is, EntityPlayer ep) {
        if (this == ALLOYS) {
            return PoolRecipes.instance.getPoolRecipeByOutput(is).playerHasProgress(ep);
        }
        return true;
    }

    static {
        researchList = ChromaResearch.values();
        levelMap = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());
        itemMap = new ItemHashMap();
        abilityMap = new HashMap();
        parents = new ArrayList<ChromaResearch>();
        nonParents = new ArrayList<ChromaResearch>();
        obtainable = new ArrayList<ChromaResearch>();
        byName = new HashMap();
        duplicateChecker = new IdentityHashMap();
        int index = 0;
        for (int i = 0; i < researchList.length; ++i) {
            ChromaResearch pre;
            ChromaResearch r = researchList[i];
            if (!r.isDummiedOut()) {
                if (r.level != null) {
                    levelMap.addValue((Object)r.level, (Object)r);
                }
                byName.put(r.name(), r);
                if (r.isParent) {
                    parents.add(r);
                    ++index;
                } else {
                    nonParents.add(r);
                    if (!r.isAlwaysPresent()) {
                        obtainable.add(r);
                    }
                    r.sectionIndex = index;
                }
            }
            if ((pre = duplicateChecker.get(r.getIDObject())) != null) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Two research fragments have the same block/item/ability/etc: " + r + " & " + pre);
            }
            duplicateChecker.put(r.getIDObject(), r);
            ChromaResearchManager.instance.register(r);
        }
    }
}

