/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.Base.ItemCrystalBasic;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.ChromaNames;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemAdjacencyPlacer;
import Reika.ChromatiCraft.Items.ItemChromaBerry;
import Reika.ChromatiCraft.Items.ItemChromaCrafting;
import Reika.ChromatiCraft.Items.ItemChromaMisc;
import Reika.ChromatiCraft.Items.ItemChromaPlacer;
import Reika.ChromatiCraft.Items.ItemCluster;
import Reika.ChromatiCraft.Items.ItemCrystalSeeds;
import Reika.ChromatiCraft.Items.ItemCrystalShard;
import Reika.ChromatiCraft.Items.ItemDimGen;
import Reika.ChromatiCraft.Items.ItemElementalStone;
import Reika.ChromatiCraft.Items.ItemFertilitySeed;
import Reika.ChromatiCraft.Items.ItemInfoFragment;
import Reika.ChromatiCraft.Items.ItemLinkedTilePlacer;
import Reika.ChromatiCraft.Items.ItemMagicBranch;
import Reika.ChromatiCraft.Items.ItemStorageCrystal;
import Reika.ChromatiCraft.Items.ItemTieredResource;
import Reika.ChromatiCraft.Items.ItemUnknownArtefact;
import Reika.ChromatiCraft.Items.Tools.ItemAuraPouch;
import Reika.ChromatiCraft.Items.Tools.ItemBulkMover;
import Reika.ChromatiCraft.Items.Tools.ItemCaveExitFinder;
import Reika.ChromatiCraft.Items.Tools.ItemChainGun;
import Reika.ChromatiCraft.Items.Tools.ItemChromaBook;
import Reika.ChromatiCraft.Items.Tools.ItemChromaBucket;
import Reika.ChromatiCraft.Items.Tools.ItemConnector;
import Reika.ChromatiCraft.Items.Tools.ItemCrystalCard;
import Reika.ChromatiCraft.Items.Tools.ItemCrystalPotion;
import Reika.ChromatiCraft.Items.Tools.ItemDataCrystal;
import Reika.ChromatiCraft.Items.Tools.ItemDoorKey;
import Reika.ChromatiCraft.Items.Tools.ItemEfficiencyCrystal;
import Reika.ChromatiCraft.Items.Tools.ItemEnderCrystal;
import Reika.ChromatiCraft.Items.Tools.ItemFloatstoneBoots;
import Reika.ChromatiCraft.Items.Tools.ItemInventoryLinker;
import Reika.ChromatiCraft.Items.Tools.ItemKillAuraGun;
import Reika.ChromatiCraft.Items.Tools.ItemManipulator;
import Reika.ChromatiCraft.Items.Tools.ItemMultiTool;
import Reika.ChromatiCraft.Items.Tools.ItemOrePick;
import Reika.ChromatiCraft.Items.Tools.ItemOreSilker;
import Reika.ChromatiCraft.Items.Tools.ItemOwnerKey;
import Reika.ChromatiCraft.Items.Tools.ItemPendant;
import Reika.ChromatiCraft.Items.Tools.ItemPurifyCrystal;
import Reika.ChromatiCraft.Items.Tools.ItemPylonFinder;
import Reika.ChromatiCraft.Items.Tools.ItemSplashGun;
import Reika.ChromatiCraft.Items.Tools.ItemSplineAttack;
import Reika.ChromatiCraft.Items.Tools.ItemStructureFinder;
import Reika.ChromatiCraft.Items.Tools.ItemThrowableGem;
import Reika.ChromatiCraft.Items.Tools.ItemVacuumGun;
import Reika.ChromatiCraft.Items.Tools.ItemWarpCapsule;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemBuilderWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemCaptureWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemDuplicationWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemExcavationWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemFlightWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemGrowthWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemLightWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemMobSonar;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemMobilityWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemResetWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemShooWand;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemTransitionWand;
import Reika.ChromatiCraft.ModInterface.AE.ItemCrystalCell;
import Reika.ChromatiCraft.ModInterface.AE.ItemVoidStorage;
import Reika.ChromatiCraft.ModInterface.Bees.ItemChromaBeeFrame;
import Reika.ChromatiCraft.ModInterface.ItemColoredModInteract;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ItemWarpProofer;
import Reika.ChromatiCraft.Registry.AdjacencyUpgrades;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Plants.TileEntityCrystalPlant;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Interfaces.Registry.ItemEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StatCollector;

public enum ChromaItems implements ItemEnum
{
    BUCKET(16, true, "chroma.bucket", ItemChromaBucket.class),
    PLACER(0, true, "chroma.placer", ItemChromaPlacer.class),
    LINK(0, false, "chroma.invlink", ItemInventoryLinker.class),
    RIFT(0, false, "chroma.rift", ItemLinkedTilePlacer.class),
    ADJACENCY(0, true, "chroma.adjacency", ItemAdjacencyPlacer.class),
    TOOL(32, false, "chroma.tool", ItemManipulator.class),
    SHARD(64, true, "crystal.shard", ItemCrystalShard.class),
    POTION(0, true, "crystal.potion", ItemCrystalPotion.class),
    CLUSTER(80, true, "crystal.cluster", ItemCluster.class),
    PENDANT(96, true, "crystal.pendant", ItemPendant.class),
    PENDANT3(112, true, "crystal.pendant3", ItemPendant.class),
    SEED(128, true, "crystal.seeds", ItemCrystalSeeds.class),
    ENDERCRYSTAL(0, true, "chroma.endercrystal", ItemEnderCrystal.class),
    DYE(48, true, "dye.item", ItemCrystalBasic.class),
    EXCAVATOR(80, false, "chroma.excavator", ItemExcavationWand.class),
    VACUUMGUN(8, false, "chroma.vac", ItemVacuumGun.class),
    CRAFTING(0, true, "chroma.craft", ItemChromaCrafting.class),
    LENS(144, true, "chroma.lens", ItemCrystalBasic.class),
    STORAGE(2, true, "chroma.storage", ItemStorageCrystal.class),
    LINKTOOL(3, false, "chroma.linker", ItemConnector.class),
    BERRY(176, true, "chroma.berry", ItemChromaBerry.class),
    FINDER(4, false, "chroma.finder", ItemPylonFinder.class),
    TIERED(128, true, "chroma.tiered", ItemTieredResource.class),
    ELEMENTAL(192, true, "chroma.elemental", ItemElementalStone.class),
    TRANSITION(81, false, "chroma.transition", ItemTransitionWand.class),
    HELP(5, false, "chroma.helpitem", ItemChromaBook.class),
    WARP(7, true, "chroma.warp", ItemWarpProofer.class, ModList.THAUMCRAFT),
    MISC(224, true, "chroma.misc", ItemChromaMisc.class),
    FRAGMENT(9, true, "chroma.fragment", ItemInfoFragment.class),
    DUPLICATOR(82, false, "chroma.duplicator", ItemDuplicationWand.class),
    TELEPORT(83, false, "chroma.teleport", ItemMobilityWand.class),
    BUILDER(84, false, "chroma.builder", ItemBuilderWand.class),
    CAPTURE(85, false, "chroma.capture", ItemCaptureWand.class),
    VOIDCELL(10, false, "chroma.aecell", ItemVoidStorage.class, ModList.APPENG),
    MODINTERACT(176, true, "chroma.modinteract", ItemChromaMisc.class),
    MULTITOOL(25, false, "chroma.multitool", ItemMultiTool.class),
    SHOO(86, false, "chroma.shoo", ItemShooWand.class),
    OREPICK(27, false, "chroma.orepick", ItemOrePick.class),
    ORESILK(26, false, "chroma.oresilk", ItemOreSilker.class),
    AURAPOUCH(29, false, "chroma.aurapouch", ItemAuraPouch.class),
    GROWTH(87, false, "chroma.growth", ItemGrowthWand.class),
    BULKMOVER(12, false, "chroma.bulkmove", ItemBulkMover.class),
    CHAINGUN(13, false, "chroma.chaingun", ItemChainGun.class),
    HOVERWAND(88, false, "chroma.hover", ItemFlightWand.class),
    DIMGEN(48, true, "chroma.dimgen", ItemDimGen.class),
    SPLASHGUN(14, false, "chroma.splashgun", ItemSplashGun.class),
    KEY(15, false, "chroma.key", ItemDoorKey.class),
    CARD(31, false, "chroma.card", ItemCrystalCard.class),
    SHARE(30, false, "chroma.share", ItemOwnerKey.class),
    RESET(89, false, "chroma.reset", ItemResetWand.class),
    COLOREDMOD(0, true, "chroma.colormod", ItemColoredModInteract.class),
    LIGHTWAND(91, false, "chroma.lightwand", ItemLightWand.class),
    CRYSTALCELL(22, false, "chroma.crystalcell", ItemCrystalCell.class, ModList.APPENG),
    PURIFY(33, true, "chroma.purify", ItemPurifyCrystal.class),
    EFFICIENCY(37, false, "chroma.efficiency", ItemEfficiencyCrystal.class),
    KILLAURAGUN(38, false, "chroma.killauragun", ItemKillAuraGun.class),
    THROWGEM(0, true, "chroma.throwgem", ItemThrowableGem.class),
    FLOATBOOTS(40, false, "chroma.floatboots", ItemFloatstoneBoots.class),
    WARPCAPSULE(41, false, "chroma.warpitem", ItemWarpCapsule.class),
    BEEFRAME(208, false, "chroma.beeframe", ItemChromaBeeFrame.class, ModList.FORESTRY),
    STRUCTUREFINDER(43, false, "chroma.structfind", ItemStructureFinder.class),
    MAGICBRANCH(0, true, "chroma.branch", ItemMagicBranch.class),
    ARTEFACT(112, true, "chroma.artefact", ItemUnknownArtefact.class),
    DATACRYSTAL(44, false, "chroma.datacrystal", ItemDataCrystal.class),
    MOBSONAR(92, false, "chroma.mobsonar", ItemMobSonar.class),
    FERTILITYSEED(209, true, "chroma.fertileseed", ItemFertilitySeed.class),
    CAVEPATHER(45, false, "chroma.cavepather", ItemCaveExitFinder.class),
    SPLINEATTACK(46, false, "chroma.splineattack", ItemSplineAttack.class);

    private final int index;
    private final boolean hasSubtypes;
    private final String name;
    private final Class itemClass;
    private int texturesheet;
    private ModList condition;
    private int maxindex;
    public static final ChromaItems[] itemList;
    private static final HashMap<Item, ChromaItems> itemMap;

    private ChromaItems(int tex, boolean sub, String n2, Class<? extends Item> iCl) {
        this(tex, sub, n2, iCl, null);
    }

    private ChromaItems(int tex, boolean sub, String n2, Class<? extends Item> iCl, ModList api) {
        this.index = tex;
        this.hasSubtypes = sub;
        this.name = n2;
        this.itemClass = iCl;
        this.condition = api;
    }

    public Class[] getConstructorParamTypes() {
        if (this.isArmor()) {
            return new Class[]{Integer.TYPE, Integer.TYPE};
        }
        return new Class[]{Integer.TYPE};
    }

    public Object[] getConstructorParams() {
        if (this.isArmor()) {
            return new Object[]{this.getTextureIndex(), this.getArmorRender()};
        }
        return new Object[]{this.getTextureIndex()};
    }

    private ItemArmor.ArmorMaterial getArmorMaterial() {
        return null;
    }

    public int getArmorType() {
        switch (this) {
            default: 
        }
        return 0;
    }

    public int getTextureIndex() {
        return this.index;
    }

    public static boolean isRegistered(ItemStack is) {
        return ChromaItems.isRegistered(is.func_77973_b());
    }

    public static boolean isRegistered(Item id) {
        return ChromaItems.getEntryByID(id) != null;
    }

    public static ChromaItems getEntryByID(Item id) {
        return itemMap.get(id);
    }

    public static ChromaItems getEntry(ItemStack is) {
        if (is == null) {
            return null;
        }
        return ChromaItems.getEntryByID(is.func_77973_b());
    }

    public String getName(int dmg) {
        if (this.hasMultiValuedName()) {
            return this.getMultiValuedName(dmg);
        }
        return this.name;
    }

    public String getBasicName() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public String getMultiValuedName(int meta) {
        if (!this.hasMultiValuedName()) {
            throw new RuntimeException("Item " + this.name + " was called for a multi-name, yet does not have one!");
        }
        if (meta == Short.MAX_VALUE) {
            return this.getBasicName() + " (Any)";
        }
        switch (this) {
            case PLACER: {
                return ChromaTiles.TEList[meta].getName();
            }
            case ADJACENCY: {
                return AdjacencyUpgrades.upgrades[meta].getName();
            }
            case BUCKET: {
                return StatCollector.func_74838_a((String)ChromaNames.fluidNames[meta]) + " " + this.getBasicName();
            }
            case SHARD: {
                String s = meta >= 16 ? "Boosted " : "";
                return s + CrystalElement.elements[meta % 16].displayName + " " + this.getBasicName();
            }
            case POTION: 
            case PENDANT: 
            case PENDANT3: 
            case DYE: 
            case LENS: 
            case BERRY: 
            case ELEMENTAL: 
            case THROWGEM: {
                return CrystalElement.elements[meta].displayName + " " + this.getBasicName();
            }
            case CLUSTER: {
                return StatCollector.func_74838_a((String)ChromaNames.clusterNames[meta]);
            }
            case TIERED: {
                return StatCollector.func_74838_a((String)ChromaNames.tieredNames[meta]);
            }
            case SEED: {
                return CrystalElement.elements[meta % 16].displayName + " " + this.getBasicName();
            }
            case MISC: {
                return StatCollector.func_74838_a((String)ChromaNames.miscNames[meta]);
            }
            case MODINTERACT: {
                return StatCollector.func_74838_a((String)ChromaNames.modInteractNames[meta]);
            }
            case COLOREDMOD: {
                return CrystalElement.elements[meta % 16].displayName + " " + StatCollector.func_74838_a((String)ChromaNames.coloredModInteractNames[meta / 16]);
            }
            case ENDERCRYSTAL: {
                return this.getBasicName();
            }
            case CRAFTING: {
                return StatCollector.func_74838_a((String)ChromaNames.craftingNames[meta]);
            }
            case STORAGE: {
                return StatCollector.func_74838_a((String)ChromaNames.storageNames[meta]) + " " + this.getBasicName();
            }
            case FRAGMENT: {
                return this.getBasicName();
            }
            case OREPICK: 
            case ORESILK: 
            case MULTITOOL: {
                return this.getBasicName();
            }
            case WARP: {
                String pre = meta == 1 ? "Charged " : "Inert ";
                return pre + this.getBasicName();
            }
            case DIMGEN: {
                return StatCollector.func_74838_a((String)ChromaNames.dimGenNames[meta]);
            }
            case PURIFY: 
            case EFFICIENCY: {
                return this.getBasicName();
            }
            case MAGICBRANCH: {
                return ItemMagicBranch.BranchTypes.list[meta].name().toLowerCase(Locale.ENGLISH) + " " + this.getBasicName();
            }
            case ARTEFACT: {
                return StatCollector.func_74838_a((String)("chromaunknownartefact." + ItemUnknownArtefact.ArtefactTypes.list[meta].name().toLowerCase(Locale.ENGLISH)));
            }
            case FERTILITYSEED: {
                return this.getBasicName();
            }
        }
        throw new RuntimeException("Item " + this.name + " was called for a multi-name, but it was not registered!");
    }

    public int getArmorRender() {
        if (!this.isArmor()) {
            throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Item " + this.name + " is not an armor yet was called for its render!");
        }
        switch (this) {
            case FLOATBOOTS: {
                return ChromaCommon.armor;
            }
        }
        throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Item " + this.name + " is an armor yet has no specified render!");
    }

    public String getUnlocalizedName() {
        return ReikaStringParser.stripSpaces((String)this.name).toLowerCase(Locale.ENGLISH);
    }

    public Item getItemInstance() {
        return ChromatiCraft.items[this.ordinal()];
    }

    public boolean hasMultiValuedName() {
        return this.hasSubtypes;
    }

    public boolean isTool() {
        return false;
    }

    public boolean isCreativeOnly() {
        return false;
    }

    public int getNumberMetadatas() {
        if (!this.hasSubtypes) {
            return 1;
        }
        switch (this) {
            case BUCKET: {
                return ChromaNames.fluidNames.length;
            }
            case PLACER: {
                return ChromaTiles.TEList.length;
            }
            case ADJACENCY: {
                return CrystalElement.elements.length;
            }
            case SHARD: {
                return CrystalElement.elements.length * 2;
            }
            case POTION: 
            case PENDANT: 
            case PENDANT3: 
            case DYE: 
            case LENS: 
            case BERRY: 
            case ELEMENTAL: 
            case THROWGEM: {
                return CrystalElement.elements.length;
            }
            case CLUSTER: {
                return ChromaNames.clusterNames.length;
            }
            case TIERED: {
                return ChromaNames.tieredNames.length;
            }
            case MISC: {
                return ChromaNames.miscNames.length;
            }
            case MODINTERACT: {
                return ChromaNames.modInteractNames.length;
            }
            case COLOREDMOD: {
                return ChromaNames.coloredModInteractNames.length * CrystalElement.elements.length;
            }
            case SEED: {
                return ReikaMathLibrary.intpow2((int)2, (int)(TileEntityCrystalPlant.Modifier.list.length + 4));
            }
            case ENDERCRYSTAL: {
                return 2;
            }
            case CRAFTING: {
                return ChromaNames.craftingNames.length;
            }
            case STORAGE: {
                return ChromaNames.storageNames.length;
            }
            case FRAGMENT: {
                return ReikaJavaLibrary.getEnumLengthWithoutInitializing(ChromaResearch.class);
            }
            case WARP: {
                return 2;
            }
            case OREPICK: {
                return 720;
            }
            case MULTITOOL: {
                return 400;
            }
            case ORESILK: {
                return 180;
            }
            case DIMGEN: {
                return BlockDimensionDeco.DimDecoTypes.list.length;
            }
            case PURIFY: {
                return 4;
            }
            case MAGICBRANCH: {
                return ItemMagicBranch.BranchTypes.list.length;
            }
            case ARTEFACT: {
                return ItemUnknownArtefact.ArtefactTypes.list.length;
            }
            case FERTILITYSEED: {
                return 7;
            }
        }
        throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Item " + this.name + " has subtypes but the number was not specified!");
    }

    public boolean isArmor() {
        switch (this) {
            case FLOATBOOTS: {
                return true;
            }
        }
        return false;
    }

    public ItemStack getCraftedProduct(int amt) {
        return new ItemStack(this.getItemInstance(), amt, 0);
    }

    public ItemStack getCraftedMetadataProduct(int amt, int meta) {
        return new ItemStack(this.getItemInstance(), amt, meta);
    }

    public ItemStack getStackOf() {
        return this.getCraftedProduct(1);
    }

    public ItemStack getStackOfMetadata(int meta) {
        return this.getCraftedMetadataProduct(1, meta);
    }

    public ItemStack getStackOf(CrystalElement e) {
        return this.getStackOfMetadata(e.ordinal());
    }

    public boolean overridesRightClick(ItemStack is) {
        switch (this) {
            case TOOL: 
            case LINKTOOL: {
                return true;
            }
        }
        return false;
    }

    public Class getObjectClass() {
        return this.itemClass;
    }

    public boolean isDummiedOut() {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            return false;
        }
        if (this.hasPrerequisite() && !this.getPrerequisite().isLoaded()) {
            return true;
        }
        return this.itemClass == null;
    }

    private boolean hasPrerequisite() {
        return this.condition != null;
    }

    private ModList getPrerequisite() {
        return this.condition;
    }

    public void addRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getStackOf(), (Object[])params);
        }
    }

    public void addSizedRecipe(int num, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getCraftedProduct(num), (Object[])params);
        }
    }

    public void addMetaRecipe(int meta, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getStackOfMetadata(meta), (Object[])params);
        }
    }

    public void addSizedMetaRecipe(int meta, int num, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getCraftedMetadataProduct(num, meta), (Object[])params);
        }
    }

    public void addEnchantedRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            ItemStack is = this.getEnchantedStack();
            GameRegistry.addRecipe((ItemStack)is, (Object[])params);
        }
    }

    public void addShapelessEnchantedRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            ItemStack is = this.getEnchantedStack();
            GameRegistry.addShapelessRecipe((ItemStack)is, (Object[])params);
        }
    }

    public ItemStack getEnchantedStack() {
        ItemStack is = this.getStackOf();
        if (is == null) {
            return is;
        }
        switch (this) {
            default: 
        }
        return is;
    }

    public void addShapelessRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addShapelessRecipe((ItemStack)this.getStackOf(), (Object[])params);
        }
    }

    public void addRecipe(IRecipe ir) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((IRecipe)ir);
        }
    }

    public void addOreRecipe(Object ... in) {
        ItemStack out;
        boolean added;
        if (this.isDummiedOut() || (added = ReikaRecipeHelper.addOreRecipe((ItemStack)(out = this.getStackOf()), (Object[])in))) {
            // empty if block
        }
    }

    public boolean isAvailableInCreativeInventory() {
        if (ChromatiCraft.instance.isLocked()) {
            return false;
        }
        return !this.isDummiedOut();
    }

    public boolean overwritingItem() {
        return false;
    }

    public boolean isContinuousCreativeMetadatas() {
        if (this.isTool()) {
            return false;
        }
        if (this.isArmor()) {
            return false;
        }
        switch (this) {
            default: 
        }
        return true;
    }

    public boolean matchWith(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == this.getItemInstance();
    }

    public boolean isPlacer() {
        switch (this) {
            case PLACER: 
            case ADJACENCY: 
            case ENDERCRYSTAL: 
            case RIFT: {
                return true;
            }
        }
        return false;
    }

    public static void loadMappings() {
        for (int i = 0; i < itemList.length; ++i) {
            ChromaItems r = itemList[i];
            itemMap.put(r.getItemInstance(), r);
        }
    }

    public ItemStack getAnyMetaStack() {
        return this.getStackOfMetadata(Short.MAX_VALUE);
    }

    public boolean isConfigDisabled() {
        return false;
    }

    static {
        itemList = ChromaItems.values();
        itemMap = new HashMap();
    }
}

