/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.EssentiaNetwork;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

@APIStripper.Strippable(value={"thaumcraft.api.aspects.IEssentiaTransport"})
public class TileEntityEssentiaRelay
extends TileEntityChromaticBase
implements IEssentiaTransport,
BreakAction,
SneakPop {
    public static final int SEARCH_RANGE = 8;
    public static final int THROUGHPUT = 4;
    private static Class jarClass;
    private static Field filterField;
    private final StepTimer scanTimer = new StepTimer(50);
    EssentiaNetwork network;
    private final Collection<EssentiaNetwork.EssentiaPath> activePaths = new ArrayList<EssentiaNetwork.EssentiaPath>();
    private final HashMap<Coordinate, Aspect> labelledJars = new HashMap();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ESSENTIARELAY;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        HashSet<Coordinate> activeTargets = new HashSet<Coordinate>();
        for (EssentiaNetwork.EssentiaPath p : this.activePaths) {
            p.update(world, x, y, z);
            if (p.target == null) continue;
            activeTargets.add(new Coordinate(p.target));
        }
        this.activePaths.clear();
        for (Coordinate c : this.labelledJars.keySet()) {
            int found;
            int amt;
            IAspectContainer ia;
            AspectList al;
            if (activeTargets.contains(c)) continue;
            Aspect a = this.labelledJars.get(c);
            TileEntity te = c.getTileEntity(world);
            if (!(te instanceof IAspectContainer) || (al = (ia = (IAspectContainer)te).getAspects()) == null || (amt = Math.min(4, 64 - al.getAmount(a))) <= 0 || (found = this.collectEssentiaToTarget(a, amt, new WorldLocation(world, c))) <= 0) continue;
            int ret = ia.addToContainer(a, found);
        }
        this.scanTimer.update();
        if (this.scanTimer.checkCap()) {
            this.scan(world, x, y, z);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.scan(world, x, y, z);
    }

    void scan(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        this.labelledJars.clear();
        this.network = new EssentiaNetwork();
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                for (int k = -8; k <= 8; ++k) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    TileEntity te = world.func_147438_o(dx, dy, dz);
                    if (!(te instanceof IEssentiaTransport)) continue;
                    if (te != this) {
                        if (te instanceof TileEntityEssentiaRelay) {
                            TileEntityEssentiaRelay tr = (TileEntityEssentiaRelay)te;
                            if (tr.network != null) {
                                this.network.merge(tr.network);
                            }
                        }
                        this.network.addTile(this, te);
                    }
                    if (jarClass == null || !jarClass.isAssignableFrom(te.getClass())) continue;
                    try {
                        Aspect a = (Aspect)filterField.get(te);
                        if (a == null) continue;
                        this.labelledJars.put(new Coordinate(te), a);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private void addPath(EssentiaNetwork.EssentiaPath p) {
        this.activePaths.add(p);
    }

    public boolean isConnectable(ForgeDirection face) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return true;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return 36;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        EssentiaNetwork.EssentiaMovement r;
        amount = Math.min(4, amount);
        EssentiaNetwork.EssentiaMovement essentiaMovement = r = this.network != null ? this.network.removeEssentia(this, face, aspect, amount) : null;
        if (r != null) {
            for (EssentiaNetwork.EssentiaPath p : r.paths()) {
                this.addPath(p);
            }
            return r.totalAmount;
        }
        return 0;
    }

    private int collectEssentiaToTarget(Aspect a, int amt, WorldLocation tgt) {
        EssentiaNetwork.EssentiaMovement r;
        amt = Math.min(4, amt);
        EssentiaNetwork.EssentiaMovement essentiaMovement = r = this.network != null ? this.network.removeEssentia(this, ForgeDirection.DOWN, a, amt, tgt) : null;
        if (r != null) {
            for (EssentiaNetwork.EssentiaPath p : r.paths()) {
                this.addPath(p);
            }
            return r.totalAmount;
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        EssentiaNetwork.EssentiaMovement s;
        amount = Math.min(4, amount);
        EssentiaNetwork.EssentiaMovement essentiaMovement = s = this.network != null ? this.network.addEssentia(this, face, aspect, amount) : null;
        if (s != null) {
            for (EssentiaNetwork.EssentiaPath p : s.paths()) {
                this.addPath(p);
            }
            return s.totalAmount;
        }
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        TileEntity te = this.getAdjacentTileEntity(face);
        return te instanceof IEssentiaTransport ? ((IEssentiaTransport)te).getSuctionType(face.getOpposite()) : null;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        Aspect a = this.getEssentiaType(face);
        return a != null && this.network != null ? this.network.countEssentia(a) : 0;
    }

    public int getMinimumSuction() {
        return 24;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public void breakBlock() {
        if (this.network != null) {
            this.network.reset();
        }
    }

    @Override
    public final void drop() {
        ItemStack is = this.getTile().getCraftedProduct();
        is.field_77990_d = new NBTTagCompound();
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        this.delete();
    }

    @Override
    public final boolean canDrop(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.placerUUID);
    }

    static {
        if (ModList.THAUMCRAFT.isLoaded()) {
            try {
                jarClass = Class.forName("thaumcraft.common.tiles.TileJarFillable");
                filterField = jarClass.getField("aspectFilter");
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)"Could not fetch Warded Jar class");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
        }
    }
}

