/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.ModInteract.CompoundAspectTank;
import Reika.DragonAPI.Interfaces.TileEntity.HitAction;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;

@APIStripper.Strippable(value={"thaumcraft.api.aspects.IAspectSource", "thaumcraft.api.aspects.IEssentiaTransport"})
public class TileEntityAspectJar
extends TileEntityChromaticBase
implements IAspectSource,
IEssentiaTransport,
NBTTile,
HitAction {
    public static final int CAPACITY = 500;
    public static final int CAPACITY_PRIMAL = 6000;
    public static final int HITS_TO_SPILL = 5;
    public static final int COOLDOWN_TO_SPILL = 40;
    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    private PrimalBiasAspectTank tank;
    private JarTilt angle = null;
    private int hitCount;
    private final int[] hits = new int[5];
    private ForgeDirection spilled;

    public TileEntityAspectJar() {
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.tank = new PrimalBiasAspectTank(500, 6000, 16);
        }
    }

    public JarTilt getAngle() {
        return this.angle;
    }

    public ForgeDirection getSpill() {
        return this.spilled;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ASPECTJAR;
    }

    public void onHit(World world, int x, int y, int z, EntityPlayer ep) {
        ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)ThaumItemHelper.BlockEntry.JAR.getBlock());
        if (this.spilled != null) {
            return;
        }
        if (this.angle == null) {
            ForgeDirection dir = ReikaEntityHelper.getDirectionFromEntityLook((EntityLivingBase)ep, (boolean)false);
            this.angle = new JarTilt(dir, 30.0f);
        }
        ++this.hitCount;
        int tick = this.getTicksExisted();
        if (this.hitCount >= 5 && tick - this.hits[this.hits.length - 1] <= 40) {
            this.angle = new JarTilt(this.angle, 90.0f);
        }
        ReikaArrayHelper.cycleArray((int[])this.hits, (int)tick);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.angle != null && this.spilled == null) {
            if (this.angle.update()) {
                this.angle = null;
            } else if (this.angle.angle >= 89.0f) {
                this.spill(world, x, y, z);
            }
        }
    }

    private void spill(World world, int x, int y, int z) {
        boolean fill;
        this.spilled = this.angle.direction;
        ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150359_w);
        boolean bl = fill = !this.tank.isEmpty();
        if (fill) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"game.neutral.swim", (float)0.6f, (float)((float)ReikaRandomHelper.getRandomPlusMinus((double)1.25, (double)0.5)));
            Block b = GameRegistry.findBlock((String)ModList.THAUMCRAFT.modLabel, (String)"blockFluxGoo");
            Block b2 = GameRegistry.findBlock((String)ModList.THAUMCRAFT.modLabel, (String)"blockFluxGas");
            int dx = x + this.spilled.offsetX;
            int dz = z + this.spilled.offsetZ;
            if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)y, (int)dz)) {
                world.func_147449_b(dx, y, dz, b);
                for (int i = 2; i < 6; ++i) {
                    ForgeDirection dir = this.dirs[i];
                    int ddx = dx + dir.offsetX;
                    int ddz = dz + dir.offsetZ;
                    if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)ddx, (int)y, (int)ddz)) continue;
                    world.func_147449_b(ddx, y, ddz, b);
                }
            }
            if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)(y + 1), (int)dz)) {
                world.func_147449_b(dx, y + 1, dz, b2);
            }
        }
        this.tank.empty();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public AspectList getAspects() {
        AspectList al = new AspectList();
        for (Aspect a : this.tank.getAspects()) {
            al.add(a, this.tank.getLevel(a));
        }
        return al;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int getAmount(Aspect a) {
        return this.tank.getLevel(a);
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public Collection<Aspect> getAllAspects() {
        return this.tank.getAspects();
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public void setAspects(AspectList aspects) {
        if (aspects.size() == 0) {
            this.tank.empty();
        } else {
            Aspect a = aspects.getAspects()[0];
            this.tank.setAspect(a, aspects.getAmount(a));
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean doesContainerAccept(Aspect tag) {
        return this.tank.canAccept(tag);
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int addToContainer(Aspect tag, int amount) {
        int add;
        if (this.doesContainerAccept(tag) && (add = Math.min(amount, this.tank.getRemainingSpace(tag))) >= 0) {
            this.tank.addAspect(tag, add);
            return amount - add;
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.tank.getLevel(tag) >= amount) {
            this.tank.drainAspect(tag, amount);
            return true;
        }
        return false;
    }

    @Deprecated
    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean takeFromContainer(AspectList ot) {
        return this.takeFromContainer(ot.getAspects()[0], ot.getAmount(ot.getAspects()[0]));
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.tank.getLevel(tag) >= amount;
    }

    @Deprecated
    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean doesContainerContain(AspectList ot) {
        return this.doesContainerContainAmount(ot.getAspects()[0], ot.getAmount(ot.getAspects()[0]));
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int containerContains(Aspect tag) {
        return this.tank.getLevel(tag);
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean isConnectable(ForgeDirection face) {
        return true;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean canOutputTo(ForgeDirection face) {
        return true;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public void setSuction(Aspect aspect, int amount) {
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int getSuctionAmount(ForgeDirection face) {
        return this.tank.getAspects() != null ? 48 : 32;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.tank.getAspects() != null ? this.tank.drainAspect(aspect, amount) : 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.tank.canAccept(aspect) ? this.tank.addAspect(aspect, amount) : 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public Aspect getEssentiaType(ForgeDirection face) {
        return this.tank.getFirstAspect();
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int getEssentiaAmount(ForgeDirection face) {
        return this.tank.getLevel(this.tank.getFirstAspect());
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int getMinimumSuction() {
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean renderExtendedTube() {
        return true;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.tank.writeToNBT(NBT);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.tank.readFromNBT(NBT);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("spill", this.spilled != null ? this.spilled.ordinal() : -1);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        int idx = NBT.func_74762_e("spill");
        this.spilled = idx >= 0 ? this.dirs[idx] : null;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.tank.writeToNBT(NBT);
        }
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        if (is.field_77990_d != null && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaTiles.ASPECTJAR.getCraftedProduct()) && ModList.THAUMCRAFT.isLoaded()) {
            this.tank.readFromNBT(is.field_77990_d);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean hasAspects() {
        return this.tank != null && !this.tank.isEmpty();
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public Aspect getFirstAspect() {
        return this.tank.getFirstAspect();
    }

    public static ArrayList<String> parseNBT(NBTTagCompound tag) {
        ArrayList<String> li = new ArrayList<String>();
        if (ModList.THAUMCRAFT.isLoaded()) {
            CompoundAspectTank cat = new CompoundAspectTank(Integer.MAX_VALUE);
            cat.readFromNBT(tag);
            li.add("Aspects: ");
            for (Aspect a : cat.getAspects()) {
                int amt = cat.getLevel(a);
                li.add("  " + a.getName() + ": " + amt);
            }
        }
        return li;
    }

    public static class JarTilt {
        public final ForgeDirection direction;
        private float angle = 0.0f;
        private boolean increasing = true;
        private final float maxAngle;

        private JarTilt(JarTilt t, float max) {
            this.direction = t.direction;
            this.angle = t.angle;
            this.increasing = t.increasing;
            this.maxAngle = max;
        }

        private JarTilt(ForgeDirection dir, float max) {
            this.direction = dir;
            this.maxAngle = max;
        }

        public float getAngle() {
            return this.angle;
        }

        private boolean update() {
            float speed;
            float f = speed = this.angle > 45.0f ? 1.0f + (float)Math.pow(this.angle - 25.0f, 1.25) / 4.0f : 1.0f + (this.maxAngle - this.angle) / 4.0f;
            if (this.increasing) {
                this.angle += speed;
                if (this.angle >= this.maxAngle) {
                    this.angle = this.maxAngle;
                    this.increasing = false;
                }
            } else {
                this.angle -= speed;
                if (this.angle <= 0.0f) {
                    this.angle = 0.0f;
                    return true;
                }
            }
            return false;
        }
    }

    public static class PrimalBiasAspectTank
    extends CompoundAspectTank {
        public final int primalCapacity;

        public PrimalBiasAspectTank(int c, int pc, int max) {
            super(c, max);
            this.primalCapacity = pc;
        }

        public int getMaxCapacity(Aspect a) {
            return a.isPrimal() ? this.primalCapacity : this.capacity;
        }
    }
}

