/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.wands.WandCap;

public class TieredOreCap
extends WandCap {
    private static final HashMap<BlockTieredOre.TieredOres, WandType> items = new HashMap();
    public static final String RESEARCH_ID = "tieredorecap";

    public static void registerAll() {
        for (BlockTieredOre.TieredOres t : items.keySet()) {
            TieredOreCap cap = new TieredOreCap(t);
            if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) continue;
            TieredOreCap.registerTexture(t, cap);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerTexture(BlockTieredOre.TieredOres t, WandCap cap) {
        cap.setTexture(DirectResourceManager.getResource((String)("Reika/ChromatiCraft/Textures/Wands/cap_" + t.name().toLowerCase(Locale.ENGLISH) + ".png")));
    }

    private TieredOreCap(BlockTieredOre.TieredOres t) {
        super("TIEREDCAP_" + t.name(), 0.8f, (List)items.get((Object)t).aspects, 0.5f, items.get((Object)t).item, 10);
    }

    public String getResearch() {
        return RESEARCH_ID;
    }

    public static void addRecipes() {
        int i = -2;
        String ref = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? ChromaDescriptions.getParentPage() + "thaum.xml" : "";
        ArrayList<ShapedArcaneRecipe> li = new ArrayList<ShapedArcaneRecipe>();
        AspectList total = new AspectList();
        for (BlockTieredOre.TieredOres t : items.keySet()) {
            WandType wt = items.get((Object)t);
            AspectList al = new AspectList();
            int n = t == BlockTieredOre.TieredOres.FOCAL ? 2 : 1;
            al.add(Aspect.ORDER, 20 * n);
            Aspect a = (Aspect)wt.aspects.get(0);
            al.add(a, 50 * n);
            Object[] recipe = new Object[]{"AAA", "A A", Character.valueOf('A'), wt.raw};
            total.add(al);
            ShapedArcaneRecipe ir = ThaumcraftApi.addArcaneCraftingRecipe((String)"", (ItemStack)wt.item, (AspectList)al, (Object[])recipe);
            String id = "CAP_TIEREDCAP_" + t.name();
            String desc = "Novel caps";
            MathExpression cost = new MathExpression(){

                public double evaluate(double arg) throws ArithmeticException {
                    return arg / 5.0;
                }

                public double getBaseValue() {
                    return 0.0;
                }

                public String toString() {
                    return "/5";
                }
            };
            li.add(ir);
            ++i;
        }
        Collections.sort(li, new RecipeComparator());
        Object[] recipes = li.toArray(new ShapedArcaneRecipe[li.size()]);
        ReikaThaumHelper.addResearchForMultipleRecipesViaXML((String)"Elemental Caps", (ItemStack)ChromaStacks.chromaCap, (String)RESEARCH_ID, (String)"Novel Caps", (String)"chromaticraft", ChromatiCraft.class, (String)ref, (int)0, (int)0, (Object[])recipes, (int)1, (int)2, (AspectList)total).setParents(new String[]{"ROD_silverwood", "CAP_thaumium", "SCEPTRE"});
        ThaumcraftApi.addWarpToResearch((String)RESEARCH_ID, (int)3);
    }

    static {
        items.put(BlockTieredOre.TieredOres.FIRAXITE, new WandType(ChromaStacks.firaxiteCap, ChromaStacks.fieryIngot, new Aspect[]{Aspect.FIRE, Aspect.ORDER, Aspect.MAGIC, Aspect.CRYSTAL}));
        items.put(BlockTieredOre.TieredOres.WATERY, new WandType(ChromaStacks.waterCap, ChromaStacks.waterIngot, new Aspect[]{Aspect.WATER, Aspect.ORDER, Aspect.MAGIC, Aspect.CRYSTAL}));
        items.put(BlockTieredOre.TieredOres.RESO, new WandType(ChromaStacks.endCap, ChromaStacks.enderIngot, new Aspect[]{Aspect.ENTROPY, Aspect.ELDRITCH, Aspect.ORDER, Aspect.MAGIC, Aspect.CRYSTAL}));
        items.put(BlockTieredOre.TieredOres.FOCAL, new WandType(ChromaStacks.chromaCap, ChromaStacks.complexIngot, new Aspect[]{Aspect.AIR, Aspect.FIRE, Aspect.WATER, Aspect.EARTH, Aspect.ORDER, Aspect.ENTROPY}));
    }

    private static class RecipeComparator
    implements Comparator<ShapedArcaneRecipe> {
        private RecipeComparator() {
        }

        @Override
        public int compare(ShapedArcaneRecipe o1, ShapedArcaneRecipe o2) {
            ItemStack i1 = o1.output;
            ItemStack i2 = o2.output;
            if (ReikaItemHelper.matchStacks((ItemStack)i1, (ItemStack)i2)) {
                return 0;
            }
            if (ReikaItemHelper.matchStacks((ItemStack)i1, (ItemStack)ChromaStacks.chromaCap)) {
                return Integer.MAX_VALUE;
            }
            if (ReikaItemHelper.matchStacks((ItemStack)i2, (ItemStack)ChromaStacks.chromaCap)) {
                return Integer.MIN_VALUE;
            }
            return Integer.compare(i1.func_77960_j(), i2.func_77960_j());
        }
    }

    private static class WandType {
        private final ArrayList<Aspect> aspects = new ArrayList();
        private final ItemStack item;
        private final ItemStack raw;

        private WandType(ItemStack is, ItemStack raw, Aspect ... as) {
            this.item = is;
            this.raw = raw;
            for (Aspect a : as) {
                this.addAspect(a);
            }
        }

        private WandType addAspect(Aspect a) {
            this.aspects.add(a);
            return this;
        }
    }
}

