/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.NodeReceiverWrapper;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import thaumcraft.api.nodes.INode;

public class NodeRecharger
implements TickRegistry.TickHandler {
    public static final NodeRecharger instance = new NodeRecharger();
    private static final String NBT_TAG = "PYLON_RECHARGE_DATA";
    private final HashMap<Integer, HashMap<WorldLocation, NodeReceiverWrapper>> nodes = new HashMap();
    private final HashSet<Integer> ticked = new HashSet();

    private NodeRecharger() {
    }

    public boolean addNode(INode n) {
        WorldLocation loc = new WorldLocation((TileEntity)n);
        return this.addLocation(loc, n, true);
    }

    private HashMap<WorldLocation, NodeReceiverWrapper> getOrCreateMap(int id) {
        HashMap<Object, NodeReceiverWrapper> map = this.nodes.get(id);
        if (map == null) {
            map = new HashMap();
            this.nodes.put(id, map);
        }
        return map;
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        World world = (World)tickData[0];
        int id = world.field_73011_w.field_76574_g;
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.nodes.get(id);
        NodeRechargeData.initNetworkData(world).func_76186_a(true);
        if (map != null) {
            HashSet<WorldLocation> remove = new HashSet<WorldLocation>();
            for (WorldLocation loc : map.keySet()) {
                NodeReceiverWrapper node = map.get(loc);
                if (loc.getTileEntity() instanceof INode) {
                    node.tick();
                    continue;
                }
                remove.add(loc);
            }
            for (WorldLocation loc : remove) {
                this.removeLocation(loc, world, true);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload evt) {
        this.ticked.remove(evt.world.field_73011_w.field_76574_g);
    }

    private boolean addLocation(WorldLocation loc, INode n, boolean save) {
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.getOrCreateMap(loc.dimensionID);
        NodeReceiverWrapper wrap = new NodeReceiverWrapper(n);
        map.put(loc, wrap);
        if (save) {
            NodeRechargeData.initNetworkData(((TileEntity)n).field_145850_b).func_76186_a(true);
        }
        return true;
    }

    private boolean removeLocation(WorldLocation loc, World world, boolean save) {
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.nodes.get(world.field_73011_w.field_76574_g);
        if (map != null) {
            map.remove(loc);
            if (save) {
                NodeRechargeData.initNetworkData(world).func_76186_a(false);
            }
            return true;
        }
        return false;
    }

    public NodeReceiverWrapper getWrapper(WorldLocation loc) {
        TileEntity te;
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.getOrCreateMap(loc.dimensionID);
        NodeReceiverWrapper wrap = map.get(loc);
        if (wrap == null && (te = loc.getTileEntity()) instanceof INode) {
            this.addLocation(loc, (INode)te, true);
        }
        return wrap;
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.WORLD);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.END;
    }

    public String getLabel() {
        return "CC-TC Node Crystal Net Recharging";
    }

    private void save(NBTTagCompound NBT) {
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        NBTTagList li = new NBTTagList();
        for (HashMap<WorldLocation, NodeReceiverWrapper> map : this.nodes.values()) {
            for (WorldLocation loc : map.keySet()) {
                NBTTagCompound nbt = new NBTTagCompound();
                loc.writeToNBT(nbt);
                li.func_74742_a((NBTBase)nbt);
            }
        }
        tag.func_74782_a("list", (NBTBase)li);
        NBT.func_74782_a(NBT_TAG, (NBTBase)tag);
    }

    private void load(NBTTagCompound NBT) {
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        NBTTagList li = tag.func_150295_c("list", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound nbt = (NBTTagCompound)o;
            WorldLocation loc = WorldLocation.readFromNBT((NBTTagCompound)nbt);
            TileEntity te = loc.getTileEntity();
            if (te instanceof INode) {
                this.addLocation(loc, (INode)te, false);
                continue;
            }
            ChromatiCraft.logger.logError((Object)("Data saved a TC aura node at " + loc + ", but the node was deleted between world save and reload?!"));
        }
    }

    public static class NodeRechargeData
    extends WorldSavedData {
        private static final String IDENTIFIER = "PYLON_RECHARGE_DATA";

        public NodeRechargeData() {
            super("PYLON_RECHARGE_DATA");
        }

        public NodeRechargeData(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound NBT) {
            if (ModList.THAUMCRAFT.isLoaded()) {
                instance.load(NBT);
            }
        }

        public void func_76187_b(NBTTagCompound NBT) {
            instance.save(NBT);
        }

        private static NodeRechargeData initNetworkData(World world) {
            NodeRechargeData data = (NodeRechargeData)world.func_72943_a(NodeRechargeData.class, "PYLON_RECHARGE_DATA");
            if (data == null) {
                data = new NodeRechargeData();
                world.func_72823_a("PYLON_RECHARGE_DATA", (WorldSavedData)data);
            }
            return data;
        }
    }
}

