/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.NotifiedNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.WrapperTile;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public final class NodeReceiverWrapper
implements CrystalReceiver,
NotifiedNetworkTile,
WrapperTile {
    private static final int DELAY = 600;
    private static final int MIN_DELAY = 200;
    private static final int NEW_ASPECT_COST = 240000;
    private static final float LOSS_FACTOR = 0.6f;
    private static final String LOGGER_ID = "chromanodes";
    private static final Random rand = new Random();
    private final INode node;
    public final WorldLocation location;
    private final UUID uid = UUID.randomUUID();
    private int fulltick = 200;
    private int tick = 600;
    private final ElementTagCompound baseVis = new ElementTagCompound();
    private final WeightedRandom<Aspect> newAspectWeight = new WeightedRandom();

    NodeReceiverWrapper(INode n) {
        this.node = n;
        this.location = new WorldLocation((TileEntity)n);
        AspectList al = n.getAspectsBase();
        for (Aspect a : Aspect.aspects.values()) {
            if (al.aspects.containsKey(a)) continue;
            double wt = a.isPrimal() ? 100.0 : (double)(10 / ReikaThaumHelper.decompose((Aspect)a).size());
            this.newAspectWeight.addEntry((Object)a, wt);
        }
        for (Aspect a : al.aspects.keySet()) {
            int amt = al.getAmount(a);
            ElementTagCompound tag = this.getTagValue(a).scale(amt);
            this.baseVis.addTag(tag);
        }
        ModularLogger.instance.log(LOGGER_ID, "Node wrapper created for node " + this.location);
    }

    private int getCurrentValue(CrystalElement e) {
        int val = 0;
        AspectList al = this.node.getAspects();
        for (Aspect a : al.aspects.keySet()) {
            int amt = al.getAmount(a);
            val += this.getTagValue(a).getValue(e) * amt;
        }
        return val;
    }

    private ElementTagCompound getTagValue(Aspect a) {
        return ChromaAspectManager.instance.getElementCost(a, 1.0f);
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return this.baseVis.contains(e);
    }

    @Override
    public void cachePosition() {
    }

    @Override
    public void removeFromCache() {
    }

    @Override
    public double getDistanceSqTo(double x, double y, double z) {
        return this.location.getSquareDistanceTo(x, y, z);
    }

    @Override
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    public int getX() {
        return this.location.xCoord;
    }

    @Override
    public int getY() {
        return this.location.yCoord;
    }

    @Override
    public int getZ() {
        return this.location.zCoord;
    }

    @Override
    public int maxThroughput() {
        return 50;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public UUID getUniqueID() {
        return this.uid;
    }

    @Override
    public UUID getPlacerUUID() {
        return null;
    }

    @Override
    public int receiveElement(CrystalElement e, int amt) {
        if (!this.isConductingElement(e)) {
            return 0;
        }
        Collection<Aspect> li = ChromaAspectManager.instance.getAspects(e, true);
        AspectList al = new AspectList();
        for (Aspect a : li) {
            if (!this.node.getAspectsBase().aspects.containsKey(a)) continue;
            al.add(a, (int)Math.ceil((float)amt * 0.6f / (float)this.baseVis.getValue(e)));
        }
        this.recharge(al);
        this.tick = 0;
        return this.isFull(e) ? 0 : amt;
    }

    private boolean isFull(CrystalElement e) {
        Collection<Aspect> li = ChromaAspectManager.instance.getAspects(e, true);
        for (Aspect a : li) {
            if (this.isFull(a)) continue;
            return false;
        }
        return true;
    }

    private boolean isFull(Aspect a) {
        return this.node.getAspects().getAmount(a) >= this.node.getAspectsBase().getAmount(a);
    }

    private void recharge(AspectList al) {
        for (Aspect a : al.aspects.keySet()) {
            int amt = (Integer)al.aspects.get(a);
            int space = this.node.getAspectsBase().getAmount(a) - this.node.getAspects().getAmount(a);
            this.node.addToContainer(a, Math.min(amt, space));
        }
        if (rand.nextInt(20) == 0) {
            this.playSound("thaumcraft:runicShieldCharge", 1.0f, 0.5f);
        }
        if (rand.nextInt(240) == 0) {
            this.healNode();
        }
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " recharge");
        this.location.triggerBlockUpdate(false);
    }

    public void tick() {
        ++this.tick;
        ++this.fulltick;
        if (rand.nextInt(240) == 0) {
            this.playSound("thaumcraft:zap");
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CHARGINGNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (int[])new int[0]);
        }
        if (rand.nextInt(1600) == 0) {
            this.healNode();
        }
        if (this.tick >= 600 && this.fulltick >= 200) {
            ElementTagCompound req = new ElementTagCompound();
            for (Aspect a : this.node.getAspectsBase().aspects.keySet()) {
                if (a == null) continue;
                int space = this.node.getAspectsBase().getAmount(a) - this.node.getAspects().getAmount(a);
                req.addTag(this.getTagValue(a).scale(space * space));
            }
            req.scale(2.0833333f);
            boolean flag = false;
            for (CrystalElement e : req.elementSet()) {
                ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " requesting " + req.getValue(e) + " of " + e.displayName);
                flag |= CrystalNetworker.instance.makeRequest(this, e, req.getValue(e), this.getReceiveRange());
            }
            this.fulltick = 0;
            if (flag) {
                this.playSound("thaumcraft:craftstart");
                this.tick = 0;
            }
        }
        if (rand.nextInt(8000) == 0 && !this.newAspectWeight.isEmpty()) {
            AspectList al = this.node.getAspectsBase();
            Aspect a = (Aspect)this.newAspectWeight.getRandomEntry();
            this.newAspectWeight.remove((Object)a);
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " attempting to gain aspect '" + a.getName() + "'");
            if (this.tryToAddAspect(a, al)) {
                ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " gained aspect '" + a.getName() + "'");
            }
            this.location.triggerBlockUpdate(false);
        }
    }

    private boolean tryToAddAspect(Aspect a, AspectList base) {
        ElementTagCompound tag = this.getTagValue(a);
        boolean flag = true;
        for (CrystalElement e : tag.elementSet()) {
            flag &= CrystalNetworker.instance.findSourceWithX(this, e, 240000, this.getReceiveRange(), true) != null;
        }
        if (flag) {
            base.add(a, 1);
            this.node.addToContainer(a, 1);
            this.baseVis.addTag(this.getTagValue(a));
            this.playSound("thaumcraft:hhon");
            this.playSound("thaumcraft:hhoff");
            ReikaPacketHelper.sendStringPacketWithRadius((String)"ChromaData", (int)ChromaPackets.NEWASPECTNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (String)a.getName().toLowerCase(Locale.ENGLISH));
            return true;
        }
        return false;
    }

    @Override
    public void onPathBroken(CrystalFlow p, CrystalNetworkLogger.FlowFail f) {
        this.playSound("thaumcraft:craftfail");
        if (rand.nextInt(8) == 0) {
            this.damageNode();
        }
    }

    private void damageNode() {
        ChromaSounds.ERROR.playSound(((TileEntity)this.node).field_145850_b, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, 0.75f, 2.0f);
        ChromaSounds.ERROR.playSound(((TileEntity)this.node).field_145850_b, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, 1.0f, 1.0f);
        ChromaSounds.ERROR.playSound(((TileEntity)this.node).field_145850_b, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, 0.75f, 0.5f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.HURTNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (int[])new int[0]);
        if (rand.nextInt(60) == 0) {
            if (this.node.getNodeModifier() != null) {
                switch (this.node.getNodeModifier()) {
                    case BRIGHT: {
                        this.node.setNodeModifier(null);
                        break;
                    }
                    case PALE: {
                        this.node.setNodeModifier(NodeModifier.FADING);
                        break;
                    }
                    case FADING: {
                        this.emptyNode();
                    }
                }
            } else {
                this.node.setNodeModifier(NodeModifier.PALE);
            }
        }
        if (rand.nextInt(480) == 0) {
            switch (this.node.getNodeType()) {
                case PURE: {
                    this.node.setNodeType(NodeType.NORMAL);
                    break;
                }
                case NORMAL: {
                    this.node.setNodeType(NodeType.UNSTABLE);
                    break;
                }
                case UNSTABLE: {
                    this.node.setNodeType(NodeType.DARK);
                    break;
                }
                case DARK: {
                    this.node.setNodeType(NodeType.TAINTED);
                    break;
                }
                case TAINTED: {
                    this.node.setNodeType(NodeType.HUNGRY);
                    break;
                }
                case HUNGRY: {
                    this.destroyNode();
                }
            }
        }
        AspectList al = this.node.getAspectsBase();
        for (Aspect a : al.aspects.keySet()) {
            int amt = al.getAmount(a);
            if (amt <= 1) continue;
            int rem = Math.min(amt - 1, (int)(rand.nextFloat() * ((float)amt / 2.0f)));
            al.remove(a, rem);
        }
        this.location.triggerBlockUpdate(false);
    }

    private void healNode() {
        ChromaSounds.CAST.playSoundAtBlock(this.location);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.HEALNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (int[])new int[0]);
        if (rand.nextInt(60) == 0) {
            if (this.node.getNodeModifier() != null) {
                switch (this.node.getNodeModifier()) {
                    case BRIGHT: {
                        break;
                    }
                    case PALE: {
                        this.node.setNodeModifier(null);
                        break;
                    }
                    case FADING: {
                        this.node.setNodeModifier(NodeModifier.PALE);
                    }
                }
            } else {
                this.node.setNodeModifier(NodeModifier.BRIGHT);
            }
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " brightness change");
        }
        if (rand.nextInt(240) == 0) {
            switch (this.node.getNodeType()) {
                case PURE: {
                    break;
                }
                case NORMAL: {
                    this.node.setNodeType(NodeType.PURE);
                    break;
                }
                case UNSTABLE: {
                    this.node.setNodeType(NodeType.NORMAL);
                    break;
                }
                case DARK: {
                    this.node.setNodeType(NodeType.UNSTABLE);
                    break;
                }
                case TAINTED: {
                    this.node.setNodeType(NodeType.DARK);
                    break;
                }
                case HUNGRY: {
                    this.node.setNodeType(NodeType.TAINTED);
                }
            }
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " type change");
        }
        AspectList al = this.node.getAspectsBase();
        for (Aspect a : al.aspects.keySet()) {
            int amt = al.getAmount(a);
            int newamt = Math.min(720, Math.max(amt + 1, (int)((double)amt + rand.nextDouble() * Math.sqrt(amt))));
            al.merge(a, newamt);
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " aspect '" + a.getName() + "' cap increased to " + newamt);
        }
        this.location.triggerBlockUpdate(false);
    }

    private void emptyNode() {
        for (Aspect a : this.node.getAspects().aspects.keySet()) {
            int amt = this.node.getAspects().getAmount(a);
            if (amt <= 1) continue;
            this.node.takeFromContainer(a, amt - 1);
        }
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " emptied");
        this.location.triggerBlockUpdate(false);
    }

    private void fillNode() {
        this.node.setAspects(this.node.getAspectsBase());
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " filled");
        this.location.triggerBlockUpdate(false);
    }

    private void destroyNode() {
        this.playSound("thaumcraft:craftfail", 2.0f, 1.0f);
        this.playSound("thaumcraft:craftfail", 2.0f, 1.0f);
        this.playSound("thaumcraft:craftfail", 1.0f, 0.5f);
        World world = ((TileEntity)this.node).field_145850_b;
        double x = (double)this.location.xCoord + 0.5;
        double y = (double)this.location.yCoord + 0.5;
        double z = (double)this.location.zCoord + 0.5;
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.DESTROYNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (int[])new int[0]);
        ChromaSounds.POWERDOWN.playSound(world, x, y, z, 2.0f, 1.0f);
        ChromaSounds.POWERDOWN.playSound(world, x, y, z, 2.0f, 1.0f);
        EntityLightningBolt elb = new EntityLightningBolt(world, x - 0.5, y, z - 0.5);
        world.func_72942_c((Entity)elb);
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " destroyed");
        this.location.setBlock(Blocks.field_150350_a);
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerNewAspectFX(World world, int x, int y, int z, Aspect a) {
        double dx = (double)x + 0.5;
        double dy = (double)y + 0.5;
        double dz = (double)z + 0.5;
        for (int i = 0; i < 16; ++i) {
            float fx = (float)ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)4.0);
            float fy = (float)ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)4.0);
            float fz = (float)ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)4.0);
            ReikaThaumHelper.triggerEffect((ReikaThaumHelper.EffectType)ReikaThaumHelper.EffectType.NODEBOLT, (Object[])new Object[]{world, Float.valueOf((float)dx), Float.valueOf((float)dy), Float.valueOf((float)dz), Float.valueOf(fx), Float.valueOf(fy), Float.valueOf(fz)});
        }
        int color = a.getColor();
        for (int i = 0; i < 64; ++i) {
            float gv = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.25, (double)0.125);
            if (rand.nextInt(3) > 0) {
                gv = -gv;
            }
            double v = 0.125 + rand.nextDouble() * 0.0625;
            double va = rand.nextDouble() * 360.0;
            double vx = v * Math.cos(Math.toDegrees(va));
            double vz = v * Math.sin(Math.toDegrees(va));
            EntityBlurFX fx = new EntityBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vx, 0.0, vz).setColor(color).setGravity(gv).setScale(2.0f).setRapidExpand();
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        EntityCenterBlurFX fx = new EntityCenterBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5).setColor(a.getColor()).setScale(20.0f);
        fx.field_70145_X = true;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerDestroyFX(World world, int x, int y, int z) {
        EntityFX fx;
        NodeReceiverWrapper wrap = new NodeReceiverWrapper((INode)world.func_147438_o(x, y, z));
        for (int i = 0; i < 512; ++i) {
            Aspect a = (Aspect)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, wrap.node.getAspects().aspects.keySet());
            double v = 0.125 + rand.nextDouble() * 0.25;
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            int color = a.getColor();
            fx = new EntityBlurFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), rx, ry, rz).setColor(color);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
        }
        for (int k = 0; k < 16; ++k) {
            CrystalElement e = CrystalElement.elements[k];
            if (wrap.getCurrentValue(e) <= 0) continue;
            for (int i = 0; i < 8; ++i) {
                double v = 0.125 + rand.nextDouble() * 0.25;
                double rx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
                double ry = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
                double rz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
                fx = new EntityRuneFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), rx, ry, rz, e);
                ((EntityRuneFX)fx).field_70145_X = true;
                Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerDamageFX(World world, int x, int y, int z) {
        ReikaThaumHelper.triggerEffect((ReikaThaumHelper.EffectType)ReikaThaumHelper.EffectType.NODEBURST, (Object[])new Object[]{world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, Float.valueOf(1.0f)});
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerChargingFX(World world, int x, int y, int z) {
        int i;
        NodeReceiverWrapper wrap = new NodeReceiverWrapper((INode)world.func_147438_o(x, y, z));
        double dx = (double)x + 0.5;
        double dy = (double)y + 0.5;
        double dz = (double)z + 0.5;
        for (i = 0; i < 8; ++i) {
            Aspect a = (Aspect)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, wrap.node.getAspects().aspects.keySet());
            double px = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)0.125);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)0.125);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)0.125);
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
            EntityLaserFX fx = new EntityLaserFX(CrystalElement.WHITE, world, px, py, pz, vx, vy, vz).setColor(a.getColor());
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < 6; ++i) {
            double r = rand.nextInt(32) == 0 ? 2.5 : (rand.nextInt(8) == 0 ? 1.25 : 0.75);
            float px = (float)ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)r);
            float py = (float)ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)r);
            float pz = (float)ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)r);
            ReikaThaumHelper.triggerEffect((ReikaThaumHelper.EffectType)ReikaThaumHelper.EffectType.NODEBOLT, (Object[])new Object[]{world, Float.valueOf((float)dx), Float.valueOf((float)dy), Float.valueOf((float)dz), Float.valueOf(px), Float.valueOf(py), Float.valueOf(pz)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerHealFX(World world, int x, int y, int z) {
        NodeReceiverWrapper wrap = new NodeReceiverWrapper((INode)world.func_147438_o(x, y, z));
        double dx = (double)x + 0.5;
        double dy = (double)y + 0.5;
        double dz = (double)z + 0.5;
        for (double d = -1.0; d <= 1.0; d += 0.125) {
            Aspect a = (Aspect)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, wrap.node.getAspects().aspects.keySet());
            int color = a.getColor();
            EntityBlurFX fx = new EntityBlurFX(world, dx, dy + d, dz).setColor(color).setScale(2.5f - 2.0f * (float)Math.abs(d)).setRapidExpand().setLife(20);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void playSound(String s) {
        this.playSound(s, 1.0f, 1.0f);
    }

    private void playSound(String s, float vol, float p) {
        ReikaSoundHelper.playSoundFromServer((World)((TileEntity)this.node).field_145850_b, (double)((double)this.getX() + 0.5), (double)((double)this.getY() + 0.5), (double)((double)this.getZ() + 0.5), (String)s, (float)vol, (float)p, (boolean)false);
    }

    @Override
    public void onPathCompleted(CrystalFlow p) {
    }

    @Override
    public void onPathConnected(CrystalPath p) {
        ChromaSounds.CAST.playSoundAtBlock(this.getWorld(), this.getX(), this.getY(), this.getZ(), 1.0f, 0.65f);
    }

    @Override
    public void onTileNetworkTopologyChange(CrystalNetworkTile te, boolean remove) {
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public ImmutableTriple<Double, Double, Double> getTargetRenderOffset(CrystalElement e) {
        return null;
    }

    @Override
    public double getIncomingBeamRadius() {
        return 0.0875;
    }

    @Override
    public boolean existsInWorld() {
        return false;
    }

    @Override
    public Class getTileClass() {
        return this.node.getClass();
    }

    public String toString() {
        return ReikaThaumHelper.aspectsToString((AspectList)this.node.getAspectsBase()) + " @ " + this.location;
    }

    public boolean canConductInterdimensionally() {
        return false;
    }

    @Override
    public boolean canReceiveFrom(CrystalTransmitter r) {
        return true;
    }

    @Override
    public boolean needsLineOfSightFromTransmitter(CrystalTransmitter r) {
        return true;
    }

    static {
        ModularLogger.instance.addLogger((DragonAPIMod)ChromatiCraft.instance, LOGGER_ID);
    }
}

